# Generated by Django 4.0.6 on 2022-08-23 11:22

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='Token',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'key',
                    models.CharField(
                        max_length=64,
                        unique=True,
                        validators=[
                            django.core.validators.MaxLengthValidator(64),
                            django.core.validators.MinLengthValidator(64),
                        ],
                        verbose_name='Hexadecimal key, length is 64 chars',
                    ),
                ),
                (
                    'owner',
                    models.CharField(
                        max_length=150, verbose_name='Owner, for traceability'
                    ),
                ),
                (
                    'comment',
                    models.CharField(
                        default='',
                        max_length=100,
                        verbose_name='Reason that this token was created',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('enabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Worker',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'name',
                    models.SlugField(
                        help_text='Human readable name of the worker based on the FQDN',
                        unique=True,
                    ),
                ),
                ('registered_at', models.DateTimeField()),
                ('connected_at', models.DateTimeField(blank=True, null=True)),
                ('static_metadata', models.JSONField(blank=True, default=dict)),
                (
                    'dynamic_metadata',
                    models.JSONField(blank=True, default=dict),
                ),
                (
                    'dynamic_metadata_updated_at',
                    models.DateTimeField(blank=True, null=True),
                ),
                (
                    'token',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name='worker',
                        to='db.token',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='WorkRequest',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('pending', 'Pending'),
                            ('running', 'Running'),
                            ('completed', 'Completed'),
                            ('aborted', 'Aborted'),
                        ],
                        default='pending',
                        editable=False,
                        max_length=9,
                    ),
                ),
                (
                    'result',
                    models.CharField(
                        choices=[
                            ('', ''),
                            ('success', 'Success'),
                            ('failure', 'Failure'),
                            ('error', 'Error'),
                        ],
                        default='',
                        editable=False,
                        max_length=7,
                    ),
                ),
                (
                    'task_name',
                    models.CharField(
                        max_length=100,
                        verbose_name='Name of the task to execute',
                    ),
                ),
                ('task_data', models.JSONField(blank=True, default=dict)),
                (
                    'worker',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='assigned_work_requests',
                        to='db.worker',
                    ),
                ),
            ],
        ),
    ]
