# Copyright 2022 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Test for the main entry point of debusine."""
from datetime import datetime
from unittest import TestCase

from debusine.client.models import WorkRequest


class WorkRequestTests(TestCase):
    """Tests for WorkRequest."""

    def create_work_request(self):
        """Return a new WorkRequest."""
        return WorkRequest(
            id=5,
            task_name='sbuild',
            created_at=datetime(2022, 3, 9, 11, 59, 43),
            started_at=datetime(2022, 3, 9, 11, 59, 46),
            completed_at=datetime(2022, 3, 9, 12, 00, 32),
            status='RUNNING',
            result='NA',
            worker=6,
            task_data={},
        )

    def test_work_request__str__(self):
        """__str__() return WorkRequest: {_id}."""
        work_request = self.create_work_request()

        self.assertEqual(str(work_request), 'WorkRequest: 5')
