# Copyright 2022 The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Models used by debusine client."""
from datetime import datetime

from pydantic import BaseModel


class WorkRequest(BaseModel):
    """Declare a WorkRequest."""

    id: int = None
    created_at: datetime = None
    started_at: datetime = None
    completed_at: datetime = None
    duration: int = None
    status: str = None
    result: str = None
    worker: int = None
    task_name: str = None
    task_data: dict = None

    def __str__(self):
        """Return representation of the object."""
        return f'WorkRequest: {self.id}'
