/*
 *
 *  Copyright (C) 2015-2022, J. Riesmeier, Oldenburg, Germany
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  Header file with DICOM Controlled Terminology Code Definitions (Coding Scheme "DCM", Version "01")
 *
 *  Generated automatically from DICOM PS 3.16-2022d
 *  File created on 2022-10-24 17:36:18 by J. Riesmeier
 *
 */


#ifndef CODES_DCM_H
#define CODES_DCM_H

#include "dcmtk/config/osconfig.h"   /* make sure OS specific configuration is included first */

#include "dcmtk/dcmsr/dsrcodvl.h"


/*-----------------------*
 *  general information  *
 *-----------------------*/

#define CODE_DCM_CodingSchemeDesignator              "DCM"
#define CODE_DCM_CodingSchemeName                    "DICOM Controlled Terminology"
#define CODE_DCM_CodingSchemeDescription             "PS3.16 Content Mapping Resource, Annex D"
#define CODE_DCM_CodingSchemeResponsibleOrganization "DICOM"
#define CODE_DCM_CodingSchemeUID                     "1.2.840.10008.2.16.4"


/*--------------------*
 *  code definitions  *
 *--------------------*/

// total number of codes: 4658
// - retired: 201
// - no name: 27
// - not unique: 17

// The basic scheme for creating the names is as follows:
//   'CODE_' + <coding-scheme-designator> + ['_RETIRED'] + '_' + <code-name>
// where <coding-scheme-designator> is "DCM" and <code-name> is either
// - a cleaned camel-case version of the code meaning (if unique within this coding scheme) or
// - a cleaned camel-case version of the code meaning with an underscore and the code value appended or
// - simply the code value with an underscore character appended (if code meaning contains an equation).
// The "cleaned camel-case version of the code meaning" is an attempt to map the free text
// description of the code meaning to a compiler-friendly but still human-readable representation.

#define CODE_DCM_Annotation                                                DSRBasicCodedEntry("ANN", "DCM", "Annotation")
#define CODE_DCM_Autorefraction                                            DSRBasicCodedEntry("AR", "DCM", "Autorefraction")
#define CODE_DCM_Archive                                                   DSRBasicCodedEntry("ARCHIVE", "DCM", "Archive")
#define CODE_DCM_RETIRED_Angioscopy                                        DSRBasicCodedEntry("AS", "DCM", "Angioscopy")
#define CODE_DCM_ContentAssessmentResult                                   DSRBasicCodedEntry("ASMT", "DCM", "Content Assessment Result")
#define CODE_DCM_Audio                                                     DSRBasicCodedEntry("AU", "DCM", "Audio")
#define CODE_DCM_UltrasoundBoneDensitometry                                DSRBasicCodedEntry("BDUS", "DCM", "Ultrasound Bone Densitometry")
#define CODE_DCM_BiomagneticImaging                                        DSRBasicCodedEntry("BI", "DCM", "Biomagnetic imaging")
#define CODE_DCM_BoneMineralDensitometry                                   DSRBasicCodedEntry("BMD", "DCM", "Bone Mineral Densitometry")
#define CODE_DCM_ComputerAssistedDetectionDiagnosis                        DSRBasicCodedEntry("CAD", "DCM", "Computer Assisted Detection/Diagnosis")
#define CODE_DCM_ImageCapture                                              DSRBasicCodedEntry("CAPTURE", "DCM", "Image Capture")
#define CODE_DCM_RETIRED_ColorFlowDoppler                                  DSRBasicCodedEntry("CD", "DCM", "Color flow Doppler")
#define CODE_DCM_RETIRED_Cinefluorography                                  DSRBasicCodedEntry("CF", "DCM", "Cinefluorography")
#define CODE_DCM_ComputationServer                                         DSRBasicCodedEntry("COMP", "DCM", "Computation Server")
#define CODE_DCM_RETIRED_Culposcopy                                        DSRBasicCodedEntry("CP", "DCM", "Culposcopy")
#define CODE_DCM_ComputedRadiography                                       DSRBasicCodedEntry("CR", "DCM", "Computed Radiography")
#define CODE_DCM_RETIRED_Cystoscopy                                        DSRBasicCodedEntry("CS", "DCM", "Cystoscopy")
#define CODE_DCM_ComputedTomography                                        DSRBasicCodedEntry("CT", "DCM", "Computed Tomography")
#define CODE_DCM_CTProtocol                                                DSRBasicCodedEntry("CTPROTOCOL", "DCM", "CT Protocol")
#define CODE_DCM_RETIRED_DuplexDoppler                                     DSRBasicCodedEntry("DD", "DCM", "Duplex Doppler")
#define CODE_DCM_RETIRED_DigitalFluoroscopy                                DSRBasicCodedEntry("DF", "DCM", "Digital fluoroscopy")
#define CODE_DCM_Diaphanography                                            DSRBasicCodedEntry("DG", "DCM", "Diaphanography")
#define CODE_DCM_RETIRED_DigitalMicroscopy                                 DSRBasicCodedEntry("DM", "DCM", "Digital microscopy")
#define CODE_DCM_Dermoscopy                                                DSRBasicCodedEntry("DMS", "DCM", "Dermoscopy")
#define CODE_DCM_Document_DOC                                              DSRBasicCodedEntry("DOC", "DCM", "Document")
#define CODE_DCM_DocumentDigitizerEquipment                                DSRBasicCodedEntry("DOCD", "DCM", "Document Digitizer Equipment")
#define CODE_DCM_RETIRED_DigitalSubtractionAngiography                     DSRBasicCodedEntry("DS", "DCM", "Digital Subtraction Angiography")
#define CODE_DCM_DepartmentSystemScheduler                                 DSRBasicCodedEntry("DSS", "DCM", "Department System Scheduler")
#define CODE_DCM_DigitalRadiography                                        DSRBasicCodedEntry("DX", "DCM", "Digital Radiography")
#define CODE_DCM_RETIRED_Echocardiography                                  DSRBasicCodedEntry("EC", "DCM", "Echocardiography")
#define CODE_DCM_Electrocardiography                                       DSRBasicCodedEntry("ECG", "DCM", "Electrocardiography")
#define CODE_DCM_Electroencephalography                                    DSRBasicCodedEntry("EEG", "DCM", "Electroencephalography")
#define CODE_DCM_Electromyography                                          DSRBasicCodedEntry("EMG", "DCM", "Electromyography")
#define CODE_DCM_Electrooculography                                        DSRBasicCodedEntry("EOG", "DCM", "Electrooculography")
#define CODE_DCM_CardiacElectrophysiology                                  DSRBasicCodedEntry("EPS", "DCM", "Cardiac Electrophysiology")
#define CODE_DCM_Endoscopy                                                 DSRBasicCodedEntry("ES", "DCM", "Endoscopy")
#define CODE_DCM_Female                                                    DSRBasicCodedEntry("F", "DCM", "Female")
#define CODE_DCM_RETIRED_FluoresceinAngiography                            DSRBasicCodedEntry("FA", "DCM", "Fluorescein angiography")
#define CODE_DCM_FemaleChangedToMale                                       DSRBasicCodedEntry("FC", "DCM", "Female changed to Male")
#define CODE_DCM_SpatialFiducials_FID                                      DSRBasicCodedEntry("FID", "DCM", "Spatial Fiducials")
#define CODE_DCM_FilmDigitizer                                             DSRBasicCodedEntry("FILMD", "DCM", "Film Digitizer")
#define CODE_DCM_FemalePseudohermaphrodite                                 DSRBasicCodedEntry("FP", "DCM", "Female Pseudohermaphrodite")
#define CODE_DCM_RETIRED_Fundoscopy                                        DSRBasicCodedEntry("FS", "DCM", "Fundoscopy")
#define CODE_DCM_GeneralMicroscopy                                         DSRBasicCodedEntry("GM", "DCM", "General Microscopy")
#define CODE_DCM_Hermaphrodite                                             DSRBasicCodedEntry("H", "DCM", "Hermaphrodite")
#define CODE_DCM_HardCopy                                                  DSRBasicCodedEntry("HC", "DCM", "Hard Copy")
#define CODE_DCM_HemodynamicWaveform                                       DSRBasicCodedEntry("HD", "DCM", "Hemodynamic Waveform")
#define CODE_DCM_IntraOralRadiography                                      DSRBasicCodedEntry("IO", "DCM", "Intra-oral Radiography")
#define CODE_DCM_IntraocularLensCalculation                                DSRBasicCodedEntry("IOL", "DCM", "Intraocular Lens Calculation")
#define CODE_DCM_IntravascularOpticalCoherenceTomography                   DSRBasicCodedEntry("IVOCT", "DCM", "Intravascular Optical Coherence Tomography")
#define CODE_DCM_IntravascularUltrasound                                   DSRBasicCodedEntry("IVUS", "DCM", "Intravascular Ultrasound")
#define CODE_DCM_Keratometry                                               DSRBasicCodedEntry("KER", "DCM", "Keratometry")
#define CODE_DCM_KeyObjectSelection                                        DSRBasicCodedEntry("KO", "DCM", "Key Object Selection")
#define CODE_DCM_Lensometry                                                DSRBasicCodedEntry("LEN", "DCM", "Lensometry")
#define CODE_DCM_ProcedureLogging                                          DSRBasicCodedEntry("LOG", "DCM", "Procedure Logging")
#define CODE_DCM_RETIRED_Laparoscopy                                       DSRBasicCodedEntry("LP", "DCM", "Laparoscopy")
#define CODE_DCM_LaserSurfaceScan                                          DSRBasicCodedEntry("LS", "DCM", "Laser surface scan")
#define CODE_DCM_Male                                                      DSRBasicCodedEntry("M", "DCM", "Male")
#define CODE_DCM_3DManufacturingModelingSystem                             DSRBasicCodedEntry("M3D", "DCM", "3D Manufacturing Modeling System")
#define CODE_DCM_RETIRED_MagneticResonanceAngiography                      DSRBasicCodedEntry("MA", "DCM", "Magnetic resonance angiography")
#define CODE_DCM_MaleChangedToFemale                                       DSRBasicCodedEntry("MC", "DCM", "Male changed to Female")
#define CODE_DCM_MediaCreationDevice                                       DSRBasicCodedEntry("MCD", "DCM", "Media Creation Device")
#define CODE_DCM_PortableMediaImporterEquipment                            DSRBasicCodedEntry("MEDIM", "DCM", "Portable Media Importer Equipment")
#define CODE_DCM_Mammography                                               DSRBasicCodedEntry("MG", "DCM", "Mammography")
#define CODE_DCM_MalePseudohermaphrodite                                   DSRBasicCodedEntry("MP", "DCM", "Male Pseudohermaphrodite")
#define CODE_DCM_MagneticResonance                                         DSRBasicCodedEntry("MR", "DCM", "Magnetic Resonance")
#define CODE_DCM_RETIRED_MagneticResonanceSpectroscopy                     DSRBasicCodedEntry("MS", "DCM", "Magnetic resonance spectroscopy")
#define CODE_DCM_Nearline                                                  DSRBasicCodedEntry("NEARLINE", "DCM", "Nearline")
#define CODE_DCM_NuclearMedicine                                           DSRBasicCodedEntry("NM", "DCM", "Nuclear Medicine")
#define CODE_DCM_OphthalmicAxialMeasurements                               DSRBasicCodedEntry("OAM", "DCM", "Ophthalmic Axial Measurements")
#define CODE_DCM_OpticalCoherenceTomography                                DSRBasicCodedEntry("OCT", "DCM", "Optical Coherence Tomography")
#define CODE_DCM_Offline                                                   DSRBasicCodedEntry("OFFLINE", "DCM", "Offline")
#define CODE_DCM_Online                                                    DSRBasicCodedEntry("ONLINE", "DCM", "Online")
#define CODE_DCM_OphthalmicPhotography                                     DSRBasicCodedEntry("OP", "DCM", "Ophthalmic photography")
#define CODE_DCM_OphthalmicMapping                                         DSRBasicCodedEntry("OPM", "DCM", "Ophthalmic Mapping")
#define CODE_DCM_OphthalmicRefraction                                      DSRBasicCodedEntry("OPR", "DCM", "Ophthalmic Refraction")
#define CODE_DCM_OphthalmicTomography                                      DSRBasicCodedEntry("OPT", "DCM", "Ophthalmic Tomography")
#define CODE_DCM_OphthalmicTomographyBScanVolumeAnalysis                   DSRBasicCodedEntry("OPTBSV", "DCM", "Ophthalmic Tomography B-scan Volume Analysis")
#define CODE_DCM_OphthalmicTomographyEnFace                                DSRBasicCodedEntry("OPTENF", "DCM", "Ophthalmic Tomography En Face")
#define CODE_DCM_OphthalmicVisualField                                     DSRBasicCodedEntry("OPV", "DCM", "Ophthalmic Visual Field")
#define CODE_DCM_OpticalSurfaceScanner                                     DSRBasicCodedEntry("OSS", "DCM", "Optical Surface Scanner")
#define CODE_DCM_OtherModality                                             DSRBasicCodedEntry("OT", "DCM", "Other Modality")
#define CODE_DCM_Plan                                                      DSRBasicCodedEntry("PLAN", "DCM", "Plan")
#define CODE_DCM_PositionSensor                                            DSRBasicCodedEntry("POS", "DCM", "Position Sensor")
#define CODE_DCM_PresentationState                                         DSRBasicCodedEntry("PR", "DCM", "Presentation State")
#define CODE_DCM_HardCopyPrintServer                                       DSRBasicCodedEntry("PRINT", "DCM", "Hard Copy Print Server")
#define CODE_DCM_PositronEmissionTomography                                DSRBasicCodedEntry("PT", "DCM", "Positron emission tomography")
#define CODE_DCM_PanoramicXRay                                             DSRBasicCodedEntry("PX", "DCM", "Panoramic X-Ray")
#define CODE_DCM_Registration                                              DSRBasicCodedEntry("REG", "DCM", "Registration")
#define CODE_DCM_RespiratoryWaveform                                       DSRBasicCodedEntry("RESP", "DCM", "Respiratory Waveform")
#define CODE_DCM_Radiofluoroscopy                                          DSRBasicCodedEntry("RF", "DCM", "Radiofluoroscopy")
#define CODE_DCM_RadiographicImaging                                       DSRBasicCodedEntry("RG", "DCM", "Radiographic imaging")
#define CODE_DCM_RadiationTherapyDevice                                    DSRBasicCodedEntry("RT", "DCM", "Radiation Therapy Device")
#define CODE_DCM_RadiotherapyDose                                          DSRBasicCodedEntry("RTDOSE", "DCM", "Radiotherapy Dose")
#define CODE_DCM_RadiotherapyImage                                         DSRBasicCodedEntry("RTIMAGE", "DCM", "Radiotherapy Image")
#define CODE_DCM_RadiotherapyPlan                                          DSRBasicCodedEntry("RTPLAN", "DCM", "Radiotherapy Plan")
#define CODE_DCM_RadiotherapyTreatmentRecord                               DSRBasicCodedEntry("RTRECORD", "DCM", "Radiotherapy Treatment Record")
#define CODE_DCM_RadiotherapyStructureSet                                  DSRBasicCodedEntry("RTSTRUCT", "DCM", "Radiotherapy Structure Set")
#define CODE_DCM_RealWorldValueMap                                         DSRBasicCodedEntry("RWV", "DCM", "Real World Value Map")
#define CODE_DCM_Segmentation_SEG                                          DSRBasicCodedEntry("SEG", "DCM", "Segmentation")
#define CODE_DCM_SlideMicroscopy_SM                                        DSRBasicCodedEntry("SM", "DCM", "Slide Microscopy")
#define CODE_DCM_StereometricRelationship                                  DSRBasicCodedEntry("SMR", "DCM", "Stereometric Relationship")
#define CODE_DCM_StructuredReportDocument                                  DSRBasicCodedEntry("SR", "DCM", "Structured Report Document")
#define CODE_DCM_SubjectiveRefraction                                      DSRBasicCodedEntry("SRF", "DCM", "Subjective Refraction")
#define CODE_DCM_RETIRED_SinglePhotonEmissionComputedTomography            DSRBasicCodedEntry("ST", "DCM", "Single-photon emission computed tomography")
#define CODE_DCM_AutomatedSlideStainer                                     DSRBasicCodedEntry("STAIN", "DCM", "Automated Slide Stainer")
#define CODE_DCM_TextureMap                                                DSRBasicCodedEntry("TEXTUREMAP", "DCM", "Texture Map")
#define CODE_DCM_Thermography                                              DSRBasicCodedEntry("TG", "DCM", "Thermography")
#define CODE_DCM_UnknownSex                                                DSRBasicCodedEntry("U", "DCM", "Unknown Sex")
#define CODE_DCM_Unavailable                                               DSRBasicCodedEntry("UNAVAILABLE", "DCM", "Unavailable")
#define CODE_DCM_Ultrasound                                                DSRBasicCodedEntry("US", "DCM", "Ultrasound")
#define CODE_DCM_VisualAcuity                                              DSRBasicCodedEntry("VA", "DCM", "Visual Acuity")
#define CODE_DCM_RETIRED_Videofluorography                                 DSRBasicCodedEntry("VF", "DCM", "Videofluorography")
#define CODE_DCM_VideoTapeDigitizerEquipment                               DSRBasicCodedEntry("VIDD", "DCM", "Video Tape Digitizer Equipment")
#define CODE_DCM_Workstation                                               DSRBasicCodedEntry("WSD", "DCM", "Workstation")
#define CODE_DCM_XRayAngiography                                           DSRBasicCodedEntry("XA", "DCM", "X-Ray Angiography")
#define CODE_DCM_ExternalCameraPhotography                                 DSRBasicCodedEntry("XC", "DCM", "External-camera Photography")
#define CODE_DCM_DigitalTimecode_NOS                                       DSRBasicCodedEntry("109001", "DCM", "Digital timecode (NOS)")
#define CODE_DCM_ECGBasedGatingSignal_processed                            DSRBasicCodedEntry("109002", "DCM", "ECG-based gating signal, processed")
#define CODE_DCM_IRIGBTimecode                                             DSRBasicCodedEntry("109003", "DCM", "IRIG-B timecode")
#define CODE_DCM_XRayFluoroscopyOnSignal                                   DSRBasicCodedEntry("109004", "DCM", "X-Ray Fluoroscopy On Signal")
#define CODE_DCM_XRayOnTrigger                                             DSRBasicCodedEntry("109005", "DCM", "X-Ray On Trigger")
#define CODE_DCM_DifferentialSignal                                        DSRBasicCodedEntry("109006", "DCM", "Differential signal")
#define CODE_DCM_HisBundleElectrogram                                      DSRBasicCodedEntry("109007", "DCM", "His bundle electrogram")
#define CODE_DCM_MonopoleSignal                                            DSRBasicCodedEntry("109008", "DCM", "Monopole signal")
#define CODE_DCM_Pacing_electrical_stimulus_voltage                        DSRBasicCodedEntry("109009", "DCM", "Pacing (electrical) stimulus, voltage")
#define CODE_DCM_RadioFrequencyAblation_power                              DSRBasicCodedEntry("109010", "DCM", "Radio frequency ablation, power")
#define CODE_DCM_VoltageMeasurementByBasketCatheter                        DSRBasicCodedEntry("109011", "DCM", "Voltage measurement by basket catheter")
#define CODE_DCM_VoltageMeasurementByMappingCatheter                       DSRBasicCodedEntry("109012", "DCM", "Voltage measurement by mapping catheter")
#define CODE_DCM_VoltageMeasurement                                        DSRBasicCodedEntry("109013", "DCM", "Voltage measurement")
#define CODE_DCM_35PercentOfThermalCO                                      DSRBasicCodedEntry("109014", "DCM", "35% of thermal CO")
#define CODE_DCM_70PercentOfThermalCO                                      DSRBasicCodedEntry("109015", "DCM", "70% of thermal CO")
#define CODE_DCM_AWavePeakPressure                                         DSRBasicCodedEntry("109016", "DCM", "A wave peak pressure")
#define CODE_DCM_AWavePressure_average                                     DSRBasicCodedEntry("109017", "DCM", "A wave pressure, average")
#define CODE_DCM_BeatDetected_accepted                                     DSRBasicCodedEntry("109018", "DCM", "Beat detected (accepted)")
#define CODE_DCM_BeatDetected_rejected                                     DSRBasicCodedEntry("109019", "DCM", "Beat detected (rejected)")
#define CODE_DCM_RETIRED_DiastolicPressure_average                         DSRBasicCodedEntry("109020", "DCM", "Diastolic pressure, average")
#define CODE_DCM_RETIRED_DiastolicPressureNadir                            DSRBasicCodedEntry("109021", "DCM", "Diastolic pressure nadir")
#define CODE_DCM_RETIRED_EndDiastole                                       DSRBasicCodedEntry("109022", "DCM", "End diastole")
#define CODE_DCM_EndOfExpiration                                           DSRBasicCodedEntry("109023", "DCM", "End of expiration")
#define CODE_DCM_EndOfInspiration                                          DSRBasicCodedEntry("109024", "DCM", "End of inspiration")
#define CODE_DCM_MaxDpDt                                                   DSRBasicCodedEntry("109025", "DCM", "Max dp/dt")
#define CODE_DCM_MaxNegDpDt                                                DSRBasicCodedEntry("109026", "DCM", "Max neg dp/dt")
#define CODE_DCM_RETIRED_MeanBloodPressure                                 DSRBasicCodedEntry("109027", "DCM", "Mean blood pressure")
#define CODE_DCM_PeakOfThermalCardiacOutputBolus                           DSRBasicCodedEntry("109028", "DCM", "Peak of thermal cardiac output bolus")
#define CODE_DCM_StartOfExpiration                                         DSRBasicCodedEntry("109029", "DCM", "Start of expiration")
#define CODE_DCM_StartOfInspiration                                        DSRBasicCodedEntry("109030", "DCM", "Start of inspiration")
#define CODE_DCM_StartOfThermalCardiacOutputBolus                          DSRBasicCodedEntry("109031", "DCM", "Start of thermal cardiac output bolus")
#define CODE_DCM_RETIRED_SystolicPressure_average                          DSRBasicCodedEntry("109032", "DCM", "Systolic pressure, average")
#define CODE_DCM_RETIRED_SystolicPeakPressure                              DSRBasicCodedEntry("109033", "DCM", "Systolic peak pressure")
#define CODE_DCM_VWavePeakPressure                                         DSRBasicCodedEntry("109034", "DCM", "V wave peak pressure")
#define CODE_DCM_VWavePressure_average                                     DSRBasicCodedEntry("109035", "DCM", "V wave pressure, average")
#define CODE_DCM_ValveClose                                                DSRBasicCodedEntry("109036", "DCM", "Valve close")
#define CODE_DCM_ValveOpen                                                 DSRBasicCodedEntry("109037", "DCM", "Valve open")
#define CODE_DCM_AblationOff                                               DSRBasicCodedEntry("109038", "DCM", "Ablation off")
#define CODE_DCM_Ablationon                                                DSRBasicCodedEntry("109039", "DCM", "Ablation on")
#define CODE_DCM_HISBundleWave                                             DSRBasicCodedEntry("109040", "DCM", "HIS bundle wave")
#define CODE_DCM_PWave                                                     DSRBasicCodedEntry("109041", "DCM", "P wave")
#define CODE_DCM_QWave                                                     DSRBasicCodedEntry("109042", "DCM", "Q wave")
#define CODE_DCM_RWave                                                     DSRBasicCodedEntry("109043", "DCM", "R wave")
#define CODE_DCM_SWave                                                     DSRBasicCodedEntry("109044", "DCM", "S wave")
#define CODE_DCM_StartOfAtrialContraction                                  DSRBasicCodedEntry("109045", "DCM", "Start of atrial contraction")
#define CODE_DCM_StartOfAtrialContraction_subsequent                       DSRBasicCodedEntry("109046", "DCM", "Start of atrial contraction (subsequent)")
#define CODE_DCM_StimulationAtRate1Interval                                DSRBasicCodedEntry("109047", "DCM", "Stimulation at rate 1 interval")
#define CODE_DCM_StimulationAtRate2Interval                                DSRBasicCodedEntry("109048", "DCM", "Stimulation at rate 2 interval")
#define CODE_DCM_StimulationAtRate3Interval                                DSRBasicCodedEntry("109049", "DCM", "Stimulation at rate 3 interval")
#define CODE_DCM_StimulationAtRate4Interval                                DSRBasicCodedEntry("109050", "DCM", "Stimulation at rate 4 interval")
#define CODE_DCM_TWave                                                     DSRBasicCodedEntry("109051", "DCM", "T wave")
#define CODE_DCM_VWave                                                     DSRBasicCodedEntry("109052", "DCM", "V wave")
#define CODE_DCM_VWaveOfNextBeat                                           DSRBasicCodedEntry("109053", "DCM", "V wave of next beat")
#define CODE_DCM_PatientState                                              DSRBasicCodedEntry("109054", "DCM", "Patient State")
#define CODE_DCM_ProtocolStage                                             DSRBasicCodedEntry("109055", "DCM", "Protocol Stage")
#define CODE_DCM_StressProtocol                                            DSRBasicCodedEntry("109056", "DCM", "Stress Protocol")
#define CODE_DCM_RETIRED_CatheterizationProcedurePhase                     DSRBasicCodedEntry("109057", "DCM", "Catheterization Procedure Phase")
#define CODE_DCM_ContrastPhase                                             DSRBasicCodedEntry("109058", "DCM", "Contrast Phase")
#define CODE_DCM_PhysiologicalChallenges                                   DSRBasicCodedEntry("109059", "DCM", "Physiological challenges")
#define CODE_DCM_ProcedureStepNumber                                       DSRBasicCodedEntry("109060", "DCM", "Procedure Step Number")
#define CODE_DCM_EPProcedurePhase                                          DSRBasicCodedEntry("109061", "DCM", "EP Procedure Phase")
#define CODE_DCM_PulseTrainDefinition                                      DSRBasicCodedEntry("109063", "DCM", "Pulse train definition")
#define CODE_DCM_RETIRED_EndOfSystole                                      DSRBasicCodedEntry("109070", "DCM", "End of systole")
#define CODE_DCM_IndicatorMeanTransitTime                                  DSRBasicCodedEntry("109071", "DCM", "Indicator mean transit time")
#define CODE_DCM_Tau                                                       DSRBasicCodedEntry("109072", "DCM", "Tau")
#define CODE_DCM_VMaxMyocardial                                            DSRBasicCodedEntry("109073", "DCM", "V max myocardial")
#define CODE_DCM_RealTimeAcquisition                                       DSRBasicCodedEntry("109080", "DCM", "Real time acquisition")
#define CODE_DCM_ProspectiveGating                                         DSRBasicCodedEntry("109081", "DCM", "Prospective gating")
#define CODE_DCM_RetrospectiveGating                                       DSRBasicCodedEntry("109082", "DCM", "Retrospective gating")
#define CODE_DCM_Paced                                                     DSRBasicCodedEntry("109083", "DCM", "Paced")
#define CODE_DCM_RETIRED_CardiacStressState                                DSRBasicCodedEntry("109091", "DCM", "Cardiac Stress State")
#define CODE_DCM_ReinjectionState                                          DSRBasicCodedEntry("109092", "DCM", "Reinjection State")
#define CODE_DCM_RedistributionState                                       DSRBasicCodedEntry("109093", "DCM", "Redistribution State")
#define CODE_DCM_DelayedRedistributionState                                DSRBasicCodedEntry("109094", "DCM", "Delayed Redistribution State")
#define CODE_DCM_RETIRED_PeakStressState                                   DSRBasicCodedEntry("109095", "DCM", "Peak stress state")
#define CODE_DCM_RETIRED_RecoveryState                                     DSRBasicCodedEntry("109096", "DCM", "Recovery state")
#define CODE_DCM_AcquisitionEquipment                                      DSRBasicCodedEntry("109101", "DCM", "Acquisition Equipment")
#define CODE_DCM_ProcessingEquipment                                       DSRBasicCodedEntry("109102", "DCM", "Processing Equipment")
#define CODE_DCM_ModifyingEquipment                                        DSRBasicCodedEntry("109103", "DCM", "Modifying Equipment")
#define CODE_DCM_DeIdentifyingEquipment                                    DSRBasicCodedEntry("109104", "DCM", "De-identifying Equipment")
#define CODE_DCM_FrameExtractingEquipment                                  DSRBasicCodedEntry("109105", "DCM", "Frame Extracting Equipment")
#define CODE_DCM_EnhancedMultiFrameConversionEquipment                     DSRBasicCodedEntry("109106", "DCM", "Enhanced Multi-frame Conversion Equipment")
#define CODE_DCM_Voice                                                     DSRBasicCodedEntry("109110", "DCM", "Voice")
#define CODE_DCM_OperatorNarrative                                         DSRBasicCodedEntry("109111", "DCM", "Operator's narrative")
#define CODE_DCM_AmbientRoomEnvironment                                    DSRBasicCodedEntry("109112", "DCM", "Ambient room environment")
#define CODE_DCM_DopplerAudio                                              DSRBasicCodedEntry("109113", "DCM", "Doppler audio")
#define CODE_DCM_Phonocardiogram                                           DSRBasicCodedEntry("109114", "DCM", "Phonocardiogram")
#define CODE_DCM_PhysiologicalAudioSignal                                  DSRBasicCodedEntry("109115", "DCM", "Physiological audio signal")
#define CODE_DCM_ArterialPulseWaveform                                     DSRBasicCodedEntry("109116", "DCM", "Arterial Pulse Waveform")
#define CODE_DCM_RespirationWaveform                                       DSRBasicCodedEntry("109117", "DCM", "Respiration Waveform")
#define CODE_DCM_OnAdmissionToUnit                                         DSRBasicCodedEntry("109120", "DCM", "On admission to unit")
#define CODE_DCM_OnDischarge                                               DSRBasicCodedEntry("109121", "DCM", "On discharge")
#define CODE_DCM_OnDischargeFromUnit                                       DSRBasicCodedEntry("109122", "DCM", "On discharge from unit")
#define CODE_DCM_PreIntervention                                           DSRBasicCodedEntry("109123", "DCM", "Pre-intervention")
#define CODE_DCM_PostIntervention                                          DSRBasicCodedEntry("109124", "DCM", "Post-intervention")
#define CODE_DCM_AtLastAppointment                                         DSRBasicCodedEntry("109125", "DCM", "At last appointment")
#define CODE_DCM_JointPositionMethod                                       DSRBasicCodedEntry("109132", "DCM", "Joint position method")
#define CODE_DCM_PhysicalForce                                             DSRBasicCodedEntry("109133", "DCM", "Physical force")
#define CODE_DCM_PriorToVoiding                                            DSRBasicCodedEntry("109134", "DCM", "Prior to voiding")
#define CODE_DCM_PostVoiding                                               DSRBasicCodedEntry("109135", "DCM", "Post voiding")
#define CODE_DCM_NeutralMusculoskeletalPosition                            DSRBasicCodedEntry("109136", "DCM", "Neutral musculoskeletal position")
#define CODE_DCM_DuringVoiding                                             DSRBasicCodedEntry("109137", "DCM", "During voiding")
#define CODE_DCM_AmericaKennelClub                                         DSRBasicCodedEntry("109200", "DCM", "America Kennel Club")
#define CODE_DCM_AmericaPetRegistryInc                                     DSRBasicCodedEntry("109201", "DCM", "America's Pet Registry Inc.")
#define CODE_DCM_AmericanCanineAssociation                                 DSRBasicCodedEntry("109202", "DCM", "American Canine Association")
#define CODE_DCM_AmericanPurebredRegistry                                  DSRBasicCodedEntry("109203", "DCM", "American Purebred Registry")
#define CODE_DCM_AmericanRareBreedAssociation                              DSRBasicCodedEntry("109204", "DCM", "American Rare Breed Association")
#define CODE_DCM_AnimalRegistryUnlimited                                   DSRBasicCodedEntry("109205", "DCM", "Animal Registry Unlimited")
#define CODE_DCM_AnimalResearchFoundation                                  DSRBasicCodedEntry("109206", "DCM", "Animal Research Foundation")
#define CODE_DCM_CanadianBorderCollieAssociation                           DSRBasicCodedEntry("109207", "DCM", "Canadian Border Collie Association")
#define CODE_DCM_CanadianKennelClub                                        DSRBasicCodedEntry("109208", "DCM", "Canadian Kennel Club")
#define CODE_DCM_CanadianLivestockRecordsAssociation                       DSRBasicCodedEntry("109209", "DCM", "Canadian Livestock Records Association")
#define CODE_DCM_CanineFederationOfCanada                                  DSRBasicCodedEntry("109210", "DCM", "Canine Federation of Canada")
#define CODE_DCM_ContinentalKennelClub                                     DSRBasicCodedEntry("109211", "DCM", "Continental Kennel Club")
#define CODE_DCM_DogRegistryOfAmerica                                      DSRBasicCodedEntry("109212", "DCM", "Dog Registry of America")
#define CODE_DCM_FederationOfInternationalCanines                          DSRBasicCodedEntry("109213", "DCM", "Federation of International Canines")
#define CODE_DCM_InternationalProgressiveDogBreedersAlliance               DSRBasicCodedEntry("109214", "DCM", "International Progressive Dog Breeders' Alliance")
#define CODE_DCM_NationalKennelClub                                        DSRBasicCodedEntry("109215", "DCM", "National Kennel Club")
#define CODE_DCM_NorthAmericanPurebredDogRegistry                          DSRBasicCodedEntry("109216", "DCM", "North American Purebred Dog Registry")
#define CODE_DCM_UnitedAllBreedRegistry                                    DSRBasicCodedEntry("109217", "DCM", "United All Breed Registry")
#define CODE_DCM_UnitedKennelClub                                          DSRBasicCodedEntry("109218", "DCM", "United Kennel Club")
#define CODE_DCM_UniversalKennelClubInternational                          DSRBasicCodedEntry("109219", "DCM", "Universal Kennel Club International")
#define CODE_DCM_WorkingCanineAssociationOfCanada                          DSRBasicCodedEntry("109220", "DCM", "Working Canine Association of Canada")
#define CODE_DCM_WorldKennelClub                                           DSRBasicCodedEntry("109221", "DCM", "World Kennel Club")
#define CODE_DCM_WorldWideKennelClub                                       DSRBasicCodedEntry("109222", "DCM", "World Wide Kennel Club")
#define CODE_DCM_OverallImageQualityEvaluation                             DSRBasicCodedEntry("109701", "DCM", "Overall image quality evaluation")
#define CODE_DCM_GrayscaleResolutionEvaluation                             DSRBasicCodedEntry("109702", "DCM", "Grayscale resolution evaluation")
#define CODE_DCM_LuminanceResponseEvaluation                               DSRBasicCodedEntry("109703", "DCM", "Luminance response evaluation")
#define CODE_DCM_LuminanceUniformityEvaluation                             DSRBasicCodedEntry("109704", "DCM", "Luminance uniformity evaluation")
#define CODE_DCM_ChromaticityEvaluation                                    DSRBasicCodedEntry("109705", "DCM", "Chromaticity evaluation")
#define CODE_DCM_PixelFaultsEvaluation                                     DSRBasicCodedEntry("109706", "DCM", "Pixel faults evaluation")
#define CODE_DCM_VeilingGlareEvaluation                                    DSRBasicCodedEntry("109707", "DCM", "Veiling glare evaluation")
#define CODE_DCM_GeometricalImageEvaluation                                DSRBasicCodedEntry("109708", "DCM", "Geometrical image evaluation")
#define CODE_DCM_AngularViewingEvaluation                                  DSRBasicCodedEntry("109709", "DCM", "Angular viewing evaluation")
#define CODE_DCM_ClinicalEvaluation                                        DSRBasicCodedEntry("109710", "DCM", "Clinical evaluation")
#define CODE_DCM_TG18_QCPattern                                            DSRBasicCodedEntry("109801", "DCM", "TG18-QC Pattern")
#define CODE_DCM_TG18_BRPattern                                            DSRBasicCodedEntry("109802", "DCM", "TG18-BR Pattern")
#define CODE_DCM_TG18_PQCPattern                                           DSRBasicCodedEntry("109803", "DCM", "TG18-PQC Pattern")
#define CODE_DCM_TG18_CTPattern                                            DSRBasicCodedEntry("109804", "DCM", "TG18-CT Pattern")
#define CODE_DCM_TG18_LN801Pattern                                         DSRBasicCodedEntry("109805", "DCM", "TG18-LN8-01 Pattern")
#define CODE_DCM_TG18_LN802Pattern                                         DSRBasicCodedEntry("109806", "DCM", "TG18-LN8-02 Pattern")
#define CODE_DCM_TG18_LN803Pattern                                         DSRBasicCodedEntry("109807", "DCM", "TG18-LN8-03 Pattern")
#define CODE_DCM_TG18_LN804Pattern                                         DSRBasicCodedEntry("109808", "DCM", "TG18-LN8-04 Pattern")
#define CODE_DCM_TG18_LN805Pattern                                         DSRBasicCodedEntry("109809", "DCM", "TG18-LN8-05 Pattern")
#define CODE_DCM_TG18_LN806Pattern                                         DSRBasicCodedEntry("109810", "DCM", "TG18-LN8-06 Pattern")
#define CODE_DCM_TG18_LN807Pattern                                         DSRBasicCodedEntry("109811", "DCM", "TG18-LN8-07 Pattern")
#define CODE_DCM_TG18_LN808Pattern                                         DSRBasicCodedEntry("109812", "DCM", "TG18-LN8-08 Pattern")
#define CODE_DCM_TG18_LN809Pattern                                         DSRBasicCodedEntry("109813", "DCM", "TG18-LN8-09 Pattern")
#define CODE_DCM_TG18_LN810Pattern                                         DSRBasicCodedEntry("109814", "DCM", "TG18-LN8-10 Pattern")
#define CODE_DCM_TG18_LN811Pattern                                         DSRBasicCodedEntry("109815", "DCM", "TG18-LN8-11 Pattern")
#define CODE_DCM_TG18_LN812Pattern                                         DSRBasicCodedEntry("109816", "DCM", "TG18-LN8-12 Pattern")
#define CODE_DCM_TG18_LN813Pattern                                         DSRBasicCodedEntry("109817", "DCM", "TG18-LN8-13 Pattern")
#define CODE_DCM_TG18_LN814Pattern                                         DSRBasicCodedEntry("109818", "DCM", "TG18-LN8-14 Pattern")
#define CODE_DCM_TG18_LN815Pattern                                         DSRBasicCodedEntry("109819", "DCM", "TG18-LN8-15 Pattern")
#define CODE_DCM_TG18_LN816Pattern                                         DSRBasicCodedEntry("109820", "DCM", "TG18-LN8-16 Pattern")
#define CODE_DCM_TG18_LN817Pattern                                         DSRBasicCodedEntry("109821", "DCM", "TG18-LN8-17 Pattern")
#define CODE_DCM_TG18_LN818Pattern                                         DSRBasicCodedEntry("109822", "DCM", "TG18-LN8-18 Pattern")
#define CODE_DCM_TG18_LN1201Pattern                                        DSRBasicCodedEntry("109823", "DCM", "TG18-LN12-01 Pattern")
#define CODE_DCM_TG18_LN1202Pattern                                        DSRBasicCodedEntry("109824", "DCM", "TG18-LN12-02 Pattern")
#define CODE_DCM_TG18_LN1203Pattern                                        DSRBasicCodedEntry("109825", "DCM", "TG18-LN12-03 Pattern")
#define CODE_DCM_TG18_LN1204Pattern                                        DSRBasicCodedEntry("109826", "DCM", "TG18-LN12-04 Pattern")
#define CODE_DCM_TG18_LN1205Pattern                                        DSRBasicCodedEntry("109827", "DCM", "TG18-LN12-05 Pattern")
#define CODE_DCM_TG18_LN1206Pattern                                        DSRBasicCodedEntry("109828", "DCM", "TG18-LN12-06 Pattern")
#define CODE_DCM_TG18_LN1207Pattern                                        DSRBasicCodedEntry("109829", "DCM", "TG18-LN12-07 Pattern")
#define CODE_DCM_TG18_LN1208Pattern                                        DSRBasicCodedEntry("109830", "DCM", "TG18-LN12-08 Pattern")
#define CODE_DCM_TG18_LN1209Pattern                                        DSRBasicCodedEntry("109831", "DCM", "TG18-LN12-09 Pattern")
#define CODE_DCM_TG18_LN1210Pattern                                        DSRBasicCodedEntry("109832", "DCM", "TG18-LN12-10 Pattern")
#define CODE_DCM_TG18_LN1211Pattern                                        DSRBasicCodedEntry("109833", "DCM", "TG18-LN12-11 Pattern")
#define CODE_DCM_TG18_LN1212Pattern                                        DSRBasicCodedEntry("109834", "DCM", "TG18-LN12-12 Pattern")
#define CODE_DCM_TG18_LN1213Pattern                                        DSRBasicCodedEntry("109835", "DCM", "TG18-LN12-13 Pattern")
#define CODE_DCM_TG18_LN1214Pattern                                        DSRBasicCodedEntry("109836", "DCM", "TG18-LN12-14 Pattern")
#define CODE_DCM_TG18_LN1215Pattern                                        DSRBasicCodedEntry("109837", "DCM", "TG18-LN12-15 Pattern")
#define CODE_DCM_TG18_LN1216Pattern                                        DSRBasicCodedEntry("109838", "DCM", "TG18-LN12-16 Pattern")
#define CODE_DCM_TG18_LN1217Pattern                                        DSRBasicCodedEntry("109839", "DCM", "TG18-LN12-17 Pattern")
#define CODE_DCM_TG18_LN1218Pattern                                        DSRBasicCodedEntry("109840", "DCM", "TG18-LN12-18 Pattern")
#define CODE_DCM_TG18_UN10Pattern                                          DSRBasicCodedEntry("109841", "DCM", "TG18-UN10 Pattern")
#define CODE_DCM_TG18_UN80Pattern                                          DSRBasicCodedEntry("109842", "DCM", "TG18-UN80 Pattern")
#define CODE_DCM_TG18_UNL10Pattern                                         DSRBasicCodedEntry("109843", "DCM", "TG18-UNL10 Pattern")
#define CODE_DCM_TG18_UNL80Pattern                                         DSRBasicCodedEntry("109844", "DCM", "TG18-UNL80 Pattern")
#define CODE_DCM_TG18_ADPattern                                            DSRBasicCodedEntry("109845", "DCM", "TG18-AD Pattern")
#define CODE_DCM_TG18_MPPattern                                            DSRBasicCodedEntry("109846", "DCM", "TG18-MP Pattern")
#define CODE_DCM_TG18_RH10Pattern                                          DSRBasicCodedEntry("109847", "DCM", "TG18-RH10 Pattern")
#define CODE_DCM_TG18_RH50Pattern                                          DSRBasicCodedEntry("109848", "DCM", "TG18-RH50 Pattern")
#define CODE_DCM_TG18_RH89Pattern                                          DSRBasicCodedEntry("109849", "DCM", "TG18-RH89 Pattern")
#define CODE_DCM_TG18_RV10Pattern                                          DSRBasicCodedEntry("109850", "DCM", "TG18-RV10 Pattern")
#define CODE_DCM_TG18_RV50Pattern                                          DSRBasicCodedEntry("109851", "DCM", "TG18-RV50 Pattern")
#define CODE_DCM_TG18_RV89Pattern                                          DSRBasicCodedEntry("109852", "DCM", "TG18-RV89 Pattern")
#define CODE_DCM_TG18_PXPattern                                            DSRBasicCodedEntry("109853", "DCM", "TG18-PX Pattern")
#define CODE_DCM_TG18_CXPattern                                            DSRBasicCodedEntry("109854", "DCM", "TG18-CX Pattern")
#define CODE_DCM_TG18_LPH10Pattern                                         DSRBasicCodedEntry("109855", "DCM", "TG18-LPH10 Pattern")
#define CODE_DCM_TG18_LPH50Pattern                                         DSRBasicCodedEntry("109856", "DCM", "TG18-LPH50 Pattern")
#define CODE_DCM_TG18_LPH89Pattern                                         DSRBasicCodedEntry("109857", "DCM", "TG18-LPH89 Pattern")
#define CODE_DCM_TG18_LPV10Pattern                                         DSRBasicCodedEntry("109858", "DCM", "TG18-LPV10 Pattern")
#define CODE_DCM_TG18_LPV50Pattern                                         DSRBasicCodedEntry("109859", "DCM", "TG18-LPV50 Pattern")
#define CODE_DCM_TG18_LPV89Pattern                                         DSRBasicCodedEntry("109860", "DCM", "TG18-LPV89 Pattern")
#define CODE_DCM_TG18_AFCPattern                                           DSRBasicCodedEntry("109861", "DCM", "TG18-AFC Pattern")
#define CODE_DCM_TG18_NS10Pattern                                          DSRBasicCodedEntry("109862", "DCM", "TG18-NS10 Pattern")
#define CODE_DCM_TG18_NS50Pattern                                          DSRBasicCodedEntry("109863", "DCM", "TG18-NS50 Pattern")
#define CODE_DCM_TG18_NS89Pattern                                          DSRBasicCodedEntry("109864", "DCM", "TG18-NS89 Pattern")
#define CODE_DCM_TG18_GVPattern                                            DSRBasicCodedEntry("109865", "DCM", "TG18-GV Pattern")
#define CODE_DCM_TG18_GVNPattern                                           DSRBasicCodedEntry("109866", "DCM", "TG18-GVN Pattern")
#define CODE_DCM_TG18_GQPattern                                            DSRBasicCodedEntry("109867", "DCM", "TG18-GQ Pattern")
#define CODE_DCM_TG18_GQNPattern                                           DSRBasicCodedEntry("109868", "DCM", "TG18-GQN Pattern")
#define CODE_DCM_TG18_GQBPattern                                           DSRBasicCodedEntry("109869", "DCM", "TG18-GQB Pattern")
#define CODE_DCM_TG18_GA03Pattern                                          DSRBasicCodedEntry("109870", "DCM", "TG18-GA03 Pattern")
#define CODE_DCM_TG18_GA05Pattern                                          DSRBasicCodedEntry("109871", "DCM", "TG18-GA05 Pattern")
#define CODE_DCM_TG18_GA08Pattern                                          DSRBasicCodedEntry("109872", "DCM", "TG18-GA08 Pattern")
#define CODE_DCM_TG18_GA10Pattern                                          DSRBasicCodedEntry("109873", "DCM", "TG18-GA10 Pattern")
#define CODE_DCM_TG18_GA15Pattern                                          DSRBasicCodedEntry("109874", "DCM", "TG18-GA15 Pattern")
#define CODE_DCM_TG18_GA20Pattern                                          DSRBasicCodedEntry("109875", "DCM", "TG18-GA20 Pattern")
#define CODE_DCM_TG18_GA25Pattern                                          DSRBasicCodedEntry("109876", "DCM", "TG18-GA25 Pattern")
#define CODE_DCM_TG18_GA30Pattern                                          DSRBasicCodedEntry("109877", "DCM", "TG18-GA30 Pattern")
#define CODE_DCM_TG18_CHImage                                              DSRBasicCodedEntry("109878", "DCM", "TG18-CH Image")
#define CODE_DCM_TG18_KNImage                                              DSRBasicCodedEntry("109879", "DCM", "TG18-KN Image")
#define CODE_DCM_TG18_MM1Image                                             DSRBasicCodedEntry("109880", "DCM", "TG18-MM1 Image")
#define CODE_DCM_TG18_MM2Image                                             DSRBasicCodedEntry("109881", "DCM", "TG18-MM2 Image")
#define CODE_DCM_OIQPattern                                                DSRBasicCodedEntry("109901", "DCM", "OIQ Pattern")
#define CODE_DCM_ANGPattern                                                DSRBasicCodedEntry("109902", "DCM", "ANG Pattern")
#define CODE_DCM_GDPattern                                                 DSRBasicCodedEntry("109903", "DCM", "GD Pattern")
#define CODE_DCM_BN01Pattern                                               DSRBasicCodedEntry("109904", "DCM", "BN01 Pattern")
#define CODE_DCM_BN02Pattern                                               DSRBasicCodedEntry("109905", "DCM", "BN02 Pattern")
#define CODE_DCM_BN03Pattern                                               DSRBasicCodedEntry("109906", "DCM", "BN03 Pattern")
#define CODE_DCM_BN04Pattern                                               DSRBasicCodedEntry("109907", "DCM", "BN04 Pattern")
#define CODE_DCM_BN05Pattern                                               DSRBasicCodedEntry("109908", "DCM", "BN05 Pattern")
#define CODE_DCM_BN06Pattern                                               DSRBasicCodedEntry("109909", "DCM", "BN06 Pattern")
#define CODE_DCM_BN07Pattern                                               DSRBasicCodedEntry("109910", "DCM", "BN07 Pattern")
#define CODE_DCM_BN08Pattern                                               DSRBasicCodedEntry("109911", "DCM", "BN08 Pattern")
#define CODE_DCM_BN09Pattern                                               DSRBasicCodedEntry("109912", "DCM", "BN09 Pattern")
#define CODE_DCM_BN10Pattern                                               DSRBasicCodedEntry("109913", "DCM", "BN10 Pattern")
#define CODE_DCM_BN11Pattern                                               DSRBasicCodedEntry("109914", "DCM", "BN11 Pattern")
#define CODE_DCM_BN12Pattern                                               DSRBasicCodedEntry("109915", "DCM", "BN12 Pattern")
#define CODE_DCM_BN13Pattern                                               DSRBasicCodedEntry("109916", "DCM", "BN13 Pattern")
#define CODE_DCM_BN14Pattern                                               DSRBasicCodedEntry("109917", "DCM", "BN14 Pattern")
#define CODE_DCM_BN15Pattern                                               DSRBasicCodedEntry("109918", "DCM", "BN15 Pattern")
#define CODE_DCM_BN16Pattern                                               DSRBasicCodedEntry("109919", "DCM", "BN16 Pattern")
#define CODE_DCM_BN17Pattern                                               DSRBasicCodedEntry("109920", "DCM", "BN17 Pattern")
#define CODE_DCM_BN18Pattern                                               DSRBasicCodedEntry("109921", "DCM", "BN18 Pattern")
#define CODE_DCM_DINGrayscalePattern                                       DSRBasicCodedEntry("109931", "DCM", "DIN Grayscale Pattern")
#define CODE_DCM_DINGeometryPattern                                        DSRBasicCodedEntry("109932", "DCM", "DIN Geometry Pattern")
#define CODE_DCM_DINResolutionPattern                                      DSRBasicCodedEntry("109933", "DCM", "DIN Resolution Pattern")
#define CODE_DCM_WhitePattern                                              DSRBasicCodedEntry("109941", "DCM", "White Pattern")
#define CODE_DCM_SMPTEPattern                                              DSRBasicCodedEntry("109943", "DCM", "SMPTE Pattern")
#define CODE_DCM_CRTDisplay                                                DSRBasicCodedEntry("109991", "DCM", "CRT Display")
#define CODE_DCM_LiquidCrystalDisplay                                      DSRBasicCodedEntry("109992", "DCM", "Liquid Crystal Display")
#define CODE_DCM_PlasmaDisplay                                             DSRBasicCodedEntry("109993", "DCM", "Plasma Display")
#define CODE_DCM_OLED                                                      DSRBasicCodedEntry("109994", "DCM", "OLED")
#define CODE_DCM_DLPRearProjectionSystem                                   DSRBasicCodedEntry("109995", "DCM", "DLP Rear Projection System")
#define CODE_DCM_DLPFrontProjectionSystem                                  DSRBasicCodedEntry("109996", "DCM", "DLP Front Projection System")
#define CODE_DCM_CRTRearProjectionSystem                                   DSRBasicCodedEntry("109997", "DCM", "CRT Rear Projection System")
#define CODE_DCM_CRTFrontProjectionSystem                                  DSRBasicCodedEntry("109998", "DCM", "CRT Front Projection System")
#define CODE_DCM_OtherProjectionSystem                                     DSRBasicCodedEntry("109999", "DCM", "Other Projection System")
#define CODE_DCM_ImageProcessing                                           DSRBasicCodedEntry("110001", "DCM", "Image Processing")
#define CODE_DCM_QualityControl                                            DSRBasicCodedEntry("110002", "DCM", "Quality Control")
#define CODE_DCM_ComputerAidedDiagnosis                                    DSRBasicCodedEntry("110003", "DCM", "Computer Aided Diagnosis")
#define CODE_DCM_ComputerAidedDetection                                    DSRBasicCodedEntry("110004", "DCM", "Computer Aided Detection")
#define CODE_DCM_Interpretation                                            DSRBasicCodedEntry("110005", "DCM", "Interpretation")
#define CODE_DCM_Transcription_110006                                      DSRBasicCodedEntry("110006", "DCM", "Transcription")
#define CODE_DCM_ReportVerification                                        DSRBasicCodedEntry("110007", "DCM", "Report Verification")
#define CODE_DCM_Print                                                     DSRBasicCodedEntry("110008", "DCM", "Print")
#define CODE_DCM_NoSubsequentWorkitems                                     DSRBasicCodedEntry("110009", "DCM", "No subsequent Workitems")
#define CODE_DCM_Film_110010                                               DSRBasicCodedEntry("110010", "DCM", "Film")
#define CODE_DCM_Dictation                                                 DSRBasicCodedEntry("110011", "DCM", "Dictation")
#define CODE_DCM_Transcription_110012                                      DSRBasicCodedEntry("110012", "DCM", "Transcription")
#define CODE_DCM_MediaImport                                               DSRBasicCodedEntry("110013", "DCM", "Media Import")
#define CODE_DCM_SheetFilmDigitized                                        DSRBasicCodedEntry("110020", "DCM", "Sheet Film Digitized")
#define CODE_DCM_CineFilmDigitized                                         DSRBasicCodedEntry("110021", "DCM", "Cine Film Digitized")
#define CODE_DCM_VideoTapeDigitized                                        DSRBasicCodedEntry("110022", "DCM", "Video Tape Digitized")
#define CODE_DCM_PaperDigitized                                            DSRBasicCodedEntry("110023", "DCM", "Paper Digitized")
#define CODE_DCM_CDImported                                                DSRBasicCodedEntry("110024", "DCM", "CD Imported")
#define CODE_DCM_DVDImported                                               DSRBasicCodedEntry("110025", "DCM", "DVD Imported")
#define CODE_DCM_MODImported                                               DSRBasicCodedEntry("110026", "DCM", "MOD Imported")
#define CODE_DCM_StudiesImported                                           DSRBasicCodedEntry("110027", "DCM", "Studies Imported")
#define CODE_DCM_InstancesImported                                         DSRBasicCodedEntry("110028", "DCM", "Instances Imported")
#define CODE_DCM_USBDiskEmulation                                          DSRBasicCodedEntry("110030", "DCM", "USB Disk Emulation")
#define CODE_DCM_Email                                                     DSRBasicCodedEntry("110031", "DCM", "Email")
#define CODE_DCM_CD                                                        DSRBasicCodedEntry("110032", "DCM", "CD")
#define CODE_DCM_DVD                                                       DSRBasicCodedEntry("110033", "DCM", "DVD")
#define CODE_DCM_CompactFlash                                              DSRBasicCodedEntry("110034", "DCM", "Compact Flash")
#define CODE_DCM_MultiMediaCard                                            DSRBasicCodedEntry("110035", "DCM", "Multi-media Card")
#define CODE_DCM_SecureDigitalCard                                         DSRBasicCodedEntry("110036", "DCM", "Secure Digital Card")
#define CODE_DCM_URI                                                       DSRBasicCodedEntry("110037", "DCM", "URI")
#define CODE_DCM_PaperDocument                                             DSRBasicCodedEntry("110038", "DCM", "Paper Document")
#define CODE_DCM_ApplicationActivity                                       DSRBasicCodedEntry("110100", "DCM", "Application Activity")
#define CODE_DCM_AuditLogUsed                                              DSRBasicCodedEntry("110101", "DCM", "Audit Log Used")
#define CODE_DCM_BeginTransferringDICOMInstances                           DSRBasicCodedEntry("110102", "DCM", "Begin Transferring DICOM Instances")
#define CODE_DCM_DICOMInstancesAccessed                                    DSRBasicCodedEntry("110103", "DCM", "DICOM Instances Accessed")
#define CODE_DCM_DICOMInstancesTransferred                                 DSRBasicCodedEntry("110104", "DCM", "DICOM Instances Transferred")
#define CODE_DCM_DICOMStudyDeleted                                         DSRBasicCodedEntry("110105", "DCM", "DICOM Study Deleted")
#define CODE_DCM_Export                                                    DSRBasicCodedEntry("110106", "DCM", "Export")
#define CODE_DCM_Import                                                    DSRBasicCodedEntry("110107", "DCM", "Import")
#define CODE_DCM_NetworkEntry                                              DSRBasicCodedEntry("110108", "DCM", "Network Entry")
#define CODE_DCM_OrderRecord                                               DSRBasicCodedEntry("110109", "DCM", "Order Record")
#define CODE_DCM_PatientRecord                                             DSRBasicCodedEntry("110110", "DCM", "Patient Record")
#define CODE_DCM_ProcedureRecord                                           DSRBasicCodedEntry("110111", "DCM", "Procedure Record")
#define CODE_DCM_Query                                                     DSRBasicCodedEntry("110112", "DCM", "Query")
#define CODE_DCM_SecurityAlert                                             DSRBasicCodedEntry("110113", "DCM", "Security Alert")
#define CODE_DCM_UserAuthentication                                        DSRBasicCodedEntry("110114", "DCM", "User Authentication")
#define CODE_DCM_StationAETitle                                            DSRBasicCodedEntry("110119", "DCM", "Station AE Title")
#define CODE_DCM_ApplicationStart                                          DSRBasicCodedEntry("110120", "DCM", "Application Start")
#define CODE_DCM_ApplicationStop                                           DSRBasicCodedEntry("110121", "DCM", "Application Stop")
#define CODE_DCM_Login                                                     DSRBasicCodedEntry("110122", "DCM", "Login")
#define CODE_DCM_Logout                                                    DSRBasicCodedEntry("110123", "DCM", "Logout")
#define CODE_DCM_Attach                                                    DSRBasicCodedEntry("110124", "DCM", "Attach")
#define CODE_DCM_Detach                                                    DSRBasicCodedEntry("110125", "DCM", "Detach")
#define CODE_DCM_NodeAuthentication                                        DSRBasicCodedEntry("110126", "DCM", "Node Authentication")
#define CODE_DCM_EmergencyOverrideStarted                                  DSRBasicCodedEntry("110127", "DCM", "Emergency Override Started")
#define CODE_DCM_NetworkConfiguration                                      DSRBasicCodedEntry("110128", "DCM", "Network Configuration")
#define CODE_DCM_SecurityConfiguration                                     DSRBasicCodedEntry("110129", "DCM", "Security Configuration")
#define CODE_DCM_HardwareConfiguration                                     DSRBasicCodedEntry("110130", "DCM", "Hardware Configuration")
#define CODE_DCM_SoftwareConfiguration                                     DSRBasicCodedEntry("110131", "DCM", "Software Configuration")
#define CODE_DCM_UseOfRestrictedFunction                                   DSRBasicCodedEntry("110132", "DCM", "Use of Restricted Function")
#define CODE_DCM_AuditRecordingStopped                                     DSRBasicCodedEntry("110133", "DCM", "Audit Recording Stopped")
#define CODE_DCM_AuditRecordingStarted                                     DSRBasicCodedEntry("110134", "DCM", "Audit Recording Started")
#define CODE_DCM_ObjectSecurityAttributesChanged                           DSRBasicCodedEntry("110135", "DCM", "Object Security Attributes Changed")
#define CODE_DCM_SecurityRolesChanged                                      DSRBasicCodedEntry("110136", "DCM", "Security Roles Changed")
#define CODE_DCM_UserSecurityAttributesChanged                             DSRBasicCodedEntry("110137", "DCM", "User security Attributes Changed")
#define CODE_DCM_EmergencyOverrideStopped                                  DSRBasicCodedEntry("110138", "DCM", "Emergency Override Stopped")
#define CODE_DCM_RemoteServiceOperationStarted                             DSRBasicCodedEntry("110139", "DCM", "Remote Service Operation Started")
#define CODE_DCM_RemoteServiceOperationStopped                             DSRBasicCodedEntry("110140", "DCM", "Remote Service Operation Stopped")
#define CODE_DCM_LocalServiceOperationStarted                              DSRBasicCodedEntry("110141", "DCM", "Local Service Operation Started")
#define CODE_DCM_LocalServiceOperationStopped                              DSRBasicCodedEntry("110142", "DCM", "Local Service Operation Stopped")
#define CODE_DCM_AuthenticationDecision                                    DSRBasicCodedEntry("110143", "DCM", "Authentication Decision")
#define CODE_DCM_AuthorizationDecision                                     DSRBasicCodedEntry("110144", "DCM", "Authorization Decision")
#define CODE_DCM_SessionStart                                              DSRBasicCodedEntry("110145", "DCM", "Session start")
#define CODE_DCM_SessionStop                                               DSRBasicCodedEntry("110146", "DCM", "Session stop")
#define CODE_DCM_AccessControlDecision                                     DSRBasicCodedEntry("110147", "DCM", "Access Control Decision")
#define CODE_DCM_Application                                               DSRBasicCodedEntry("110150", "DCM", "Application")
#define CODE_DCM_ApplicationLauncher                                       DSRBasicCodedEntry("110151", "DCM", "Application Launcher")
#define CODE_DCM_DestinationRoleID                                         DSRBasicCodedEntry("110152", "DCM", "Destination Role ID")
#define CODE_DCM_SourceRoleID                                              DSRBasicCodedEntry("110153", "DCM", "Source Role ID")
#define CODE_DCM_DestinationMedia                                          DSRBasicCodedEntry("110154", "DCM", "Destination Media")
#define CODE_DCM_SourceMedia                                               DSRBasicCodedEntry("110155", "DCM", "Source Media")
#define CODE_DCM_StudyInstanceUID                                          DSRBasicCodedEntry("110180", "DCM", "Study Instance UID")
#define CODE_DCM_SOPClassUID                                               DSRBasicCodedEntry("110181", "DCM", "SOP Class UID")
#define CODE_DCM_NodeID                                                    DSRBasicCodedEntry("110182", "DCM", "Node ID")
#define CODE_DCM_IssuerOfIdentifier                                        DSRBasicCodedEntry("110190", "DCM", "Issuer of Identifier")
#define CODE_DCM_DoctorCanceledProcedure                                   DSRBasicCodedEntry("110500", "DCM", "Doctor canceled procedure")
#define CODE_DCM_EquipmentFailure                                          DSRBasicCodedEntry("110501", "DCM", "Equipment failure")
#define CODE_DCM_IncorrectProcedureOrdered                                 DSRBasicCodedEntry("110502", "DCM", "Incorrect procedure ordered")
#define CODE_DCM_PatientAllergicToMediaContrast                            DSRBasicCodedEntry("110503", "DCM", "Patient allergic to media/contrast")
#define CODE_DCM_PatientDied                                               DSRBasicCodedEntry("110504", "DCM", "Patient died")
#define CODE_DCM_PatientRefusedToContinueProcedure                         DSRBasicCodedEntry("110505", "DCM", "Patient refused to continue procedure")
#define CODE_DCM_PatientTakenForTreatmentOrSurgery                         DSRBasicCodedEntry("110506", "DCM", "Patient taken for treatment or surgery")
#define CODE_DCM_PatientDidNotArrive                                       DSRBasicCodedEntry("110507", "DCM", "Patient did not arrive")
#define CODE_DCM_PatientPregnant                                           DSRBasicCodedEntry("110508", "DCM", "Patient pregnant")
#define CODE_DCM_ChangeOfProcedureForCorrectCharging                       DSRBasicCodedEntry("110509", "DCM", "Change of procedure for correct charging")
#define CODE_DCM_DuplicateOrder                                            DSRBasicCodedEntry("110510", "DCM", "Duplicate order")
#define CODE_DCM_NursingUnitCancel                                         DSRBasicCodedEntry("110511", "DCM", "Nursing unit cancel")
#define CODE_DCM_IncorrectSideOrdered                                      DSRBasicCodedEntry("110512", "DCM", "Incorrect side ordered")
#define CODE_DCM_DiscontinuedForUnspecifiedReason                          DSRBasicCodedEntry("110513", "DCM", "Discontinued for unspecified reason")
#define CODE_DCM_IncorrectWorklistEntrySelected                            DSRBasicCodedEntry("110514", "DCM", "Incorrect worklist entry selected")
#define CODE_DCM_PatientConditionPreventedContinuing                       DSRBasicCodedEntry("110515", "DCM", "Patient condition prevented continuing")
#define CODE_DCM_EquipmentChange                                           DSRBasicCodedEntry("110516", "DCM", "Equipment change")
#define CODE_DCM_PatientMovement                                           DSRBasicCodedEntry("110518", "DCM", "Patient Movement")
#define CODE_DCM_OperatorError                                             DSRBasicCodedEntry("110519", "DCM", "Operator Error")
#define CODE_DCM_ObjectsIncorrectlyFormatted                               DSRBasicCodedEntry("110521", "DCM", "Objects incorrectly formatted")
#define CODE_DCM_ObjectTypesNotSupported                                   DSRBasicCodedEntry("110522", "DCM", "Object Types not supported")
#define CODE_DCM_ObjectSetIncomplete                                       DSRBasicCodedEntry("110523", "DCM", "Object Set incomplete")
#define CODE_DCM_MediaFailure                                              DSRBasicCodedEntry("110524", "DCM", "Media Failure")
#define CODE_DCM_ResourcePreEmpted                                         DSRBasicCodedEntry("110526", "DCM", "Resource pre-empted")
#define CODE_DCM_ResourceInadequate                                        DSRBasicCodedEntry("110527", "DCM", "Resource inadequate")
#define CODE_DCM_DiscontinuedProcedureStepRescheduled                      DSRBasicCodedEntry("110528", "DCM", "Discontinued Procedure Step rescheduled")
#define CODE_DCM_DiscontinuedProcedureStepReschedulingRecommended          DSRBasicCodedEntry("110529", "DCM", "Discontinued Procedure Step rescheduling recommended")
#define CODE_DCM_WorkitemAssignmentRejectedByAssignedResource              DSRBasicCodedEntry("110530", "DCM", "Workitem assignment rejected by assigned resource")
#define CODE_DCM_InsufficientQualityForInterpretation                      DSRBasicCodedEntry("110531", "DCM", "Insufficient quality for interpretation")
#define CODE_DCM_InterpretationRequiresSpecialistExpertise                 DSRBasicCodedEntry("110532", "DCM", "Interpretation requires specialist expertise")
#define CODE_DCM_WorkitemExpired                                           DSRBasicCodedEntry("110533", "DCM", "Workitem expired")
#define CODE_DCM_VentralDiencephalon                                       DSRBasicCodedEntry("110700", "DCM", "Ventral Diencephalon")
#define CODE_DCM_WhiteMatterT1Hypointensity                                DSRBasicCodedEntry("110701", "DCM", "White Matter T1 Hypointensity")
#define CODE_DCM_WhiteMatterT2Hyperintensity                               DSRBasicCodedEntry("110702", "DCM", "White Matter T2 Hyperintensity")
#define CODE_DCM_SuperiorLongitudinalFasciculusI                           DSRBasicCodedEntry("110703", "DCM", "superior longitudinal fasciculus I")
#define CODE_DCM_SuperiorLongitudinalFasciculusII                          DSRBasicCodedEntry("110704", "DCM", "superior longitudinal fasciculus II")
#define CODE_DCM_SuperiorLongitudinalFasciculusIII                         DSRBasicCodedEntry("110705", "DCM", "superior longitudinal fasciculus III")
#define CODE_DCM_PerilesionalWhiteMatter                                   DSRBasicCodedEntry("110706", "DCM", "Perilesional White Matter")
#define CODE_DCM_SpinTaggingPerfusionMRSignalIntensity                     DSRBasicCodedEntry("110800", "DCM", "Spin Tagging Perfusion MR Signal Intensity")
#define CODE_DCM_ContrastAgentAngioMRSignalIntensity                       DSRBasicCodedEntry("110801", "DCM", "Contrast Agent Angio MR Signal Intensity")
#define CODE_DCM_TimeOfFlightAngioMRSignalIntensity                        DSRBasicCodedEntry("110802", "DCM", "Time Of Flight Angio MR Signal Intensity")
#define CODE_DCM_ProtonDensityWeightedMRSignalIntensity                    DSRBasicCodedEntry("110803", "DCM", "Proton Density Weighted MR Signal Intensity")
#define CODE_DCM_T1WeightedMRSignalIntensity                               DSRBasicCodedEntry("110804", "DCM", "T1 Weighted MR Signal Intensity")
#define CODE_DCM_T2WeightedMRSignalIntensity                               DSRBasicCodedEntry("110805", "DCM", "T2 Weighted MR Signal Intensity")
#define CODE_DCM_T2StarWeightedMRSignalIntensity                           DSRBasicCodedEntry("110806", "DCM", "T2* Weighted MR Signal Intensity")
#define CODE_DCM_FieldMapMRSignalIntensity                                 DSRBasicCodedEntry("110807", "DCM", "Field Map MR Signal Intensity")
#define CODE_DCM_FractionalAnisotropy                                      DSRBasicCodedEntry("110808", "DCM", "Fractional Anisotropy")
#define CODE_DCM_RelativeAnisotropy                                        DSRBasicCodedEntry("110809", "DCM", "Relative Anisotropy")
#define CODE_DCM_VolumetricDiffusionDxxComponent                           DSRBasicCodedEntry("110810", "DCM", "Volumetric Diffusion Dxx Component")
#define CODE_DCM_VolumetricDiffusionDxyComponent                           DSRBasicCodedEntry("110811", "DCM", "Volumetric Diffusion Dxy Component")
#define CODE_DCM_VolumetricDiffusionDxzComponent                           DSRBasicCodedEntry("110812", "DCM", "Volumetric Diffusion Dxz Component")
#define CODE_DCM_VolumetricDiffusionDyyComponent                           DSRBasicCodedEntry("110813", "DCM", "Volumetric Diffusion Dyy Component")
#define CODE_DCM_VolumetricDiffusionDyzComponent                           DSRBasicCodedEntry("110814", "DCM", "Volumetric Diffusion Dyz Component")
#define CODE_DCM_VolumetricDiffusionDzzComponent                           DSRBasicCodedEntry("110815", "DCM", "Volumetric Diffusion Dzz Component")
#define CODE_DCM_T1WeightedDynamicContrastEnhancedMRSignalIntensity        DSRBasicCodedEntry("110816", "DCM", "T1 Weighted Dynamic Contrast Enhanced MR Signal Intensity")
#define CODE_DCM_T2WeightedDynamicContrastEnhancedMRSignalIntensity        DSRBasicCodedEntry("110817", "DCM", "T2 Weighted Dynamic Contrast Enhanced MR Signal Intensity")
#define CODE_DCM_T2StarWeightedDynamicContrastEnhancedMRSignalIntensity    DSRBasicCodedEntry("110818", "DCM", "T2* Weighted Dynamic Contrast Enhanced MR Signal Intensity")
#define CODE_DCM_BloodOxygenationLevel                                     DSRBasicCodedEntry("110819", "DCM", "Blood Oxygenation Level")
#define CODE_DCM_NuclearMedicineProjectionActivity                         DSRBasicCodedEntry("110820", "DCM", "Nuclear Medicine Projection Activity")
#define CODE_DCM_NuclearMedicineTomographicActivity                        DSRBasicCodedEntry("110821", "DCM", "Nuclear Medicine Tomographic Activity")
#define CODE_DCM_SpatialDisplacementXComponent                             DSRBasicCodedEntry("110822", "DCM", "Spatial Displacement X Component")
#define CODE_DCM_SpatialDisplacementYComponent                             DSRBasicCodedEntry("110823", "DCM", "Spatial Displacement Y Component")
#define CODE_DCM_SpatialDisplacementZComponent                             DSRBasicCodedEntry("110824", "DCM", "Spatial Displacement Z Component")
#define CODE_DCM_HemodynamicResistance                                     DSRBasicCodedEntry("110825", "DCM", "Hemodynamic Resistance")
#define CODE_DCM_IndexedHemodynamicResistance                              DSRBasicCodedEntry("110826", "DCM", "Indexed Hemodynamic Resistance")
#define CODE_DCM_TissueVelocity                                            DSRBasicCodedEntry("110827", "DCM", "Tissue Velocity")
#define CODE_DCM_FlowVelocity                                              DSRBasicCodedEntry("110828", "DCM", "Flow Velocity")
#define CODE_DCM_FlowVariance                                              DSRBasicCodedEntry("110829", "DCM", "Flow Variance")
#define CODE_DCM_Elasticity                                                DSRBasicCodedEntry("110830", "DCM", "Elasticity")
#define CODE_DCM_Perfusion                                                 DSRBasicCodedEntry("110831", "DCM", "Perfusion")
#define CODE_DCM_SpeedOfSound                                              DSRBasicCodedEntry("110832", "DCM", "Speed of sound")
#define CODE_DCM_UltrasoundAttenuation                                     DSRBasicCodedEntry("110833", "DCM", "Ultrasound Attenuation")
#define CODE_DCM_RGBRComponent                                             DSRBasicCodedEntry("110834", "DCM", "RGB R Component")
#define CODE_DCM_RGBGComponent                                             DSRBasicCodedEntry("110835", "DCM", "RGB G Component")
#define CODE_DCM_RGBBComponent                                             DSRBasicCodedEntry("110836", "DCM", "RGB B Component")
#define CODE_DCM_YBRFULLYComponent                                         DSRBasicCodedEntry("110837", "DCM", "YBR FULL Y Component")
#define CODE_DCM_YBRFULLCBComponent                                        DSRBasicCodedEntry("110838", "DCM", "YBR FULL CB Component")
#define CODE_DCM_YBRFULLCRComponent                                        DSRBasicCodedEntry("110839", "DCM", "YBR FULL CR Component")
#define CODE_DCM_YBRPARTIALYComponent                                      DSRBasicCodedEntry("110840", "DCM", "YBR PARTIAL Y Component")
#define CODE_DCM_YBRPARTIALCBComponent                                     DSRBasicCodedEntry("110841", "DCM", "YBR PARTIAL CB Component")
#define CODE_DCM_YBRPARTIALCRComponent                                     DSRBasicCodedEntry("110842", "DCM", "YBR PARTIAL CR Component")
#define CODE_DCM_YBRICTYComponent                                          DSRBasicCodedEntry("110843", "DCM", "YBR ICT Y Component")
#define CODE_DCM_YBRICTCBComponent                                         DSRBasicCodedEntry("110844", "DCM", "YBR ICT CB Component")
#define CODE_DCM_YBRICTCRComponent                                         DSRBasicCodedEntry("110845", "DCM", "YBR ICT CR Component")
#define CODE_DCM_YBRRCTYComponent                                          DSRBasicCodedEntry("110846", "DCM", "YBR RCT Y Component")
#define CODE_DCM_YBRRCTCBComponent                                         DSRBasicCodedEntry("110847", "DCM", "YBR RCT CB Component")
#define CODE_DCM_YBRRCTCRComponent                                         DSRBasicCodedEntry("110848", "DCM", "YBR RCT CR Component")
#define CODE_DCM_Echogenicity                                              DSRBasicCodedEntry("110849", "DCM", "Echogenicity")
#define CODE_DCM_XRayAttenuation                                           DSRBasicCodedEntry("110850", "DCM", "X-Ray Attenuation")
#define CODE_DCM_RETIRED_XRayAttenuationCoefficient                        DSRBasicCodedEntry("110851", "DCM", "X-Ray Attenuation Coefficient")
#define CODE_DCM_MRSignalIntensity                                         DSRBasicCodedEntry("110852", "DCM", "MR signal intensity")
#define CODE_DCM_BinarySegmentation                                        DSRBasicCodedEntry("110853", "DCM", "Binary Segmentation")
#define CODE_DCM_FractionalProbabilisticSegmentation                       DSRBasicCodedEntry("110854", "DCM", "Fractional Probabilistic Segmentation")
#define CODE_DCM_FractionalOccupancySegmentation                           DSRBasicCodedEntry("110855", "DCM", "Fractional Occupancy Segmentation")
#define CODE_DCM_LinearDisplacement                                        DSRBasicCodedEntry("110856", "DCM", "Linear Displacement")
#define CODE_DCM_PhotonEnergy                                              DSRBasicCodedEntry("110857", "DCM", "Photon Energy")
#define CODE_DCM_Time                                                      DSRBasicCodedEntry("110858", "DCM", "Time")
#define CODE_DCM_Angle                                                     DSRBasicCodedEntry("110859", "DCM", "Angle")
#define CODE_DCM_LeftRightAxis                                             DSRBasicCodedEntry("110860", "DCM", "Left-Right Axis")
#define CODE_DCM_HeadFootAxis                                              DSRBasicCodedEntry("110861", "DCM", "Head-Foot Axis")
#define CODE_DCM_AnteriorPosteriorAxis                                     DSRBasicCodedEntry("110862", "DCM", "Anterior-Posterior Axis")
#define CODE_DCM_ApexBaseAxis                                              DSRBasicCodedEntry("110863", "DCM", "Apex-Base Axis")
#define CODE_DCM_AnteriorInferiorAxis                                      DSRBasicCodedEntry("110864", "DCM", "Anterior-Inferior Axis")
#define CODE_DCM_SeptumWallAxis                                            DSRBasicCodedEntry("110865", "DCM", "Septum-Wall Axis")
#define CODE_DCM_RightToLeft                                               DSRBasicCodedEntry("110866", "DCM", "Right To Left")
#define CODE_DCM_LeftToRight                                               DSRBasicCodedEntry("110867", "DCM", "Left To Right")
#define CODE_DCM_HeadToFoot                                                DSRBasicCodedEntry("110868", "DCM", "Head To Foot")
#define CODE_DCM_FootToHead                                                DSRBasicCodedEntry("110869", "DCM", "Foot To Head")
#define CODE_DCM_AnteriorToPosterior                                       DSRBasicCodedEntry("110870", "DCM", "Anterior To Posterior")
#define CODE_DCM_PosteriorToAnterior                                       DSRBasicCodedEntry("110871", "DCM", "Posterior To Anterior")
#define CODE_DCM_ApexToBase                                                DSRBasicCodedEntry("110872", "DCM", "Apex To Base")
#define CODE_DCM_BaseToApex                                                DSRBasicCodedEntry("110873", "DCM", "Base To Apex")
#define CODE_DCM_AnteriorToInferior                                        DSRBasicCodedEntry("110874", "DCM", "Anterior To Inferior")
#define CODE_DCM_InferiorToAnterior                                        DSRBasicCodedEntry("110875", "DCM", "Inferior To Anterior")
#define CODE_DCM_SeptumToWall                                              DSRBasicCodedEntry("110876", "DCM", "Septum To Wall")
#define CODE_DCM_WallToSeptum                                              DSRBasicCodedEntry("110877", "DCM", "Wall To Septum")
#define CODE_DCM_ImagePosition_Patient_X                                   DSRBasicCodedEntry("110901", "DCM", "Image Position (Patient) X")
#define CODE_DCM_ImagePosition_Patient_Y                                   DSRBasicCodedEntry("110902", "DCM", "Image Position (Patient) Y")
#define CODE_DCM_ImagePosition_Patient_Z                                   DSRBasicCodedEntry("110903", "DCM", "Image Position (Patient) Z")
#define CODE_DCM_ImageOrientation_Patient_RowX                             DSRBasicCodedEntry("110904", "DCM", "Image Orientation (Patient) Row X")
#define CODE_DCM_ImageOrientation_Patient_RowY                             DSRBasicCodedEntry("110905", "DCM", "Image Orientation (Patient) Row Y")
#define CODE_DCM_ImageOrientation_Patient_RowZ                             DSRBasicCodedEntry("110906", "DCM", "Image Orientation (Patient) Row Z")
#define CODE_DCM_ImageOrientation_Patient_ColumnX                          DSRBasicCodedEntry("110907", "DCM", "Image Orientation (Patient) Column X")
#define CODE_DCM_ImageOrientation_Patient_ColumnY                          DSRBasicCodedEntry("110908", "DCM", "Image Orientation (Patient) Column Y")
#define CODE_DCM_ImageOrientation_Patient_ColumnZ                          DSRBasicCodedEntry("110909", "DCM", "Image Orientation (Patient) Column Z")
#define CODE_DCM_PixelDataRows                                             DSRBasicCodedEntry("110910", "DCM", "Pixel Data Rows")
#define CODE_DCM_PixelDataColumns                                          DSRBasicCodedEntry("110911", "DCM", "Pixel Data Columns")
#define CODE_DCM_AlgorithmFamily                                           DSRBasicCodedEntry("111000", "DCM", "Algorithm Family")
#define CODE_DCM_AlgorithmName                                             DSRBasicCodedEntry("111001", "DCM", "Algorithm Name")
#define CODE_DCM_AlgorithmParameters                                       DSRBasicCodedEntry("111002", "DCM", "Algorithm Parameters")
#define CODE_DCM_AlgorithmVersion                                          DSRBasicCodedEntry("111003", "DCM", "Algorithm Version")
#define CODE_DCM_AnalysisPerformed                                         DSRBasicCodedEntry("111004", "DCM", "Analysis Performed")
#define CODE_DCM_AssessmentCategory                                        DSRBasicCodedEntry("111005", "DCM", "Assessment Category")
#define CODE_DCM_RETIRED_BreastComposition                                 DSRBasicCodedEntry("111006", "DCM", "Breast composition")
#define CODE_DCM_BreastOutlineIncludingPectoralMuscleTissue                DSRBasicCodedEntry("111007", "DCM", "Breast Outline including Pectoral Muscle Tissue")
#define CODE_DCM_CalcificationDistribution                                 DSRBasicCodedEntry("111008", "DCM", "Calcification Distribution")
#define CODE_DCM_CalcificationType                                         DSRBasicCodedEntry("111009", "DCM", "Calcification Type")
#define CODE_DCM_Center                                                    DSRBasicCodedEntry("111010", "DCM", "Center")
#define CODE_DCM_CertaintyOfFeature                                        DSRBasicCodedEntry("111011", "DCM", "Certainty of Feature")
#define CODE_DCM_CertaintyOfFinding                                        DSRBasicCodedEntry("111012", "DCM", "Certainty of Finding")
#define CODE_DCM_CertaintyOfImpression                                     DSRBasicCodedEntry("111013", "DCM", "Certainty of Impression")
#define CODE_DCM_ClockfaceOrRegion                                         DSRBasicCodedEntry("111014", "DCM", "Clockface or region")
#define CODE_DCM_CompositeFeature                                          DSRBasicCodedEntry("111015", "DCM", "Composite Feature")
#define CODE_DCM_CompositeType                                             DSRBasicCodedEntry("111016", "DCM", "Composite type")
#define CODE_DCM_CADProcessingAndFindingsSummary                           DSRBasicCodedEntry("111017", "DCM", "CAD Processing and Findings Summary")
#define CODE_DCM_ContentDate                                               DSRBasicCodedEntry("111018", "DCM", "Content Date")
#define CODE_DCM_ContentTime                                               DSRBasicCodedEntry("111019", "DCM", "Content Time")
#define CODE_DCM_Depth                                                     DSRBasicCodedEntry("111020", "DCM", "Depth")
#define CODE_DCM_DescriptionOfChange                                       DSRBasicCodedEntry("111021", "DCM", "Description of Change")
#define CODE_DCM_DetectionPerformed                                        DSRBasicCodedEntry("111022", "DCM", "Detection Performed")
#define CODE_DCM_DifferentialDiagnosisImpression                           DSRBasicCodedEntry("111023", "DCM", "Differential Diagnosis/Impression")
#define CODE_DCM_FailedAnalyses                                            DSRBasicCodedEntry("111024", "DCM", "Failed Analyses")
#define CODE_DCM_FailedDetections                                          DSRBasicCodedEntry("111025", "DCM", "Failed Detections")
#define CODE_DCM_HorizontalPixelSpacing                                    DSRBasicCodedEntry("111026", "DCM", "Horizontal Pixel Spacing")
#define CODE_DCM_ImageLaterality                                           DSRBasicCodedEntry("111027", "DCM", "Image Laterality")
#define CODE_DCM_ImageLibrary                                              DSRBasicCodedEntry("111028", "DCM", "Image Library")
#define CODE_DCM_ImageQualityRating                                        DSRBasicCodedEntry("111029", "DCM", "Image Quality Rating")
#define CODE_DCM_ImageRegion                                               DSRBasicCodedEntry("111030", "DCM", "Image Region")
#define CODE_DCM_ImageView                                                 DSRBasicCodedEntry("111031", "DCM", "Image View")
#define CODE_DCM_ImageViewModifier                                         DSRBasicCodedEntry("111032", "DCM", "Image View Modifier")
#define CODE_DCM_ImpressionDescription                                     DSRBasicCodedEntry("111033", "DCM", "Impression Description")
#define CODE_DCM_IndividualImpressionRecommendation                        DSRBasicCodedEntry("111034", "DCM", "Individual Impression/Recommendation")
#define CODE_DCM_LesionDensity                                             DSRBasicCodedEntry("111035", "DCM", "Lesion Density")
#define CODE_DCM_MammographyCADReport                                      DSRBasicCodedEntry("111036", "DCM", "Mammography CAD Report")
#define CODE_DCM_Margins                                                   DSRBasicCodedEntry("111037", "DCM", "Margins")
#define CODE_DCM_NumberOfCalcifications                                    DSRBasicCodedEntry("111038", "DCM", "Number of calcifications")
#define CODE_DCM_ObjectType                                                DSRBasicCodedEntry("111039", "DCM", "Object type")
#define CODE_DCM_OriginalSource                                            DSRBasicCodedEntry("111040", "DCM", "Original Source")
#define CODE_DCM_Outline                                                   DSRBasicCodedEntry("111041", "DCM", "Outline")
#define CODE_DCM_Pathology                                                 DSRBasicCodedEntry("111042", "DCM", "Pathology")
#define CODE_DCM_PatientOrientationColumn                                  DSRBasicCodedEntry("111043", "DCM", "Patient Orientation Column")
#define CODE_DCM_PatientOrientationRow                                     DSRBasicCodedEntry("111044", "DCM", "Patient Orientation Row")
#define CODE_DCM_PectoralMuscleOutline                                     DSRBasicCodedEntry("111045", "DCM", "Pectoral Muscle Outline")
#define CODE_DCM_PercentFibroglandularTissue                               DSRBasicCodedEntry("111046", "DCM", "Percent Fibroglandular Tissue")
#define CODE_DCM_ProbabilityOfCancer                                       DSRBasicCodedEntry("111047", "DCM", "Probability of cancer")
#define CODE_DCM_QuadrantLocation                                          DSRBasicCodedEntry("111048", "DCM", "Quadrant location")
#define CODE_DCM_QualitativeDifference                                     DSRBasicCodedEntry("111049", "DCM", "Qualitative Difference")
#define CODE_DCM_QualityAssessment                                         DSRBasicCodedEntry("111050", "DCM", "Quality Assessment")
#define CODE_DCM_QualityControlStandard                                    DSRBasicCodedEntry("111051", "DCM", "Quality Control Standard")
#define CODE_DCM_QualityFinding                                            DSRBasicCodedEntry("111052", "DCM", "Quality Finding")
#define CODE_DCM_RecommendedFollowUp                                       DSRBasicCodedEntry("111053", "DCM", "Recommended Follow-up")
#define CODE_DCM_RecommendedFollowUpDate                                   DSRBasicCodedEntry("111054", "DCM", "Recommended Follow-up Date")
#define CODE_DCM_RecommendedFollowUpInterval                               DSRBasicCodedEntry("111055", "DCM", "Recommended Follow-up Interval")
#define CODE_DCM_RenderingIntent                                           DSRBasicCodedEntry("111056", "DCM", "Rendering Intent")
#define CODE_DCM_ScopeOfFeature                                            DSRBasicCodedEntry("111057", "DCM", "Scope of Feature")
#define CODE_DCM_SelectedRegionDescription                                 DSRBasicCodedEntry("111058", "DCM", "Selected Region Description")
#define CODE_DCM_SingleImageFinding                                        DSRBasicCodedEntry("111059", "DCM", "Single Image Finding")
#define CODE_DCM_StudyDate                                                 DSRBasicCodedEntry("111060", "DCM", "Study Date")
#define CODE_DCM_StudyTime                                                 DSRBasicCodedEntry("111061", "DCM", "Study Time")
#define CODE_DCM_SuccessfulAnalyses                                        DSRBasicCodedEntry("111062", "DCM", "Successful Analyses")
#define CODE_DCM_SuccessfulDetections                                      DSRBasicCodedEntry("111063", "DCM", "Successful Detections")
#define CODE_DCM_SummaryOfDetections                                       DSRBasicCodedEntry("111064", "DCM", "Summary of Detections")
#define CODE_DCM_SummaryOfAnalyses                                         DSRBasicCodedEntry("111065", "DCM", "Summary of Analyses")
#define CODE_DCM_VerticalPixelSpacing                                      DSRBasicCodedEntry("111066", "DCM", "Vertical Pixel Spacing")
#define CODE_DCM_Crosstable                                                DSRBasicCodedEntry("111069", "DCM", "Crosstable")
#define CODE_DCM_CADOperatingPoint                                         DSRBasicCodedEntry("111071", "DCM", "CAD Operating Point")
#define CODE_DCM_MaximumCADOperatingPoint                                  DSRBasicCodedEntry("111072", "DCM", "Maximum CAD Operating Point")
#define CODE_DCM_CADOperatingPointDescription                              DSRBasicCodedEntry("111081", "DCM", "CAD Operating Point Description")
#define CODE_DCM_FalseMarkersPerImage                                      DSRBasicCodedEntry("111086", "DCM", "False Markers per Image")
#define CODE_DCM_FalseMarkersPerCase                                       DSRBasicCodedEntry("111087", "DCM", "False Markers per Case")
#define CODE_DCM_CaseSensitivity                                           DSRBasicCodedEntry("111088", "DCM", "Case Sensitivity")
#define CODE_DCM_LesionSensitivity                                         DSRBasicCodedEntry("111089", "DCM", "Lesion Sensitivity")
#define CODE_DCM_CaseSpecificity                                           DSRBasicCodedEntry("111090", "DCM", "Case Specificity")
#define CODE_DCM_ImageSpecificity                                          DSRBasicCodedEntry("111091", "DCM", "Image Specificity")
#define CODE_DCM_RecommendedCADOperatingPoint                              DSRBasicCodedEntry("111092", "DCM", "Recommended CAD Operating Point")
#define CODE_DCM_CADOperatingPointTable                                    DSRBasicCodedEntry("111093", "DCM", "CAD Operating Point Table")
#define CODE_DCM_SelectedRegion                                            DSRBasicCodedEntry("111099", "DCM", "Selected region")
#define CODE_DCM_BreastGeometry                                            DSRBasicCodedEntry("111100", "DCM", "Breast geometry")
#define CODE_DCM_ImageQuality                                              DSRBasicCodedEntry("111101", "DCM", "Image Quality")
#define CODE_DCM_NonLesion                                                 DSRBasicCodedEntry("111102", "DCM", "Non-lesion")
#define CODE_DCM_RETIRED_Density                                           DSRBasicCodedEntry("111103", "DCM", "Density")
#define CODE_DCM_RETIRED_IndividualCalcification                           DSRBasicCodedEntry("111104", "DCM", "Individual Calcification")
#define CODE_DCM_RETIRED_CalcificationCluster                              DSRBasicCodedEntry("111105", "DCM", "Calcification Cluster")
#define CODE_DCM_CooperLigamentChanges                                     DSRBasicCodedEntry("111111", "DCM", "Cooper's ligament changes")
#define CODE_DCM_MassInTheSkin                                             DSRBasicCodedEntry("111112", "DCM", "Mass in the skin")
#define CODE_DCM_MassonTheSkin                                             DSRBasicCodedEntry("111113", "DCM", "Mass on the skin")
#define CODE_DCM_PostProcedureMammogramsForMarkerPlacement                 DSRBasicCodedEntry("111120", "DCM", "Post Procedure Mammograms for Marker Placement")
#define CODE_DCM_FollowUpPostBiopsyAsDirectedByClinician                   DSRBasicCodedEntry("111121", "DCM", "Follow-up post biopsy as directed by clinician")
#define CODE_DCM_KnownBiopsyProvenMalignancy_takeAppropriateAction         DSRBasicCodedEntry("111122", "DCM", "Known biopsy proven malignancy - take appropriate action")
#define CODE_DCM_MarkerPlacement                                           DSRBasicCodedEntry("111123", "DCM", "Marker placement")
#define CODE_DCM_PersonalHistoryOfBreastCancerWithMastectomy               DSRBasicCodedEntry("111124", "DCM", "Personal history of breast cancer with mastectomy")
#define CODE_DCM_KnownBiopsyProvenMalignancy                               DSRBasicCodedEntry("111125", "DCM", "Known biopsy proven malignancy")
#define CODE_DCM_ImageDetectedMass                                         DSRBasicCodedEntry("111126", "DCM", "Image detected mass")
#define CODE_DCM_Targeted                                                  DSRBasicCodedEntry("111127", "DCM", "Targeted")
#define CODE_DCM_Survey                                                    DSRBasicCodedEntry("111128", "DCM", "Survey")
#define CODE_DCM_ClusteredMicrocysts                                       DSRBasicCodedEntry("111129", "DCM", "Clustered microcysts")
#define CODE_DCM_ComplicatedCyst                                           DSRBasicCodedEntry("111130", "DCM", "Complicated cyst")
#define CODE_DCM_AdditionalProjections                                     DSRBasicCodedEntry("111135", "DCM", "Additional projections")
#define CODE_DCM_SpotMagnificationViews                                    DSRBasicCodedEntry("111136", "DCM", "Spot magnification view(s)")
#define CODE_DCM_RETIRED_Ultrasound                                        DSRBasicCodedEntry("111137", "DCM", "Ultrasound")
#define CODE_DCM_OldFilmsForComparison                                     DSRBasicCodedEntry("111138", "DCM", "Old films for comparison")
#define CODE_DCM_RETIRED_Ductography                                       DSRBasicCodedEntry("111139", "DCM", "Ductography")
#define CODE_DCM_NormalIntervalFollowUp                                    DSRBasicCodedEntry("111140", "DCM", "Normal interval follow-up")
#define CODE_DCM_AnyDecisionToBiopsyShouldBeBasedonClinicalAssessment      DSRBasicCodedEntry("111141", "DCM", "Any decision to biopsy should be based on clinical assessment")
#define CODE_DCM_FollowUpAtShortInterval_1to11Months                       DSRBasicCodedEntry("111142", "DCM", "Follow-up at short interval (1-11 months)")
#define CODE_DCM_BiopsyShouldBeConsidered                                  DSRBasicCodedEntry("111143", "DCM", "Biopsy should be considered")
#define CODE_DCM_NeedleLocalizationAndBiopsy                               DSRBasicCodedEntry("111144", "DCM", "Needle localization and biopsy")
#define CODE_DCM_HistologyUsingCoreBiopsy                                  DSRBasicCodedEntry("111145", "DCM", "Histology using core biopsy")
#define CODE_DCM_SuggestiveOfMalignancy_takeAppropriateAction              DSRBasicCodedEntry("111146", "DCM", "Suggestive of malignancy - take appropriate action")
#define CODE_DCM_CytologicAnalysis                                         DSRBasicCodedEntry("111147", "DCM", "Cytologic analysis")
#define CODE_DCM_BiopsyShouldBeStronglyConsidered                          DSRBasicCodedEntry("111148", "DCM", "Biopsy should be strongly considered")
#define CODE_DCM_HighlySuggestiveOfMalignancy_takeAppropriateAction        DSRBasicCodedEntry("111149", "DCM", "Highly suggestive of malignancy - take appropriate action")
#define CODE_DCM_PresentationRequired_RenderingDeviceIsExpectedToPresent   DSRBasicCodedEntry("111150", "DCM", "Presentation Required: Rendering device is expected to present")
#define CODE_DCM_PresentationOptional_RenderingDeviceMayPresent            DSRBasicCodedEntry("111151", "DCM", "Presentation Optional: Rendering device may present")
#define CODE_DCM_NotForPresentation_RenderingDeviceExpectedNotToPresent    DSRBasicCodedEntry("111152", "DCM", "Not for Presentation: Rendering device expected not to present")
#define CODE_DCM_TargetContentItemsAreRelatedTemporally                    DSRBasicCodedEntry("111153", "DCM", "Target content items are related temporally")
#define CODE_DCM_TargetContentItemsAreRelatedSpatially                     DSRBasicCodedEntry("111154", "DCM", "Target content items are related spatially")
#define CODE_DCM_TargetContentItemsAreRelatedContraLaterally               DSRBasicCodedEntry("111155", "DCM", "Target content items are related contra-laterally")
#define CODE_DCM_FeatureDetectedonTheOnlyImage                             DSRBasicCodedEntry("111156", "DCM", "Feature detected on the only image")
#define CODE_DCM_FeatureDetectedonOnlyOneOfTheImages                       DSRBasicCodedEntry("111157", "DCM", "Feature detected on only one of the images")
#define CODE_DCM_FeatureDetectedonMultipleImages                           DSRBasicCodedEntry("111158", "DCM", "Feature detected on multiple images")
#define CODE_DCM_FeatureDetectedonImagesFromMultipleModalities             DSRBasicCodedEntry("111159", "DCM", "Feature detected on images from multiple modalities")
#define CODE_DCM_RETIRED_ScarTissue                                        DSRBasicCodedEntry("111168", "DCM", "Scar tissue")
#define CODE_DCM_RETIRED_JWire                                             DSRBasicCodedEntry("111170", "DCM", "J Wire")
#define CODE_DCM_RETIRED_Pacemaker                                         DSRBasicCodedEntry("111171", "DCM", "Pacemaker")
#define CODE_DCM_RETIRED_Paddle                                            DSRBasicCodedEntry("111172", "DCM", "Paddle")
#define CODE_DCM_RETIRED_Collimator                                        DSRBasicCodedEntry("111173", "DCM", "Collimator")
#define CODE_DCM_RETIRED_IDPlate                                           DSRBasicCodedEntry("111174", "DCM", "ID Plate")
#define CODE_DCM_OtherMarker                                               DSRBasicCodedEntry("111175", "DCM", "Other Marker")
#define CODE_DCM_Unspecified                                               DSRBasicCodedEntry("111176", "DCM", "Unspecified")
#define CODE_DCM_ViewAndLateralityMarkerIsMissing                          DSRBasicCodedEntry("111177", "DCM", "View and Laterality Marker is missing")
#define CODE_DCM_ViewAndLateralityMarkerDoesNotHaveBothViewAndLaterality   DSRBasicCodedEntry("111178", "DCM", "View and Laterality Marker does not have both view and laterality")
#define CODE_DCM_ViewAndLateralityMarkerDoesNotHaveApprovedCodes           DSRBasicCodedEntry("111179", "DCM", "View and Laterality Marker does not have approved codes")
#define CODE_DCM_ViewAndLateralityMarkerIsNotNearTheAxilla                 DSRBasicCodedEntry("111180", "DCM", "View and Laterality Marker is not near the axilla")
#define CODE_DCM_ViewAndLateralityMarkerOverlapsBreastTissue               DSRBasicCodedEntry("111181", "DCM", "View and Laterality Marker overlaps breast tissue")
#define CODE_DCM_ViewAndLateralityMarkerIsPartiallyObscured                DSRBasicCodedEntry("111182", "DCM", "View and Laterality Marker is partially obscured")
#define CODE_DCM_ViewAndLateralityMarkerIsIncorrect                        DSRBasicCodedEntry("111183", "DCM", "View and Laterality Marker is incorrect")
#define CODE_DCM_ViewAndLateralityMarkerIsOffImage                         DSRBasicCodedEntry("111184", "DCM", "View and Laterality Marker is off image")
#define CODE_DCM_FlashIsNotNearEdgeOfFilm                                  DSRBasicCodedEntry("111185", "DCM", "Flash is not near edge of film")
#define CODE_DCM_FlashIsIllegible_doesNotFit_orIsLopsided                  DSRBasicCodedEntry("111186", "DCM", "Flash is illegible, does not fit, or is lopsided")
#define CODE_DCM_FlashDoesntIncludePatientNameAndAdditionalPatientId       DSRBasicCodedEntry("111187", "DCM", "Flash doesn't include patient name and additional patient id")
#define CODE_DCM_FlashDoesntIncludeDateOfExamination                       DSRBasicCodedEntry("111188", "DCM", "Flash doesn't include date of examination")
#define CODE_DCM_FlashDoesntIncludeFacilityNameAndLocation                 DSRBasicCodedEntry("111189", "DCM", "Flash doesn't include facility name and location")
#define CODE_DCM_FlashDoesntIncludeTechnologistIdentification              DSRBasicCodedEntry("111190", "DCM", "Flash doesn't include technologist identification")
#define CODE_DCM_FlashDoesntIncludeCassetteScreenDetectorIdentification    DSRBasicCodedEntry("111191", "DCM", "Flash doesn't include cassette/screen/detector identification")
#define CODE_DCM_FlashDoesntIncludeMammographyUnitIdentification           DSRBasicCodedEntry("111192", "DCM", "Flash doesn't include mammography unit identification")
#define CODE_DCM_DateStickerIsMissing                                      DSRBasicCodedEntry("111193", "DCM", "Date sticker is missing")
#define CODE_DCM_TechnicalFactorsMissing                                   DSRBasicCodedEntry("111194", "DCM", "Technical factors missing")
#define CODE_DCM_CollimationTooCloseToBreast                               DSRBasicCodedEntry("111195", "DCM", "Collimation too close to breast")
#define CODE_DCM_InadequateCompression                                     DSRBasicCodedEntry("111196", "DCM", "Inadequate compression")
#define CODE_DCM_MLOInsufficientPectoralMuscle                             DSRBasicCodedEntry("111197", "DCM", "MLO Insufficient pectoral muscle")
#define CODE_DCM_MLONoFatIsVisualizedPosteriorToFibroglandularTissues      DSRBasicCodedEntry("111198", "DCM", "MLO No fat is visualized posterior to fibroglandular tissues")
#define CODE_DCM_MLOPoorSeparationOfDeepAndSuperficialBreastTissues        DSRBasicCodedEntry("111199", "DCM", "MLO Poor separation of deep and superficial breast tissues")
#define CODE_DCM_MLOEvidenceOfMotionBlur                                   DSRBasicCodedEntry("111200", "DCM", "MLO Evidence of motion blur")
#define CODE_DCM_MLOInframammaryFoldIsNotOpen                              DSRBasicCodedEntry("111201", "DCM", "MLO Inframammary fold is not open")
#define CODE_DCM_CCNotAllMedialTissueVisualized                            DSRBasicCodedEntry("111202", "DCM", "CC Not all medial tissue visualized")
#define CODE_DCM_CCNippleNotCenteredonImage                                DSRBasicCodedEntry("111203", "DCM", "CC Nipple not centered on image")
#define CODE_DCM_CCPosteriorNippleLineDoesNotMeasureWithin1cmOfMLO         DSRBasicCodedEntry("111204", "DCM", "CC Posterior nipple line does not measure within 1 cm of MLO")
#define CODE_DCM_NippleNotInProfile                                        DSRBasicCodedEntry("111205", "DCM", "Nipple not in profile")
#define CODE_DCM_InsufficientImplantDisplacementIncorrect                  DSRBasicCodedEntry("111206", "DCM", "Insufficient implant displacement incorrect")
#define CODE_DCM_ImageArtifacts                                            DSRBasicCodedEntry("111207", "DCM", "Image artifact(s)")
#define CODE_DCM_GridArtifacts                                             DSRBasicCodedEntry("111208", "DCM", "Grid artifact(s)")
#define CODE_DCM_Positioning                                               DSRBasicCodedEntry("111209", "DCM", "Positioning")
#define CODE_DCM_MotionBlur                                                DSRBasicCodedEntry("111210", "DCM", "Motion blur")
#define CODE_DCM_UnderExposed                                              DSRBasicCodedEntry("111211", "DCM", "Under exposed")
#define CODE_DCM_OverExposed                                               DSRBasicCodedEntry("111212", "DCM", "Over exposed")
#define CODE_DCM_NoImage                                                   DSRBasicCodedEntry("111213", "DCM", "No image")
#define CODE_DCM_DetectorArtifacts                                         DSRBasicCodedEntry("111214", "DCM", "Detector artifact(s)")
#define CODE_DCM_Artifacts_otherThanGridOrDetectorArtifact                 DSRBasicCodedEntry("111215", "DCM", "Artifact(s) other than grid or detector artifact")
#define CODE_DCM_MechanicalFailure                                         DSRBasicCodedEntry("111216", "DCM", "Mechanical failure")
#define CODE_DCM_ElectricalFailure                                         DSRBasicCodedEntry("111217", "DCM", "Electrical failure")
#define CODE_DCM_SoftwareFailure                                           DSRBasicCodedEntry("111218", "DCM", "Software failure")
#define CODE_DCM_InappropriateImageProcessing                              DSRBasicCodedEntry("111219", "DCM", "Inappropriate image processing")
#define CODE_DCM_OtherFailure                                              DSRBasicCodedEntry("111220", "DCM", "Other failure")
#define CODE_DCM_UnknownFailure                                            DSRBasicCodedEntry("111221", "DCM", "Unknown failure")
#define CODE_DCM_Succeeded                                                 DSRBasicCodedEntry("111222", "DCM", "Succeeded")
#define CODE_DCM_PartiallySucceeded                                        DSRBasicCodedEntry("111223", "DCM", "Partially Succeeded")
#define CODE_DCM_Failed                                                    DSRBasicCodedEntry("111224", "DCM", "Failed")
#define CODE_DCM_NotAttempted                                              DSRBasicCodedEntry("111225", "DCM", "Not Attempted")
#define CODE_DCM_IndividualImpressionRecommendationAnalysis                DSRBasicCodedEntry("111233", "DCM", "Individual Impression/Recommendation Analysis")
#define CODE_DCM_OverallImpressionRecommendationAnalysis                   DSRBasicCodedEntry("111234", "DCM", "Overall Impression/Recommendation Analysis")
#define CODE_DCM_Unusable_QualityRendersImageUnusable                      DSRBasicCodedEntry("111235", "DCM", "Unusable - Quality renders image unusable")
#define CODE_DCM_Usable_DoesNotMeetTheQualityControlStandard               DSRBasicCodedEntry("111236", "DCM", "Usable - Does not meet the quality control standard")
#define CODE_DCM_Usable_MeetsTheQualityControlStandard                     DSRBasicCodedEntry("111237", "DCM", "Usable - Meets the quality control standard")
#define CODE_DCM_MammographyQualityControlManual1999_ACR                   DSRBasicCodedEntry("111238", "DCM", "Mammography Quality Control Manual 1999, ACR")
#define CODE_DCM_Title21CFRSection900_SubpartB                             DSRBasicCodedEntry("111239", "DCM", "Title 21 CFR Section 900, Subpart B")
#define CODE_DCM_InstitutionallyDefinedQualityControlStandard              DSRBasicCodedEntry("111240", "DCM", "Institutionally defined quality control standard")
#define CODE_DCM_AllAlgorithmsSucceeded_withoutFindings                    DSRBasicCodedEntry("111241", "DCM", "All algorithms succeeded; without findings")
#define CODE_DCM_AllAlgorithmsSucceeded_withFindings                       DSRBasicCodedEntry("111242", "DCM", "All algorithms succeeded; with findings")
#define CODE_DCM_NotAllAlgorithmsSucceeded_withoutFindings                 DSRBasicCodedEntry("111243", "DCM", "Not all algorithms succeeded; without findings")
#define CODE_DCM_NotAllAlgorithmsSucceeded_withFindings                    DSRBasicCodedEntry("111244", "DCM", "Not all algorithms succeeded; with findings")
#define CODE_DCM_NoAlgorithmsSucceeded_withoutFindings                     DSRBasicCodedEntry("111245", "DCM", "No algorithms succeeded; without findings")
#define CODE_DCM_RETIRED_Adenolipoma                                       DSRBasicCodedEntry("111248", "DCM", "Adenolipoma")
#define CODE_DCM_RETIRED_DuctalHyperplasia                                 DSRBasicCodedEntry("111249", "DCM", "Ductal hyperplasia")
#define CODE_DCM_RETIRED_Adenomyoepithelioma                               DSRBasicCodedEntry("111250", "DCM", "Adenomyoepithelioma")
#define CODE_DCM_NormalAxillaryNode                                        DSRBasicCodedEntry("111251", "DCM", "Normal axillary node")
#define CODE_DCM_AxillaryNodeWithCalcifications                            DSRBasicCodedEntry("111252", "DCM", "Axillary node with calcifications")
#define CODE_DCM_AxillaryNodeHyperplasia                                   DSRBasicCodedEntry("111253", "DCM", "Axillary node hyperplasia")
#define CODE_DCM_RETIRED_AsynchronousInvolution                            DSRBasicCodedEntry("111254", "DCM", "Asynchronous involution")
#define CODE_DCM_BenignCystWithBlood                                       DSRBasicCodedEntry("111255", "DCM", "Benign cyst with blood")
#define CODE_DCM_BenignCalcifications                                      DSRBasicCodedEntry("111256", "DCM", "Benign Calcifications")
#define CODE_DCM_RETIRED_IntracysticPapilloma                              DSRBasicCodedEntry("111257", "DCM", "Intracystic papilloma")
#define CODE_DCM_DuctalAdenoma                                             DSRBasicCodedEntry("111258", "DCM", "Ductal adenoma")
#define CODE_DCM_DiabeticFibrousMastopathy                                 DSRBasicCodedEntry("111259", "DCM", "Diabetic fibrous mastopathy")
#define CODE_DCM_RETIRED_ExtraAbdominalDesmoid                             DSRBasicCodedEntry("111260", "DCM", "Extra abdominal desmoid")
#define CODE_DCM_RETIRED_EpidermalInclusionCyst                            DSRBasicCodedEntry("111262", "DCM", "Epidermal inclusion cyst")
#define CODE_DCM_FibroadenomatoidHyperplasia                               DSRBasicCodedEntry("111263", "DCM", "Fibroadenomatoid hyperplasia")
#define CODE_DCM_Fibroadenolipoma                                          DSRBasicCodedEntry("111264", "DCM", "Fibroadenolipoma")
#define CODE_DCM_RETIRED_ForeignBody_reaction                              DSRBasicCodedEntry("111265", "DCM", "Foreign body (reaction)")
#define CODE_DCM_RETIRED_Galactocele                                       DSRBasicCodedEntry("111269", "DCM", "Galactocele")
#define CODE_DCM_RETIRED_Hemangioma_nonparenchymal_subcutaneous            DSRBasicCodedEntry("111271", "DCM", "Hemangioma - nonparenchymal, subcutaneous")
#define CODE_DCM_RETIRED_Hyperplasia_usual                                 DSRBasicCodedEntry("111273", "DCM", "Hyperplasia, usual")
#define CODE_DCM_JuvenilePapillomatosis                                    DSRBasicCodedEntry("111277", "DCM", "Juvenile papillomatosis")
#define CODE_DCM_RETIRED_LactatingAdenoma                                  DSRBasicCodedEntry("111278", "DCM", "Lactating adenoma")
#define CODE_DCM_LactationalChange                                         DSRBasicCodedEntry("111279", "DCM", "Lactational change")
#define CODE_DCM_LargeDuctPapilloma                                        DSRBasicCodedEntry("111281", "DCM", "Large duct papilloma")
#define CODE_DCM_RETIRED_Myofibroblastoma                                  DSRBasicCodedEntry("111283", "DCM", "Myofibroblastoma")
#define CODE_DCM_MicroglandularAdenosis                                    DSRBasicCodedEntry("111284", "DCM", "Microglandular adenosis")
#define CODE_DCM_MultipleIntraductalPapillomas                             DSRBasicCodedEntry("111285", "DCM", "Multiple Intraductal Papillomas")
#define CODE_DCM_NoAbnormality                                             DSRBasicCodedEntry("111286", "DCM", "No abnormality")
#define CODE_DCM_NormalBreastTissue                                        DSRBasicCodedEntry("111287", "DCM", "Normal breast tissue")
#define CODE_DCM_RETIRED_Neurofibromatosis                                 DSRBasicCodedEntry("111288", "DCM", "Neurofibromatosis")
#define CODE_DCM_OilCyst_fatNecrosisCyst                                   DSRBasicCodedEntry("111290", "DCM", "Oil cyst (fat necrosis cyst)")
#define CODE_DCM_PostReductionMammoplasty                                  DSRBasicCodedEntry("111291", "DCM", "Post reduction mammoplasty")
#define CODE_DCM_PseudoangiomatousStromalHyperplasia                       DSRBasicCodedEntry("111292", "DCM", "Pseudoangiomatous stromal hyperplasia")
#define CODE_DCM_RETIRED_RadialScar                                        DSRBasicCodedEntry("111293", "DCM", "Radial scar")
#define CODE_DCM_RETIRED_SclerosingAdenosis                                DSRBasicCodedEntry("111294", "DCM", "Sclerosing adenosis")
#define CODE_DCM_SiliconeGranuloma                                         DSRBasicCodedEntry("111296", "DCM", "Silicone granuloma")
#define CODE_DCM_NippleCharacteristic                                      DSRBasicCodedEntry("111297", "DCM", "Nipple Characteristic")
#define CODE_DCM_VirginalHyperplasia                                       DSRBasicCodedEntry("111298", "DCM", "Virginal hyperplasia")
#define CODE_DCM_PeripheralDuctPapillomas                                  DSRBasicCodedEntry("111299", "DCM", "Peripheral duct papillomas")
#define CODE_DCM_AxillaryNodeWithLymphoma                                  DSRBasicCodedEntry("111300", "DCM", "Axillary node with lymphoma")
#define CODE_DCM_AxillaryNodalMetastases                                   DSRBasicCodedEntry("111301", "DCM", "Axillary nodal metastases")
#define CODE_DCM_RETIRED_Angiosarcoma                                      DSRBasicCodedEntry("111302", "DCM", "Angiosarcoma")
#define CODE_DCM_BloodVessel_vascular_invasion                             DSRBasicCodedEntry("111303", "DCM", "Blood vessel (vascular) invasion")
#define CODE_DCM_CarcinomaInChildren                                       DSRBasicCodedEntry("111304", "DCM", "Carcinoma in children")
#define CODE_DCM_CarcinomaInEctopicBreast                                  DSRBasicCodedEntry("111305", "DCM", "Carcinoma in ectopic breast")
#define CODE_DCM_CarcinomaWithEndocrineDifferentiation                     DSRBasicCodedEntry("111306", "DCM", "Carcinoma with endocrine differentiation")
#define CODE_DCM_BasalCellCarcinomaOfNipple                                DSRBasicCodedEntry("111307", "DCM", "Basal cell carcinoma of nipple")
#define CODE_DCM_RETIRED_CarcinomaWithMetaplasia                           DSRBasicCodedEntry("111308", "DCM", "Carcinoma with metaplasia")
#define CODE_DCM_CartilaginousAndOsseousChange                             DSRBasicCodedEntry("111309", "DCM", "Cartilaginous and osseous change")
#define CODE_DCM_CarcinomaInPregnancyAndLactation                          DSRBasicCodedEntry("111310", "DCM", "Carcinoma in pregnancy and lactation")
#define CODE_DCM_RETIRED_Carcinosarcoma                                    DSRBasicCodedEntry("111311", "DCM", "Carcinosarcoma")
#define CODE_DCM_IntraductalComedocarcinomaWithNecrosis                    DSRBasicCodedEntry("111312", "DCM", "Intraductal comedocarcinoma with necrosis")
#define CODE_DCM_IntraductalCarcinoma_lowGrade                             DSRBasicCodedEntry("111313", "DCM", "Intraductal carcinoma, low grade")
#define CODE_DCM_RETIRED_IntraductalCarcinomaMicroPapillary                DSRBasicCodedEntry("111314", "DCM", "Intraductal carcinoma micro-papillary")
#define CODE_DCM_IntracysticPapillaryCarcinoma                             DSRBasicCodedEntry("111315", "DCM", "Intracystic papillary carcinoma")
#define CODE_DCM_InvasiveAndInSituCarcinoma                                DSRBasicCodedEntry("111316", "DCM", "Invasive and in-situ carcinoma")
#define CODE_DCM_RETIRED_InvasiveLobularCarcinoma                          DSRBasicCodedEntry("111317", "DCM", "Invasive lobular carcinoma")
#define CODE_DCM_LeukemicInfiltration                                      DSRBasicCodedEntry("111318", "DCM", "Leukemic infiltration")
#define CODE_DCM_LympathicVesselInvasion                                   DSRBasicCodedEntry("111320", "DCM", "Lympathic vessel invasion")
#define CODE_DCM_RETIRED_Lymphoma                                          DSRBasicCodedEntry("111321", "DCM", "Lymphoma")
#define CODE_DCM_OccultCarcinomaPresentingWithAxillaryLymphNodeMetastases  DSRBasicCodedEntry("111322", "DCM", "Occult carcinoma presenting with axillary lymph node metastases")
#define CODE_DCM_MetastaticCancerToTheBreast                               DSRBasicCodedEntry("111323", "DCM", "Metastatic cancer to the breast")
#define CODE_DCM_MetastaticCancerToTheBreastFromTheColon                   DSRBasicCodedEntry("111324", "DCM", "Metastatic cancer to the breast from the colon")
#define CODE_DCM_MetastaticCancerToTheBreastFromTheLung                    DSRBasicCodedEntry("111325", "DCM", "Metastatic cancer to the breast from the lung")
#define CODE_DCM_MetastaticMelanomaToTheBreast                             DSRBasicCodedEntry("111326", "DCM", "Metastatic melanoma to the breast")
#define CODE_DCM_MetastaticCancerToTheBreastFromTheOvary                   DSRBasicCodedEntry("111327", "DCM", "Metastatic cancer to the breast from the ovary")
#define CODE_DCM_MetastaticSarcomaToTheBreast                              DSRBasicCodedEntry("111328", "DCM", "Metastatic sarcoma to the breast")
#define CODE_DCM_MultifocalIntraductalCarcinoma                            DSRBasicCodedEntry("111329", "DCM", "Multifocal intraductal carcinoma")
#define CODE_DCM_MetastaticDiseaseToAxillaryNode                           DSRBasicCodedEntry("111330", "DCM", "Metastatic disease to axillary node")
#define CODE_DCM_RETIRED_MalignantFibrousHistiocytoma                      DSRBasicCodedEntry("111331", "DCM", "Malignant fibrous histiocytoma")
#define CODE_DCM_MultifocalInvasiveDuctalCarcinoma                         DSRBasicCodedEntry("111332", "DCM", "Multifocal invasive ductal carcinoma")
#define CODE_DCM_MetastasisToAnIntramammaryLymphNode                       DSRBasicCodedEntry("111333", "DCM", "Metastasis to an intramammary lymph node")
#define CODE_DCM_MalignantMelanomaOfNipple                                 DSRBasicCodedEntry("111334", "DCM", "Malignant melanoma of nipple")
#define CODE_DCM_RETIRED_NeoplasmOfTheMammarySkin                          DSRBasicCodedEntry("111335", "DCM", "Neoplasm of the mammary skin")
#define CODE_DCM_RETIRED_PapillaryCarcinomaInSitu                          DSRBasicCodedEntry("111336", "DCM", "Papillary carcinoma in-situ")
#define CODE_DCM_RecurrentMalignancy                                       DSRBasicCodedEntry("111338", "DCM", "Recurrent malignancy")
#define CODE_DCM_SquamousCellCarcinomaOfTheNipple                          DSRBasicCodedEntry("111340", "DCM", "Squamous cell carcinoma of the nipple")
#define CODE_DCM_IntraductalCarcinoma_highGrade                            DSRBasicCodedEntry("111341", "DCM", "Intraductal carcinoma, high grade")
#define CODE_DCM_RETIRED_InvasiveCribriformCarcinoma                       DSRBasicCodedEntry("111342", "DCM", "Invasive cribriform carcinoma")
#define CODE_DCM_AngularMargins                                            DSRBasicCodedEntry("111343", "DCM", "Angular margins")
#define CODE_DCM_FinePleomorphicCalcification                              DSRBasicCodedEntry("111344", "DCM", "Fine pleomorphic calcification")
#define CODE_DCM_Macrocalcifications                                       DSRBasicCodedEntry("111345", "DCM", "Macrocalcifications")
#define CODE_DCM_CalcificationsWithinAMass                                 DSRBasicCodedEntry("111346", "DCM", "Calcifications within a mass")
#define CODE_DCM_CalcificationsOutsideOfAMass                              DSRBasicCodedEntry("111347", "DCM", "Calcifications outside of a mass")
#define CODE_DCM_BreastBackgroundEchotexture                               DSRBasicCodedEntry("111350", "DCM", "Breast background echotexture")
#define CODE_DCM_HomogeneousFatEchotexture                                 DSRBasicCodedEntry("111351", "DCM", "Homogeneous fat echotexture")
#define CODE_DCM_HomogeneousFibroglandularEchotexture                      DSRBasicCodedEntry("111352", "DCM", "Homogeneous fibroglandular echotexture")
#define CODE_DCM_HeterogeneousEchotexture                                  DSRBasicCodedEntry("111353", "DCM", "Heterogeneous echotexture")
#define CODE_DCM_Orientation                                               DSRBasicCodedEntry("111354", "DCM", "Orientation")
#define CODE_DCM_Parallel                                                  DSRBasicCodedEntry("111355", "DCM", "Parallel")
#define CODE_DCM_NotParallel                                               DSRBasicCodedEntry("111356", "DCM", "Not parallel")
#define CODE_DCM_LesionBoundary                                            DSRBasicCodedEntry("111357", "DCM", "Lesion boundary")
#define CODE_DCM_AbruptInterface                                           DSRBasicCodedEntry("111358", "DCM", "Abrupt interface")
#define CODE_DCM_EchogenicHalo                                             DSRBasicCodedEntry("111359", "DCM", "Echogenic halo")
#define CODE_DCM_EchoPattern                                               DSRBasicCodedEntry("111360", "DCM", "Echo pattern")
#define CODE_DCM_Anechoic                                                  DSRBasicCodedEntry("111361", "DCM", "Anechoic")
#define CODE_DCM_Hyperechoic                                               DSRBasicCodedEntry("111362", "DCM", "Hyperechoic")
#define CODE_DCM_Complex                                                   DSRBasicCodedEntry("111363", "DCM", "Complex")
#define CODE_DCM_Hypoechoic                                                DSRBasicCodedEntry("111364", "DCM", "Hypoechoic")
#define CODE_DCM_Isoechoic                                                 DSRBasicCodedEntry("111365", "DCM", "Isoechoic")
#define CODE_DCM_PosteriorAcousticFeatures                                 DSRBasicCodedEntry("111366", "DCM", "Posterior acoustic features")
#define CODE_DCM_NoPosteriorAcousticFeatures                               DSRBasicCodedEntry("111367", "DCM", "No posterior acoustic features")
#define CODE_DCM_PosteriorEnhancement                                      DSRBasicCodedEntry("111368", "DCM", "Posterior enhancement")
#define CODE_DCM_PosteriorShadowing                                        DSRBasicCodedEntry("111369", "DCM", "Posterior shadowing")
#define CODE_DCM_CombinedPosteriorEnhancementAndShadowing                  DSRBasicCodedEntry("111370", "DCM", "Combined posterior enhancement and shadowing")
#define CODE_DCM_IdentifiableEffectonSurroundingTissues                    DSRBasicCodedEntry("111371", "DCM", "Identifiable effect on surrounding tissues")
#define CODE_DCM_Vascularity                                               DSRBasicCodedEntry("111372", "DCM", "Vascularity")
#define CODE_DCM_VascularityNotPresent                                     DSRBasicCodedEntry("111373", "DCM", "Vascularity not present")
#define CODE_DCM_VascularityNotAssessed                                    DSRBasicCodedEntry("111374", "DCM", "Vascularity not assessed")
#define CODE_DCM_VascularityPresentInLesion                                DSRBasicCodedEntry("111375", "DCM", "Vascularity present in lesion")
#define CODE_DCM_VascularityPresentImmediatelyAdjacentToLesion             DSRBasicCodedEntry("111376", "DCM", "Vascularity present immediately adjacent to lesion")
#define CODE_DCM_DiffuselyIncreasedVascularityInSurroundingTissue          DSRBasicCodedEntry("111377", "DCM", "Diffusely increased vascularity in surrounding tissue")
#define CODE_DCM_CorrelationToOtherFindings                                DSRBasicCodedEntry("111380", "DCM", "Correlation to other Findings")
#define CODE_DCM_CorrelatesToPhysicalExamFindings                          DSRBasicCodedEntry("111381", "DCM", "Correlates to physical exam findings")
#define CODE_DCM_CorrelatesToMammographyFindings                           DSRBasicCodedEntry("111382", "DCM", "Correlates to mammography findings")
#define CODE_DCM_CorrelatesToMRIFindings                                   DSRBasicCodedEntry("111383", "DCM", "Correlates to MRI findings")
#define CODE_DCM_CorrelatesToUltrasoundFindings                            DSRBasicCodedEntry("111384", "DCM", "Correlates to ultrasound findings")
#define CODE_DCM_CorrelatesToOtherImagingFindings                          DSRBasicCodedEntry("111385", "DCM", "Correlates to other imaging findings")
#define CODE_DCM_NoCorrelationToOtherImagingFindings                       DSRBasicCodedEntry("111386", "DCM", "No correlation to other imaging findings")
#define CODE_DCM_NoCorrelationToClinicalFindings                           DSRBasicCodedEntry("111387", "DCM", "No correlation to clinical findings")
#define CODE_DCM_MalignancyType                                            DSRBasicCodedEntry("111388", "DCM", "Malignancy Type")
#define CODE_DCM_InvasiveBreastCarcinoma                                   DSRBasicCodedEntry("111389", "DCM", "Invasive breast carcinoma")
#define CODE_DCM_OtherMalignancyType                                       DSRBasicCodedEntry("111390", "DCM", "Other malignancy type")
#define CODE_DCM_MenstrualCyclePhase                                       DSRBasicCodedEntry("111391", "DCM", "Menstrual Cycle Phase")
#define CODE_DCM_1stWeek                                                   DSRBasicCodedEntry("111392", "DCM", "1st week")
#define CODE_DCM_2ndWeek                                                   DSRBasicCodedEntry("111393", "DCM", "2nd week")
#define CODE_DCM_3rdWeek                                                   DSRBasicCodedEntry("111394", "DCM", "3rd week")
#define CODE_DCM_EstimatedTimeframe                                        DSRBasicCodedEntry("111395", "DCM", "Estimated Timeframe")
#define CODE_DCM_LessThan3MonthsAgo                                        DSRBasicCodedEntry("111396", "DCM", "< 3 months ago")
#define CODE_DCM_4MonthsTo1YearAgo                                         DSRBasicCodedEntry("111397", "DCM", "4 months to 1 year ago")
#define CODE_DCM_GreaterThan1YearAgo                                       DSRBasicCodedEntry("111398", "DCM", "> 1 year ago")
#define CODE_DCM_TimeframeUncertain                                        DSRBasicCodedEntry("111399", "DCM", "Timeframe uncertain")
#define CODE_DCM_BreastImagingReport                                       DSRBasicCodedEntry("111400", "DCM", "Breast Imaging Report")
#define CODE_DCM_RETIRED_ReasonForProcedure                                DSRBasicCodedEntry("111401", "DCM", "Reason for Procedure")
#define CODE_DCM_ClinicalFinding                                           DSRBasicCodedEntry("111402", "DCM", "Clinical Finding")
#define CODE_DCM_BaselineScreeningMammogram                                DSRBasicCodedEntry("111403", "DCM", "Baseline screening mammogram")
#define CODE_DCM_FirstMammogramEver                                        DSRBasicCodedEntry("111404", "DCM", "First mammogram ever")
#define CODE_DCM_ImplantType                                               DSRBasicCodedEntry("111405", "DCM", "Implant type")
#define CODE_DCM_NumberOfSimilarFindings                                   DSRBasicCodedEntry("111406", "DCM", "Number of similar findings")
#define CODE_DCM_ImplantFinding                                            DSRBasicCodedEntry("111407", "DCM", "Implant finding")
#define CODE_DCM_FilmScreenMammography                                     DSRBasicCodedEntry("111408", "DCM", "Film Screen Mammography")
#define CODE_DCM_RETIRED_DigitalMammography                                DSRBasicCodedEntry("111409", "DCM", "Digital Mammography")
#define CODE_DCM_SurgicalConsult                                           DSRBasicCodedEntry("111410", "DCM", "Surgical consult")
#define CODE_DCM_MammographyCAD                                            DSRBasicCodedEntry("111411", "DCM", "Mammography CAD")
#define CODE_DCM_NarrativeSummary                                          DSRBasicCodedEntry("111412", "DCM", "Narrative Summary")
#define CODE_DCM_OverallAssessment                                         DSRBasicCodedEntry("111413", "DCM", "Overall Assessment")
#define CODE_DCM_SupplementaryData                                         DSRBasicCodedEntry("111414", "DCM", "Supplementary Data")
#define CODE_DCM_AdditionalEvaluationRequestedFromPriorStudy               DSRBasicCodedEntry("111415", "DCM", "Additional evaluation requested from prior study")
#define CODE_DCM_FollowUpAtShortIntervalFromPriorStudy                     DSRBasicCodedEntry("111416", "DCM", "Follow-up at short interval from prior study")
#define CODE_DCM_HistoryOfBreastAugmentation_asymptomatic                  DSRBasicCodedEntry("111417", "DCM", "History of breast augmentation, asymptomatic")
#define CODE_DCM_ReviewOfAnOutsideStudy                                    DSRBasicCodedEntry("111418", "DCM", "Review of an outside study")
#define CODE_DCM_AdditionalEvaluationRequestedFromAbnormalScreeningExam    DSRBasicCodedEntry("111419", "DCM", "Additional evaluation requested from abnormal screening exam")
#define CODE_DCM_HistoryOfBenignBreastBiopsy                               DSRBasicCodedEntry("111420", "DCM", "History of benign breast biopsy")
#define CODE_DCM_PersonalHistoryOfBreastCancerWithBreastConservationTherapy DSRBasicCodedEntry("111421", "DCM", "Personal history of breast cancer with breast conservation therapy")
#define CODE_DCM_PhysicalExaminationResults                                DSRBasicCodedEntry("111423", "DCM", "Physical Examination Results")
#define CODE_DCM_ComparisonToPreviousFindings                              DSRBasicCodedEntry("111424", "DCM", "Comparison to previous findings")
#define CODE_DCM_IntraluminalFillingDefect                                 DSRBasicCodedEntry("111425", "DCM", "Intraluminal filling defect")
#define CODE_DCM_MultipleFillingDefect                                     DSRBasicCodedEntry("111426", "DCM", "Multiple filling defect")
#define CODE_DCM_AbruptDuctTermination                                     DSRBasicCodedEntry("111427", "DCM", "Abrupt duct termination")
#define CODE_DCM_Extravasation                                             DSRBasicCodedEntry("111428", "DCM", "Extravasation")
#define CODE_DCM_DuctNarrowing                                             DSRBasicCodedEntry("111429", "DCM", "Duct narrowing")
#define CODE_DCM_CystFill                                                  DSRBasicCodedEntry("111430", "DCM", "Cyst fill")
#define CODE_DCM_InstrumentApproach                                        DSRBasicCodedEntry("111431", "DCM", "Instrument Approach")
#define CODE_DCM_InferolateralToSuperomedial                               DSRBasicCodedEntry("111432", "DCM", "Inferolateral to superomedial")
#define CODE_DCM_InferomedialToSuperolateral                               DSRBasicCodedEntry("111433", "DCM", "Inferomedial to superolateral")
#define CODE_DCM_SuperolateralToInferomedial                               DSRBasicCodedEntry("111434", "DCM", "Superolateral to inferomedial")
#define CODE_DCM_SuperomedialToInferolateral                               DSRBasicCodedEntry("111435", "DCM", "Superomedial to inferolateral")
#define CODE_DCM_NumberOfPasses                                            DSRBasicCodedEntry("111436", "DCM", "Number of passes")
#define CODE_DCM_NumberOfSpecimens                                         DSRBasicCodedEntry("111437", "DCM", "Number of specimens")
#define CODE_DCM_NeedleInTarget                                            DSRBasicCodedEntry("111438", "DCM", "Needle in target")
#define CODE_DCM_NumberOfNeedlesAroundTarget                               DSRBasicCodedEntry("111439", "DCM", "Number of needles around target")
#define CODE_DCM_IncisionMade                                              DSRBasicCodedEntry("111440", "DCM", "Incision made")
#define CODE_DCM_RETIRED_MicroclipPlaced                                   DSRBasicCodedEntry("111441", "DCM", "Microclip placed")
#define CODE_DCM_ConfirmationOfTarget                                      DSRBasicCodedEntry("111442", "DCM", "Confirmation of target")
#define CODE_DCM_TargetCompletelyContainedInTheSpecimen                    DSRBasicCodedEntry("111443", "DCM", "Target completely contained in the specimen")
#define CODE_DCM_TargetPartiallyObtainedInTheSpecimen                      DSRBasicCodedEntry("111444", "DCM", "Target partially obtained in the specimen")
#define CODE_DCM_TargetNotInTheSpecimen                                    DSRBasicCodedEntry("111445", "DCM", "Target not in the specimen")
#define CODE_DCM_CalcificationsSeenInTheCore                               DSRBasicCodedEntry("111446", "DCM", "Calcifications seen in the core")
#define CODE_DCM_LesionCompletelyRemoved                                   DSRBasicCodedEntry("111447", "DCM", "Lesion completely removed")
#define CODE_DCM_LesionPartiallyRemoved                                    DSRBasicCodedEntry("111448", "DCM", "Lesion partially removed")
#define CODE_DCM_FluidObtained                                             DSRBasicCodedEntry("111449", "DCM", "Fluid obtained")
#define CODE_DCM_LightBrownColor                                           DSRBasicCodedEntry("111450", "DCM", "Light brown color")
#define CODE_DCM_DarkRedColor                                              DSRBasicCodedEntry("111451", "DCM", "Dark red color")
#define CODE_DCM_DarkBrownColor                                            DSRBasicCodedEntry("111452", "DCM", "Dark brown color")
#define CODE_DCM_BrightRedColor                                            DSRBasicCodedEntry("111453", "DCM", "Bright red color")
#define CODE_DCM_BloodTingedColor                                          DSRBasicCodedEntry("111454", "DCM", "Blood tinged color")
#define CODE_DCM_OccultBloodTestResult                                     DSRBasicCodedEntry("111455", "DCM", "Occult blood test result")
#define CODE_DCM_ActiononFluid                                             DSRBasicCodedEntry("111456", "DCM", "Action on fluid")
#define CODE_DCM_SentForAnalysis                                           DSRBasicCodedEntry("111457", "DCM", "Sent for analysis")
#define CODE_DCM_Discarded                                                 DSRBasicCodedEntry("111458", "DCM", "Discarded")
#define CODE_DCM_MassWithCalcifications                                    DSRBasicCodedEntry("111459", "DCM", "Mass with calcifications")
#define CODE_DCM_ComplexCyst                                               DSRBasicCodedEntry("111460", "DCM", "Complex cyst")
#define CODE_DCM_IntracysticLesion                                         DSRBasicCodedEntry("111461", "DCM", "Intracystic lesion")
#define CODE_DCM_SolidMass                                                 DSRBasicCodedEntry("111462", "DCM", "Solid mass")
#define CODE_DCM_SupplementaryDataForIntervention                          DSRBasicCodedEntry("111463", "DCM", "Supplementary Data for Intervention")
#define CODE_DCM_ProcedureModifier                                         DSRBasicCodedEntry("111464", "DCM", "Procedure Modifier")
#define CODE_DCM_NeedleGauge                                               DSRBasicCodedEntry("111465", "DCM", "Needle Gauge")
#define CODE_DCM_SeverityOfComplication                                    DSRBasicCodedEntry("111466", "DCM", "Severity of Complication")
#define CODE_DCM_NeedleLength                                              DSRBasicCodedEntry("111467", "DCM", "Needle Length")
#define CODE_DCM_PathologyResults                                          DSRBasicCodedEntry("111468", "DCM", "Pathology Results")
#define CODE_DCM_SamplingDateTime                                          DSRBasicCodedEntry("111469", "DCM", "Sampling DateTime")
#define CODE_DCM_Uninvolved                                                DSRBasicCodedEntry("111470", "DCM", "Uninvolved")
#define CODE_DCM_Involved                                                  DSRBasicCodedEntry("111471", "DCM", "Involved")
#define CODE_DCM_NippleInvolved                                            DSRBasicCodedEntry("111472", "DCM", "Nipple involved")
#define CODE_DCM_NumberOfNodesRemoved                                      DSRBasicCodedEntry("111473", "DCM", "Number of nodes removed")
#define CODE_DCM_NumberOfNodesPositive                                     DSRBasicCodedEntry("111474", "DCM", "Number of nodes positive")
#define CODE_DCM_EstrogenReceptor                                          DSRBasicCodedEntry("111475", "DCM", "Estrogen receptor")
#define CODE_DCM_ProgesteroneReceptor                                      DSRBasicCodedEntry("111476", "DCM", "Progesterone receptor")
#define CODE_DCM_SPhase                                                    DSRBasicCodedEntry("111477", "DCM", "S Phase")
#define CODE_DCM_NonBloodyDischarge_fromNipple                             DSRBasicCodedEntry("111478", "DCM", "Non-bloody discharge (from nipple)")
#define CODE_DCM_DifficultPhysicalClinicalExamination                      DSRBasicCodedEntry("111479", "DCM", "Difficult physical/clinical examination")
#define CODE_DCM_CancerElsewhere                                           DSRBasicCodedEntry("111480", "DCM", "Cancer elsewhere")
#define CODE_DCM_SalineImplant                                             DSRBasicCodedEntry("111481", "DCM", "Saline implant")
#define CODE_DCM_PolyurethaneImplant                                       DSRBasicCodedEntry("111482", "DCM", "Polyurethane implant")
#define CODE_DCM_PercutaneousSiliconeInjection                             DSRBasicCodedEntry("111483", "DCM", "Percutaneous silicone injection")
#define CODE_DCM_CombinationImplant                                        DSRBasicCodedEntry("111484", "DCM", "Combination implant")
#define CODE_DCM_PrePectoralImplant                                        DSRBasicCodedEntry("111485", "DCM", "Pre-pectoral implant")
#define CODE_DCM_RetroPectoralImplant                                      DSRBasicCodedEntry("111486", "DCM", "Retro-pectoral implant")
#define CODE_DCM_Mammographic_crosshair                                    DSRBasicCodedEntry("111487", "DCM", "Mammographic (crosshair)")
#define CODE_DCM_Mammographic_grid                                         DSRBasicCodedEntry("111488", "DCM", "Mammographic (grid)")
#define CODE_DCM_PalpationGuided                                           DSRBasicCodedEntry("111489", "DCM", "Palpation guided")
#define CODE_DCM_VacuumAssisted                                            DSRBasicCodedEntry("111490", "DCM", "Vacuum assisted")
#define CODE_DCM_AbnormalDischarge                                         DSRBasicCodedEntry("111491", "DCM", "Abnormal discharge")
#define CODE_DCM_NoComplications                                           DSRBasicCodedEntry("111492", "DCM", "No complications")
#define CODE_DCM_Stage0                                                    DSRBasicCodedEntry("111494", "DCM", "Stage 0")
#define CODE_DCM_StageI                                                    DSRBasicCodedEntry("111495", "DCM", "Stage I")
#define CODE_DCM_StageIIA                                                  DSRBasicCodedEntry("111496", "DCM", "Stage IIA")
#define CODE_DCM_StageIIB                                                  DSRBasicCodedEntry("111497", "DCM", "Stage IIB")
#define CODE_DCM_StageIIIA                                                 DSRBasicCodedEntry("111498", "DCM", "Stage IIIA")
#define CODE_DCM_StageIIIB                                                 DSRBasicCodedEntry("111499", "DCM", "Stage IIIB")
#define CODE_DCM_StageIIIC                                                 DSRBasicCodedEntry("111500", "DCM", "Stage IIIC")
#define CODE_DCM_StageIV                                                   DSRBasicCodedEntry("111501", "DCM", "Stage IV")
#define CODE_DCM_BloomRichardsonGrade                                      DSRBasicCodedEntry("111502", "DCM", "Bloom-Richardson Grade")
#define CODE_DCM_NormalImplants                                            DSRBasicCodedEntry("111503", "DCM", "Normal implants")
#define CODE_DCM_AsymmetricImplants                                        DSRBasicCodedEntry("111504", "DCM", "Asymmetric implants")
#define CODE_DCM_CalcifiedImplant                                          DSRBasicCodedEntry("111505", "DCM", "Calcified implant")
#define CODE_DCM_DistortedImplant                                          DSRBasicCodedEntry("111506", "DCM", "Distorted implant")
#define CODE_DCM_SiliconeLadenLymphNodes                                   DSRBasicCodedEntry("111507", "DCM", "Silicone-laden lymph nodes")
#define CODE_DCM_FreeSilicone                                              DSRBasicCodedEntry("111508", "DCM", "Free silicone")
#define CODE_DCM_HerniatedImplant                                          DSRBasicCodedEntry("111509", "DCM", "Herniated implant")
#define CODE_DCM_Explantation                                              DSRBasicCodedEntry("111510", "DCM", "Explantation")
#define CODE_DCM_RelevantPatientInformationForBreastImaging                DSRBasicCodedEntry("111511", "DCM", "Relevant Patient Information for Breast Imaging")
#define CODE_DCM_RETIRED_MedicationHistory                                 DSRBasicCodedEntry("111512", "DCM", "Medication History")
#define CODE_DCM_RelevantPreviousProcedures                                DSRBasicCodedEntry("111513", "DCM", "Relevant Previous Procedures")
#define CODE_DCM_RETIRED_RelevantIndicatedProblems                         DSRBasicCodedEntry("111514", "DCM", "Relevant Indicated Problems")
#define CODE_DCM_RelevantRiskFactors                                       DSRBasicCodedEntry("111515", "DCM", "Relevant Risk Factors")
#define CODE_DCM_MedicationType                                            DSRBasicCodedEntry("111516", "DCM", "Medication Type")
#define CODE_DCM_RelevantPatientInformation                                DSRBasicCodedEntry("111517", "DCM", "Relevant Patient Information")
#define CODE_DCM_AgeWhenFirstMenstrualPeriodOccurred                       DSRBasicCodedEntry("111518", "DCM", "Age when first menstrual period occurred")
#define CODE_DCM_AgeAtFirstFullTermPregnancy                               DSRBasicCodedEntry("111519", "DCM", "Age at First Full Term Pregnancy")
#define CODE_DCM_AgeAtMenopause                                            DSRBasicCodedEntry("111520", "DCM", "Age at Menopause")
#define CODE_DCM_AgeWhenHysterectomyPerformed                              DSRBasicCodedEntry("111521", "DCM", "Age when hysterectomy performed")
#define CODE_DCM_AgeWhenLeftOvaryRemoved                                   DSRBasicCodedEntry("111522", "DCM", "Age when left ovary removed")
#define CODE_DCM_AgeWhenRightOvaryRemoved                                  DSRBasicCodedEntry("111523", "DCM", "Age when right ovary removed")
#define CODE_DCM_AgeStarted                                                DSRBasicCodedEntry("111524", "DCM", "Age Started")
#define CODE_DCM_AgeEnded                                                  DSRBasicCodedEntry("111525", "DCM", "Age Ended")
#define CODE_DCM_DateTimeStarted                                           DSRBasicCodedEntry("111526", "DCM", "DateTime Started")
#define CODE_DCM_DateTimeEnded                                             DSRBasicCodedEntry("111527", "DCM", "DateTime Ended")
#define CODE_DCM_Ongoing                                                   DSRBasicCodedEntry("111528", "DCM", "Ongoing")
#define CODE_DCM_BrandName                                                 DSRBasicCodedEntry("111529", "DCM", "Brand Name")
#define CODE_DCM_RiskFactorModifier                                        DSRBasicCodedEntry("111530", "DCM", "Risk Factor modifier")
#define CODE_DCM_PreviousProcedure                                         DSRBasicCodedEntry("111531", "DCM", "Previous Procedure")
#define CODE_DCM_RETIRED_PregnancyStatus                                   DSRBasicCodedEntry("111532", "DCM", "Pregnancy Status")
#define CODE_DCM_IndicatedProblem                                          DSRBasicCodedEntry("111533", "DCM", "Indicated Problem")
#define CODE_DCM_RoleOfPersonReporting                                     DSRBasicCodedEntry("111534", "DCM", "Role of person reporting")
#define CODE_DCM_DateTimeProblemObserved                                   DSRBasicCodedEntry("111535", "DCM", "DateTime problem observed")
#define CODE_DCM_DateTimeOfLastEvaluation                                  DSRBasicCodedEntry("111536", "DCM", "DateTime of last evaluation")
#define CODE_DCM_FamilyMemberWithRiskFactor                                DSRBasicCodedEntry("111537", "DCM", "Family Member with Risk Factor")
#define CODE_DCM_AgeAtOccurrence                                           DSRBasicCodedEntry("111538", "DCM", "Age at Occurrence")
#define CODE_DCM_MenopausalPhase                                           DSRBasicCodedEntry("111539", "DCM", "Menopausal phase")
#define CODE_DCM_SideOfFamily                                              DSRBasicCodedEntry("111540", "DCM", "Side of Family")
#define CODE_DCM_Maternal                                                  DSRBasicCodedEntry("111541", "DCM", "Maternal")
#define CODE_DCM_UnspecifiedGynecologicalHormone                           DSRBasicCodedEntry("111542", "DCM", "Unspecified gynecological hormone")
#define CODE_DCM_BreastFeedingHistory                                      DSRBasicCodedEntry("111543", "DCM", "Breast feeding history")
#define CODE_DCM_AverageBreastFeedingPeriod                                DSRBasicCodedEntry("111544", "DCM", "Average breast feeding period")
#define CODE_DCM_SubstanceUseHistory                                       DSRBasicCodedEntry("111545", "DCM", "Substance Use History")
#define CODE_DCM_UsedSubstanceType                                         DSRBasicCodedEntry("111546", "DCM", "Used Substance Type")
#define CODE_DCM_EnvironmentalExposureHistory                              DSRBasicCodedEntry("111547", "DCM", "Environmental Exposure History")
#define CODE_DCM_EnvironmentalFactor                                       DSRBasicCodedEntry("111548", "DCM", "Environmental Factor")
#define CODE_DCM_PreviousReports                                           DSRBasicCodedEntry("111549", "DCM", "Previous Reports")
#define CODE_DCM_PersonalBreastCancerHistory                               DSRBasicCodedEntry("111550", "DCM", "Personal breast cancer history")
#define CODE_DCM_HistoryOfEndometrialCancer                                DSRBasicCodedEntry("111551", "DCM", "History of endometrial cancer")
#define CODE_DCM_HistoryOfOvarianCancer                                    DSRBasicCodedEntry("111552", "DCM", "History of ovarian cancer")
#define CODE_DCM_HistoryOfHighRiskLesiononPreviousBiopsy                   DSRBasicCodedEntry("111553", "DCM", "History of high risk lesion on previous biopsy")
#define CODE_DCM_PostMenopausalPatient                                     DSRBasicCodedEntry("111554", "DCM", "Post menopausal patient")
#define CODE_DCM_LateChildBearing_after30                                  DSRBasicCodedEntry("111555", "DCM", "Late child bearing (after 30)")
#define CODE_DCM_BRCA1BreastCancerGene                                     DSRBasicCodedEntry("111556", "DCM", "BRCA1 breast cancer gene")
#define CODE_DCM_BRCA2BreastCancerGene                                     DSRBasicCodedEntry("111557", "DCM", "BRCA2 breast cancer gene")
#define CODE_DCM_BRCA3BreastCancerGene                                     DSRBasicCodedEntry("111558", "DCM", "BRCA3 breast cancer gene")
#define CODE_DCM_WeakFamilyHistoryOfBreastCancer                           DSRBasicCodedEntry("111559", "DCM", "Weak family history of breast cancer")
#define CODE_DCM_IntermediateFamilyHistoryOfBreastCancer                   DSRBasicCodedEntry("111560", "DCM", "Intermediate family history of breast cancer")
#define CODE_DCM_VeryStrongFamilyHistoryOfBreastCancer                     DSRBasicCodedEntry("111561", "DCM", "Very strong family history of breast cancer")
#define CODE_DCM_FamilyHistoryOfProstateCancer                             DSRBasicCodedEntry("111562", "DCM", "Family history of prostate cancer")
#define CODE_DCM_FamilyHistoryUnknown                                      DSRBasicCodedEntry("111563", "DCM", "Family history unknown")
#define CODE_DCM_NippleDischargeCytology                                   DSRBasicCodedEntry("111564", "DCM", "Nipple discharge cytology")
#define CODE_DCM_UterineMalformations                                      DSRBasicCodedEntry("111565", "DCM", "Uterine malformations")
#define CODE_DCM_SpontaneousAbortion                                       DSRBasicCodedEntry("111566", "DCM", "Spontaneous Abortion")
#define CODE_DCM_GynecologicCondition                                      DSRBasicCodedEntry("111567", "DCM", "Gynecologic condition")
#define CODE_DCM_GynecologicSurgery                                        DSRBasicCodedEntry("111568", "DCM", "Gynecologic surgery")
#define CODE_DCM_PreviousLBWOrIUGRBirth                                    DSRBasicCodedEntry("111569", "DCM", "Previous LBW or IUGR birth")
#define CODE_DCM_PreviousFetalMalformationSyndrome                         DSRBasicCodedEntry("111570", "DCM", "Previous fetal malformation/syndrome")
#define CODE_DCM_PreviousRHNegativeOrBloodDyscrasiaAtBirth                 DSRBasicCodedEntry("111571", "DCM", "Previous RH negative or blood dyscrasia at birth")
#define CODE_DCM_HistoryOfMultipleFetuses                                  DSRBasicCodedEntry("111572", "DCM", "History of multiple fetuses")
#define CODE_DCM_CurrentPregnancy_knownOrSuspectedMalformationsSyndromes   DSRBasicCodedEntry("111573", "DCM", "Current pregnancy, known or suspected malformations/syndromes")
#define CODE_DCM_FamilyHistory_fetalMalformationSyndrome                   DSRBasicCodedEntry("111574", "DCM", "Family history, fetal malformation/syndrome")
#define CODE_DCM_High                                                      DSRBasicCodedEntry("111575", "DCM", "High")
#define CODE_DCM_Medium                                                    DSRBasicCodedEntry("111576", "DCM", "Medium")
#define CODE_DCM_Low                                                       DSRBasicCodedEntry("111577", "DCM", "Low")
#define CODE_DCM_DoseFrequency                                             DSRBasicCodedEntry("111578", "DCM", "Dose frequency")
#define CODE_DCM_RateOfExposure                                            DSRBasicCodedEntry("111579", "DCM", "Rate of exposure")
#define CODE_DCM_VolumeOfUse                                               DSRBasicCodedEntry("111580", "DCM", "Volume of use")
#define CODE_DCM_RelativeDoseAmount                                        DSRBasicCodedEntry("111581", "DCM", "Relative dose amount")
#define CODE_DCM_RelativeAmountOfExposure                                  DSRBasicCodedEntry("111582", "DCM", "Relative amount of exposure")
#define CODE_DCM_RelativeAmountOfUse                                       DSRBasicCodedEntry("111583", "DCM", "Relative amount of use")
#define CODE_DCM_RelativeDoseFrequency                                     DSRBasicCodedEntry("111584", "DCM", "Relative dose frequency")
#define CODE_DCM_RelativeFrequencyOfExposure                               DSRBasicCodedEntry("111585", "DCM", "Relative frequency of exposure")
#define CODE_DCM_RelativeFrequencyOfUse                                    DSRBasicCodedEntry("111586", "DCM", "Relative frequency of use")
#define CODE_DCM_NoKnownExposure                                           DSRBasicCodedEntry("111587", "DCM", "No known exposure")
#define CODE_DCM_RecallForTechnicalReasons                                 DSRBasicCodedEntry("111590", "DCM", "Recall for technical reasons")
#define CODE_DCM_RecallForImagingFindings                                  DSRBasicCodedEntry("111591", "DCM", "Recall for imaging findings")
#define CODE_DCM_RecallForPatientSymptomsClinicalFindings                  DSRBasicCodedEntry("111592", "DCM", "Recall for patient symptoms/ clinical findings")
#define CODE_DCM_LBWOrIUGR                                                 DSRBasicCodedEntry("111593", "DCM", "LBW or IUGR")
#define CODE_DCM_RETIRED_GreenFilter                                       DSRBasicCodedEntry("111601", "DCM", "Green filter")
#define CODE_DCM_RETIRED_RedFilter                                         DSRBasicCodedEntry("111602", "DCM", "Red filter")
#define CODE_DCM_RETIRED_BlueFilter                                        DSRBasicCodedEntry("111603", "DCM", "Blue filter")
#define CODE_DCM_RETIRED_YellowGreenFilter                                 DSRBasicCodedEntry("111604", "DCM", "Yellow-green filter")
#define CODE_DCM_RETIRED_BlueGreenFilter                                   DSRBasicCodedEntry("111605", "DCM", "Blue-green filter")
#define CODE_DCM_RETIRED_InfraredFilter                                    DSRBasicCodedEntry("111606", "DCM", "Infrared filter")
#define CODE_DCM_RETIRED_PolarizingFilter                                  DSRBasicCodedEntry("111607", "DCM", "Polarizing filter")
#define CODE_DCM_NoFilter                                                  DSRBasicCodedEntry("111609", "DCM", "No filter")
#define CODE_DCM_Field1ForJoslin3Field                                     DSRBasicCodedEntry("111621", "DCM", "Field 1 for Joslin 3 field")
#define CODE_DCM_Field2ForJoslin3Field                                     DSRBasicCodedEntry("111622", "DCM", "Field 2 for Joslin 3 field")
#define CODE_DCM_Field3ForJoslin3Field                                     DSRBasicCodedEntry("111623", "DCM", "Field 3 for Joslin 3 field")
#define CODE_DCM_DiffuseDirectIllumination                                 DSRBasicCodedEntry("111625", "DCM", "Diffuse direct illumination")
#define CODE_DCM_ScheimpflugCamera                                         DSRBasicCodedEntry("111626", "DCM", "Scheimpflug Camera")
#define CODE_DCM_ScotopicLight                                             DSRBasicCodedEntry("111627", "DCM", "Scotopic light")
#define CODE_DCM_MesopicLight                                              DSRBasicCodedEntry("111628", "DCM", "Mesopic light")
#define CODE_DCM_PhotopicLight                                             DSRBasicCodedEntry("111629", "DCM", "Photopic light")
#define CODE_DCM_DynamicLight                                              DSRBasicCodedEntry("111630", "DCM", "Dynamic light")
#define CODE_DCM_AverageGlandularDose                                      DSRBasicCodedEntry("111631", "DCM", "Average Glandular Dose")
#define CODE_DCM_AnodeTargetMaterial                                       DSRBasicCodedEntry("111632", "DCM", "Anode Target Material")
#define CODE_DCM_CompressionThickness                                      DSRBasicCodedEntry("111633", "DCM", "Compression Thickness")
#define CODE_DCM_HalfValueLayer                                            DSRBasicCodedEntry("111634", "DCM", "Half Value Layer")
#define CODE_DCM_XRayGrid                                                  DSRBasicCodedEntry("111635", "DCM", "X-Ray Grid")
#define CODE_DCM_EntranceExposureAtRP                                      DSRBasicCodedEntry("111636", "DCM", "Entrance Exposure at RP")
#define CODE_DCM_AccumulatedAverageGlandularDose                           DSRBasicCodedEntry("111637", "DCM", "Accumulated Average Glandular Dose")
#define CODE_DCM_PatientEquivalentThickness                                DSRBasicCodedEntry("111638", "DCM", "Patient Equivalent Thickness")
#define CODE_DCM_VirtualGrid                                               DSRBasicCodedEntry("111640", "DCM", "Virtual grid")
#define CODE_DCM_FixedGrid                                                 DSRBasicCodedEntry("111641", "DCM", "Fixed grid")
#define CODE_DCM_FocusedGrid                                               DSRBasicCodedEntry("111642", "DCM", "Focused grid")
#define CODE_DCM_ReciprocatingGrid                                         DSRBasicCodedEntry("111643", "DCM", "Reciprocating grid")
#define CODE_DCM_ParallelGrid                                              DSRBasicCodedEntry("111644", "DCM", "Parallel grid")
#define CODE_DCM_CrossedGrid                                               DSRBasicCodedEntry("111645", "DCM", "Crossed grid")
#define CODE_DCM_NoGrid                                                    DSRBasicCodedEntry("111646", "DCM", "No grid")
#define CODE_DCM_CompressionForce                                          DSRBasicCodedEntry("111647", "DCM", "Compression Force")
#define CODE_DCM_CompressionPressure                                       DSRBasicCodedEntry("111648", "DCM", "Compression Pressure")
#define CODE_DCM_CompressionContactArea                                    DSRBasicCodedEntry("111649", "DCM", "Compression Contact Area")
#define CODE_DCM_SpectaclePrescriptionReport                               DSRBasicCodedEntry("111671", "DCM", "Spectacle Prescription Report")
#define CODE_DCM_AddNear                                                   DSRBasicCodedEntry("111672", "DCM", "Add Near")
#define CODE_DCM_AddIntermediate                                           DSRBasicCodedEntry("111673", "DCM", "Add Intermediate")
#define CODE_DCM_AddOther                                                  DSRBasicCodedEntry("111674", "DCM", "Add Other")
#define CODE_DCM_HorizontalPrismPower                                      DSRBasicCodedEntry("111675", "DCM", "Horizontal Prism Power")
#define CODE_DCM_HorizontalPrismBase                                       DSRBasicCodedEntry("111676", "DCM", "Horizontal Prism Base")
#define CODE_DCM_VerticalPrismPower                                        DSRBasicCodedEntry("111677", "DCM", "Vertical Prism Power")
#define CODE_DCM_VerticalPrismBase                                         DSRBasicCodedEntry("111678", "DCM", "Vertical Prism Base")
#define CODE_DCM_DistancePupillaryDistance                                 DSRBasicCodedEntry("111679", "DCM", "Distance Pupillary Distance")
#define CODE_DCM_NearPupillaryDistance                                     DSRBasicCodedEntry("111680", "DCM", "Near Pupillary Distance")
#define CODE_DCM_SMILE                                                     DSRBasicCodedEntry("111681", "DCM", "SMILE")
#define CODE_DCM_AutorefractionVisualAcuity                                DSRBasicCodedEntry("111685", "DCM", "Autorefraction Visual Acuity")
#define CODE_DCM_HabitualVisualAcuity                                      DSRBasicCodedEntry("111686", "DCM", "Habitual Visual Acuity")
#define CODE_DCM_PrescriptionVisualAcuity                                  DSRBasicCodedEntry("111687", "DCM", "Prescription Visual Acuity")
#define CODE_DCM_RightEyeRx                                                DSRBasicCodedEntry("111688", "DCM", "Right Eye Rx")
#define CODE_DCM_LeftEyeRx                                                 DSRBasicCodedEntry("111689", "DCM", "Left Eye Rx")
#define CODE_DCM_MacularGridThicknessAndVolumeReport                       DSRBasicCodedEntry("111690", "DCM", "Macular Grid Thickness and Volume Report")
#define CODE_DCM_NumberOfImagesUsedForMacularMeasurements                  DSRBasicCodedEntry("111691", "DCM", "Number of Images Used for Macular Measurements")
#define CODE_DCM_NumberOfSamplesUsedPerImage                               DSRBasicCodedEntry("111692", "DCM", "Number of Samples Used per Image")
#define CODE_DCM_AnalysisQualityRating                                     DSRBasicCodedEntry("111693", "DCM", "Analysis Quality Rating")
#define CODE_DCM_ImageSetQualityRating                                     DSRBasicCodedEntry("111694", "DCM", "Image Set Quality Rating")
#define CODE_DCM_InterferingTearsOrDrops                                   DSRBasicCodedEntry("111695", "DCM", "Interfering Tears or Drops")
#define CODE_DCM_VisualFixationQualityDuringAcquisition                    DSRBasicCodedEntry("111696", "DCM", "Visual Fixation Quality During Acquisition")
#define CODE_DCM_VisualFixationQualityProblem                              DSRBasicCodedEntry("111697", "DCM", "Visual Fixation Quality Problem")
#define CODE_DCM_OphthalmicMacularGridProblem                              DSRBasicCodedEntry("111698", "DCM", "Ophthalmic Macular Grid Problem")
#define CODE_DCM_SpecimenContainerIdentifier                               DSRBasicCodedEntry("111700", "DCM", "Specimen Container Identifier")
#define CODE_DCM_ProcessingType                                            DSRBasicCodedEntry("111701", "DCM", "Processing type")
#define CODE_DCM_DateTimeOfProcessing                                      DSRBasicCodedEntry("111702", "DCM", "DateTime of processing")
#define CODE_DCM_ProcessingStepDescription                                 DSRBasicCodedEntry("111703", "DCM", "Processing step description")
#define CODE_DCM_SamplingMethod                                            DSRBasicCodedEntry("111704", "DCM", "Sampling Method")
#define CODE_DCM_ParentSpecimenIdentifier                                  DSRBasicCodedEntry("111705", "DCM", "Parent Specimen Identifier")
#define CODE_DCM_IssuerOfParentSpecimenIdentifier                          DSRBasicCodedEntry("111706", "DCM", "Issuer of Parent Specimen Identifier")
#define CODE_DCM_ParentSpecimenType                                        DSRBasicCodedEntry("111707", "DCM", "Parent specimen type")
#define CODE_DCM_PositionFrameOfReference                                  DSRBasicCodedEntry("111708", "DCM", "Position Frame of Reference")
#define CODE_DCM_LocationOfSamplingSite                                    DSRBasicCodedEntry("111709", "DCM", "Location of sampling site")
#define CODE_DCM_LocationOfSamplingSiteXOffset                             DSRBasicCodedEntry("111710", "DCM", "Location of sampling site X offset")
#define CODE_DCM_LocationOfSamplingSiteYOffset                             DSRBasicCodedEntry("111711", "DCM", "Location of sampling site Y offset")
#define CODE_DCM_LocationOfSamplingSiteZOffset                             DSRBasicCodedEntry("111712", "DCM", "Location of sampling site Z offset")
#define CODE_DCM_LocationOfSpecimen                                        DSRBasicCodedEntry("111718", "DCM", "Location of Specimen")
#define CODE_DCM_LocationOfSpecimenXOffset                                 DSRBasicCodedEntry("111719", "DCM", "Location of Specimen X offset")
#define CODE_DCM_LocationOfSpecimenYOffset                                 DSRBasicCodedEntry("111720", "DCM", "Location of Specimen Y offset")
#define CODE_DCM_LocationOfSpecimenZOffset                                 DSRBasicCodedEntry("111721", "DCM", "Location of Specimen Z offset")
#define CODE_DCM_VisualMarkingOfSpecimen                                   DSRBasicCodedEntry("111723", "DCM", "Visual Marking of Specimen")
#define CODE_DCM_IssuerOfSpecimenIdentifier                                DSRBasicCodedEntry("111724", "DCM", "Issuer of Specimen Identifier")
#define CODE_DCM_DissectionWithEntireSpecimenSubmission                    DSRBasicCodedEntry("111726", "DCM", "Dissection with entire specimen submission")
#define CODE_DCM_DissectionWithRepresentativeSectionsSubmission            DSRBasicCodedEntry("111727", "DCM", "Dissection with representative sections submission")
#define CODE_DCM_SpecimenStorage                                           DSRBasicCodedEntry("111729", "DCM", "Specimen storage")
#define CODE_DCM_TransmissionIllumination                                  DSRBasicCodedEntry("111741", "DCM", "Transmission illumination")
#define CODE_DCM_ReflectionIllumination                                    DSRBasicCodedEntry("111742", "DCM", "Reflection illumination")
#define CODE_DCM_EpifluorescenceIllumination                               DSRBasicCodedEntry("111743", "DCM", "Epifluorescence illumination")
#define CODE_DCM_BrightfieldIllumination                                   DSRBasicCodedEntry("111744", "DCM", "Brightfield illumination")
#define CODE_DCM_DarkfieldIllumination                                     DSRBasicCodedEntry("111745", "DCM", "Darkfield illumination")
#define CODE_DCM_ObliqueIllumination                                       DSRBasicCodedEntry("111746", "DCM", "Oblique illumination")
#define CODE_DCM_PhaseContrastIllumination                                 DSRBasicCodedEntry("111747", "DCM", "Phase contrast illumination")
#define CODE_DCM_DifferentialInterferenceContrast                          DSRBasicCodedEntry("111748", "DCM", "Differential interference contrast")
#define CODE_DCM_TotalInternalReflectionFluorescence                       DSRBasicCodedEntry("111749", "DCM", "Total internal reflection fluorescence")
#define CODE_DCM_UltrasoundContact                                         DSRBasicCodedEntry("111750", "DCM", "Ultrasound Contact")
#define CODE_DCM_UltrasoundImmersion                                       DSRBasicCodedEntry("111751", "DCM", "Ultrasound Immersion")
#define CODE_DCM_Optical                                                   DSRBasicCodedEntry("111752", "DCM", "Optical")
#define CODE_DCM_ManualKeratometry                                         DSRBasicCodedEntry("111753", "DCM", "Manual Keratometry")
#define CODE_DCM_AutoKeratometry                                           DSRBasicCodedEntry("111754", "DCM", "Auto Keratometry")
#define CODE_DCM_SimulatedKeratometry                                      DSRBasicCodedEntry("111755", "DCM", "Simulated Keratometry")
#define CODE_DCM_EquivalentKReading                                        DSRBasicCodedEntry("111756", "DCM", "Equivalent K-reading")
#define CODE_DCM_KeratometryMeasurementsSOPInstance                        DSRBasicCodedEntry("111757", "DCM", "Keratometry Measurements SOP Instance")
#define CODE_DCM_TotalCorneaPowerMeasurementMethod                         DSRBasicCodedEntry("111758", "DCM", "Total Cornea Power Measurement Method")
#define CODE_DCM_PosteriorCorneaSurfaceMeasurementMethod                   DSRBasicCodedEntry("111759", "DCM", "Posterior Cornea Surface Measurement Method")
#define CODE_DCM_Haigis                                                    DSRBasicCodedEntry("111760", "DCM", "Haigis")
#define CODE_DCM_HaigisL                                                   DSRBasicCodedEntry("111761", "DCM", "Haigis-L")
#define CODE_DCM_Holladay1                                                 DSRBasicCodedEntry("111762", "DCM", "Holladay 1")
#define CODE_DCM_Holladay2                                                 DSRBasicCodedEntry("111763", "DCM", "Holladay 2")
#define CODE_DCM_HofferQ                                                   DSRBasicCodedEntry("111764", "DCM", "Hoffer Q")
#define CODE_DCM_Olsen                                                     DSRBasicCodedEntry("111765", "DCM", "Olsen")
#define CODE_DCM_SRKII                                                     DSRBasicCodedEntry("111766", "DCM", "SRKII")
#define CODE_DCM_SRKT                                                      DSRBasicCodedEntry("111767", "DCM", "SRK-T")
#define CODE_DCM_ACDConstant                                               DSRBasicCodedEntry("111768", "DCM", "ACD Constant")
#define CODE_DCM_HaigisA0                                                  DSRBasicCodedEntry("111769", "DCM", "Haigis a0")
#define CODE_DCM_HaigisA1                                                  DSRBasicCodedEntry("111770", "DCM", "Haigis a1")
#define CODE_DCM_HaigisA2                                                  DSRBasicCodedEntry("111771", "DCM", "Haigis a2")
#define CODE_DCM_HofferPACDConstant                                        DSRBasicCodedEntry("111772", "DCM", "Hoffer pACD Constant")
#define CODE_DCM_SurgeonFactor                                             DSRBasicCodedEntry("111773", "DCM", "Surgeon Factor")
#define CODE_DCM_FrontOfCorneaToFrontOfLens                                DSRBasicCodedEntry("111776", "DCM", "Front Of Cornea To Front Of Lens")
#define CODE_DCM_BackOfCorneaToFrontOfLens                                 DSRBasicCodedEntry("111777", "DCM", "Back Of Cornea To Front Of Lens")
#define CODE_DCM_SingleOrAnteriorLens                                      DSRBasicCodedEntry("111778", "DCM", "Single or Anterior Lens")
#define CODE_DCM_PosteriorLens                                             DSRBasicCodedEntry("111779", "DCM", "Posterior Lens")
#define CODE_DCM_MeasurementFromThisDevice                                 DSRBasicCodedEntry("111780", "DCM", "Measurement From This Device")
#define CODE_DCM_ExternalDataSource                                        DSRBasicCodedEntry("111781", "DCM", "External Data Source")
#define CODE_DCM_AxialMeasurementsSOPInstance                              DSRBasicCodedEntry("111782", "DCM", "Axial Measurements SOP Instance")
#define CODE_DCM_RefractiveMeasurementsSOPInstance                         DSRBasicCodedEntry("111783", "DCM", "Refractive Measurements SOP Instance")
#define CODE_DCM_AutorefractionMeasurementsSOPInstance                     DSRBasicCodedEntry("111784", "DCM", "Autorefraction Measurements SOP Instance")
#define CODE_DCM_StandardDeviationOfMeasurementsUsed                       DSRBasicCodedEntry("111786", "DCM", "Standard Deviation of measurements used")
#define CODE_DCM_SignalToNoiseRatio                                        DSRBasicCodedEntry("111787", "DCM", "Signal to Noise Ratio")
#define CODE_DCM_SphericalProjection                                       DSRBasicCodedEntry("111791", "DCM", "Spherical projection")
#define CODE_DCM_SurfaceContourMapping                                     DSRBasicCodedEntry("111792", "DCM", "Surface contour mapping")
#define CODE_DCM_VisualField242TestPattern                                 DSRBasicCodedEntry("111800", "DCM", "Visual Field 24-2 Test Pattern")
#define CODE_DCM_VisualField102TestPattern                                 DSRBasicCodedEntry("111801", "DCM", "Visual Field 10-2 Test Pattern")
#define CODE_DCM_VisualField302TestPattern                                 DSRBasicCodedEntry("111802", "DCM", "Visual Field 30-2 Test Pattern")
#define CODE_DCM_VisualField604TestPattern                                 DSRBasicCodedEntry("111803", "DCM", "Visual Field 60-4 Test Pattern")
#define CODE_DCM_VisualFieldMaculaTestPattern                              DSRBasicCodedEntry("111804", "DCM", "Visual Field Macula Test Pattern")
#define CODE_DCM_VisualFieldCentral40PointTestPattern                      DSRBasicCodedEntry("111805", "DCM", "Visual Field Central 40 Point Test Pattern")
#define CODE_DCM_VisualFieldCentral76PointTestPattern                      DSRBasicCodedEntry("111806", "DCM", "Visual Field Central 76 Point Test Pattern")
#define CODE_DCM_VisualFieldPeripheral60PointTestPattern                   DSRBasicCodedEntry("111807", "DCM", "Visual Field Peripheral 60 Point Test Pattern")
#define CODE_DCM_VisualFieldFullField81PointTestPattern                    DSRBasicCodedEntry("111808", "DCM", "Visual Field Full Field 81 Point Test Pattern")
#define CODE_DCM_VisualFieldFullField120PointTestPattern                   DSRBasicCodedEntry("111809", "DCM", "Visual Field Full Field 120 Point Test Pattern")
#define CODE_DCM_VisualFieldGTestPattern                                   DSRBasicCodedEntry("111810", "DCM", "Visual Field G Test Pattern")
#define CODE_DCM_VisualFieldMTestPattern                                   DSRBasicCodedEntry("111811", "DCM", "Visual Field M Test Pattern")
#define CODE_DCM_VisualField07TestPattern                                  DSRBasicCodedEntry("111812", "DCM", "Visual Field 07 Test Pattern")
#define CODE_DCM_VisualFieldLVCTestPattern                                 DSRBasicCodedEntry("111813", "DCM", "Visual Field LVC Test Pattern")
#define CODE_DCM_VisualFieldCentralTestPattern                             DSRBasicCodedEntry("111814", "DCM", "Visual Field Central Test Pattern")
#define CODE_DCM_VisualFieldSITAStandardTestStrategy                       DSRBasicCodedEntry("111815", "DCM", "Visual Field SITA-Standard Test Strategy")
#define CODE_DCM_VisualFieldSITASWAPTestStrategy                           DSRBasicCodedEntry("111816", "DCM", "Visual Field SITA-SWAP Test Strategy")
#define CODE_DCM_VisualFieldSITAFastTestStrategy                           DSRBasicCodedEntry("111817", "DCM", "Visual Field SITA-Fast Test Strategy")
#define CODE_DCM_VisualFieldFullThresholdTestStrategy                      DSRBasicCodedEntry("111818", "DCM", "Visual Field Full Threshold Test Strategy")
#define CODE_DCM_VisualFieldFastPacTestStrategy                            DSRBasicCodedEntry("111819", "DCM", "Visual Field FastPac Test Strategy")
#define CODE_DCM_VisualFieldFullFromPriorTestStrategy                      DSRBasicCodedEntry("111820", "DCM", "Visual Field Full From Prior Test Strategy")
#define CODE_DCM_VisualFieldOptimaTestStrategy                             DSRBasicCodedEntry("111821", "DCM", "Visual Field Optima Test Strategy")
#define CODE_DCM_VisualFieldTwoZoneTestStrategy                            DSRBasicCodedEntry("111822", "DCM", "Visual Field Two-Zone Test Strategy")
#define CODE_DCM_VisualFieldThreeZoneTestStrategy                          DSRBasicCodedEntry("111823", "DCM", "Visual Field Three-Zone Test Strategy")
#define CODE_DCM_VisualFieldQuantifyDefectsTestStrategy                    DSRBasicCodedEntry("111824", "DCM", "Visual Field Quantify-Defects Test Strategy")
#define CODE_DCM_VisualFieldTOPTestStrategy                                DSRBasicCodedEntry("111825", "DCM", "Visual Field TOP Test Strategy")
#define CODE_DCM_VisualFieldDynamicTestStrategy                            DSRBasicCodedEntry("111826", "DCM", "Visual Field Dynamic Test Strategy")
#define CODE_DCM_VisualFieldNormalTestStrategy                             DSRBasicCodedEntry("111827", "DCM", "Visual Field Normal Test Strategy")
#define CODE_DCM_VisualField1LTTestStrategy                                DSRBasicCodedEntry("111828", "DCM", "Visual Field 1-LT Test Strategy")
#define CODE_DCM_VisualField2LTTestStrategy                                DSRBasicCodedEntry("111829", "DCM", "Visual Field 2-LT Test Strategy")
#define CODE_DCM_VisualFieldLVSTestStrategy                                DSRBasicCodedEntry("111830", "DCM", "Visual Field LVS Test Strategy")
#define CODE_DCM_VisualFieldGATETestStrategy                               DSRBasicCodedEntry("111831", "DCM", "Visual Field GATE Test Strategy")
#define CODE_DCM_VisualFieldGATEiTestStrategy                              DSRBasicCodedEntry("111832", "DCM", "Visual Field GATEi Test Strategy")
#define CODE_DCM_VisualField2LTDynamicTestStrategy                         DSRBasicCodedEntry("111833", "DCM", "Visual Field 2LT-Dynamic Test Strategy")
#define CODE_DCM_VisualField2LTNormalTestStrategy                          DSRBasicCodedEntry("111834", "DCM", "Visual Field 2LT-Normal Test Strategy")
#define CODE_DCM_VisualFieldFastThresholdTestStrategy                      DSRBasicCodedEntry("111835", "DCM", "Visual Field Fast Threshold Test Strategy")
#define CODE_DCM_VisualFieldCLIPTestStrategy                               DSRBasicCodedEntry("111836", "DCM", "Visual Field CLIP Test Strategy")
#define CODE_DCM_VisualFieldCLASSStrategy                                  DSRBasicCodedEntry("111837", "DCM", "Visual Field CLASS Strategy")
#define CODE_DCM_AgeCorrected                                              DSRBasicCodedEntry("111838", "DCM", "Age corrected")
#define CODE_DCM_ThresholdRelated                                          DSRBasicCodedEntry("111839", "DCM", "Threshold related")
#define CODE_DCM_SingleLuminance                                           DSRBasicCodedEntry("111840", "DCM", "Single luminance")
#define CODE_DCM_FovealSensitivityRelated                                  DSRBasicCodedEntry("111841", "DCM", "Foveal sensitivity related")
#define CODE_DCM_RelatedToNonMacularSensitivity                            DSRBasicCodedEntry("111842", "DCM", "Related to non macular sensitivity")
#define CODE_DCM_AutomatedOptical                                          DSRBasicCodedEntry("111843", "DCM", "Automated Optical")
#define CODE_DCM_BlindSpotMonitoring                                       DSRBasicCodedEntry("111844", "DCM", "Blind Spot Monitoring")
#define CODE_DCM_MacularFixationTesting                                    DSRBasicCodedEntry("111845", "DCM", "Macular Fixation Testing")
#define CODE_DCM_ObservationByExaminer                                     DSRBasicCodedEntry("111846", "DCM", "Observation by Examiner")
#define CODE_DCM_OutsideNormalLimits                                       DSRBasicCodedEntry("111847", "DCM", "Outside normal limits")
#define CODE_DCM_Borderline                                                DSRBasicCodedEntry("111848", "DCM", "Borderline")
#define CODE_DCM_AbnormallyHighSensitivity                                 DSRBasicCodedEntry("111849", "DCM", "Abnormally high sensitivity")
#define CODE_DCM_GeneralReductionInSensitivity                             DSRBasicCodedEntry("111850", "DCM", "General reduction in sensitivity")
#define CODE_DCM_BorderlineAndGeneralReductionInSensitivity                DSRBasicCodedEntry("111851", "DCM", "Borderline and general reduction in sensitivity")
#define CODE_DCM_VisualFieldIndex                                          DSRBasicCodedEntry("111852", "DCM", "Visual Field Index")
#define CODE_DCM_VisualFieldLossDueToDiffuseDefect                         DSRBasicCodedEntry("111853", "DCM", "Visual Field Loss Due to Diffuse Defect")
#define CODE_DCM_VisualFieldLossDueToLocalDefect                           DSRBasicCodedEntry("111854", "DCM", "Visual Field Loss Due to Local Defect")
#define CODE_DCM_GlaucomaHemifieldTestAnalysis                             DSRBasicCodedEntry("111855", "DCM", "Glaucoma Hemifield Test Analysis")
#define CODE_DCM_OpticalFixationMeasurements                               DSRBasicCodedEntry("111856", "DCM", "Optical Fixation Measurements")
#define CODE_DCM_HaigisToric                                               DSRBasicCodedEntry("111860", "DCM", "Haigis Toric")
#define CODE_DCM_HaigisLToric                                              DSRBasicCodedEntry("111861", "DCM", "Haigis-L Toric")
#define CODE_DCM_BarrettToric                                              DSRBasicCodedEntry("111862", "DCM", "Barrett Toric")
#define CODE_DCM_BarrettTrueK                                              DSRBasicCodedEntry("111863", "DCM", "Barrett True-K")
#define CODE_DCM_BarrettTrueKToric                                         DSRBasicCodedEntry("111864", "DCM", "Barrett True-K Toric")
#define CODE_DCM_BarrettUniversalII                                        DSRBasicCodedEntry("111865", "DCM", "Barrett Universal II")
#define CODE_DCM_BarrettLensFactor                                         DSRBasicCodedEntry("111866", "DCM", "Barrett Lens Factor")
#define CODE_DCM_BarrettDesignFactor                                       DSRBasicCodedEntry("111867", "DCM", "Barrett Design Factor")
#define CODE_DCM_MaculaCentered                                            DSRBasicCodedEntry("111900", "DCM", "Macula centered")
#define CODE_DCM_DiscCentered                                              DSRBasicCodedEntry("111901", "DCM", "Disc centered")
#define CODE_DCM_LesionCentered                                            DSRBasicCodedEntry("111902", "DCM", "Lesion centered")
#define CODE_DCM_DiscMaculaCentered                                        DSRBasicCodedEntry("111903", "DCM", "Disc-macula centered")
#define CODE_DCM_MidPeripheralSuperior                                     DSRBasicCodedEntry("111904", "DCM", "Mid-peripheral-superior")
#define CODE_DCM_MidPeripheralSuperiorTemporal                             DSRBasicCodedEntry("111905", "DCM", "Mid-peripheral-superior temporal")
#define CODE_DCM_MidPeripheralTemporal                                     DSRBasicCodedEntry("111906", "DCM", "Mid-peripheral-temporal")
#define CODE_DCM_MidPeripheralInferiorTemporal                             DSRBasicCodedEntry("111907", "DCM", "Mid-peripheral-inferior temporal")
#define CODE_DCM_MidPeripheralInferior                                     DSRBasicCodedEntry("111908", "DCM", "Mid-peripheral-inferior")
#define CODE_DCM_MidPeripheralInferiorNasal                                DSRBasicCodedEntry("111909", "DCM", "Mid-peripheral-inferior nasal")
#define CODE_DCM_MidPeripheralNasal                                        DSRBasicCodedEntry("111910", "DCM", "Mid-peripheral-nasal")
#define CODE_DCM_MidPeripheralSuperiorNasal                                DSRBasicCodedEntry("111911", "DCM", "Mid-peripheral-superior nasal")
#define CODE_DCM_PeripheralSuperior                                        DSRBasicCodedEntry("111912", "DCM", "Peripheral-superior")
#define CODE_DCM_PeripheralSuperiorTemporal                                DSRBasicCodedEntry("111913", "DCM", "Peripheral-superior temporal")
#define CODE_DCM_PeripheralTemporal                                        DSRBasicCodedEntry("111914", "DCM", "Peripheral-temporal")
#define CODE_DCM_PeripheralInferiorTemporal                                DSRBasicCodedEntry("111915", "DCM", "Peripheral-inferior temporal")
#define CODE_DCM_PeripheralInferior                                        DSRBasicCodedEntry("111916", "DCM", "Peripheral-inferior")
#define CODE_DCM_PeripheralInferiorNasal                                   DSRBasicCodedEntry("111917", "DCM", "Peripheral-inferior nasal")
#define CODE_DCM_PeripheralNasal                                           DSRBasicCodedEntry("111918", "DCM", "Peripheral-nasal")
#define CODE_DCM_PeripheralSuperiorNasal                                   DSRBasicCodedEntry("111919", "DCM", "Peripheral-superior nasal")
#define CODE_DCM_TimeDomain                                                DSRBasicCodedEntry("111920", "DCM", "Time domain")
#define CODE_DCM_SpectralDomain                                            DSRBasicCodedEntry("111921", "DCM", "Spectral domain")
#define CODE_DCM_NoCornealCompensation                                     DSRBasicCodedEntry("111922", "DCM", "No corneal compensation")
#define CODE_DCM_CornealBirefringenceCompensation                          DSRBasicCodedEntry("111923", "DCM", "Corneal birefringence compensation")
#define CODE_DCM_RetinalTopography                                         DSRBasicCodedEntry("111924", "DCM", "Retinal topography")
#define CODE_DCM_RetinalNerveFiberLayerThickness                           DSRBasicCodedEntry("111925", "DCM", "Retinal nerve fiber layer thickness")
#define CODE_DCM_GanglionCellComplexThickness                              DSRBasicCodedEntry("111926", "DCM", "Ganglion cell complex thickness")
#define CODE_DCM_TotalRetinalThickness_ILMToISOS                           DSRBasicCodedEntry("111927", "DCM", "Total retinal thickness (ILM to IS-OS)")
#define CODE_DCM_TotalRetinalThickness_ILMToRPE                            DSRBasicCodedEntry("111928", "DCM", "Total retinal thickness (ILM to RPE)")
#define CODE_DCM_TotalRetinalThickness_ILMToBM                             DSRBasicCodedEntry("111929", "DCM", "Total retinal thickness (ILM to BM)")
#define CODE_DCM_AbsoluteOphthalmicThickness                               DSRBasicCodedEntry("111930", "DCM", "Absolute ophthalmic thickness")
#define CODE_DCM_ThicknessDeviationCategoryFromNormativeData               DSRBasicCodedEntry("111931", "DCM", "Thickness deviation category from normative data")
#define CODE_DCM_ThicknessDeviationFromNormativeData                       DSRBasicCodedEntry("111932", "DCM", "Thickness deviation from normative data")
#define CODE_DCM_RelatedOphthalmicThicknessMap                             DSRBasicCodedEntry("111933", "DCM", "Related ophthalmic thickness map")
#define CODE_DCM_DiscFovea                                                 DSRBasicCodedEntry("111934", "DCM", "Disc-Fovea")
#define CODE_DCM_PGreaterThan5Percent                                      DSRBasicCodedEntry("111935", "DCM", "p>5%")
#define CODE_DCM_PLessThan5Percent                                         DSRBasicCodedEntry("111936", "DCM", "p<5%")
#define CODE_DCM_PLessThan2Percent                                         DSRBasicCodedEntry("111937", "DCM", "p<2%")
#define CODE_DCM_PLessThan1Percent                                         DSRBasicCodedEntry("111938", "DCM", "p<1%")
#define CODE_DCM_PLessThan0dot5Percent                                     DSRBasicCodedEntry("111939", "DCM", "p<0.5%")
#define CODE_DCM_CornealAxialPowerMap                                      DSRBasicCodedEntry("111940", "DCM", "Corneal axial power map")
#define CODE_DCM_CornealInstantaneousPowerMap                              DSRBasicCodedEntry("111941", "DCM", "Corneal instantaneous power map")
#define CODE_DCM_CornealRefractivePowerMap                                 DSRBasicCodedEntry("111942", "DCM", "Corneal refractive power map")
#define CODE_DCM_CornealElevationMap                                       DSRBasicCodedEntry("111943", "DCM", "Corneal elevation map")
#define CODE_DCM_CornealWavefrontMap                                       DSRBasicCodedEntry("111944", "DCM", "Corneal wavefront map")
#define CODE_DCM_ElevationBasedCornealTomographer                          DSRBasicCodedEntry("111945", "DCM", "Elevation-based corneal tomographer")
#define CODE_DCM_ReflectionBasedCornealTopographer                         DSRBasicCodedEntry("111946", "DCM", "Reflection-based corneal topographer")
#define CODE_DCM_InterferometryBasedCornealTomographer                     DSRBasicCodedEntry("111947", "DCM", "Interferometry-based corneal tomographer")
#define CODE_DCM_ChestCADReport                                            DSRBasicCodedEntry("112000", "DCM", "Chest CAD Report")
#define CODE_DCM_Opacity                                                   DSRBasicCodedEntry("112001", "DCM", "Opacity")
#define CODE_DCM_SeriesInstanceUID                                         DSRBasicCodedEntry("112002", "DCM", "Series Instance UID")
#define CODE_DCM_AssociatedChestComponent                                  DSRBasicCodedEntry("112003", "DCM", "Associated Chest Component")
#define CODE_DCM_AbnormalInterstitialPattern                               DSRBasicCodedEntry("112004", "DCM", "Abnormal interstitial pattern")
#define CODE_DCM_RadiographicAnatomy                                       DSRBasicCodedEntry("112005", "DCM", "Radiographic anatomy")
#define CODE_DCM_DistributionDescriptor                                    DSRBasicCodedEntry("112006", "DCM", "Distribution Descriptor")
#define CODE_DCM_BorderDefinition                                          DSRBasicCodedEntry("112007", "DCM", "Border definition")
#define CODE_DCM_SiteInvolvement                                           DSRBasicCodedEntry("112008", "DCM", "Site involvement")
#define CODE_DCM_TypeOfContent                                             DSRBasicCodedEntry("112009", "DCM", "Type of Content")
#define CODE_DCM_TextureDescriptor                                         DSRBasicCodedEntry("112010", "DCM", "Texture Descriptor")
#define CODE_DCM_PositionerPrimaryAngle                                    DSRBasicCodedEntry("112011", "DCM", "Positioner Primary Angle")
#define CODE_DCM_PositionerSecondaryAngle                                  DSRBasicCodedEntry("112012", "DCM", "Positioner Secondary Angle")
#define CODE_DCM_LocationInChest                                           DSRBasicCodedEntry("112013", "DCM", "Location in Chest")
#define CODE_DCM_OrientationDescriptor                                     DSRBasicCodedEntry("112014", "DCM", "Orientation Descriptor")
#define CODE_DCM_BorderShape                                               DSRBasicCodedEntry("112015", "DCM", "Border shape")
#define CODE_DCM_BaselineCategory                                          DSRBasicCodedEntry("112016", "DCM", "Baseline Category")
#define CODE_DCM_CavityExtentAsPercentOfVolume                             DSRBasicCodedEntry("112017", "DCM", "Cavity extent as percent of volume")
#define CODE_DCM_CalcificationExtentAsPercentOfSurface                     DSRBasicCodedEntry("112018", "DCM", "Calcification extent as percent of surface")
#define CODE_DCM_CalcificationExtentAsPercentOfVolume                      DSRBasicCodedEntry("112019", "DCM", "Calcification extent as percent of volume")
#define CODE_DCM_ResponseEvaluation                                        DSRBasicCodedEntry("112020", "DCM", "Response Evaluation")
#define CODE_DCM_ResponseEvaluationMethod                                  DSRBasicCodedEntry("112021", "DCM", "Response Evaluation Method")
#define CODE_DCM_RECIST                                                    DSRBasicCodedEntry("112022", "DCM", "RECIST")
#define CODE_DCM_CompositeFeatureModifier                                  DSRBasicCodedEntry("112023", "DCM", "Composite Feature Modifier")
#define CODE_DCM_SingleImageFindingModifier                                DSRBasicCodedEntry("112024", "DCM", "Single Image Finding Modifier")
#define CODE_DCM_SizeDescriptor                                            DSRBasicCodedEntry("112025", "DCM", "Size Descriptor")
#define CODE_DCM_WidthDescriptor                                           DSRBasicCodedEntry("112026", "DCM", "Width Descriptor")
#define CODE_DCM_OpacityDescriptor                                         DSRBasicCodedEntry("112027", "DCM", "Opacity Descriptor")
#define CODE_DCM_AbnormalDistributionOfAnatomicStructure                   DSRBasicCodedEntry("112028", "DCM", "Abnormal Distribution of Anatomic Structure")
#define CODE_DCM_WHO                                                       DSRBasicCodedEntry("112029", "DCM", "WHO")
#define CODE_DCM_CalcificationDescriptor                                   DSRBasicCodedEntry("112030", "DCM", "Calcification Descriptor")
#define CODE_DCM_AttenuationCoefficient                                    DSRBasicCodedEntry("112031", "DCM", "Attenuation Coefficient")
#define CODE_DCM_ThresholdAttenuationCoefficient                           DSRBasicCodedEntry("112032", "DCM", "Threshold Attenuation Coefficient")
#define CODE_DCM_AbnormalOpacity                                           DSRBasicCodedEntry("112033", "DCM", "Abnormal opacity")
#define CODE_DCM_CalculationDescription                                    DSRBasicCodedEntry("112034", "DCM", "Calculation Description")
#define CODE_DCM_PerformanceOfPediatricAndAdultChestRadiography_ACR        DSRBasicCodedEntry("112035", "DCM", "Performance of Pediatric and Adult Chest Radiography, ACR")
#define CODE_DCM_ACRPositionStatement                                      DSRBasicCodedEntry("112036", "DCM", "ACR Position Statement")
#define CODE_DCM_NonLesionModifier                                         DSRBasicCodedEntry("112037", "DCM", "Non-lesion Modifier")
#define CODE_DCM_OsseousModifier                                           DSRBasicCodedEntry("112038", "DCM", "Osseous Modifier")
#define CODE_DCM_TrackingIdentifier                                        DSRBasicCodedEntry("112039", "DCM", "Tracking Identifier")
#define CODE_DCM_TrackingUniqueIdentifier                                  DSRBasicCodedEntry("112040", "DCM", "Tracking Unique Identifier")
#define CODE_DCM_TargetLesionCompleteResponse                              DSRBasicCodedEntry("112041", "DCM", "Target Lesion Complete Response")
#define CODE_DCM_TargetLesionPartialResponse                               DSRBasicCodedEntry("112042", "DCM", "Target Lesion Partial Response")
#define CODE_DCM_TargetLesionProgressiveDisease                            DSRBasicCodedEntry("112043", "DCM", "Target Lesion Progressive Disease")
#define CODE_DCM_TargetLesionStableDisease                                 DSRBasicCodedEntry("112044", "DCM", "Target Lesion Stable Disease")
#define CODE_DCM_NonTargetLesionCompleteResponse                           DSRBasicCodedEntry("112045", "DCM", "Non-Target Lesion Complete Response")
#define CODE_DCM_NonTargetLesionIncompleteResponseOrStableDisease          DSRBasicCodedEntry("112046", "DCM", "Non-Target Lesion Incomplete Response or Stable Disease")
#define CODE_DCM_NonTargetLesionProgressiveDisease                         DSRBasicCodedEntry("112047", "DCM", "Non-Target Lesion Progressive Disease")
#define CODE_DCM_CurrentResponse                                           DSRBasicCodedEntry("112048", "DCM", "Current Response")
#define CODE_DCM_BestOverallResponse                                       DSRBasicCodedEntry("112049", "DCM", "Best Overall Response")
#define CODE_DCM_AnatomicIdentifier                                        DSRBasicCodedEntry("112050", "DCM", "Anatomic Identifier")
#define CODE_DCM_MeasurementOfResponse                                     DSRBasicCodedEntry("112051", "DCM", "Measurement of Response")
#define CODE_DCM_Bronchovascular                                           DSRBasicCodedEntry("112052", "DCM", "Bronchovascular")
#define CODE_DCM_Osseous                                                   DSRBasicCodedEntry("112053", "DCM", "Osseous")
#define CODE_DCM_SecondaryPulmonaryLobule                                  DSRBasicCodedEntry("112054", "DCM", "Secondary pulmonary lobule")
#define CODE_DCM_AgatstonScoringMethod                                     DSRBasicCodedEntry("112055", "DCM", "Agatston scoring method")
#define CODE_DCM_VolumeScoringMethod                                       DSRBasicCodedEntry("112056", "DCM", "Volume scoring method")
#define CODE_DCM_MassScoringMethod                                         DSRBasicCodedEntry("112057", "DCM", "Mass scoring method")
#define CODE_DCM_CalciumScore                                              DSRBasicCodedEntry("112058", "DCM", "Calcium score")
#define CODE_DCM_PrimaryComplex                                            DSRBasicCodedEntry("112059", "DCM", "Primary complex")
#define CODE_DCM_Oligemia                                                  DSRBasicCodedEntry("112060", "DCM", "Oligemia")
#define CODE_DCM_AbnormalLines_1D                                          DSRBasicCodedEntry("112061", "DCM", "Abnormal lines (1D)")
#define CODE_DCM_AbnormalLucency                                           DSRBasicCodedEntry("112062", "DCM", "Abnormal lucency")
#define CODE_DCM_AbnormalCalcifications                                    DSRBasicCodedEntry("112063", "DCM", "Abnormal calcifications")
#define CODE_DCM_AbnormalTexture                                           DSRBasicCodedEntry("112064", "DCM", "Abnormal texture")
#define CODE_DCM_ReticulonodularPattern                                    DSRBasicCodedEntry("112065", "DCM", "Reticulonodular pattern")
#define CODE_DCM_BeadedSeptumSign                                          DSRBasicCodedEntry("112066", "DCM", "Beaded septum sign")
#define CODE_DCM_NodularPattern                                            DSRBasicCodedEntry("112067", "DCM", "Nodular pattern")
#define CODE_DCM_Pseudoplaque                                              DSRBasicCodedEntry("112068", "DCM", "Pseudoplaque")
#define CODE_DCM_SignetRingSign                                            DSRBasicCodedEntry("112069", "DCM", "Signet-ring sign")
#define CODE_DCM_AirBronchiologram                                         DSRBasicCodedEntry("112070", "DCM", "Air bronchiologram")
#define CODE_DCM_AirBronchogram                                            DSRBasicCodedEntry("112071", "DCM", "Air bronchogram")
#define CODE_DCM_AirCrescent                                               DSRBasicCodedEntry("112072", "DCM", "Air crescent")
#define CODE_DCM_HaloSign                                                  DSRBasicCodedEntry("112073", "DCM", "Halo sign")
#define CODE_DCM_TargetLesionAtBaseline                                    DSRBasicCodedEntry("112074", "DCM", "Target Lesion at Baseline")
#define CODE_DCM_NonTargetLesionAtBaseline                                 DSRBasicCodedEntry("112075", "DCM", "Non-Target Lesion at Baseline")
#define CODE_DCM_NonLesionAtBaseline                                       DSRBasicCodedEntry("112076", "DCM", "Non-Lesion at Baseline")
#define CODE_DCM_Vasoconstriction                                          DSRBasicCodedEntry("112077", "DCM", "Vasoconstriction")
#define CODE_DCM_Vasodilation                                              DSRBasicCodedEntry("112078", "DCM", "Vasodilation")
#define CODE_DCM_ArchitecturalDistortion                                   DSRBasicCodedEntry("112079", "DCM", "Architectural distortion")
#define CODE_DCM_MosaicPerfusion                                           DSRBasicCodedEntry("112080", "DCM", "Mosaic perfusion")
#define CODE_DCM_Pleonemia                                                 DSRBasicCodedEntry("112081", "DCM", "Pleonemia")
#define CODE_DCM_Interface                                                 DSRBasicCodedEntry("112082", "DCM", "Interface")
#define CODE_DCM_Line                                                      DSRBasicCodedEntry("112083", "DCM", "Line")
#define CODE_DCM_Lucency                                                   DSRBasicCodedEntry("112084", "DCM", "Lucency")
#define CODE_DCM_MidlungWindow                                             DSRBasicCodedEntry("112085", "DCM", "Midlung window")
#define CODE_DCM_CarinaAngle                                               DSRBasicCodedEntry("112086", "DCM", "Carina angle")
#define CODE_DCM_CentrilobularStructures                                   DSRBasicCodedEntry("112087", "DCM", "Centrilobular structures")
#define CODE_DCM_AnteriorJunctionLine                                      DSRBasicCodedEntry("112088", "DCM", "Anterior junction line")
#define CODE_DCM_PosteriorJunctionLine                                     DSRBasicCodedEntry("112089", "DCM", "Posterior junction line")
#define CODE_DCM_AzygoesophagealRecessInterface                            DSRBasicCodedEntry("112090", "DCM", "Azygoesophageal recess interface")
#define CODE_DCM_ParaspinalLine                                            DSRBasicCodedEntry("112091", "DCM", "Paraspinal line")
#define CODE_DCM_PosteriorTrachealStripe                                   DSRBasicCodedEntry("112092", "DCM", "Posterior tracheal stripe")
#define CODE_DCM_RightTrachealStripe                                       DSRBasicCodedEntry("112093", "DCM", "Right tracheal stripe")
#define CODE_DCM_Stripe                                                    DSRBasicCodedEntry("112094", "DCM", "Stripe")
#define CODE_DCM_Hiatus                                                    DSRBasicCodedEntry("112095", "DCM", "Hiatus")
#define CODE_DCM_RibScaleneTubercle                                        DSRBasicCodedEntry("112096", "DCM", "Rib Scalene Tubercle")
#define CODE_DCM_VertebralIntervertebralNotch                              DSRBasicCodedEntry("112097", "DCM", "Vertebral Intervertebral Notch")
#define CODE_DCM_SubscapularFossa                                          DSRBasicCodedEntry("112098", "DCM", "Subscapular Fossa")
#define CODE_DCM_ScapularSpine                                             DSRBasicCodedEntry("112099", "DCM", "Scapular Spine")
#define CODE_DCM_ScapularSupraspinatusFossa                                DSRBasicCodedEntry("112100", "DCM", "Scapular Supraspinatus Fossa")
#define CODE_DCM_ScapularInfraspinatusFossa                                DSRBasicCodedEntry("112101", "DCM", "Scapular Infraspinatus Fossa")
#define CODE_DCM_AorticKnob                                                DSRBasicCodedEntry("112102", "DCM", "Aortic knob")
#define CODE_DCM_ArchOfTheAzygosVein                                       DSRBasicCodedEntry("112103", "DCM", "Arch of the Azygos vein")
#define CODE_DCM_AirFluidLevel                                             DSRBasicCodedEntry("112104", "DCM", "Air-fluid level")
#define CODE_DCM_CoronaRadiata                                             DSRBasicCodedEntry("112105", "DCM", "Corona radiata")
#define CODE_DCM_HoneycombPattern                                          DSRBasicCodedEntry("112106", "DCM", "Honeycomb pattern")
#define CODE_DCM_FleischnerLines                                           DSRBasicCodedEntry("112107", "DCM", "Fleischner's line(s)")
#define CODE_DCM_IntralobularLines                                         DSRBasicCodedEntry("112108", "DCM", "Intralobular lines")
#define CODE_DCM_KerleyALine                                               DSRBasicCodedEntry("112109", "DCM", "Kerley A line")
#define CODE_DCM_KerleyBLine                                               DSRBasicCodedEntry("112110", "DCM", "Kerley B line")
#define CODE_DCM_KerleyCLines                                              DSRBasicCodedEntry("112111", "DCM", "Kerley C lines")
#define CODE_DCM_ParenchymalBand                                           DSRBasicCodedEntry("112112", "DCM", "Parenchymal band")
#define CODE_DCM_ReticularPattern                                          DSRBasicCodedEntry("112113", "DCM", "Reticular pattern")
#define CODE_DCM_SeptalLines                                               DSRBasicCodedEntry("112114", "DCM", "Septal line(s)")
#define CODE_DCM_SubpleuralLine                                            DSRBasicCodedEntry("112115", "DCM", "Subpleural line")
#define CODE_DCM_TramlineShadow                                            DSRBasicCodedEntry("112116", "DCM", "Tramline shadow")
#define CODE_DCM_TubularShadow                                             DSRBasicCodedEntry("112117", "DCM", "Tubular shadow")
#define CODE_DCM_Density                                                   DSRBasicCodedEntry("112118", "DCM", "Density")
#define CODE_DCM_DependentOpacity                                          DSRBasicCodedEntry("112119", "DCM", "Dependent opacity")
#define CODE_DCM_GroundGlassOpacity                                        DSRBasicCodedEntry("112120", "DCM", "Ground glass opacity")
#define CODE_DCM_Infiltrate                                                DSRBasicCodedEntry("112121", "DCM", "Infiltrate")
#define CODE_DCM_Micronodule                                               DSRBasicCodedEntry("112122", "DCM", "Micronodule")
#define CODE_DCM_PhantomTumor_pseudotumor                                  DSRBasicCodedEntry("112123", "DCM", "Phantom tumor (pseudotumor)")
#define CODE_DCM_Shadow                                                    DSRBasicCodedEntry("112124", "DCM", "Shadow")
#define CODE_DCM_SmallIrregularOpacities                                   DSRBasicCodedEntry("112125", "DCM", "Small irregular opacities")
#define CODE_DCM_SmallRoundedOpacities                                     DSRBasicCodedEntry("112126", "DCM", "Small rounded opacities")
#define CODE_DCM_TreeInBudSign                                             DSRBasicCodedEntry("112127", "DCM", "Tree-in-bud sign")
#define CODE_DCM_GranularPattern                                           DSRBasicCodedEntry("112128", "DCM", "Granular pattern")
#define CODE_DCM_MiliaryPattern                                            DSRBasicCodedEntry("112129", "DCM", "Miliary pattern")
#define CODE_DCM_MosaicPattern                                             DSRBasicCodedEntry("112130", "DCM", "Mosaic pattern")
#define CODE_DCM_ExtremelySmall                                            DSRBasicCodedEntry("112131", "DCM", "Extremely small")
#define CODE_DCM_VerySmall                                                 DSRBasicCodedEntry("112132", "DCM", "Very small")
#define CODE_DCM_TooSmall                                                  DSRBasicCodedEntry("112133", "DCM", "Too small")
#define CODE_DCM_Elliptic                                                  DSRBasicCodedEntry("112134", "DCM", "Elliptic")
#define CODE_DCM_Lobulated                                                 DSRBasicCodedEntry("112135", "DCM", "Lobulated")
#define CODE_DCM_Spiculated                                                DSRBasicCodedEntry("112136", "DCM", "Spiculated")
#define CODE_DCM_SharplyDefined                                            DSRBasicCodedEntry("112137", "DCM", "Sharply defined")
#define CODE_DCM_DistinctlyDefined                                         DSRBasicCodedEntry("112138", "DCM", "Distinctly defined")
#define CODE_DCM_WellDemarcated                                            DSRBasicCodedEntry("112139", "DCM", "Well demarcated")
#define CODE_DCM_SharplyDemarcated                                         DSRBasicCodedEntry("112140", "DCM", "Sharply demarcated")
#define CODE_DCM_PoorlyDemarcated                                          DSRBasicCodedEntry("112141", "DCM", "Poorly demarcated")
#define CODE_DCM_RETIRED_Circumscribed                                     DSRBasicCodedEntry("112142", "DCM", "Circumscribed")
#define CODE_DCM_Air                                                       DSRBasicCodedEntry("112143", "DCM", "Air")
#define CODE_DCM_RETIRED_SoftTissue                                        DSRBasicCodedEntry("112144", "DCM", "Soft tissue")
#define CODE_DCM_Calcium                                                   DSRBasicCodedEntry("112145", "DCM", "Calcium")
#define CODE_DCM_Acinar                                                    DSRBasicCodedEntry("112146", "DCM", "Acinar")
#define CODE_DCM_AirSpace                                                  DSRBasicCodedEntry("112147", "DCM", "Air space")
#define CODE_DCM_Fibronodular                                              DSRBasicCodedEntry("112148", "DCM", "Fibronodular")
#define CODE_DCM_Fluffy                                                    DSRBasicCodedEntry("112149", "DCM", "Fluffy")
#define CODE_DCM_Linear                                                    DSRBasicCodedEntry("112150", "DCM", "Linear")
#define CODE_DCM_Profusion                                                 DSRBasicCodedEntry("112151", "DCM", "Profusion")
#define CODE_DCM_SilhouetteSign                                            DSRBasicCodedEntry("112152", "DCM", "Silhouette sign")
#define CODE_DCM_Subpleural                                                DSRBasicCodedEntry("112153", "DCM", "Subpleural")
#define CODE_DCM_BatWingDistribution                                       DSRBasicCodedEntry("112154", "DCM", "Bat's wing distribution")
#define CODE_DCM_ButterflyDistribution                                     DSRBasicCodedEntry("112155", "DCM", "Butterfly distribution")
#define CODE_DCM_Centrilobular                                             DSRBasicCodedEntry("112156", "DCM", "Centrilobular")
#define CODE_DCM_Coalescent                                                DSRBasicCodedEntry("112157", "DCM", "Coalescent")
#define CODE_DCM_Lobar                                                     DSRBasicCodedEntry("112158", "DCM", "Lobar")
#define CODE_DCM_HyperAcute                                                DSRBasicCodedEntry("112159", "DCM", "Hyper-acute")
#define CODE_DCM_Homogeneous                                               DSRBasicCodedEntry("112160", "DCM", "Homogeneous")
#define CODE_DCM_Inhomogeneous                                             DSRBasicCodedEntry("112161", "DCM", "Inhomogeneous")
#define CODE_DCM_Target                                                    DSRBasicCodedEntry("112162", "DCM", "Target")
#define CODE_DCM_Fibrocalcific                                             DSRBasicCodedEntry("112163", "DCM", "Fibrocalcific")
#define CODE_DCM_Flocculent                                                DSRBasicCodedEntry("112164", "DCM", "Flocculent")
#define CODE_DCM_RETIRED_DifferenceInBorderShape                           DSRBasicCodedEntry("112165", "DCM", "Difference in border shape")
#define CODE_DCM_RETIRED_DifferenceInBorderDefinition                      DSRBasicCodedEntry("112166", "DCM", "Difference in border definition")
#define CODE_DCM_RETIRED_DifferenceInDistribution                          DSRBasicCodedEntry("112167", "DCM", "Difference in distribution")
#define CODE_DCM_RETIRED_DifferenceInSiteInvolvement                       DSRBasicCodedEntry("112168", "DCM", "Difference in site involvement")
#define CODE_DCM_RETIRED_DifferenceInTypeOfContent                         DSRBasicCodedEntry("112169", "DCM", "Difference in Type of Content")
#define CODE_DCM_RETIRED_DifferenceInTexture                               DSRBasicCodedEntry("112170", "DCM", "Difference in Texture")
#define CODE_DCM_FiducialMark                                              DSRBasicCodedEntry("112171", "DCM", "Fiducial mark")
#define CODE_DCM_Portacath                                                 DSRBasicCodedEntry("112172", "DCM", "Portacath")
#define CODE_DCM_ChestTube                                                 DSRBasicCodedEntry("112173", "DCM", "Chest tube")
#define CODE_DCM_CentralLine                                               DSRBasicCodedEntry("112174", "DCM", "Central line")
#define CODE_DCM_KidneyStent                                               DSRBasicCodedEntry("112175", "DCM", "Kidney stent")
#define CODE_DCM_PancreaticStent                                           DSRBasicCodedEntry("112176", "DCM", "Pancreatic stent")
#define CODE_DCM_NippleRing                                                DSRBasicCodedEntry("112177", "DCM", "Nipple ring")
#define CODE_DCM_Coin                                                      DSRBasicCodedEntry("112178", "DCM", "Coin")
#define CODE_DCM_MinimumAttenuationCoefficient                             DSRBasicCodedEntry("112179", "DCM", "Minimum Attenuation Coefficient")
#define CODE_DCM_MaximumAttenuationCoefficient                             DSRBasicCodedEntry("112180", "DCM", "Maximum Attenuation Coefficient")
#define CODE_DCM_MeanAttenuationCoefficient                                DSRBasicCodedEntry("112181", "DCM", "Mean Attenuation Coefficient")
#define CODE_DCM_MedianAttenuationCoefficient                              DSRBasicCodedEntry("112182", "DCM", "Median Attenuation Coefficient")
#define CODE_DCM_StandardDeviationOfAttenuationCoefficient                 DSRBasicCodedEntry("112183", "DCM", "Standard Deviation of Attenuation Coefficient")
#define CODE_DCM_PerformanceOfPediatricAndAdultThoracicCT                  DSRBasicCodedEntry("112184", "DCM", "Performance of Pediatric and Adult Thoracic CT")
#define CODE_DCM_PerformanceOfCTForDetectionOfPulmonaryEmbolismInAdults    DSRBasicCodedEntry("112185", "DCM", "Performance of CT for Detection of Pulmonary Embolism in Adults")
#define CODE_DCM_PerformanceOfHighResolutionCTOfTheLungsInAdults           DSRBasicCodedEntry("112186", "DCM", "Performance of High-Resolution CT of the Lungs in Adults")
#define CODE_DCM_UnspecifiedMethodOfCalculation                            DSRBasicCodedEntry("112187", "DCM", "Unspecified method of calculation")
#define CODE_DCM_TwoDimensionalMethod                                      DSRBasicCodedEntry("112188", "DCM", "Two-dimensional method")
#define CODE_DCM_ThreeDimensionalMethod                                    DSRBasicCodedEntry("112189", "DCM", "Three-dimensional method")
#define CODE_DCM_BreastTissueDensity                                       DSRBasicCodedEntry("112191", "DCM", "Breast tissue density")
#define CODE_DCM_VolumeOfParenchymalTissue                                 DSRBasicCodedEntry("112192", "DCM", "Volume of parenchymal tissue")
#define CODE_DCM_VolumeOfBreast                                            DSRBasicCodedEntry("112193", "DCM", "Volume of breast")
#define CODE_DCM_MassOfParenchymalTissue                                   DSRBasicCodedEntry("112194", "DCM", "Mass of parenchymal tissue")
#define CODE_DCM_MassOfBreast                                              DSRBasicCodedEntry("112195", "DCM", "Mass of breast")
#define CODE_DCM_AreaOfVascularCalcification                               DSRBasicCodedEntry("112196", "DCM", "Area of Vascular Calcification")
#define CODE_DCM_VolumeOfVascularCalcification                             DSRBasicCodedEntry("112197", "DCM", "Volume of Vascular Calcification")
#define CODE_DCM_PercentageOfVascularCalcification                         DSRBasicCodedEntry("112198", "DCM", "Percentage of Vascular Calcification")
#define CODE_DCM_MassOfVascularCalcification                               DSRBasicCodedEntry("112199", "DCM", "Mass of Vascular Calcification")
#define CODE_DCM_AverageCalcificationDistanceInACalcificationCluster       DSRBasicCodedEntry("112200", "DCM", "Average calcification distance in a calcification cluster")
#define CODE_DCM_StandardDeviationDistanceOfCalcificationsInACluster       DSRBasicCodedEntry("112201", "DCM", "Standard deviation distance of calcifications in a cluster")
#define CODE_DCM_ColonCADReport                                            DSRBasicCodedEntry("112220", "DCM", "Colon CAD Report")
#define CODE_DCM_ColonOverallAssessment                                    DSRBasicCodedEntry("112222", "DCM", "Colon Overall Assessment")
#define CODE_DCM_ImageSetProperties                                        DSRBasicCodedEntry("112224", "DCM", "Image Set Properties")
#define CODE_DCM_SliceThickness                                            DSRBasicCodedEntry("112225", "DCM", "Slice Thickness")
#define CODE_DCM_SpacingBetweenSlices                                      DSRBasicCodedEntry("112226", "DCM", "Spacing between slices")
#define CODE_DCM_FrameOfReferenceUID                                       DSRBasicCodedEntry("112227", "DCM", "Frame of Reference UID")
#define CODE_DCM_RecumbentPatientPositionWithRespectToGravity              DSRBasicCodedEntry("112228", "DCM", "Recumbent Patient Position with respect to gravity")
#define CODE_DCM_IdentifyingSegment                                        DSRBasicCodedEntry("112229", "DCM", "Identifying Segment")
#define CODE_DCM_PolypStalkWidth                                           DSRBasicCodedEntry("112232", "DCM", "Polyp stalk width")
#define CODE_DCM_DistanceFromAnus                                          DSRBasicCodedEntry("112233", "DCM", "Distance from anus")
#define CODE_DCM_AnatomicNonColon                                          DSRBasicCodedEntry("112238", "DCM", "Anatomic non-colon")
#define CODE_DCM_C0_InadequateStudyAwaitingPriorComparisons                DSRBasicCodedEntry("112240", "DCM", "C0 - Inadequate Study/Awaiting Prior Comparisons")
#define CODE_DCM_C1_NormalColonOrBenignLesion                              DSRBasicCodedEntry("112241", "DCM", "C1 - Normal Colon or Benign Lesion")
#define CODE_DCM_C2_IntermediatePolypOrIndeterminateFinding                DSRBasicCodedEntry("112242", "DCM", "C2 - Intermediate Polyp or Indeterminate Finding")
#define CODE_DCM_C3_Polyp_PossiblyAdvancedAdenoma                          DSRBasicCodedEntry("112243", "DCM", "C3 - Polyp, Possibly Advanced Adenoma")
#define CODE_DCM_C4_ColonicMass_LikelyMalignant                            DSRBasicCodedEntry("112244", "DCM", "C4 - Colonic Mass, Likely Malignant")
#define CODE_DCM_ACRGuideline_PerformanceOfAdultCTColonography             DSRBasicCodedEntry("112248", "DCM", "ACR Guideline, Performance of Adult CT Colonography")
#define CODE_DCM_ACRStandard_CTMedicalPhysicsPerformanceMonitoring         DSRBasicCodedEntry("112249", "DCM", "ACR Standard, CT medical physics performance monitoring")
#define CODE_DCM_APplus45                                                  DSRBasicCodedEntry("112300", "DCM", "AP+45")
#define CODE_DCM_APminus45                                                 DSRBasicCodedEntry("112301", "DCM", "AP-45")
#define CODE_DCM_AnatomicalAxisOfFemur                                     DSRBasicCodedEntry("112302", "DCM", "Anatomical axis of femur")
#define CODE_DCM_AcetabularCenterOfRotation                                DSRBasicCodedEntry("112303", "DCM", "Acetabular Center of Rotation")
#define CODE_DCM_FemurHeadCenterOfRotation                                 DSRBasicCodedEntry("112304", "DCM", "Femur Head Center of Rotation")
#define CODE_DCM_AcetabularCupShell                                        DSRBasicCodedEntry("112305", "DCM", "Acetabular Cup Shell")
#define CODE_DCM_AcetabularCupInsert                                       DSRBasicCodedEntry("112306", "DCM", "Acetabular Cup Insert")
#define CODE_DCM_AcetabularCupMonoblock                                    DSRBasicCodedEntry("112307", "DCM", "Acetabular Cup Monoblock")
#define CODE_DCM_FemoralHeadBallComponent                                  DSRBasicCodedEntry("112308", "DCM", "Femoral Head Ball Component")
#define CODE_DCM_FemoralHeadConeTaperComponent                             DSRBasicCodedEntry("112309", "DCM", "Femoral Head Cone Taper Component")
#define CODE_DCM_FemoralStem                                               DSRBasicCodedEntry("112310", "DCM", "Femoral Stem")
#define CODE_DCM_FemoralStemDistalComponent                                DSRBasicCodedEntry("112311", "DCM", "Femoral Stem Distal Component")
#define CODE_DCM_FemoralStemProximalComponent                              DSRBasicCodedEntry("112312", "DCM", "Femoral Stem Proximal Component")
#define CODE_DCM_FemoralStemComponent                                      DSRBasicCodedEntry("112313", "DCM", "Femoral Stem Component")
#define CODE_DCM_NeckComponent                                             DSRBasicCodedEntry("112314", "DCM", "Neck Component")
#define CODE_DCM_MonoblockStem                                             DSRBasicCodedEntry("112315", "DCM", "Monoblock Stem")
#define CODE_DCM_ProstheticShaftAugment                                    DSRBasicCodedEntry("112316", "DCM", "Prosthetic Shaft Augment")
#define CODE_DCM_FemoralHeadResurfacingComponent                           DSRBasicCodedEntry("112317", "DCM", "Femoral Head Resurfacing Component")
#define CODE_DCM_Pinning                                                   DSRBasicCodedEntry("112318", "DCM", "Pinning")
#define CODE_DCM_Sewing                                                    DSRBasicCodedEntry("112319", "DCM", "Sewing")
#define CODE_DCM_Bolting                                                   DSRBasicCodedEntry("112320", "DCM", "Bolting")
#define CODE_DCM_Wedging                                                   DSRBasicCodedEntry("112321", "DCM", "Wedging")
#define CODE_DCM_DistalCentralizer                                         DSRBasicCodedEntry("112325", "DCM", "Distal Centralizer")
#define CODE_DCM_Generic2DPlanning                                         DSRBasicCodedEntry("112340", "DCM", "Generic 2D Planning")
#define CODE_DCM_Generic3DPlanning                                         DSRBasicCodedEntry("112341", "DCM", "Generic 3D Planning")
#define CODE_DCM_GenericPlanningForHipReplacement                          DSRBasicCodedEntry("112342", "DCM", "Generic Planning for Hip Replacement")
#define CODE_DCM_GenericPlanningForKneeReplacement                         DSRBasicCodedEntry("112343", "DCM", "Generic Planning for Knee Replacement")
#define CODE_DCM_MuellerMethodPlanningForHipReplacement                    DSRBasicCodedEntry("112344", "DCM", "Mueller Method Planning for Hip Replacement")
#define CODE_DCM_ImplantationPlan                                          DSRBasicCodedEntry("112345", "DCM", "Implantation Plan")
#define CODE_DCM_SelectedImplantComponent                                  DSRBasicCodedEntry("112346", "DCM", "Selected Implant Component")
#define CODE_DCM_ComponentID                                               DSRBasicCodedEntry("112347", "DCM", "Component ID")
#define CODE_DCM_ImplantTemplate                                           DSRBasicCodedEntry("112348", "DCM", "Implant Template")
#define CODE_DCM_ComponentConnection                                       DSRBasicCodedEntry("112350", "DCM", "Component Connection")
#define CODE_DCM_MatingFeatureSetID                                        DSRBasicCodedEntry("112351", "DCM", "Mating Feature Set ID")
#define CODE_DCM_MatingFeatureID                                           DSRBasicCodedEntry("112352", "DCM", "Mating Feature ID")
#define CODE_DCM_SpatialRegistration                                       DSRBasicCodedEntry("112353", "DCM", "Spatial Registration")
#define CODE_DCM_PatientImage                                              DSRBasicCodedEntry("112354", "DCM", "Patient Image")
#define CODE_DCM_Assembly                                                  DSRBasicCodedEntry("112355", "DCM", "Assembly")
#define CODE_DCM_UserSelectedFiducial                                      DSRBasicCodedEntry("112356", "DCM", "User Selected Fiducial")
#define CODE_DCM_DerivedFiducial                                           DSRBasicCodedEntry("112357", "DCM", "Derived Fiducial")
#define CODE_DCM_InformationUsedForPlanning                                DSRBasicCodedEntry("112358", "DCM", "Information used for planning")
#define CODE_DCM_SupportingInformation                                     DSRBasicCodedEntry("112359", "DCM", "Supporting Information")
#define CODE_DCM_ImplantComponentList                                      DSRBasicCodedEntry("112360", "DCM", "Implant Component List")
#define CODE_DCM_PatientDataUsedDuringPlanning                             DSRBasicCodedEntry("112361", "DCM", "Patient Data Used During Planning")
#define CODE_DCM_DegreesOfFreedomSpecification                             DSRBasicCodedEntry("112362", "DCM", "Degrees of Freedom Specification")
#define CODE_DCM_DegreeOfFreedomID                                         DSRBasicCodedEntry("112363", "DCM", "Degree of Freedom ID")
#define CODE_DCM_RelatedPatientDataNotUsedDuringPlanning                   DSRBasicCodedEntry("112364", "DCM", "Related Patient Data Not Used During Planning")
#define CODE_DCM_RelatedImplantationReports                                DSRBasicCodedEntry("112365", "DCM", "Related Implantation Reports")
#define CODE_DCM_ImplantAssemblyTemplate                                   DSRBasicCodedEntry("112366", "DCM", "Implant Assembly Template")
#define CODE_DCM_PlanningInformationForIntraoperativeUsage                 DSRBasicCodedEntry("112367", "DCM", "Planning Information for Intraoperative Usage")
#define CODE_DCM_ImplantationPatientPositioning                            DSRBasicCodedEntry("112368", "DCM", "Implantation Patient Positioning")
#define CODE_DCM_FiducialIntent                                            DSRBasicCodedEntry("112369", "DCM", "Fiducial Intent")
#define CODE_DCM_ComponentType                                             DSRBasicCodedEntry("112370", "DCM", "Component Type")
#define CODE_DCM_ManufacturerImplantTemplate                               DSRBasicCodedEntry("112371", "DCM", "Manufacturer Implant Template")
#define CODE_DCM_DerivedPlanningImages                                     DSRBasicCodedEntry("112372", "DCM", "Derived Planning Images")
#define CODE_DCM_OtherDerivedPlanningData                                  DSRBasicCodedEntry("112373", "DCM", "Other Derived Planning Data")
#define CODE_DCM_ConnectedImplantationPlanComponent                        DSRBasicCodedEntry("112374", "DCM", "Connected Implantation Plan Component")
#define CODE_DCM_PlanningMethod                                            DSRBasicCodedEntry("112375", "DCM", "Planning Method")
#define CODE_DCM_DegreeOfFreedomExactTranslationalValue                    DSRBasicCodedEntry("112376", "DCM", "Degree of Freedom Exact Translational Value")
#define CODE_DCM_DegreeOfFreedomMinimumTranslationalValue                  DSRBasicCodedEntry("112377", "DCM", "Degree of Freedom Minimum Translational Value")
#define CODE_DCM_DegreeOfFreedomMaximumTranslationalValue                  DSRBasicCodedEntry("112378", "DCM", "Degree of Freedom Maximum Translational Value")
#define CODE_DCM_DegreeOfFreedomExactRotationalTranslationValue            DSRBasicCodedEntry("112379", "DCM", "Degree of Freedom Exact Rotational Translation Value")
#define CODE_DCM_DegreeOfFreedomMinimumRotationalValue                     DSRBasicCodedEntry("112380", "DCM", "Degree of Freedom Minimum Rotational Value")
#define CODE_DCM_DegreeOfFreedomMaximumRotationalValue                     DSRBasicCodedEntry("112381", "DCM", "Degree of Freedom Maximum Rotational Value")
#define CODE_DCM_PeriOperativePhotographicImaging                          DSRBasicCodedEntry("112700", "DCM", "Peri-operative Photographic Imaging")
#define CODE_DCM_GrossSpecimenImaging                                      DSRBasicCodedEntry("112701", "DCM", "Gross Specimen Imaging")
#define CODE_DCM_SlideMicroscopy_112702                                    DSRBasicCodedEntry("112702", "DCM", "Slide Microscopy")
#define CODE_DCM_WholeSlideImaging                                         DSRBasicCodedEntry("112703", "DCM", "Whole Slide Imaging")
#define CODE_DCM_WSI20XRGB                                                 DSRBasicCodedEntry("112704", "DCM", "WSI 20X RGB")
#define CODE_DCM_WSI40XRGB                                                 DSRBasicCodedEntry("112705", "DCM", "WSI 40X RGB")
#define CODE_DCM_IlluminationMethod                                        DSRBasicCodedEntry("112706", "DCM", "Illumination Method")
#define CODE_DCM_NumberOfFocalPlanes                                       DSRBasicCodedEntry("112707", "DCM", "Number of focal planes")
#define CODE_DCM_FocalPlaneZOffset                                         DSRBasicCodedEntry("112708", "DCM", "Focal plane Z offset")
#define CODE_DCM_MagnificationSelection                                    DSRBasicCodedEntry("112709", "DCM", "Magnification selection")
#define CODE_DCM_IlluminationWavelength                                    DSRBasicCodedEntry("112710", "DCM", "Illumination wavelength")
#define CODE_DCM_IlluminationSpectralBand                                  DSRBasicCodedEntry("112711", "DCM", "Illumination spectral band")
#define CODE_DCM_OpticalFilterType                                         DSRBasicCodedEntry("112712", "DCM", "Optical filter type")
#define CODE_DCM_TissueSelectionMethod                                     DSRBasicCodedEntry("112713", "DCM", "Tissue selection method")
#define CODE_DCM_MultiplePlanes                                            DSRBasicCodedEntry("112714", "DCM", "Multiple planes")
#define CODE_DCM_5X                                                        DSRBasicCodedEntry("112715", "DCM", "5X")
#define CODE_DCM_10X                                                       DSRBasicCodedEntry("112716", "DCM", "10X")
#define CODE_DCM_20X                                                       DSRBasicCodedEntry("112717", "DCM", "20X")
#define CODE_DCM_40X                                                       DSRBasicCodedEntry("112718", "DCM", "40X")
#define CODE_DCM_NominalEmptyTileSuppression                               DSRBasicCodedEntry("112719", "DCM", "Nominal empty tile suppression")
#define CODE_DCM_HighThresholdEmptyTileSuppression                         DSRBasicCodedEntry("112720", "DCM", "High threshold empty tile suppression")
#define CODE_DCM_NoEmptyTileSuppression                                    DSRBasicCodedEntry("112721", "DCM", "No empty tile suppression")
#define CODE_DCM_OfInterest                                                DSRBasicCodedEntry("113000", "DCM", "Of Interest")
#define CODE_DCM_RejectedForQualityReasons                                 DSRBasicCodedEntry("113001", "DCM", "Rejected for Quality Reasons")
#define CODE_DCM_ForReferringProvider                                      DSRBasicCodedEntry("113002", "DCM", "For Referring Provider")
#define CODE_DCM_ForSurgery                                                DSRBasicCodedEntry("113003", "DCM", "For Surgery")
#define CODE_DCM_ForTeaching                                               DSRBasicCodedEntry("113004", "DCM", "For Teaching")
#define CODE_DCM_ForConference                                             DSRBasicCodedEntry("113005", "DCM", "For Conference")
#define CODE_DCM_ForTherapy                                                DSRBasicCodedEntry("113006", "DCM", "For Therapy")
#define CODE_DCM_ForPatient                                                DSRBasicCodedEntry("113007", "DCM", "For Patient")
#define CODE_DCM_ForPeerReview                                             DSRBasicCodedEntry("113008", "DCM", "For Peer Review")
#define CODE_DCM_ForResearch                                               DSRBasicCodedEntry("113009", "DCM", "For Research")
#define CODE_DCM_QualityIssue                                              DSRBasicCodedEntry("113010", "DCM", "Quality Issue")
#define CODE_DCM_DocumentTitleModifier                                     DSRBasicCodedEntry("113011", "DCM", "Document Title Modifier")
#define CODE_DCM_KeyObjectDescription                                      DSRBasicCodedEntry("113012", "DCM", "Key Object Description")
#define CODE_DCM_BestInSet                                                 DSRBasicCodedEntry("113013", "DCM", "Best In Set")
#define CODE_DCM_Study                                                     DSRBasicCodedEntry("113014", "DCM", "Study")
#define CODE_DCM_Series                                                    DSRBasicCodedEntry("113015", "DCM", "Series")
#define CODE_DCM_PerformedProcedureStep                                    DSRBasicCodedEntry("113016", "DCM", "Performed Procedure Step")
#define CODE_DCM_StageView                                                 DSRBasicCodedEntry("113017", "DCM", "Stage-View")
#define CODE_DCM_ForPrinting                                               DSRBasicCodedEntry("113018", "DCM", "For Printing")
#define CODE_DCM_ForReportAttachment                                       DSRBasicCodedEntry("113020", "DCM", "For Report Attachment")
#define CODE_DCM_ForLitigation                                             DSRBasicCodedEntry("113021", "DCM", "For Litigation")
#define CODE_DCM_CollectionOfPresentationStates                            DSRBasicCodedEntry("113022", "DCM", "Collection of Presentation States")
#define CODE_DCM_DoubleExposure                                            DSRBasicCodedEntry("113026", "DCM", "Double exposure")
#define CODE_DCM_Manifest                                                  DSRBasicCodedEntry("113030", "DCM", "Manifest")
#define CODE_DCM_SignedManifest                                            DSRBasicCodedEntry("113031", "DCM", "Signed Manifest")
#define CODE_DCM_CompleteStudyContent                                      DSRBasicCodedEntry("113032", "DCM", "Complete Study Content")
#define CODE_DCM_SignedCompleteStudyContent                                DSRBasicCodedEntry("113033", "DCM", "Signed Complete Study Content")
#define CODE_DCM_CompleteAcquisitionContent                                DSRBasicCodedEntry("113034", "DCM", "Complete Acquisition Content")
#define CODE_DCM_SignedCompleteAcquisitionContent                          DSRBasicCodedEntry("113035", "DCM", "Signed Complete Acquisition Content")
#define CODE_DCM_GroupOfFramesForDisplay                                   DSRBasicCodedEntry("113036", "DCM", "Group of Frames for Display")
#define CODE_DCM_RejectedForPatientSafetyReasons                           DSRBasicCodedEntry("113037", "DCM", "Rejected for Patient Safety Reasons")
#define CODE_DCM_IncorrectModalityWorklistEntry                            DSRBasicCodedEntry("113038", "DCM", "Incorrect Modality Worklist Entry")
#define CODE_DCM_DataRetentionPolicyExpired                                DSRBasicCodedEntry("113039", "DCM", "Data Retention Policy Expired")
#define CODE_DCM_LossyCompression                                          DSRBasicCodedEntry("113040", "DCM", "Lossy Compression")
#define CODE_DCM_ApparentDiffusionCoefficient                              DSRBasicCodedEntry("113041", "DCM", "Apparent Diffusion Coefficient")
#define CODE_DCM_PixelByPixelAddition                                      DSRBasicCodedEntry("113042", "DCM", "Pixel by pixel addition")
#define CODE_DCM_DiffusionWeighted                                         DSRBasicCodedEntry("113043", "DCM", "Diffusion weighted")
#define CODE_DCM_DiffusionAnisotropy                                       DSRBasicCodedEntry("113044", "DCM", "Diffusion Anisotropy")
#define CODE_DCM_DiffusionAttenuated                                       DSRBasicCodedEntry("113045", "DCM", "Diffusion Attenuated")
#define CODE_DCM_PixelByPixelDivision                                      DSRBasicCodedEntry("113046", "DCM", "Pixel by pixel division")
#define CODE_DCM_PixelByPixelMask                                          DSRBasicCodedEntry("113047", "DCM", "Pixel by pixel mask")
#define CODE_DCM_PixelByPixelMaximum                                       DSRBasicCodedEntry("113048", "DCM", "Pixel by pixel Maximum")
#define CODE_DCM_PixelByPixelMean                                          DSRBasicCodedEntry("113049", "DCM", "Pixel by pixel mean")
#define CODE_DCM_MetaboliteMapsFromSpectroscopyData                        DSRBasicCodedEntry("113050", "DCM", "Metabolite Maps from spectroscopy data")
#define CODE_DCM_PixelByPixelMinimum                                       DSRBasicCodedEntry("113051", "DCM", "Pixel by pixel Minimum")
#define CODE_DCM_MeanTransitTime                                           DSRBasicCodedEntry("113052", "DCM", "Mean Transit Time")
#define CODE_DCM_PixelByPixelMultiplication                                DSRBasicCodedEntry("113053", "DCM", "Pixel by pixel multiplication")
#define CODE_DCM_NegativeEnhancementIntegral                               DSRBasicCodedEntry("113054", "DCM", "Negative Enhancement Integral")
#define CODE_DCM_RETIRED_RegionalCerebralBloodFlow                         DSRBasicCodedEntry("113055", "DCM", "Regional Cerebral Blood Flow")
#define CODE_DCM_RETIRED_RegionalCerebralBloodVolume                       DSRBasicCodedEntry("113056", "DCM", "Regional Cerebral Blood Volume")
#define CODE_DCM_RCoefficient                                              DSRBasicCodedEntry("113057", "DCM", "R-Coefficient")
#define CODE_DCM_ProtonDensity                                             DSRBasicCodedEntry("113058", "DCM", "Proton Density")
#define CODE_DCM_SignalChange                                              DSRBasicCodedEntry("113059", "DCM", "Signal Change")
#define CODE_DCM_SignalToNoise                                             DSRBasicCodedEntry("113060", "DCM", "Signal to Noise")
#define CODE_DCM_StandardDeviation                                         DSRBasicCodedEntry("113061", "DCM", "Standard Deviation")
#define CODE_DCM_PixelByPixelSubtraction                                   DSRBasicCodedEntry("113062", "DCM", "Pixel by pixel subtraction")
#define CODE_DCM_T1                                                        DSRBasicCodedEntry("113063", "DCM", "T1")
#define CODE_DCM_T2Star                                                    DSRBasicCodedEntry("113064", "DCM", "T2*")
#define CODE_DCM_T2                                                        DSRBasicCodedEntry("113065", "DCM", "T2")
#define CODE_DCM_TimeCourseOfSignal                                        DSRBasicCodedEntry("113066", "DCM", "Time Course of Signal")
#define CODE_DCM_TemperatureEncoded                                        DSRBasicCodedEntry("113067", "DCM", "Temperature encoded")
#define CODE_DCM_StudentTTest                                              DSRBasicCodedEntry("113068", "DCM", "Student's T-Test")
#define CODE_DCM_TimeToPeak                                                DSRBasicCodedEntry("113069", "DCM", "Time To Peak")
#define CODE_DCM_VelocityEncoded                                           DSRBasicCodedEntry("113070", "DCM", "Velocity encoded")
#define CODE_DCM_ZScore                                                    DSRBasicCodedEntry("113071", "DCM", "Z-Score")
#define CODE_DCM_MultiplanarReformatting                                   DSRBasicCodedEntry("113072", "DCM", "Multiplanar reformatting")
#define CODE_DCM_CurvedMultiplanarReformatting                             DSRBasicCodedEntry("113073", "DCM", "Curved multiplanar reformatting")
#define CODE_DCM_VolumeRendering                                           DSRBasicCodedEntry("113074", "DCM", "Volume rendering")
#define CODE_DCM_SurfaceRendering                                          DSRBasicCodedEntry("113075", "DCM", "Surface rendering")
#define CODE_DCM_Segmentation_113076                                       DSRBasicCodedEntry("113076", "DCM", "Segmentation")
#define CODE_DCM_VolumeEditing                                             DSRBasicCodedEntry("113077", "DCM", "Volume editing")
#define CODE_DCM_MaximumIntensityProjection                                DSRBasicCodedEntry("113078", "DCM", "Maximum intensity projection")
#define CODE_DCM_MinimumIntensityProjection                                DSRBasicCodedEntry("113079", "DCM", "Minimum intensity projection")
#define CODE_DCM_GlutamateAndGlutamine                                     DSRBasicCodedEntry("113080", "DCM", "Glutamate and glutamine")
#define CODE_DCM_CholineCreatineRatio                                      DSRBasicCodedEntry("113081", "DCM", "Choline/Creatine Ratio")
#define CODE_DCM_NAcetylaspartateCreatineRatio                             DSRBasicCodedEntry("113082", "DCM", "N-acetylaspartate /Creatine Ratio")
#define CODE_DCM_NAcetylaspartateCholineRatio                              DSRBasicCodedEntry("113083", "DCM", "N-acetylaspartate /Choline Ratio")
#define CODE_DCM_Tmax                                                      DSRBasicCodedEntry("113084", "DCM", "Tmax")
#define CODE_DCM_SpatialResampling                                         DSRBasicCodedEntry("113085", "DCM", "Spatial resampling")
#define CODE_DCM_EdgeEnhancement                                           DSRBasicCodedEntry("113086", "DCM", "Edge enhancement")
#define CODE_DCM_Smoothing                                                 DSRBasicCodedEntry("113087", "DCM", "Smoothing")
#define CODE_DCM_GaussianBlur                                              DSRBasicCodedEntry("113088", "DCM", "Gaussian blur")
#define CODE_DCM_UnsharpMask                                               DSRBasicCodedEntry("113089", "DCM", "Unsharp mask")
#define CODE_DCM_ImageStitching                                            DSRBasicCodedEntry("113090", "DCM", "Image stitching")
#define CODE_DCM_SpatiallyRelatedFramesExtractedFromTheVolume              DSRBasicCodedEntry("113091", "DCM", "Spatially-related frames extracted from the volume")
#define CODE_DCM_TemporallyRelatedFramesExtractedFromTheSetOfVolumes       DSRBasicCodedEntry("113092", "DCM", "Temporally-related frames extracted from the set of volumes")
#define CODE_DCM_PolarToRectangularScanConversion                          DSRBasicCodedEntry("113093", "DCM", "Polar to Rectangular Scan Conversion")
#define CODE_DCM_CreatineAndCholine                                        DSRBasicCodedEntry("113094", "DCM", "Creatine and Choline")
#define CODE_DCM_LipidAndLactate                                           DSRBasicCodedEntry("113095", "DCM", "Lipid and Lactate")
#define CODE_DCM_CreatinePlusCholineCitrateRatio                           DSRBasicCodedEntry("113096", "DCM", "Creatine+Choline/ Citrate Ratio")
#define CODE_DCM_MultiEnergyProportionalWeighting                          DSRBasicCodedEntry("113097", "DCM", "Multi-energy proportional weighting")
#define CODE_DCM_MagnetizationTransferRatio                                DSRBasicCodedEntry("113098", "DCM", "Magnetization Transfer Ratio")
#define CODE_DCM_BasicApplicationConfidentialityProfile                    DSRBasicCodedEntry("113100", "DCM", "Basic Application Confidentiality Profile")
#define CODE_DCM_CleanPixelDataOption                                      DSRBasicCodedEntry("113101", "DCM", "Clean Pixel Data Option")
#define CODE_DCM_CleanRecognizableVisualFeaturesOption                     DSRBasicCodedEntry("113102", "DCM", "Clean Recognizable Visual Features Option")
#define CODE_DCM_CleanGraphicsOption                                       DSRBasicCodedEntry("113103", "DCM", "Clean Graphics Option")
#define CODE_DCM_CleanStructuredContentOption                              DSRBasicCodedEntry("113104", "DCM", "Clean Structured Content Option")
#define CODE_DCM_CleanDescriptorsOption                                    DSRBasicCodedEntry("113105", "DCM", "Clean Descriptors Option")
#define CODE_DCM_RetainLongitudinalTemporalInformationFullDatesOption      DSRBasicCodedEntry("113106", "DCM", "Retain Longitudinal Temporal Information Full Dates Option")
#define CODE_DCM_RetainLongitudinalTemporalInformationModifiedDatesOption  DSRBasicCodedEntry("113107", "DCM", "Retain Longitudinal Temporal Information Modified Dates Option")
#define CODE_DCM_RetainPatientCharacteristicsOption                        DSRBasicCodedEntry("113108", "DCM", "Retain Patient Characteristics Option")
#define CODE_DCM_RetainDeviceIdentityOption                                DSRBasicCodedEntry("113109", "DCM", "Retain Device Identity Option")
#define CODE_DCM_RetainUIDsOption                                          DSRBasicCodedEntry("113110", "DCM", "Retain UIDs Option")
#define CODE_DCM_RetainSafePrivateOption                                   DSRBasicCodedEntry("113111", "DCM", "Retain Safe Private Option")
#define CODE_DCM_RetainInstitutionIdentityOption                           DSRBasicCodedEntry("113112", "DCM", "Retain Institution Identity Option")
#define CODE_DCM_PredecessorContainingGroupOfImagingSubjects               DSRBasicCodedEntry("113130", "DCM", "Predecessor containing group of imaging subjects")
#define CODE_DCM_ExtractionOfIndividualSubjectFromGroup                    DSRBasicCodedEntry("113131", "DCM", "Extraction of individual subject from group")
#define CODE_DCM_SingleSubjectSelectedFromGroup                            DSRBasicCodedEntry("113132", "DCM", "Single subject selected from group")
#define CODE_DCM_Trace                                                     DSRBasicCodedEntry("113201", "DCM", "Trace")
#define CODE_DCM_MeanDiffusivity                                           DSRBasicCodedEntry("113202", "DCM", "Mean Diffusivity")
#define CODE_DCM_RadialDiffusivity                                         DSRBasicCodedEntry("113203", "DCM", "Radial Diffusivity")
#define CODE_DCM_AxialDiffusivity                                          DSRBasicCodedEntry("113204", "DCM", "Axial Diffusivity")
#define CODE_DCM_MeanKurtosis                                              DSRBasicCodedEntry("113205", "DCM", "Mean Kurtosis")
#define CODE_DCM_ApparentKurtosisCoefficient                               DSRBasicCodedEntry("113206", "DCM", "Apparent Kurtosis Coefficient")
#define CODE_DCM_RadialKurtosis                                            DSRBasicCodedEntry("113207", "DCM", "Radial Kurtosis")
#define CODE_DCM_AxialKurtosis                                             DSRBasicCodedEntry("113208", "DCM", "Axial Kurtosis")
#define CODE_DCM_FractionalKurtosisAnisotropy                              DSRBasicCodedEntry("113209", "DCM", "Fractional Kurtosis Anisotropy")
#define CODE_DCM_DeterministicTrackingAlgorithm                            DSRBasicCodedEntry("113211", "DCM", "Deterministic Tracking Algorithm")
#define CODE_DCM_ProbabilisticTrackingAlgorithm                            DSRBasicCodedEntry("113212", "DCM", "Probabilistic Tracking Algorithm")
#define CODE_DCM_GlobalTrackingAlgorithm                                   DSRBasicCodedEntry("113213", "DCM", "Global Tracking Algorithm")
#define CODE_DCM_FACT                                                      DSRBasicCodedEntry("113214", "DCM", "FACT")
#define CODE_DCM_Streamline                                                DSRBasicCodedEntry("113215", "DCM", "Streamline")
#define CODE_DCM_TEND                                                      DSRBasicCodedEntry("113216", "DCM", "TEND")
#define CODE_DCM_BootstrapTrackingAlgorithm                                DSRBasicCodedEntry("113217", "DCM", "Bootstrap Tracking Algorithm")
#define CODE_DCM_Euler                                                     DSRBasicCodedEntry("113218", "DCM", "Euler")
#define CODE_DCM_RungeKutta                                                DSRBasicCodedEntry("113219", "DCM", "Runge-Kutta")
#define CODE_DCM_HARDI                                                     DSRBasicCodedEntry("113221", "DCM", "HARDI")
#define CODE_DCM_DKI                                                       DSRBasicCodedEntry("113222", "DCM", "DKI")
#define CODE_DCM_DTI                                                       DSRBasicCodedEntry("113223", "DCM", "DTI")
#define CODE_DCM_DSI                                                       DSRBasicCodedEntry("113224", "DCM", "DSI")
#define CODE_DCM_LSDI                                                      DSRBasicCodedEntry("113225", "DCM", "LSDI")
#define CODE_DCM_SingleShotEPI                                             DSRBasicCodedEntry("113226", "DCM", "Single Shot EPI")
#define CODE_DCM_MultiShotEPI                                              DSRBasicCodedEntry("113227", "DCM", "Multi Shot EPI")
#define CODE_DCM_ParallelImaging                                           DSRBasicCodedEntry("113228", "DCM", "Parallel Imaging")
#define CODE_DCM_SingleTensor                                              DSRBasicCodedEntry("113231", "DCM", "Single Tensor")
#define CODE_DCM_MultiTensor                                               DSRBasicCodedEntry("113232", "DCM", "Multi Tensor")
#define CODE_DCM_ModelFree                                                 DSRBasicCodedEntry("113233", "DCM", "Model Free")
#define CODE_DCM_CHARMED                                                   DSRBasicCodedEntry("113234", "DCM", "CHARMED")
#define CODE_DCM_DOT                                                       DSRBasicCodedEntry("113236", "DCM", "DOT")
#define CODE_DCM_PAS                                                       DSRBasicCodedEntry("113237", "DCM", "PAS")
#define CODE_DCM_SphericalDeconvolution                                    DSRBasicCodedEntry("113238", "DCM", "Spherical Deconvolution")
#define CODE_DCM_SourceImageDiffusionBValue                                DSRBasicCodedEntry("113240", "DCM", "Source image diffusion b-value")
#define CODE_DCM_ModelFittingMethod                                        DSRBasicCodedEntry("113241", "DCM", "Model fitting method")
#define CODE_DCM_MonoExponentialDiffusionModel                             DSRBasicCodedEntry("113250", "DCM", "Mono-exponential diffusion model")
#define CODE_DCM_BiExponential_IVIM_diffusionModel                         DSRBasicCodedEntry("113251", "DCM", "Bi-exponential (IVIM) diffusion model")
#define CODE_DCM_KurtosisDiffusionModel                                    DSRBasicCodedEntry("113252", "DCM", "Kurtosis diffusion model")
#define CODE_DCM_GammaDistributionModel                                    DSRBasicCodedEntry("113253", "DCM", "Gamma distribution model")
#define CODE_DCM_StretchedExponentialDiffusionModel                        DSRBasicCodedEntry("113254", "DCM", "Stretched exponential diffusion model")
#define CODE_DCM_TruncatedGaussianDiffusionModel                           DSRBasicCodedEntry("113255", "DCM", "Truncated Gaussian diffusion model")
#define CODE_DCM_LogOfRatioOfTwoSamples                                    DSRBasicCodedEntry("113260", "DCM", "Log of ratio of two samples")
#define CODE_DCM_LeastSquaresFitOfMultipleSamples                          DSRBasicCodedEntry("113261", "DCM", "Least squares fit of multiple samples")
#define CODE_DCM_LevenbergMarquardt                                        DSRBasicCodedEntry("113265", "DCM", "Levenberg-Marquardt")
#define CODE_DCM_TrustRegion                                               DSRBasicCodedEntry("113266", "DCM", "Trust-Region")
#define CODE_DCM_FixedDp                                                   DSRBasicCodedEntry("113267", "DCM", "Fixed-Dp")
#define CODE_DCM_SegmentedUnconstrained                                    DSRBasicCodedEntry("113268", "DCM", "Segmented-Unconstrained")
#define CODE_DCM_SegmentedConstrained                                      DSRBasicCodedEntry("113269", "DCM", "Segmented-Constrained")
#define CODE_DCM_BayesianProbability                                       DSRBasicCodedEntry("113270", "DCM", "Bayesian-Probability")
#define CODE_DCM_DotDotDot                                                 DSRBasicCodedEntry("...", "DCM", "...")
#define CODE_DCM_VoxelwiseSelectionOfBValue                                DSRBasicCodedEntry("113285", "DCM", "Voxelwise selection of b-value")
#define CODE_DCM_VolumeRatio                                               DSRBasicCodedEntry("113288", "DCM", "Volume Ratio")
#define CODE_DCM_DiffusionCoefficient                                      DSRBasicCodedEntry("113289", "DCM", "Diffusion Coefficient")
#define CODE_DCM_MonoExponentialApparentDiffusionCoefficient               DSRBasicCodedEntry("113290", "DCM", "Mono-exponential Apparent Diffusion Coefficient")
#define CODE_DCM_SlowDiffusionCoefficient                                  DSRBasicCodedEntry("113291", "DCM", "Slow Diffusion Coefficient")
#define CODE_DCM_FastDiffusionCoefficient                                  DSRBasicCodedEntry("113292", "DCM", "Fast Diffusion Coefficient")
#define CODE_DCM_FastDiffusionCoefficientFraction                          DSRBasicCodedEntry("113293", "DCM", "Fast Diffusion Coefficient Fraction")
#define CODE_DCM_KurtosisDiffusionCoefficient                              DSRBasicCodedEntry("113294", "DCM", "Kurtosis Diffusion Coefficient")
#define CODE_DCM_GammaDistributionScaleParameter                           DSRBasicCodedEntry("113295", "DCM", "Gamma Distribution Scale Parameter")
#define CODE_DCM_GammaDistributionShapeParameter                           DSRBasicCodedEntry("113296", "DCM", "Gamma Distribution Shape Parameter")
#define CODE_DCM_GammaDistributionMode                                     DSRBasicCodedEntry("113297", "DCM", "Gamma Distribution Mode")
#define CODE_DCM_DistributedDiffusionCoefficient                           DSRBasicCodedEntry("113298", "DCM", "Distributed Diffusion Coefficient")
#define CODE_DCM_AnomalousExponentParameter                                DSRBasicCodedEntry("113299", "DCM", "Anomalous Exponent Parameter")
#define CODE_DCM_RadiopharmaceuticalRadiationDoseReport                    DSRBasicCodedEntry("113500", "DCM", "Radiopharmaceutical Radiation Dose Report")
#define CODE_DCM_RadiopharmaceuticalAdministration                         DSRBasicCodedEntry("113502", "DCM", "Radiopharmaceutical Administration")
#define CODE_DCM_RadiopharmaceuticalAdministrationEventUID                 DSRBasicCodedEntry("113503", "DCM", "Radiopharmaceutical Administration Event UID")
#define CODE_DCM_IntravenousExtravasationSymptoms                          DSRBasicCodedEntry("113505", "DCM", "Intravenous Extravasation Symptoms")
#define CODE_DCM_EstimatedExtravasationActivity                            DSRBasicCodedEntry("113506", "DCM", "Estimated Extravasation Activity")
#define CODE_DCM_AdministeredActivity                                      DSRBasicCodedEntry("113507", "DCM", "Administered activity")
#define CODE_DCM_PreAdministrationMeasuredActivity                         DSRBasicCodedEntry("113508", "DCM", "Pre-Administration Measured Activity")
#define CODE_DCM_PostAdministrationMeasuredActivity                        DSRBasicCodedEntry("113509", "DCM", "Post-Administration Measured Activity")
#define CODE_DCM_DrugProductIdentifier                                     DSRBasicCodedEntry("113510", "DCM", "Drug Product Identifier")
#define CODE_DCM_RadiopharmaceuticalDispenseUnitIdentifier                 DSRBasicCodedEntry("113511", "DCM", "Radiopharmaceutical Dispense Unit Identifier")
#define CODE_DCM_RadiopharmaceuticalLotIdentifier                          DSRBasicCodedEntry("113512", "DCM", "Radiopharmaceutical Lot Identifier")
#define CODE_DCM_ReagentVialIdentifier                                     DSRBasicCodedEntry("113513", "DCM", "Reagent Vial Identifier")
#define CODE_DCM_RadionuclideVialIdentifier                                DSRBasicCodedEntry("113514", "DCM", "Radionuclide Vial Identifier")
#define CODE_DCM_PrescriptionIdentifier                                    DSRBasicCodedEntry("113516", "DCM", "Prescription Identifier")
#define CODE_DCM_OrganDoseInformation                                      DSRBasicCodedEntry("113517", "DCM", "Organ Dose Information")
#define CODE_DCM_OrganDose                                                 DSRBasicCodedEntry("113518", "DCM", "Organ Dose")
#define CODE_DCM_MIRDPamphlet1                                             DSRBasicCodedEntry("113520", "DCM", "MIRD Pamphlet 1")
#define CODE_DCM_ICRPPublication53                                         DSRBasicCodedEntry("113521", "DCM", "ICRP Publication 53")
#define CODE_DCM_ICRPPublication80                                         DSRBasicCodedEntry("113522", "DCM", "ICRP Publication 80")
#define CODE_DCM_ICRPPublication106                                        DSRBasicCodedEntry("113523", "DCM", "ICRP Publication 106")
#define CODE_DCM_MIRDOSE                                                   DSRBasicCodedEntry("113526", "DCM", "MIRDOSE")
#define CODE_DCM_OLINDAEXM                                                 DSRBasicCodedEntry("113527", "DCM", "OLINDA-EXM")
#define CODE_DCM_PackageInsert                                             DSRBasicCodedEntry("113528", "DCM", "Package Insert")
#define CODE_DCM_InstitutionallyApprovedEstimates                          DSRBasicCodedEntry("113529", "DCM", "Institutionally Approved Estimates")
#define CODE_DCM_InvestigationalNewDrug                                    DSRBasicCodedEntry("113530", "DCM", "Investigational New Drug")
#define CODE_DCM_ActivityMeasurementDevice                                 DSRBasicCodedEntry("113540", "DCM", "Activity Measurement Device")
#define CODE_DCM_DoseCalibrator                                            DSRBasicCodedEntry("113541", "DCM", "Dose Calibrator")
#define CODE_DCM_InfusionSystem                                            DSRBasicCodedEntry("113542", "DCM", "Infusion System")
#define CODE_DCM_Generator                                                 DSRBasicCodedEntry("113543", "DCM", "Generator")
#define CODE_DCM_FastingDuration                                           DSRBasicCodedEntry("113550", "DCM", "Fasting Duration")
#define CODE_DCM_HydrationVolume                                           DSRBasicCodedEntry("113551", "DCM", "Hydration Volume")
#define CODE_DCM_RecentPhysicalActivity                                    DSRBasicCodedEntry("113552", "DCM", "Recent Physical Activity")
#define CODE_DCM_AcuteUnilateralRenalBlockage                              DSRBasicCodedEntry("113560", "DCM", "Acute unilateral renal blockage")
#define CODE_DCM_LowThyroidUptake                                          DSRBasicCodedEntry("113561", "DCM", "Low Thyroid Uptake")
#define CODE_DCM_HighThyroidUptake                                         DSRBasicCodedEntry("113562", "DCM", "High Thyroid Uptake")
#define CODE_DCM_SeverelyJaundiced                                         DSRBasicCodedEntry("113563", "DCM", "Severely Jaundiced")
#define CODE_DCM_ExtravasationVisibleInImage                               DSRBasicCodedEntry("113568", "DCM", "Extravasation visible in image")
#define CODE_DCM_CockroftGaultFormulaEstimationOfGFR                       DSRBasicCodedEntry("113570", "DCM", "Cockroft-Gault Formula estimation of GFR")
#define CODE_DCM_CKDEPIFormulaEstimationOfGFR                              DSRBasicCodedEntry("113571", "DCM", "CKD-EPI Formula estimation of GFR")
#define CODE_DCM_GlomerularFiltrationRate_MDRD                             DSRBasicCodedEntry("113572", "DCM", "Glomerular Filtration Rate (MDRD)")
#define CODE_DCM_GlomerularFiltrationRateNonBlack_MDRD                     DSRBasicCodedEntry("113573", "DCM", "Glomerular Filtration Rate non-black (MDRD)")
#define CODE_DCM_GlomerularFiltrationRateBlack_MDRD                        DSRBasicCodedEntry("113574", "DCM", "Glomerular Filtration Rate black (MDRD)")
#define CODE_DCM_GlomerularFiltrationRateFemale_MDRD                       DSRBasicCodedEntry("113575", "DCM", "Glomerular Filtration Rate female (MDRD)")
#define CODE_DCM_GlomerularFiltrationRateCystatinBasedFormula              DSRBasicCodedEntry("113576", "DCM", "Glomerular Filtration Rate Cystatin-based formula")
#define CODE_DCM_GlomerularFiltrationRateCreatinineBasedFormula_Schwartz   DSRBasicCodedEntry("113577", "DCM", "Glomerular Filtration Rate Creatinine-based formula (Schwartz)")
#define CODE_DCM_Small_LessThan32cmLateralThickness                        DSRBasicCodedEntry("113601", "DCM", "Small: < 32.0 cm lateral thickness")
#define CODE_DCM_Medium_32to38cmLateralThickness                           DSRBasicCodedEntry("113602", "DCM", "Medium: 32.0-38.0 cm lateral thickness")
#define CODE_DCM_Large_GreaterThan38cmLateralThickness                     DSRBasicCodedEntry("113603", "DCM", "Large: > 38.0 cm lateral thickness")
#define CODE_DCM_IrradiationEventLabel                                     DSRBasicCodedEntry("113605", "DCM", "Irradiation Event Label")
#define CODE_DCM_LabelType                                                 DSRBasicCodedEntry("113606", "DCM", "Label Type")
#define CODE_DCM_SeriesNumber                                              DSRBasicCodedEntry("113607", "DCM", "Series Number")
#define CODE_DCM_AcquisitionNumber                                         DSRBasicCodedEntry("113608", "DCM", "Acquisition Number")
#define CODE_DCM_InstanceNumber                                            DSRBasicCodedEntry("113609", "DCM", "Instance Number")
#define CODE_DCM_StationaryAcquisition_113611                              DSRBasicCodedEntry("113611", "DCM", "Stationary Acquisition")
#define CODE_DCM_SteppingAcquisition                                       DSRBasicCodedEntry("113612", "DCM", "Stepping Acquisition")
#define CODE_DCM_RotationalAcquisition                                     DSRBasicCodedEntry("113613", "DCM", "Rotational Acquisition")
#define CODE_DCM_PlaneA                                                    DSRBasicCodedEntry("113620", "DCM", "Plane A")
#define CODE_DCM_PlaneB                                                    DSRBasicCodedEntry("113621", "DCM", "Plane B")
#define CODE_DCM_SinglePlane                                               DSRBasicCodedEntry("113622", "DCM", "Single Plane")
#define CODE_DCM_Continuous                                                DSRBasicCodedEntry("113630", "DCM", "Continuous")
#define CODE_DCM_Pulsed                                                    DSRBasicCodedEntry("113631", "DCM", "Pulsed")
#define CODE_DCM_StripFilter                                               DSRBasicCodedEntry("113650", "DCM", "Strip filter")
#define CODE_DCM_WedgeFilter                                               DSRBasicCodedEntry("113651", "DCM", "Wedge filter")
#define CODE_DCM_ButterflyFilter                                           DSRBasicCodedEntry("113652", "DCM", "Butterfly filter")
#define CODE_DCM_FlatFilter                                                DSRBasicCodedEntry("113653", "DCM", "Flat filter")
#define CODE_DCM_OutlineOfLobulations                                      DSRBasicCodedEntry("113661", "DCM", "Outline of lobulations")
#define CODE_DCM_InnerLimitsOfFuzzyMargin                                  DSRBasicCodedEntry("113662", "DCM", "Inner limits of fuzzy margin")
#define CODE_DCM_OuterLimitsOfFuzzyMargin                                  DSRBasicCodedEntry("113663", "DCM", "Outer limits of fuzzy margin")
#define CODE_DCM_OutlineOfSpiculations                                     DSRBasicCodedEntry("113664", "DCM", "Outline of spiculations")
#define CODE_DCM_LinearSpiculation                                         DSRBasicCodedEntry("113665", "DCM", "Linear spiculation")
#define CODE_DCM_PixelatedSpiculations                                     DSRBasicCodedEntry("113666", "DCM", "Pixelated spiculations")
#define CODE_DCM_OrthogonalLocationArc                                     DSRBasicCodedEntry("113669", "DCM", "Orthogonal location arc")
#define CODE_DCM_OrthogonalLocationArcInnerMargin                          DSRBasicCodedEntry("113670", "DCM", "Orthogonal location arc inner margin")
#define CODE_DCM_OrthogonalLocationArcOuterMargin                          DSRBasicCodedEntry("113671", "DCM", "Orthogonal location arc outer margin")
#define CODE_DCM_QualityControlIntent                                      DSRBasicCodedEntry("113680", "DCM", "Quality Control Intent")
#define CODE_DCM_Phantom                                                   DSRBasicCodedEntry("113681", "DCM", "Phantom")
#define CODE_DCM_ACRAccreditationPhantom_CT                                DSRBasicCodedEntry("113682", "DCM", "ACR Accreditation Phantom - CT")
#define CODE_DCM_ACRAccreditationPhantom_MR                                DSRBasicCodedEntry("113683", "DCM", "ACR Accreditation Phantom - MR")
#define CODE_DCM_ACRAccreditationPhantom_Mammography                       DSRBasicCodedEntry("113684", "DCM", "ACR Accreditation Phantom - Mammography")
#define CODE_DCM_ACRAccreditationPhantom_StereotacticBreastBiopsy          DSRBasicCodedEntry("113685", "DCM", "ACR Accreditation Phantom - Stereotactic Breast Biopsy")
#define CODE_DCM_ACRAccreditationPhantom_ECT                               DSRBasicCodedEntry("113686", "DCM", "ACR Accreditation Phantom - ECT")
#define CODE_DCM_ACRAccreditationPhantom_PET                               DSRBasicCodedEntry("113687", "DCM", "ACR Accreditation Phantom - PET")
#define CODE_DCM_ACRAccreditationPhantom_ECTPET                            DSRBasicCodedEntry("113688", "DCM", "ACR Accreditation Phantom - ECT/PET")
#define CODE_DCM_ACRAccreditationPhantom_PETFaceplate                      DSRBasicCodedEntry("113689", "DCM", "ACR Accreditation Phantom - PET Faceplate")
#define CODE_DCM_IECHeadDosimetryPhantom                                   DSRBasicCodedEntry("113690", "DCM", "IEC Head Dosimetry Phantom")
#define CODE_DCM_IECBodyDosimetryPhantom                                   DSRBasicCodedEntry("113691", "DCM", "IEC Body Dosimetry Phantom")
#define CODE_DCM_NEMAXR212000Phantom                                       DSRBasicCodedEntry("113692", "DCM", "NEMA XR21-2000 Phantom")
#define CODE_DCM_XRayRadiationDoseReport                                   DSRBasicCodedEntry("113701", "DCM", "X-Ray Radiation Dose Report")
#define CODE_DCM_AccumulatedXRayDoseData                                   DSRBasicCodedEntry("113702", "DCM", "Accumulated X-Ray Dose Data")
#define CODE_DCM_ProjectionXRay                                            DSRBasicCodedEntry("113704", "DCM", "Projection X-Ray")
#define CODE_DCM_ScopeOfAccumulation                                       DSRBasicCodedEntry("113705", "DCM", "Scope of Accumulation")
#define CODE_DCM_IrradiationEventXRayData                                  DSRBasicCodedEntry("113706", "DCM", "Irradiation Event X-Ray Data")
#define CODE_DCM_RETIRED_NiobiumOrNiobiumCompound                          DSRBasicCodedEntry("113710", "DCM", "Niobium or Niobium compound")
#define CODE_DCM_RETIRED_EuropiumOrEuropiumCompound                        DSRBasicCodedEntry("113711", "DCM", "Europium or Europium compound")
#define CODE_DCM_CalibrationProtocol                                       DSRBasicCodedEntry("113720", "DCM", "Calibration Protocol")
#define CODE_DCM_IrradiationEventType                                      DSRBasicCodedEntry("113721", "DCM", "Irradiation Event Type")
#define CODE_DCM_DoseAreaProductTotal                                      DSRBasicCodedEntry("113722", "DCM", "Dose Area Product Total")
#define CODE_DCM_CalibrationDateTime                                       DSRBasicCodedEntry("113723", "DCM", "Calibration DateTime")
#define CODE_DCM_CalibrationResponsibleParty                               DSRBasicCodedEntry("113724", "DCM", "Calibration Responsible Party")
#define CODE_DCM_Dose_RP_Total                                             DSRBasicCodedEntry("113725", "DCM", "Dose (RP) Total")
#define CODE_DCM_FluoroDoseAreaProductTotal                                DSRBasicCodedEntry("113726", "DCM", "Fluoro Dose Area Product Total")
#define CODE_DCM_AcquisitionDoseAreaProductTotal                           DSRBasicCodedEntry("113727", "DCM", "Acquisition Dose Area Product Total")
#define CODE_DCM_FluoroDose_RP_Total                                       DSRBasicCodedEntry("113728", "DCM", "Fluoro Dose (RP) Total")
#define CODE_DCM_AcquisitionDose_RP_Total                                  DSRBasicCodedEntry("113729", "DCM", "Acquisition Dose (RP) Total")
#define CODE_DCM_TotalFluoroTime                                           DSRBasicCodedEntry("113730", "DCM", "Total Fluoro Time")
#define CODE_DCM_TotalNumberOfRadiographicFrames                           DSRBasicCodedEntry("113731", "DCM", "Total Number of Radiographic Frames")
#define CODE_DCM_FluoroMode                                                DSRBasicCodedEntry("113732", "DCM", "Fluoro Mode")
#define CODE_DCM_KVP                                                       DSRBasicCodedEntry("113733", "DCM", "KVP")
#define CODE_DCM_XRayTubeCurrent                                           DSRBasicCodedEntry("113734", "DCM", "X-Ray Tube Current")
#define CODE_DCM_RETIRED_ExposureTime                                      DSRBasicCodedEntry("113735", "DCM", "Exposure Time")
#define CODE_DCM_Exposure                                                  DSRBasicCodedEntry("113736", "DCM", "Exposure")
#define CODE_DCM_DistanceSourceToReferencePoint                            DSRBasicCodedEntry("113737", "DCM", "Distance Source to Reference Point")
#define CODE_DCM_Dose_RP                                                   DSRBasicCodedEntry("113738", "DCM", "Dose (RP)")
#define CODE_DCM_PositionerPrimaryEndAngle                                 DSRBasicCodedEntry("113739", "DCM", "Positioner Primary End Angle")
#define CODE_DCM_PositionerSecondaryEndAngle                               DSRBasicCodedEntry("113740", "DCM", "Positioner Secondary End Angle")
#define CODE_DCM_IrradiationDuration                                       DSRBasicCodedEntry("113742", "DCM", "Irradiation Duration")
#define CODE_DCM_PatientOrientation                                        DSRBasicCodedEntry("113743", "DCM", "Patient Orientation")
#define CODE_DCM_PatientOrientationModifier                                DSRBasicCodedEntry("113744", "DCM", "Patient Orientation Modifier")
#define CODE_DCM_PatientTableRelationship                                  DSRBasicCodedEntry("113745", "DCM", "Patient Table Relationship")
#define CODE_DCM_DistanceSourceToIsocenter                                 DSRBasicCodedEntry("113748", "DCM", "Distance Source to Isocenter")
#define CODE_DCM_DistanceSourceToDetector                                  DSRBasicCodedEntry("113750", "DCM", "Distance Source to Detector")
#define CODE_DCM_TableLongitudinalPosition                                 DSRBasicCodedEntry("113751", "DCM", "Table Longitudinal Position")
#define CODE_DCM_TableLateralPosition                                      DSRBasicCodedEntry("113752", "DCM", "Table Lateral Position")
#define CODE_DCM_TableHeightPosition                                       DSRBasicCodedEntry("113753", "DCM", "Table Height Position")
#define CODE_DCM_TableHeadTiltAngle                                        DSRBasicCodedEntry("113754", "DCM", "Table Head Tilt Angle")
#define CODE_DCM_TableHorizontalRotationAngle                              DSRBasicCodedEntry("113755", "DCM", "Table Horizontal Rotation Angle")
#define CODE_DCM_TableCradleTiltAngle                                      DSRBasicCodedEntry("113756", "DCM", "Table Cradle Tilt Angle")
#define CODE_DCM_XRayFilterMaterial                                        DSRBasicCodedEntry("113757", "DCM", "X-Ray Filter Material")
#define CODE_DCM_XRayFilterThicknessMinimum                                DSRBasicCodedEntry("113758", "DCM", "X-Ray Filter Thickness Minimum")
#define CODE_DCM_TableLongitudinalEndPosition                              DSRBasicCodedEntry("113759", "DCM", "Table Longitudinal End Position")
#define CODE_DCM_TableLateralEndPosition                                   DSRBasicCodedEntry("113760", "DCM", "Table Lateral End Position")
#define CODE_DCM_TableHeightEndPosition                                    DSRBasicCodedEntry("113761", "DCM", "Table Height End Position")
#define CODE_DCM_CalibrationUncertainty                                    DSRBasicCodedEntry("113763", "DCM", "Calibration Uncertainty")
#define CODE_DCM_AcquisitionPlane                                          DSRBasicCodedEntry("113764", "DCM", "Acquisition Plane")
#define CODE_DCM_FocalSpotSize                                             DSRBasicCodedEntry("113766", "DCM", "Focal Spot Size")
#define CODE_DCM_AverageXRayTubeCurrent                                    DSRBasicCodedEntry("113767", "DCM", "Average X-Ray Tube Current")
#define CODE_DCM_NumberOfPulses                                            DSRBasicCodedEntry("113768", "DCM", "Number of Pulses")
#define CODE_DCM_IrradiationEventUID                                       DSRBasicCodedEntry("113769", "DCM", "Irradiation Event UID")
#define CODE_DCM_ColumnAngulation                                          DSRBasicCodedEntry("113770", "DCM", "Column Angulation")
#define CODE_DCM_XRayFilters                                               DSRBasicCodedEntry("113771", "DCM", "X-Ray Filters")
#define CODE_DCM_XRayFilterType                                            DSRBasicCodedEntry("113772", "DCM", "X-Ray Filter Type")
#define CODE_DCM_XRayFilterThicknessMaximum                                DSRBasicCodedEntry("113773", "DCM", "X-Ray Filter Thickness Maximum")
#define CODE_DCM_ReferencePointDefinition                                  DSRBasicCodedEntry("113780", "DCM", "Reference Point Definition")
#define CODE_DCM_CollimatedFieldHeight                                     DSRBasicCodedEntry("113788", "DCM", "Collimated Field Height")
#define CODE_DCM_CollimatedFieldWidth                                      DSRBasicCodedEntry("113789", "DCM", "Collimated Field Width")
#define CODE_DCM_CollimatedFieldArea                                       DSRBasicCodedEntry("113790", "DCM", "Collimated Field Area")
#define CODE_DCM_PulseRate                                                 DSRBasicCodedEntry("113791", "DCM", "Pulse Rate")
#define CODE_DCM_DistanceSourceToTablePlane                                DSRBasicCodedEntry("113792", "DCM", "Distance Source to Table Plane")
#define CODE_DCM_PulseWidth                                                DSRBasicCodedEntry("113793", "DCM", "Pulse Width")
#define CODE_DCM_DoseMeasurementDevice                                     DSRBasicCodedEntry("113794", "DCM", "Dose Measurement Device")
#define CODE_DCM_AcquiredImage                                             DSRBasicCodedEntry("113795", "DCM", "Acquired Image")
#define CODE_DCM_DLPToEConversionViaMCComputation                          DSRBasicCodedEntry("113800", "DCM", "DLP to E conversion via MC computation")
#define CODE_DCM_CTDIfreeairToEConversionViaMCComputation                  DSRBasicCodedEntry("113801", "DCM", "CTDIfreeair to E conversion via MC computation")
#define CODE_DCM_DLPToEConversionViaMeasurement                            DSRBasicCodedEntry("113802", "DCM", "DLP to E conversion via measurement")
#define CODE_DCM_CTDIfreeairToEConversionViaMeasurement                    DSRBasicCodedEntry("113803", "DCM", "CTDIfreeair to E conversion via measurement")
#define CODE_DCM_SequencedAcquisition                                      DSRBasicCodedEntry("113804", "DCM", "Sequenced Acquisition")
#define CODE_DCM_ConstantAngleAcquisition                                  DSRBasicCodedEntry("113805", "DCM", "Constant Angle Acquisition")
#define CODE_DCM_StationaryAcquisition_113806                              DSRBasicCodedEntry("113806", "DCM", "Stationary Acquisition")
#define CODE_DCM_FreeAcquisition                                           DSRBasicCodedEntry("113807", "DCM", "Free Acquisition")
#define CODE_DCM_ICRPPub60                                                 DSRBasicCodedEntry("113808", "DCM", "ICRP Pub 60")
#define CODE_DCM_StartOfXRayIrradiation                                    DSRBasicCodedEntry("113809", "DCM", "Start of X-Ray Irradiation")
#define CODE_DCM_EndOfXRayIrradiation                                      DSRBasicCodedEntry("113810", "DCM", "End of X-Ray Irradiation")
#define CODE_DCM_CTAccumulatedDoseData                                     DSRBasicCodedEntry("113811", "DCM", "CT Accumulated Dose Data")
#define CODE_DCM_TotalNumberOfIrradiationEvents                            DSRBasicCodedEntry("113812", "DCM", "Total Number of Irradiation Events")
#define CODE_DCM_CTDoseLengthProductTotal                                  DSRBasicCodedEntry("113813", "DCM", "CT Dose Length Product Total")
#define CODE_DCM_CTEffectiveDoseTotal                                      DSRBasicCodedEntry("113814", "DCM", "CT Effective Dose Total")
#define CODE_DCM_PatientModel                                              DSRBasicCodedEntry("113815", "DCM", "Patient Model")
#define CODE_DCM_ConditionEffectiveDoseMeasured                            DSRBasicCodedEntry("113816", "DCM", "Condition Effective Dose measured")
#define CODE_DCM_EffectiveDosePhantomType                                  DSRBasicCodedEntry("113817", "DCM", "Effective Dose Phantom Type")
#define CODE_DCM_DosimeterType                                             DSRBasicCodedEntry("113818", "DCM", "Dosimeter Type")
#define CODE_DCM_CTAcquisition                                             DSRBasicCodedEntry("113819", "DCM", "CT Acquisition")
#define CODE_DCM_CTAcquisitionType                                         DSRBasicCodedEntry("113820", "DCM", "CT Acquisition Type")
#define CODE_DCM_XRayFilterAluminumEquivalent                              DSRBasicCodedEntry("113821", "DCM", "X-Ray Filter Aluminum Equivalent")
#define CODE_DCM_CTAcquisitionParameters                                   DSRBasicCodedEntry("113822", "DCM", "CT Acquisition Parameters")
#define CODE_DCM_NumberOfXRaySources                                       DSRBasicCodedEntry("113823", "DCM", "Number of X-Ray Sources")
#define CODE_DCM_ExposureTime                                              DSRBasicCodedEntry("113824", "DCM", "Exposure Time")
#define CODE_DCM_ScanningLength                                            DSRBasicCodedEntry("113825", "DCM", "Scanning Length")
#define CODE_DCM_NominalSingleCollimationWidth                             DSRBasicCodedEntry("113826", "DCM", "Nominal Single Collimation Width")
#define CODE_DCM_NominalTotalCollimationWidth                              DSRBasicCodedEntry("113827", "DCM", "Nominal Total Collimation Width")
#define CODE_DCM_PitchFactor                                               DSRBasicCodedEntry("113828", "DCM", "Pitch Factor")
#define CODE_DCM_CTDose                                                    DSRBasicCodedEntry("113829", "DCM", "CT Dose")
#define CODE_DCM_MeanCTDIvol                                               DSRBasicCodedEntry("113830", "DCM", "Mean CTDIvol")
#define CODE_DCM_CTXRaySourceParameters                                    DSRBasicCodedEntry("113831", "DCM", "CT X-Ray Source Parameters")
#define CODE_DCM_IdentificationOfTheXRaySource                             DSRBasicCodedEntry("113832", "DCM", "Identification of the X-Ray Source")
#define CODE_DCM_MaximumXRayTubeCurrent                                    DSRBasicCodedEntry("113833", "DCM", "Maximum X-Ray Tube Current")
#define CODE_DCM_ExposureTimePerRotation                                   DSRBasicCodedEntry("113834", "DCM", "Exposure Time per Rotation")
#define CODE_DCM_CTDIwPhantomType                                          DSRBasicCodedEntry("113835", "DCM", "CTDIw Phantom Type")
#define CODE_DCM_CTDIfreeairCalculationFactor                              DSRBasicCodedEntry("113836", "DCM", "CTDIfreeair Calculation Factor")
#define CODE_DCM_MeanCTDIfreeair                                           DSRBasicCodedEntry("113837", "DCM", "Mean CTDIfreeair")
#define CODE_DCM_DLP                                                       DSRBasicCodedEntry("113838", "DCM", "DLP")
#define CODE_DCM_EffectiveDose                                             DSRBasicCodedEntry("113839", "DCM", "Effective Dose")
#define CODE_DCM_EffectiveDoseConversionFactor                             DSRBasicCodedEntry("113840", "DCM", "Effective Dose Conversion Factor")
#define CODE_DCM_ICRPPub103                                                DSRBasicCodedEntry("113841", "DCM", "ICRP Pub 103")
#define CODE_DCM_XRayModulationType                                        DSRBasicCodedEntry("113842", "DCM", "X-Ray Modulation Type")
#define CODE_DCM_ExposureIndex                                             DSRBasicCodedEntry("113845", "DCM", "Exposure Index")
#define CODE_DCM_TargetExposureIndex                                       DSRBasicCodedEntry("113846", "DCM", "Target Exposure Index")
#define CODE_DCM_DeviationIndex                                            DSRBasicCodedEntry("113847", "DCM", "Deviation Index")
#define CODE_DCM_IrradiationAuthorizing                                    DSRBasicCodedEntry("113850", "DCM", "Irradiation Authorizing")
#define CODE_DCM_IrradiationAdministering                                  DSRBasicCodedEntry("113851", "DCM", "Irradiation Administering")
#define CODE_DCM_IrradiationEvent                                          DSRBasicCodedEntry("113852", "DCM", "Irradiation Event")
#define CODE_DCM_RETIRED_IrradiationEventUID                               DSRBasicCodedEntry("113853", "DCM", "Irradiation Event UID")
#define CODE_DCM_SourceOfDoseInformation                                   DSRBasicCodedEntry("113854", "DCM", "Source of Dose Information")
#define CODE_DCM_TotalAcquisitionTime                                      DSRBasicCodedEntry("113855", "DCM", "Total Acquisition Time")
#define CODE_DCM_AutomatedDataCollection                                   DSRBasicCodedEntry("113856", "DCM", "Automated Data Collection")
#define CODE_DCM_ManualEntry                                               DSRBasicCodedEntry("113857", "DCM", "Manual Entry")
#define CODE_DCM_MPPSContent                                               DSRBasicCodedEntry("113858", "DCM", "MPPS Content")
#define CODE_DCM_IrradiatingDevice                                         DSRBasicCodedEntry("113859", "DCM", "Irradiating Device")
#define CODE_DCM_15cmFromIsocenterTowardSource                             DSRBasicCodedEntry("113860", "DCM", "15cm from Isocenter toward Source")
#define CODE_DCM_30cmInFrontOfImageInputSurface                            DSRBasicCodedEntry("113861", "DCM", "30cm in Front of Image Input Surface")
#define CODE_DCM_1cmAboveTabletop                                          DSRBasicCodedEntry("113862", "DCM", "1cm above Tabletop")
#define CODE_DCM_30cmAboveTabletop                                         DSRBasicCodedEntry("113863", "DCM", "30cm above Tabletop")
#define CODE_DCM_15cmFromTableCenterline                                   DSRBasicCodedEntry("113864", "DCM", "15cm from Table Centerline")
#define CODE_DCM_EntranceExposureToA4dot2cmBreastThickness                 DSRBasicCodedEntry("113865", "DCM", "Entrance exposure to a 4.2 cm breast thickness")
#define CODE_DCM_CopiedFromImageAttributes                                 DSRBasicCodedEntry("113866", "DCM", "Copied From Image Attributes")
#define CODE_DCM_ComputedFromImageAttributes                               DSRBasicCodedEntry("113867", "DCM", "Computed From Image Attributes")
#define CODE_DCM_DerivedFromHumanReadableReports                           DSRBasicCodedEntry("113868", "DCM", "Derived From Human-Readable Reports")
#define CODE_DCM_PersonName                                                DSRBasicCodedEntry("113870", "DCM", "Person Name")
#define CODE_DCM_PersonID                                                  DSRBasicCodedEntry("113871", "DCM", "Person ID")
#define CODE_DCM_PersonIDIssuer                                            DSRBasicCodedEntry("113872", "DCM", "Person ID Issuer")
#define CODE_DCM_OrganizationName                                          DSRBasicCodedEntry("113873", "DCM", "Organization Name")
#define CODE_DCM_PersonRoleInOrganization                                  DSRBasicCodedEntry("113874", "DCM", "Person Role in Organization")
#define CODE_DCM_PersonRoleInProcedure                                     DSRBasicCodedEntry("113875", "DCM", "Person Role in Procedure")
#define CODE_DCM_DeviceRoleInProcedure                                     DSRBasicCodedEntry("113876", "DCM", "Device Role in Procedure")
#define CODE_DCM_DeviceName                                                DSRBasicCodedEntry("113877", "DCM", "Device Name")
#define CODE_DCM_DeviceManufacturer                                        DSRBasicCodedEntry("113878", "DCM", "Device Manufacturer")
#define CODE_DCM_DeviceModelName                                           DSRBasicCodedEntry("113879", "DCM", "Device Model Name")
#define CODE_DCM_DeviceSerialNumber                                        DSRBasicCodedEntry("113880", "DCM", "Device Serial Number")
#define CODE_DCM_AllPlanes                                                 DSRBasicCodedEntry("113890", "DCM", "All Planes")
#define CODE_DCM_LengthOfReconstructableVolume                             DSRBasicCodedEntry("113893", "DCM", "Length of Reconstructable Volume")
#define CODE_DCM_TopZLocationOfReconstructableVolume                       DSRBasicCodedEntry("113895", "DCM", "Top Z Location of Reconstructable Volume")
#define CODE_DCM_BottomZLocationOfReconstructableVolume                    DSRBasicCodedEntry("113896", "DCM", "Bottom Z Location of Reconstructable Volume")
#define CODE_DCM_TopZLocationOfScanningLength                              DSRBasicCodedEntry("113897", "DCM", "Top Z Location of Scanning Length")
#define CODE_DCM_BottomZLocationOfScanningLength                           DSRBasicCodedEntry("113898", "DCM", "Bottom Z Location of Scanning Length")
#define CODE_DCM_ExposedRange                                              DSRBasicCodedEntry("113899", "DCM", "Exposed Range")
#define CODE_DCM_DoseCheckAlertDetails                                     DSRBasicCodedEntry("113900", "DCM", "Dose Check Alert Details")
#define CODE_DCM_DLPAlertValueConfigured                                   DSRBasicCodedEntry("113901", "DCM", "DLP Alert Value Configured")
#define CODE_DCM_CTDIvolAlertValueConfigured                               DSRBasicCodedEntry("113902", "DCM", "CTDIvol Alert Value Configured")
#define CODE_DCM_DLPAlertValue                                             DSRBasicCodedEntry("113903", "DCM", "DLP Alert Value")
#define CODE_DCM_CTDIvolAlertValue                                         DSRBasicCodedEntry("113904", "DCM", "CTDIvol Alert Value")
#define CODE_DCM_AccumulatedDLPForwardEstimate                             DSRBasicCodedEntry("113905", "DCM", "Accumulated DLP Forward Estimate")
#define CODE_DCM_AccumulatedCTDIvolForwardEstimate                         DSRBasicCodedEntry("113906", "DCM", "Accumulated CTDIvol Forward Estimate")
#define CODE_DCM_ReasonForProceeding                                       DSRBasicCodedEntry("113907", "DCM", "Reason for Proceeding")
#define CODE_DCM_DoseCheckNotificationDetails                              DSRBasicCodedEntry("113908", "DCM", "Dose Check Notification Details")
#define CODE_DCM_DLPNotificationValueConfigured                            DSRBasicCodedEntry("113909", "DCM", "DLP Notification Value Configured")
#define CODE_DCM_CTDIvolNotificationValueConfigured                        DSRBasicCodedEntry("113910", "DCM", "CTDIvol Notification Value Configured")
#define CODE_DCM_DLPNotificationValue                                      DSRBasicCodedEntry("113911", "DCM", "DLP Notification Value")
#define CODE_DCM_CTDIvolNotificationValue                                  DSRBasicCodedEntry("113912", "DCM", "CTDIvol Notification Value")
#define CODE_DCM_DLPForwardEstimate                                        DSRBasicCodedEntry("113913", "DCM", "DLP Forward Estimate")
#define CODE_DCM_CTDIvolForwardEstimate                                    DSRBasicCodedEntry("113914", "DCM", "CTDIvol Forward Estimate")
#define CODE_DCM_AlternativeDoseAlertBehaviorActive                        DSRBasicCodedEntry("113915", "DCM", "Alternative dose alert behavior active")
#define CODE_DCM_RadiationExposure                                         DSRBasicCodedEntry("113921", "DCM", "Radiation Exposure")
#define CODE_DCM_RETIRED_RadioactiveSubstanceAdministered                  DSRBasicCodedEntry("113922", "DCM", "Radioactive Substance Administered")
#define CODE_DCM_RETIRED_RadiationExposureAndProtectionInformation         DSRBasicCodedEntry("113923", "DCM", "Radiation Exposure and Protection Information")
#define CODE_DCM_SizeSpecificDoseEstimate                                  DSRBasicCodedEntry("113930", "DCM", "Size Specific Dose Estimate")
#define CODE_DCM_MeasuredLateralDimension                                  DSRBasicCodedEntry("113931", "DCM", "Measured Lateral Dimension")
#define CODE_DCM_MeasuredAPDimension                                       DSRBasicCodedEntry("113932", "DCM", "Measured AP Dimension")
#define CODE_DCM_DerivedEffectiveDiameter                                  DSRBasicCodedEntry("113933", "DCM", "Derived Effective Diameter")
#define CODE_DCM_AAPM204LateralDimension                                   DSRBasicCodedEntry("113934", "DCM", "AAPM 204 Lateral Dimension")
#define CODE_DCM_AAPM204APDimension                                        DSRBasicCodedEntry("113935", "DCM", "AAPM 204 AP Dimension")
#define CODE_DCM_AAPM204SumOfLateralAndAPDimension                         DSRBasicCodedEntry("113936", "DCM", "AAPM 204 Sum of Lateral and AP Dimension")
#define CODE_DCM_AAPM204EffectiveDiameterEstimatedFromPatientAge           DSRBasicCodedEntry("113937", "DCM", "AAPM 204 Effective Diameter Estimated From Patient Age")
#define CODE_DCM_SystemCalculated                                          DSRBasicCodedEntry("113940", "DCM", "System Calculated")
#define CODE_DCM_InDetectorPlane                                           DSRBasicCodedEntry("113941", "DCM", "In Detector Plane")
#define CODE_DCM_XRayReadingDevice                                         DSRBasicCodedEntry("113942", "DCM", "X-Ray Reading Device")
#define CODE_DCM_XRaySourceDataAvailable                                   DSRBasicCodedEntry("113943", "DCM", "X-Ray Source Data Available")
#define CODE_DCM_XRayMechanicalDataAvailable                               DSRBasicCodedEntry("113944", "DCM", "X-Ray Mechanical Data Available")
#define CODE_DCM_XRayDetectorDataAvailable                                 DSRBasicCodedEntry("113945", "DCM", "X-Ray Detector Data Available")
#define CODE_DCM_ProjectionEponymousName                                   DSRBasicCodedEntry("113946", "DCM", "Projection Eponymous Name")
#define CODE_DCM_DetectorType                                              DSRBasicCodedEntry("113947", "DCM", "Detector Type")
#define CODE_DCM_DirectDetector                                            DSRBasicCodedEntry("113948", "DCM", "Direct Detector")
#define CODE_DCM_IndirectDetector                                          DSRBasicCodedEntry("113949", "DCM", "Indirect Detector")
#define CODE_DCM_StorageDetector                                           DSRBasicCodedEntry("113950", "DCM", "Storage Detector")
#define CODE_DCM_Film_113951                                               DSRBasicCodedEntry("113951", "DCM", "Film")
#define CODE_DCM_TableMount                                                DSRBasicCodedEntry("113952", "DCM", "Table Mount")
#define CODE_DCM_UnmountedDetector                                         DSRBasicCodedEntry("113953", "DCM", "Unmounted Detector")
#define CODE_DCM_UprightStandMount                                         DSRBasicCodedEntry("113954", "DCM", "Upright Stand Mount")
#define CODE_DCM_CArmMount                                                 DSRBasicCodedEntry("113955", "DCM", "C-Arm Mount")
#define CODE_DCM_CRDRMechanicalConfiguration                               DSRBasicCodedEntry("113956", "DCM", "CR/DR Mechanical Configuration")
#define CODE_DCM_FluoroscopyGuidedProjectionRadiographySystem              DSRBasicCodedEntry("113957", "DCM", "Fluoroscopy-Guided Projection Radiography System")
#define CODE_DCM_IntegratedProjectionRadiographySystem                     DSRBasicCodedEntry("113958", "DCM", "Integrated Projection Radiography System")
#define CODE_DCM_CassetteBasedProjectionRadiographySystem                  DSRBasicCodedEntry("113959", "DCM", "Cassette-based Projection Radiography System")
#define CODE_DCM_ReconstructionAlgorithm                                   DSRBasicCodedEntry("113961", "DCM", "Reconstruction Algorithm")
#define CODE_DCM_FilteredBackProjection                                    DSRBasicCodedEntry("113962", "DCM", "Filtered Back Projection")
#define CODE_DCM_IterativeReconstruction                                   DSRBasicCodedEntry("113963", "DCM", "Iterative Reconstruction")
#define CODE_DCM_AtSurfaceOfPatient                                        DSRBasicCodedEntry("113964", "DCM", "At Surface of Patient")
#define CODE_DCM_ProcedureStepToThisPoint                                  DSRBasicCodedEntry("113970", "DCM", "Procedure Step To This Point")
#define CODE_DCM_WaterEquivalentDiameter                                   DSRBasicCodedEntry("113980", "DCM", "Water Equivalent Diameter")
#define CODE_DCM_WaterEquivalentDiameterRepresentativeValue                DSRBasicCodedEntry("113981", "DCM", "Water Equivalent Diameter Representative Value")
#define CODE_DCM_WaterEquivalentDiameterIntegratedAcrossScanRange          DSRBasicCodedEntry("113982", "DCM", "Water Equivalent Diameter Integrated Across Scan Range")
#define CODE_DCM_WaterEquivalentDiameterFromRawData                        DSRBasicCodedEntry("113983", "DCM", "Water Equivalent Diameter From Raw Data")
#define CODE_DCM_WaterEquivalentDiameterFromLocalizer                      DSRBasicCodedEntry("113984", "DCM", "Water Equivalent Diameter From Localizer")
#define CODE_DCM_SeriesOrInstanceUsedForWaterEquivalentDiameterEstimation  DSRBasicCodedEntry("113985", "DCM", "Series or Instance used for Water Equivalent Diameter estimation")
#define CODE_DCM_ZValueOfLocationOfWaterEquivalentDiameterEstimation       DSRBasicCodedEntry("113986", "DCM", "Z value of location of Water Equivalent Diameter estimation")
#define CODE_DCM_AAPM220                                                   DSRBasicCodedEntry("113987", "DCM", "AAPM 220")
#define CODE_DCM_EstimatedFromWaterEquivalentDiameter                      DSRBasicCodedEntry("113988", "DCM", "Estimated from Water Equivalent Diameter")
#define CODE_DCM_ArithmeticAverageOfSSDEz                                  DSRBasicCodedEntry("113989", "DCM", "Arithmetic Average of SSDE(z)")
#define CODE_DCM_ArithmeticAverageOfDwz                                    DSRBasicCodedEntry("113990", "DCM", "Arithmetic Average of Dw(z)")
#define CODE_DCM_DwConversionFactorCoefficients                            DSRBasicCodedEntry("113991", "DCM", "Dw Conversion Factor Coefficients")
#define CODE_DCM_WaterEquivalentDiameterFromLimitedFOVImages               DSRBasicCodedEntry("113992", "DCM", "Water Equivalent Diameter From Limited FOV Images")
#define CODE_DCM_SizeSpecificDoseEstimateAtLongitudinalPositionZ           DSRBasicCodedEntry("113993", "DCM", "Size Specific Dose Estimate At Longitudinal Position Z")
#define CODE_DCM_LongitudinalPositionZ                                     DSRBasicCodedEntry("113994", "DCM", "Longitudinal Position Z")
#define CODE_DCM_WaterEquivalentDiameterAtLongitudinalPositionZ            DSRBasicCodedEntry("113995", "DCM", "Water Equivalent Diameter At Longitudinal Position Z")
#define CODE_DCM_NotANumber                                                DSRBasicCodedEntry("114000", "DCM", "Not a number")
#define CODE_DCM_NegativeInfinity                                          DSRBasicCodedEntry("114001", "DCM", "Negative Infinity")
#define CODE_DCM_PositiveInfinity                                          DSRBasicCodedEntry("114002", "DCM", "Positive Infinity")
#define CODE_DCM_DivideByZero                                              DSRBasicCodedEntry("114003", "DCM", "Divide by zero")
#define CODE_DCM_Underflow                                                 DSRBasicCodedEntry("114004", "DCM", "Underflow")
#define CODE_DCM_Overflow                                                  DSRBasicCodedEntry("114005", "DCM", "Overflow")
#define CODE_DCM_MeasurementFailure                                        DSRBasicCodedEntry("114006", "DCM", "Measurement failure")
#define CODE_DCM_MeasurementNotAttempted                                   DSRBasicCodedEntry("114007", "DCM", "Measurement not attempted")
#define CODE_DCM_CalculationFailure                                        DSRBasicCodedEntry("114008", "DCM", "Calculation failure")
#define CODE_DCM_ValueOutOfRange                                           DSRBasicCodedEntry("114009", "DCM", "Value out of range")
#define CODE_DCM_ValueUnknown                                              DSRBasicCodedEntry("114010", "DCM", "Value unknown")
#define CODE_DCM_ValueIndeterminate                                        DSRBasicCodedEntry("114011", "DCM", "Value indeterminate")
#define CODE_DCM_TimeOfFlight                                              DSRBasicCodedEntry("114201", "DCM", "Time of flight")
#define CODE_DCM_Interferometry                                            DSRBasicCodedEntry("114202", "DCM", "Interferometry")
#define CODE_DCM_LaserScanning                                             DSRBasicCodedEntry("114203", "DCM", "Laser scanning")
#define CODE_DCM_PatternProjection                                         DSRBasicCodedEntry("114204", "DCM", "Pattern projection")
#define CODE_DCM_ShapeFromShading                                          DSRBasicCodedEntry("114205", "DCM", "Shape from shading")
#define CODE_DCM_ShapeFromMotion                                           DSRBasicCodedEntry("114206", "DCM", "Shape from motion")
#define CODE_DCM_ConfocalImaging                                           DSRBasicCodedEntry("114207", "DCM", "Confocal imaging")
#define CODE_DCM_PointCloudAlgorithmic                                     DSRBasicCodedEntry("114208", "DCM", "Point Cloud Algorithmic")
#define CODE_DCM_TurntableScanMethod                                       DSRBasicCodedEntry("114209", "DCM", "Turntable Scan Method")
#define CODE_DCM_HighResolution                                            DSRBasicCodedEntry("114210", "DCM", "High resolution")
#define CODE_DCM_FastMode                                                  DSRBasicCodedEntry("114211", "DCM", "Fast mode")
#define CODE_DCM_IterativeClosestPoint                                     DSRBasicCodedEntry("114213", "DCM", "Iterative Closest Point")
#define CODE_DCM_Freehand                                                  DSRBasicCodedEntry("114215", "DCM", "Freehand")
#define CODE_DCM_Checkerboard                                              DSRBasicCodedEntry("114216", "DCM", "Checkerboard")
#define CODE_DCM_DeviceDescription                                         DSRBasicCodedEntry("120999", "DCM", "Device Description")
#define CODE_DCM_UniqueDeviceIdentifiers                                   DSRBasicCodedEntry("121000", "DCM", "Unique Device Identifiers")
#define CODE_DCM_QuotationMode                                             DSRBasicCodedEntry("121001", "DCM", "Quotation Mode")
#define CODE_DCM_QuotedSource                                              DSRBasicCodedEntry("121002", "DCM", "Quoted Source")
#define CODE_DCM_Document_121003                                           DSRBasicCodedEntry("121003", "DCM", "Document")
#define CODE_DCM_Verbal                                                    DSRBasicCodedEntry("121004", "DCM", "Verbal")
#define CODE_DCM_ObserverType                                              DSRBasicCodedEntry("121005", "DCM", "Observer Type")
#define CODE_DCM_Person                                                    DSRBasicCodedEntry("121006", "DCM", "Person")
#define CODE_DCM_Device                                                    DSRBasicCodedEntry("121007", "DCM", "Device")
#define CODE_DCM_PersonObserverName                                        DSRBasicCodedEntry("121008", "DCM", "Person Observer Name")
#define CODE_DCM_PersonObserverOrganizationName                            DSRBasicCodedEntry("121009", "DCM", "Person Observer's Organization Name")
#define CODE_DCM_PersonObserverRoleInTheOrganization                       DSRBasicCodedEntry("121010", "DCM", "Person Observer's Role in the Organization")
#define CODE_DCM_PersonObserverRoleInThisProcedure                         DSRBasicCodedEntry("121011", "DCM", "Person Observer's Role in this Procedure")
#define CODE_DCM_DeviceObserverUID                                         DSRBasicCodedEntry("121012", "DCM", "Device Observer UID")
#define CODE_DCM_DeviceObserverName                                        DSRBasicCodedEntry("121013", "DCM", "Device Observer Name")
#define CODE_DCM_DeviceObserverManufacturer                                DSRBasicCodedEntry("121014", "DCM", "Device Observer Manufacturer")
#define CODE_DCM_DeviceObserverModelName                                   DSRBasicCodedEntry("121015", "DCM", "Device Observer Model Name")
#define CODE_DCM_DeviceObserverSerialNumber                                DSRBasicCodedEntry("121016", "DCM", "Device Observer Serial Number")
#define CODE_DCM_DeviceObserverPhysicalLocationDuringObservation           DSRBasicCodedEntry("121017", "DCM", "Device Observer Physical Location During Observation")
#define CODE_DCM_ProcedureStudyInstanceUID                                 DSRBasicCodedEntry("121018", "DCM", "Procedure Study Instance UID")
#define CODE_DCM_ProcedureStudyComponentUID                                DSRBasicCodedEntry("121019", "DCM", "Procedure Study Component UID")
#define CODE_DCM_PlacerNumber                                              DSRBasicCodedEntry("121020", "DCM", "Placer Number")
#define CODE_DCM_FillerNumber                                              DSRBasicCodedEntry("121021", "DCM", "Filler Number")
#define CODE_DCM_AccessionNumber                                           DSRBasicCodedEntry("121022", "DCM", "Accession Number")
#define CODE_DCM_ProcedureCode                                             DSRBasicCodedEntry("121023", "DCM", "Procedure Code")
#define CODE_DCM_SubjectClass                                              DSRBasicCodedEntry("121024", "DCM", "Subject Class")
#define CODE_DCM_Patient                                                   DSRBasicCodedEntry("121025", "DCM", "Patient")
#define CODE_DCM_Fetus                                                     DSRBasicCodedEntry("121026", "DCM", "Fetus")
#define CODE_DCM_Specimen                                                  DSRBasicCodedEntry("121027", "DCM", "Specimen")
#define CODE_DCM_SubjectUID                                                DSRBasicCodedEntry("121028", "DCM", "Subject UID")
#define CODE_DCM_SubjectName                                               DSRBasicCodedEntry("121029", "DCM", "Subject Name")
#define CODE_DCM_SubjectID                                                 DSRBasicCodedEntry("121030", "DCM", "Subject ID")
#define CODE_DCM_SubjectBirthDate                                          DSRBasicCodedEntry("121031", "DCM", "Subject Birth Date")
#define CODE_DCM_SubjectSex                                                DSRBasicCodedEntry("121032", "DCM", "Subject Sex")
#define CODE_DCM_SubjectAge                                                DSRBasicCodedEntry("121033", "DCM", "Subject Age")
#define CODE_DCM_SubjectSpecies                                            DSRBasicCodedEntry("121034", "DCM", "Subject Species")
#define CODE_DCM_SubjectBreed                                              DSRBasicCodedEntry("121035", "DCM", "Subject Breed")
#define CODE_DCM_MotherOfFetus                                             DSRBasicCodedEntry("121036", "DCM", "Mother of fetus")
#define CODE_DCM_RETIRED_FetusNumber                                       DSRBasicCodedEntry("121037", "DCM", "Fetus number")
#define CODE_DCM_RETIRED_NumberOfFetuses                                   DSRBasicCodedEntry("121038", "DCM", "Number of Fetuses")
#define CODE_DCM_SpecimenUID                                               DSRBasicCodedEntry("121039", "DCM", "Specimen UID")
#define CODE_DCM_RETIRED_SpecimenAccessionNumber                           DSRBasicCodedEntry("121040", "DCM", "Specimen Accession Number")
#define CODE_DCM_SpecimenIdentifier                                        DSRBasicCodedEntry("121041", "DCM", "Specimen Identifier")
#define CODE_DCM_RETIRED_SpecimenType                                      DSRBasicCodedEntry("121042", "DCM", "Specimen Type")
#define CODE_DCM_RETIRED_SlideIdentifier                                   DSRBasicCodedEntry("121043", "DCM", "Slide Identifier")
#define CODE_DCM_RETIRED_SlideUID                                          DSRBasicCodedEntry("121044", "DCM", "Slide UID")
#define CODE_DCM_Language                                                  DSRBasicCodedEntry("121045", "DCM", "Language")
#define CODE_DCM_CountryOfLanguage                                         DSRBasicCodedEntry("121046", "DCM", "Country of Language")
#define CODE_DCM_LanguageOfValue                                           DSRBasicCodedEntry("121047", "DCM", "Language of Value")
#define CODE_DCM_LanguageOfNameAndValue                                    DSRBasicCodedEntry("121048", "DCM", "Language of Name and Value")
#define CODE_DCM_LanguageOfContentItemAndDescendants                       DSRBasicCodedEntry("121049", "DCM", "Language of Content Item and Descendants")
#define CODE_DCM_EquivalentMeaningOfConceptName                            DSRBasicCodedEntry("121050", "DCM", "Equivalent Meaning of Concept Name")
#define CODE_DCM_EquivalentMeaningOfValue                                  DSRBasicCodedEntry("121051", "DCM", "Equivalent Meaning of Value")
#define CODE_DCM_PresenceOfProperty                                        DSRBasicCodedEntry("121052", "DCM", "Presence of property")
#define CODE_DCM_RETIRED_Present                                           DSRBasicCodedEntry("121053", "DCM", "Present")
#define CODE_DCM_RETIRED_Absent                                            DSRBasicCodedEntry("121054", "DCM", "Absent")
#define CODE_DCM_Path                                                      DSRBasicCodedEntry("121055", "DCM", "Path")
#define CODE_DCM_AreaOutline                                               DSRBasicCodedEntry("121056", "DCM", "Area outline")
#define CODE_DCM_PerimeterOutline                                          DSRBasicCodedEntry("121057", "DCM", "Perimeter outline")
#define CODE_DCM_ProcedureReported                                         DSRBasicCodedEntry("121058", "DCM", "Procedure reported")
#define CODE_DCM_RETIRED_PresenceUndetermined                              DSRBasicCodedEntry("121059", "DCM", "Presence Undetermined")
#define CODE_DCM_RETIRED_History                                           DSRBasicCodedEntry("121060", "DCM", "History")
#define CODE_DCM_DeviceObserverManufacturerClassUID                        DSRBasicCodedEntry("121061", "DCM", "Device Observer Manufacturer Class UID")
#define CODE_DCM_RETIRED_Request                                           DSRBasicCodedEntry("121062", "DCM", "Request")
#define CODE_DCM_RETIRED_CurrentProcedureDescriptions                      DSRBasicCodedEntry("121064", "DCM", "Current Procedure Descriptions")
#define CODE_DCM_ProcedureDescription                                      DSRBasicCodedEntry("121065", "DCM", "Procedure Description")
#define CODE_DCM_RETIRED_PriorProcedureDescriptions                        DSRBasicCodedEntry("121066", "DCM", "Prior Procedure Descriptions")
#define CODE_DCM_RETIRED_PreviousFindings                                  DSRBasicCodedEntry("121068", "DCM", "Previous Findings")
#define CODE_DCM_PreviousFinding                                           DSRBasicCodedEntry("121069", "DCM", "Previous Finding")
#define CODE_DCM_RETIRED_Findings                                          DSRBasicCodedEntry("121070", "DCM", "Findings")
#define CODE_DCM_Finding                                                   DSRBasicCodedEntry("121071", "DCM", "Finding")
#define CODE_DCM_RETIRED_Impressions                                       DSRBasicCodedEntry("121072", "DCM", "Impressions")
#define CODE_DCM_Impression                                                DSRBasicCodedEntry("121073", "DCM", "Impression")
#define CODE_DCM_RETIRED_Recommendations                                   DSRBasicCodedEntry("121074", "DCM", "Recommendations")
#define CODE_DCM_Recommendation                                            DSRBasicCodedEntry("121075", "DCM", "Recommendation")
#define CODE_DCM_RETIRED_Conclusions                                       DSRBasicCodedEntry("121076", "DCM", "Conclusions")
#define CODE_DCM_Conclusion                                                DSRBasicCodedEntry("121077", "DCM", "Conclusion")
#define CODE_DCM_RETIRED_Addendum                                          DSRBasicCodedEntry("121078", "DCM", "Addendum")
#define CODE_DCM_Baseline                                                  DSRBasicCodedEntry("121079", "DCM", "Baseline")
#define CODE_DCM_BestIllustrationOfFinding                                 DSRBasicCodedEntry("121080", "DCM", "Best illustration of finding")
#define CODE_DCM_RETIRED_Physician                                         DSRBasicCodedEntry("121081", "DCM", "Physician")
#define CODE_DCM_RETIRED_Nurse                                             DSRBasicCodedEntry("121082", "DCM", "Nurse")
#define CODE_DCM_RETIRED_Technologist                                      DSRBasicCodedEntry("121083", "DCM", "Technologist")
#define CODE_DCM_RETIRED_Radiographer                                      DSRBasicCodedEntry("121084", "DCM", "Radiographer")
#define CODE_DCM_RETIRED_Intern                                            DSRBasicCodedEntry("121085", "DCM", "Intern")
#define CODE_DCM_RETIRED_Resident                                          DSRBasicCodedEntry("121086", "DCM", "Resident")
#define CODE_DCM_RETIRED_Registrar                                         DSRBasicCodedEntry("121087", "DCM", "Registrar")
#define CODE_DCM_Fellow                                                    DSRBasicCodedEntry("121088", "DCM", "Fellow")
#define CODE_DCM_RETIRED_AttendingConsultant                               DSRBasicCodedEntry("121089", "DCM", "Attending [Consultant]")
#define CODE_DCM_RETIRED_ScrubNurse                                        DSRBasicCodedEntry("121090", "DCM", "Scrub nurse")
#define CODE_DCM_RETIRED_Surgeon                                           DSRBasicCodedEntry("121091", "DCM", "Surgeon")
#define CODE_DCM_Sonologist                                                DSRBasicCodedEntry("121092", "DCM", "Sonologist")
#define CODE_DCM_RETIRED_Sonographer                                       DSRBasicCodedEntry("121093", "DCM", "Sonographer")
#define CODE_DCM_Performing                                                DSRBasicCodedEntry("121094", "DCM", "Performing")
#define CODE_DCM_RETIRED_Referring                                         DSRBasicCodedEntry("121095", "DCM", "Referring")
#define CODE_DCM_Requesting                                                DSRBasicCodedEntry("121096", "DCM", "Requesting")
#define CODE_DCM_Recording                                                 DSRBasicCodedEntry("121097", "DCM", "Recording")
#define CODE_DCM_Verifying                                                 DSRBasicCodedEntry("121098", "DCM", "Verifying")
#define CODE_DCM_Assisting                                                 DSRBasicCodedEntry("121099", "DCM", "Assisting")
#define CODE_DCM_RETIRED_Circulating                                       DSRBasicCodedEntry("121100", "DCM", "Circulating")
#define CODE_DCM_Standby                                                   DSRBasicCodedEntry("121101", "DCM", "Standby")
#define CODE_DCM_OtherSex                                                  DSRBasicCodedEntry("121102", "DCM", "Other sex")
#define CODE_DCM_UndeterminedSex                                           DSRBasicCodedEntry("121103", "DCM", "Undetermined sex")
#define CODE_DCM_AmbiguousSex                                              DSRBasicCodedEntry("121104", "DCM", "Ambiguous sex")
#define CODE_DCM_RETIRED_RadiationPhysicist                                DSRBasicCodedEntry("121105", "DCM", "Radiation Physicist")
#define CODE_DCM_Comment                                                   DSRBasicCodedEntry("121106", "DCM", "Comment")
#define CODE_DCM_RETIRED_IndicationsForProcedure                           DSRBasicCodedEntry("121109", "DCM", "Indications for Procedure")
#define CODE_DCM_RETIRED_PatientPresentation                               DSRBasicCodedEntry("121110", "DCM", "Patient Presentation")
#define CODE_DCM_RETIRED_Summary                                           DSRBasicCodedEntry("121111", "DCM", "Summary")
#define CODE_DCM_SourceOfMeasurement                                       DSRBasicCodedEntry("121112", "DCM", "Source of Measurement")
#define CODE_DCM_RETIRED_Complications                                     DSRBasicCodedEntry("121113", "DCM", "Complications")
#define CODE_DCM_PerformingPhysician                                       DSRBasicCodedEntry("121114", "DCM", "Performing Physician")
#define CODE_DCM_DischargeSummary                                          DSRBasicCodedEntry("121115", "DCM", "Discharge Summary")
#define CODE_DCM_ProximalFindingSite                                       DSRBasicCodedEntry("121116", "DCM", "Proximal Finding Site")
#define CODE_DCM_DistalFindingSite                                         DSRBasicCodedEntry("121117", "DCM", "Distal Finding Site")
#define CODE_DCM_PatientCharacteristics                                    DSRBasicCodedEntry("121118", "DCM", "Patient Characteristics")
#define CODE_DCM_CathLabProcedureLog                                       DSRBasicCodedEntry("121120", "DCM", "Cath Lab Procedure Log")
#define CODE_DCM_RoomIdentification                                        DSRBasicCodedEntry("121121", "DCM", "Room identification")
#define CODE_DCM_EquipmentIdentification                                   DSRBasicCodedEntry("121122", "DCM", "Equipment Identification")
#define CODE_DCM_PatientStatusOrEvent                                      DSRBasicCodedEntry("121123", "DCM", "Patient Status or Event")
#define CODE_DCM_ProcedureActionItemID                                     DSRBasicCodedEntry("121124", "DCM", "Procedure Action Item ID")
#define CODE_DCM_DateTimeOfRecordingOfLogEntry                             DSRBasicCodedEntry("121125", "DCM", "DateTime of Recording of Log Entry")
#define CODE_DCM_PerformedProcedureStepSOPInstanceUID                      DSRBasicCodedEntry("121126", "DCM", "Performed Procedure Step SOP Instance UID")
#define CODE_DCM_PerformedProcedureStepSOPClassUID                         DSRBasicCodedEntry("121127", "DCM", "Performed Procedure Step SOP Class UID")
#define CODE_DCM_ProcedureActionDuration                                   DSRBasicCodedEntry("121128", "DCM", "Procedure Action Duration")
#define CODE_DCM_StartProcedureActionItem                                  DSRBasicCodedEntry("121130", "DCM", "Start Procedure Action Item")
#define CODE_DCM_EndProcedureActionItem                                    DSRBasicCodedEntry("121131", "DCM", "End Procedure Action Item")
#define CODE_DCM_SuspendProcedureActionItem                                DSRBasicCodedEntry("121132", "DCM", "Suspend Procedure Action Item")
#define CODE_DCM_ResumeProcedureActionItem                                 DSRBasicCodedEntry("121133", "DCM", "Resume Procedure Action Item")
#define CODE_DCM_ObservationDateTimeQualifier                              DSRBasicCodedEntry("121135", "DCM", "Observation DateTime Qualifier")
#define CODE_DCM_DateTimeUnsynchronized                                    DSRBasicCodedEntry("121136", "DCM", "DateTime Unsynchronized")
#define CODE_DCM_DateTimeEstimated                                         DSRBasicCodedEntry("121137", "DCM", "DateTime Estimated")
#define CODE_DCM_ImageAcquired                                             DSRBasicCodedEntry("121138", "DCM", "Image Acquired")
#define CODE_DCM_Modality                                                  DSRBasicCodedEntry("121139", "DCM", "Modality")
#define CODE_DCM_NumberOfFrames                                            DSRBasicCodedEntry("121140", "DCM", "Number of Frames")
#define CODE_DCM_ImageType                                                 DSRBasicCodedEntry("121141", "DCM", "Image Type")
#define CODE_DCM_AcquisitionDuration                                       DSRBasicCodedEntry("121142", "DCM", "Acquisition Duration")
#define CODE_DCM_WaveformAcquired                                          DSRBasicCodedEntry("121143", "DCM", "Waveform Acquired")
#define CODE_DCM_DocumentTitle                                             DSRBasicCodedEntry("121144", "DCM", "Document Title")
#define CODE_DCM_DescriptionOfMaterial                                     DSRBasicCodedEntry("121145", "DCM", "Description of Material")
#define CODE_DCM_QuantityOfMaterial                                        DSRBasicCodedEntry("121146", "DCM", "Quantity of Material")
#define CODE_DCM_BillingCode                                               DSRBasicCodedEntry("121147", "DCM", "Billing Code")
#define CODE_DCM_UnitSerialIdentifier                                      DSRBasicCodedEntry("121148", "DCM", "Unit Serial Identifier")
#define CODE_DCM_LotIdentifier                                             DSRBasicCodedEntry("121149", "DCM", "Lot Identifier")
#define CODE_DCM_DeviceCode                                                DSRBasicCodedEntry("121150", "DCM", "Device Code")
#define CODE_DCM_LesionIdentifier                                          DSRBasicCodedEntry("121151", "DCM", "Lesion Identifier")
#define CODE_DCM_PersonAdministeringDrugContrast                           DSRBasicCodedEntry("121152", "DCM", "Person administering drug/contrast")
#define CODE_DCM_LesionRisk                                                DSRBasicCodedEntry("121153", "DCM", "Lesion Risk")
#define CODE_DCM_InterventionAttemptIdentifier                             DSRBasicCodedEntry("121154", "DCM", "Intervention attempt identifier")
#define CODE_DCM_Deployment                                                DSRBasicCodedEntry("121155", "DCM", "Deployment")
#define CODE_DCM_PercutaneousEntryAction                                   DSRBasicCodedEntry("121156", "DCM", "Percutaneous Entry Action")
#define CODE_DCM_BeginCirculatorySupport                                   DSRBasicCodedEntry("121157", "DCM", "Begin Circulatory Support")
#define CODE_DCM_EndCirculatorySupport                                     DSRBasicCodedEntry("121158", "DCM", "End Circulatory Support")
#define CODE_DCM_OxygenAdministrationRate                                  DSRBasicCodedEntry("121160", "DCM", "Oxygen Administration Rate")
#define CODE_DCM_BeginOxygenAdministration                                 DSRBasicCodedEntry("121161", "DCM", "Begin Oxygen Administration")
#define CODE_DCM_EndOxygenAdministration                                   DSRBasicCodedEntry("121162", "DCM", "End oxygen administration")
#define CODE_DCM_ByVentilator                                              DSRBasicCodedEntry("121163", "DCM", "By ventilator")
#define CODE_DCM_PatientAssessmentPerformed                                DSRBasicCodedEntry("121165", "DCM", "Patient Assessment Performed")
#define CODE_DCM_BeginPacing                                               DSRBasicCodedEntry("121166", "DCM", "Begin Pacing")
#define CODE_DCM_EndPacing                                                 DSRBasicCodedEntry("121167", "DCM", "End Pacing")
#define CODE_DCM_BeginVentilation                                          DSRBasicCodedEntry("121168", "DCM", "Begin Ventilation")
#define CODE_DCM_EndVentilation                                            DSRBasicCodedEntry("121169", "DCM", "End Ventilation")
#define CODE_DCM_TechNote                                                  DSRBasicCodedEntry("121171", "DCM", "Tech Note")
#define CODE_DCM_NursingNote                                               DSRBasicCodedEntry("121172", "DCM", "Nursing Note")
#define CODE_DCM_PhysicianNote                                             DSRBasicCodedEntry("121173", "DCM", "Physician Note")
#define CODE_DCM_ProcedureNote                                             DSRBasicCodedEntry("121174", "DCM", "Procedure Note")
#define CODE_DCM_RETIRED_KeyImages                                         DSRBasicCodedEntry("121180", "DCM", "Key Images")
#define CODE_DCM_DICOMObjectCatalog                                        DSRBasicCodedEntry("121181", "DCM", "DICOM Object Catalog")
#define CODE_DCM_ReferencedFrames                                          DSRBasicCodedEntry("121190", "DCM", "Referenced Frames")
#define CODE_DCM_ReferencedSegment                                         DSRBasicCodedEntry("121191", "DCM", "Referenced Segment")
#define CODE_DCM_DeviceSubject                                             DSRBasicCodedEntry("121192", "DCM", "Device Subject")
#define CODE_DCM_DeviceSubjectName                                         DSRBasicCodedEntry("121193", "DCM", "Device Subject Name")
#define CODE_DCM_DeviceSubjectManufacturer                                 DSRBasicCodedEntry("121194", "DCM", "Device Subject Manufacturer")
#define CODE_DCM_DeviceSubjectModelName                                    DSRBasicCodedEntry("121195", "DCM", "Device Subject Model Name")
#define CODE_DCM_DeviceSubjectSerialNumber                                 DSRBasicCodedEntry("121196", "DCM", "Device Subject Serial Number")
#define CODE_DCM_DeviceSubjectPhysicalLocationDuringObservation            DSRBasicCodedEntry("121197", "DCM", "Device Subject Physical Location during observation")
#define CODE_DCM_DeviceSubjectUID                                          DSRBasicCodedEntry("121198", "DCM", "Device Subject UID")
#define CODE_DCM_IllustrationOfROI                                         DSRBasicCodedEntry("121200", "DCM", "Illustration of ROI")
#define CODE_DCM_RETIRED_AreaOutline                                       DSRBasicCodedEntry("121201", "DCM", "Area Outline")
#define CODE_DCM_RETIRED_AreaOfDefinedRegion                               DSRBasicCodedEntry("121202", "DCM", "Area of Defined Region")
#define CODE_DCM_Distance                                                  DSRBasicCodedEntry("121206", "DCM", "Distance")
#define CODE_DCM_Height                                                    DSRBasicCodedEntry("121207", "DCM", "Height")
#define CODE_DCM_InterMarkerDistance                                       DSRBasicCodedEntry("121208", "DCM", "Inter-Marker Distance")
#define CODE_DCM_RETIRED_Path                                              DSRBasicCodedEntry("121210", "DCM", "Path")
#define CODE_DCM_PathLength                                                DSRBasicCodedEntry("121211", "DCM", "Path length")
#define CODE_DCM_RETIRED_PerimeterOutline                                  DSRBasicCodedEntry("121213", "DCM", "Perimeter Outline")
#define CODE_DCM_ReferencedSegmentationFrame                               DSRBasicCodedEntry("121214", "DCM", "Referenced Segmentation Frame")
#define CODE_DCM_VolumeEstimatedFromSingle2DRegion                         DSRBasicCodedEntry("121216", "DCM", "Volume estimated from single 2D region")
#define CODE_DCM_VolumeEstimatedFromThreeOrMoreNonCoplanar2DRegions        DSRBasicCodedEntry("121217", "DCM", "Volume estimated from three or more non-coplanar 2D regions")
#define CODE_DCM_VolumeEstimatedFromTwoNonCoplanar2DRegions                DSRBasicCodedEntry("121218", "DCM", "Volume estimated from two non-coplanar 2D regions")
#define CODE_DCM_VolumeOfBoundingThreeDimensionalRegion                    DSRBasicCodedEntry("121219", "DCM", "Volume of bounding three dimensional region")
#define CODE_DCM_VolumeOfCircumscribedSphere                               DSRBasicCodedEntry("121220", "DCM", "Volume of circumscribed sphere")
#define CODE_DCM_VolumeOfEllipsoid                                         DSRBasicCodedEntry("121221", "DCM", "Volume of ellipsoid")
#define CODE_DCM_VolumeOfSphere                                            DSRBasicCodedEntry("121222", "DCM", "Volume of sphere")
#define CODE_DCM_ArmOfAngle                                                DSRBasicCodedEntry("121223", "DCM", "Arm of angle")
#define CODE_DCM_AcetabularAngle                                           DSRBasicCodedEntry("121224", "DCM", "Acetabular angle")
#define CODE_DCM_Vector                                                    DSRBasicCodedEntry("121225", "DCM", "Vector")
#define CODE_DCM_ApproximateSpatialLocation                                DSRBasicCodedEntry("121226", "DCM", "Approximate spatial location")
#define CODE_DCM_LineSegmentLength                                         DSRBasicCodedEntry("121227", "DCM", "Line segment length")
#define CODE_DCM_PathVertex                                                DSRBasicCodedEntry("121230", "DCM", "Path Vertex")
#define CODE_DCM_VolumeSurface                                             DSRBasicCodedEntry("121231", "DCM", "Volume Surface")
#define CODE_DCM_SourceSeriesForSegmentation                               DSRBasicCodedEntry("121232", "DCM", "Source series for segmentation")
#define CODE_DCM_SourceImageForSegmentation                                DSRBasicCodedEntry("121233", "DCM", "Source image for segmentation")
#define CODE_DCM_DistanceFromNipple                                        DSRBasicCodedEntry("121242", "DCM", "Distance from nipple")
#define CODE_DCM_DistanceFromSkin                                          DSRBasicCodedEntry("121243", "DCM", "Distance from skin")
#define CODE_DCM_DistanceFromChestWall                                     DSRBasicCodedEntry("121244", "DCM", "Distance from chest wall")
#define CODE_DCM_PatientExposureToIonizingRadiation                        DSRBasicCodedEntry("121290", "DCM", "Patient exposure to ionizing radiation")
#define CODE_DCM_ResultsCommunicated                                       DSRBasicCodedEntry("121291", "DCM", "Results communicated")
#define CODE_DCM_SimultaneousDoppler                                       DSRBasicCodedEntry("121301", "DCM", "Simultaneous Doppler")
#define CODE_DCM_SimultaneousHemodynamic                                   DSRBasicCodedEntry("121302", "DCM", "Simultaneous Hemodynamic")
#define CODE_DCM_SimultaneousECG                                           DSRBasicCodedEntry("121303", "DCM", "Simultaneous ECG")
#define CODE_DCM_SimultaneousVoiceNarrative                                DSRBasicCodedEntry("121304", "DCM", "Simultaneous Voice Narrative")
#define CODE_DCM_SimultaneousRespiratoryWaveform                           DSRBasicCodedEntry("121305", "DCM", "Simultaneous Respiratory Waveform")
#define CODE_DCM_SimultaneousArterialPulseWaveform                         DSRBasicCodedEntry("121306", "DCM", "Simultaneous Arterial Pulse Waveform")
#define CODE_DCM_SimultaneousPhonocardiographicWaveform                    DSRBasicCodedEntry("121307", "DCM", "Simultaneous Phonocardiographic Waveform")
#define CODE_DCM_RTTreatmentPlanForThePositionBeingVerified                DSRBasicCodedEntry("121310", "DCM", "RT treatment plan for the position being verified")
#define CODE_DCM_Localizer                                                 DSRBasicCodedEntry("121311", "DCM", "Localizer")
#define CODE_DCM_BiopsyLocalizer                                           DSRBasicCodedEntry("121312", "DCM", "Biopsy localizer")
#define CODE_DCM_OtherPartialViews                                         DSRBasicCodedEntry("121313", "DCM", "Other partial views")
#define CODE_DCM_OtherImageOfBiplanePair                                   DSRBasicCodedEntry("121314", "DCM", "Other image of biplane pair")
#define CODE_DCM_OtherImageOfStereoscopicPair                              DSRBasicCodedEntry("121315", "DCM", "Other image of stereoscopic pair")
#define CODE_DCM_ImagesRelatedToStandaloneObject                           DSRBasicCodedEntry("121316", "DCM", "Images related to standalone object")
#define CODE_DCM_Spectroscopy                                              DSRBasicCodedEntry("121317", "DCM", "Spectroscopy")
#define CODE_DCM_SpectroscopyDataForWaterPhaseCorrection                   DSRBasicCodedEntry("121318", "DCM", "Spectroscopy Data for Water Phase Correction")
#define CODE_DCM_UncompressedPredecessor                                   DSRBasicCodedEntry("121320", "DCM", "Uncompressed predecessor")
#define CODE_DCM_MaskImageForImageProcessingOperation                      DSRBasicCodedEntry("121321", "DCM", "Mask image for image processing operation")
#define CODE_DCM_SourceImageForImageProcessingOperation                    DSRBasicCodedEntry("121322", "DCM", "Source image for image processing operation")
#define CODE_DCM_SourceSeriesForImageProcessingOperation                   DSRBasicCodedEntry("121323", "DCM", "Source series for image processing operation")
#define CODE_DCM_SourceImage                                               DSRBasicCodedEntry("121324", "DCM", "Source Image")
#define CODE_DCM_LossyCompressedImage                                      DSRBasicCodedEntry("121325", "DCM", "Lossy compressed image")
#define CODE_DCM_AlternateSOPClassInstance                                 DSRBasicCodedEntry("121326", "DCM", "Alternate SOP Class instance")
#define CODE_DCM_FullFidelityImage                                         DSRBasicCodedEntry("121327", "DCM", "Full fidelity image")
#define CODE_DCM_AlternatePhotometricInterpretationImage                   DSRBasicCodedEntry("121328", "DCM", "Alternate Photometric Interpretation image")
#define CODE_DCM_SourceImageForMontage                                     DSRBasicCodedEntry("121329", "DCM", "Source image for montage")
#define CODE_DCM_LossyCompressedPredecessor                                DSRBasicCodedEntry("121330", "DCM", "Lossy compressed predecessor")
#define CODE_DCM_EquivalentCDADocument                                     DSRBasicCodedEntry("121331", "DCM", "Equivalent CDA Document")
#define CODE_DCM_CompleteRenderingForPresentation                          DSRBasicCodedEntry("121332", "DCM", "Complete Rendering for Presentation")
#define CODE_DCM_PartialRenderingForPresentation                           DSRBasicCodedEntry("121333", "DCM", "Partial Rendering for Presentation")
#define CODE_DCM_ExtendedRenderingForPresentation                          DSRBasicCodedEntry("121334", "DCM", "Extended Rendering for Presentation")
#define CODE_DCM_SourceDocument                                            DSRBasicCodedEntry("121335", "DCM", "Source Document")
#define CODE_DCM_AnatomicImage                                             DSRBasicCodedEntry("121338", "DCM", "Anatomic image")
#define CODE_DCM_FunctionalImage                                           DSRBasicCodedEntry("121339", "DCM", "Functional image")
#define CODE_DCM_SpectralFilteredImage                                     DSRBasicCodedEntry("121340", "DCM", "Spectral filtered image")
#define CODE_DCM_DeviceLocalizer                                           DSRBasicCodedEntry("121341", "DCM", "Device localizer")
#define CODE_DCM_DoseImage                                                 DSRBasicCodedEntry("121342", "DCM", "Dose Image")
#define CODE_DCM_AcquisitionFramesCorrespondingToVolume                    DSRBasicCodedEntry("121346", "DCM", "Acquisition frames corresponding to volume")
#define CODE_DCM_VolumeCorrespondingToSpatiallyRelatedAcquisitionFrames    DSRBasicCodedEntry("121347", "DCM", "Volume corresponding to spatially-related acquisition frames")
#define CODE_DCM_TemporalPredecessor                                       DSRBasicCodedEntry("121348", "DCM", "Temporal Predecessor")
#define CODE_DCM_TemporalSuccessor                                         DSRBasicCodedEntry("121349", "DCM", "Temporal Successor")
#define CODE_DCM_SameAcquisitionAtLowerResolution                          DSRBasicCodedEntry("121350", "DCM", "Same acquisition at lower resolution")
#define CODE_DCM_SameAcquisitionAtHigherResolution                         DSRBasicCodedEntry("121351", "DCM", "Same acquisition at higher resolution")
#define CODE_DCM_SameAcquisitionAtDifferentFocalDepth                      DSRBasicCodedEntry("121352", "DCM", "Same acquisition at different focal depth")
#define CODE_DCM_SameAcquisitionAtDifferentSpectralBand                    DSRBasicCodedEntry("121353", "DCM", "Same acquisition at different spectral band")
#define CODE_DCM_ImagedContainerLabel                                      DSRBasicCodedEntry("121354", "DCM", "Imaged container label")
#define CODE_DCM_ForProcessingPredecessor                                  DSRBasicCodedEntry("121358", "DCM", "For Processing predecessor")
#define CODE_DCM_ReplacedReport                                            DSRBasicCodedEntry("121360", "DCM", "Replaced report")
#define CODE_DCM_AddendedReport                                            DSRBasicCodedEntry("121361", "DCM", "Addended report")
#define CODE_DCM_PreliminaryReport                                         DSRBasicCodedEntry("121362", "DCM", "Preliminary report")
#define CODE_DCM_PartialReport                                             DSRBasicCodedEntry("121363", "DCM", "Partial report")
#define CODE_DCM_ComposedFromPriorDoses                                    DSRBasicCodedEntry("121370", "DCM", "Composed from prior doses")
#define CODE_DCM_ComposedFromPriorDosesAndCurrentPlan                      DSRBasicCodedEntry("121371", "DCM", "Composed from prior doses and current plan")
#define CODE_DCM_SourceDoseForComposingCurrentDose                         DSRBasicCodedEntry("121372", "DCM", "Source dose for composing current dose")
#define CODE_DCM_RTPreTreatmentDoseCheck                                   DSRBasicCodedEntry("121373", "DCM", "RT Pre-Treatment Dose Check")
#define CODE_DCM_RTPreTreatmentConsistencyCheck                            DSRBasicCodedEntry("121374", "DCM", "RT Pre-Treatment Consistency Check")
#define CODE_DCM_AssessmentByComparison                                    DSRBasicCodedEntry("121375", "DCM", "Assessment By Comparison")
#define CODE_DCM_AssessmentByRules                                         DSRBasicCodedEntry("121376", "DCM", "Assessment By Rules")
#define CODE_DCM_ActiveIngredientUndilutedConcentration                    DSRBasicCodedEntry("121380", "DCM", "Active Ingredient Undiluted Concentration")
#define CODE_DCM_ContrastBolusIngredientOpaque                             DSRBasicCodedEntry("121381", "DCM", "Contrast/Bolus Ingredient Opaque")
#define CODE_DCM_QuantityAdministered                                      DSRBasicCodedEntry("121382", "DCM", "Quantity administered")
#define CODE_DCM_MassAdministered                                          DSRBasicCodedEntry("121383", "DCM", "Mass administered")
#define CODE_DCM_RTPlanLabel                                               DSRBasicCodedEntry("121384", "DCM", "RT Plan Label")
#define CODE_DCM_CurrentFractionNumber                                     DSRBasicCodedEntry("121385", "DCM", "Current Fraction Number")
#define CODE_DCM_NumberOfFractionsPlanned                                  DSRBasicCodedEntry("121386", "DCM", "Number of Fractions Planned")
#define CODE_DCM_NumberOfFractionsCompleted                                DSRBasicCodedEntry("121387", "DCM", "Number of Fractions Completed")
#define CODE_DCM_CheckedInStatus                                           DSRBasicCodedEntry("121388", "DCM", "Checked-In Status")
#define CODE_DCM_ReferencedBeamNumber                                      DSRBasicCodedEntry("121389", "DCM", "Referenced Beam Number")
#define CODE_DCM_Derivation                                                DSRBasicCodedEntry("121401", "DCM", "Derivation")
#define CODE_DCM_Normality                                                 DSRBasicCodedEntry("121402", "DCM", "Normality")
#define CODE_DCM_LevelOfSignificance                                       DSRBasicCodedEntry("121403", "DCM", "Level of Significance")
#define CODE_DCM_SelectionStatus                                           DSRBasicCodedEntry("121404", "DCM", "Selection Status")
#define CODE_DCM_PopulationDescription                                     DSRBasicCodedEntry("121405", "DCM", "Population description")
#define CODE_DCM_ReferenceAuthority                                        DSRBasicCodedEntry("121406", "DCM", "Reference Authority")
#define CODE_DCM_NormalRangeDescription                                    DSRBasicCodedEntry("121407", "DCM", "Normal Range description")
#define CODE_DCM_NormalRangeAuthority                                      DSRBasicCodedEntry("121408", "DCM", "Normal Range Authority")
#define CODE_DCM_UserChosenValue                                           DSRBasicCodedEntry("121410", "DCM", "User chosen value")
#define CODE_DCM_MostRecentValueChosen                                     DSRBasicCodedEntry("121411", "DCM", "Most recent value chosen")
#define CODE_DCM_MeanValueChosen                                           DSRBasicCodedEntry("121412", "DCM", "Mean value chosen")
#define CODE_DCM_StandardDeviationOfPopulation                             DSRBasicCodedEntry("121414", "DCM", "Standard deviation of population")
#define CODE_DCM_PercentileRankingOfMeasurement                            DSRBasicCodedEntry("121415", "DCM", "Percentile Ranking of measurement")
#define CODE_DCM_ZScoreOfMeasurement                                       DSRBasicCodedEntry("121416", "DCM", "Z-Score of measurement")
#define CODE_DCM_2SigmaDeviationOfPopulation                               DSRBasicCodedEntry("121417", "DCM", "2 Sigma deviation of population")
#define CODE_DCM_Equation                                                  DSRBasicCodedEntry("121420", "DCM", "Equation")
#define CODE_DCM_EquationCitation                                          DSRBasicCodedEntry("121421", "DCM", "Equation Citation")
#define CODE_DCM_TableOfValuesCitation                                     DSRBasicCodedEntry("121422", "DCM", "Table of Values Citation")
#define CODE_DCM_MethodCitation                                            DSRBasicCodedEntry("121423", "DCM", "Method Citation")
#define CODE_DCM_TableOfValues                                             DSRBasicCodedEntry("121424", "DCM", "Table of Values")
#define CODE_DCM_Index                                                     DSRBasicCodedEntry("121425", "DCM", "Index")
#define CODE_DCM_RETIRED_Estimated                                         DSRBasicCodedEntry("121427", "DCM", "Estimated")
#define CODE_DCM_RETIRED_Calculated                                        DSRBasicCodedEntry("121428", "DCM", "Calculated")
#define CODE_DCM_Concern                                                   DSRBasicCodedEntry("121430", "DCM", "Concern")
#define CODE_DCM_DateTimeConcernNoted                                      DSRBasicCodedEntry("121431", "DCM", "DateTime Concern Noted")
#define CODE_DCM_DateTimeConcernResolved                                   DSRBasicCodedEntry("121432", "DCM", "DateTime Concern Resolved")
#define CODE_DCM_DateTimeProblemResolved                                   DSRBasicCodedEntry("121433", "DCM", "DateTime Problem Resolved")
#define CODE_DCM_ServiceDeliveryLocation                                   DSRBasicCodedEntry("121434", "DCM", "Service Delivery Location")
#define CODE_DCM_ServicePerformer                                          DSRBasicCodedEntry("121435", "DCM", "Service Performer")
#define CODE_DCM_MedicalDeviceUsed                                         DSRBasicCodedEntry("121436", "DCM", "Medical Device Used")
#define CODE_DCM_RETIRED_PharmacologicAndExerciseStressTest                DSRBasicCodedEntry("121437", "DCM", "Pharmacologic and exercise stress test")
#define CODE_DCM_RETIRED_PacedStressTest                                   DSRBasicCodedEntry("121438", "DCM", "Paced stress test")
#define CODE_DCM_RETIRED_CorrectionOfCongenitalCardiovascularDeformity     DSRBasicCodedEntry("121439", "DCM", "Correction of congenital cardiovascular deformity")
#define CODE_DCM_RTPatientSetup                                            DSRBasicCodedEntry("121701", "DCM", "RT Patient Setup")
#define CODE_DCM_RTPatientPositionAcquisition_singlePlaneMV                DSRBasicCodedEntry("121702", "DCM", "RT Patient Position Acquisition, single plane MV")
#define CODE_DCM_RTPatientPositionAcquisition_dualPlaneMV                  DSRBasicCodedEntry("121703", "DCM", "RT Patient Position Acquisition, dual plane MV")
#define CODE_DCM_RTPatientPositionAcquisition_singlePlaneKV                DSRBasicCodedEntry("121704", "DCM", "RT Patient Position Acquisition, single plane kV")
#define CODE_DCM_RTPatientPositionAcquisition_dualPlaneKV                  DSRBasicCodedEntry("121705", "DCM", "RT Patient Position Acquisition, dual plane kV")
#define CODE_DCM_RTPatientPositionAcquisition_dualPlaneKVMV                DSRBasicCodedEntry("121706", "DCM", "RT Patient Position Acquisition, dual plane kV/MV")
#define CODE_DCM_RTPatientPositionAcquisition_CTKV                         DSRBasicCodedEntry("121707", "DCM", "RT Patient Position Acquisition, CT kV")
#define CODE_DCM_RTPatientPositionAcquisition_CTMV                         DSRBasicCodedEntry("121708", "DCM", "RT Patient Position Acquisition, CT MV")
#define CODE_DCM_RTPatientPositionAcquisition_Optical                      DSRBasicCodedEntry("121709", "DCM", "RT Patient Position Acquisition, Optical")
#define CODE_DCM_RTPatientPositionAcquisition_Ultrasound                   DSRBasicCodedEntry("121710", "DCM", "RT Patient Position Acquisition, Ultrasound")
#define CODE_DCM_RTPatientPositionAcquisition_SpatialFiducials             DSRBasicCodedEntry("121711", "DCM", "RT Patient Position Acquisition, Spatial Fiducials")
#define CODE_DCM_RTPatientPositionRegistration_singlePlane                 DSRBasicCodedEntry("121712", "DCM", "RT Patient Position Registration, single plane")
#define CODE_DCM_RTPatientPositionRegistration_dualPlane                   DSRBasicCodedEntry("121713", "DCM", "RT Patient Position Registration, dual plane")
#define CODE_DCM_RTPatientPositionRegistration_3DCTGeneral                 DSRBasicCodedEntry("121714", "DCM", "RT Patient Position Registration, 3D CT general")
#define CODE_DCM_RTPatientPositionRegistration_3DCTMarkerBased             DSRBasicCodedEntry("121715", "DCM", "RT Patient Position Registration, 3D CT marker-based")
#define CODE_DCM_RTPatientPositionRegistration_3DCTVolumeBased             DSRBasicCodedEntry("121716", "DCM", "RT Patient Position Registration, 3D CT volume-based")
#define CODE_DCM_RTPatientPositionRegistration_3Don2DReference             DSRBasicCodedEntry("121717", "DCM", "RT Patient Position Registration, 3D on 2D reference")
#define CODE_DCM_RTPatientPositionRegistration_2Don3DReference             DSRBasicCodedEntry("121718", "DCM", "RT Patient Position Registration, 2D on 3D reference")
#define CODE_DCM_RTPatientPositionRegistration_Optical                     DSRBasicCodedEntry("121719", "DCM", "RT Patient Position Registration, Optical")
#define CODE_DCM_RTPatientPositionRegistration_Ultrasound                  DSRBasicCodedEntry("121720", "DCM", "RT Patient Position Registration, Ultrasound")
#define CODE_DCM_RTPatientPositionRegistration_SpatialFiducials            DSRBasicCodedEntry("121721", "DCM", "RT Patient Position Registration, Spatial Fiducials")
#define CODE_DCM_RTPatientPositionAdjustment                               DSRBasicCodedEntry("121722", "DCM", "RT Patient Position Adjustment")
#define CODE_DCM_RTPatientPositionInTreatmentSessionReview                 DSRBasicCodedEntry("121723", "DCM", "RT Patient Position In-treatment-session Review")
#define CODE_DCM_RTTreatmentSimulationWithInternalVerification             DSRBasicCodedEntry("121724", "DCM", "RT Treatment Simulation with Internal Verification")
#define CODE_DCM_RTTreatmentSimulationWithExternalVerification             DSRBasicCodedEntry("121725", "DCM", "RT Treatment Simulation with External Verification")
#define CODE_DCM_RTTreatmentWithInternalVerification                       DSRBasicCodedEntry("121726", "DCM", "RT Treatment with Internal Verification")
#define CODE_DCM_RTTreatmentWithExternalVerification                       DSRBasicCodedEntry("121727", "DCM", "RT Treatment with External Verification")
#define CODE_DCM_RTTreatmentQAWithInternalVerification                     DSRBasicCodedEntry("121728", "DCM", "RT Treatment QA with Internal Verification")
#define CODE_DCM_RTTreatmentQAWithExternalVerification                     DSRBasicCodedEntry("121729", "DCM", "RT Treatment QA with External Verification")
#define CODE_DCM_RTMachineQA                                               DSRBasicCodedEntry("121730", "DCM", "RT Machine QA")
#define CODE_DCM_RTTreatmentQAByRTPlanDoseCheck                            DSRBasicCodedEntry("121731", "DCM", "RT Treatment QA by RT Plan Dose Check")
#define CODE_DCM_RTTreatmentQAByRTPlanDifferenceCheck                      DSRBasicCodedEntry("121732", "DCM", "RT Treatment QA by RT Plan Difference Check")
#define CODE_DCM_RTTreatmentQAByRTIonPlanDoseCheck                         DSRBasicCodedEntry("121733", "DCM", "RT Treatment QA by RT Ion Plan Dose Check")
#define CODE_DCM_RTTreatmentQAWithRTIonPlanDifferenceCheck                 DSRBasicCodedEntry("121734", "DCM", "RT Treatment QA with RT Ion Plan Difference Check")
#define CODE_DCM_RTBrachyTreatment                                         DSRBasicCodedEntry("121735", "DCM", "RT Brachy Treatment")
#define CODE_DCM_TreatmentDeliveryType                                     DSRBasicCodedEntry("121740", "DCM", "Treatment Delivery Type")
#define CODE_DCM_PatientCalledToProcedureRoom                              DSRBasicCodedEntry("122001", "DCM", "Patient called to procedure room")
#define CODE_DCM_PatientAdmittedToProcedureRoom                            DSRBasicCodedEntry("122002", "DCM", "Patient admitted to procedure room")
#define CODE_DCM_PatientGivenPreProcedureInstruction                       DSRBasicCodedEntry("122003", "DCM", "Patient given pre-procedure instruction")
#define CODE_DCM_PatientInformedConsentGiven                               DSRBasicCodedEntry("122004", "DCM", "Patient informed consent given")
#define CODE_DCM_PatientAdvanceDirectiveGiven                              DSRBasicCodedEntry("122005", "DCM", "Patient advance directive given")
#define CODE_DCM_NilPerOs_NPO_statusConfirmed                              DSRBasicCodedEntry("122006", "DCM", "Nil Per Os (NPO) status confirmed")
#define CODE_DCM_PatientAssistedToTable                                    DSRBasicCodedEntry("122007", "DCM", "Patient assisted to table")
#define CODE_DCM_PatientPreppedAndDraped                                   DSRBasicCodedEntry("122008", "DCM", "Patient prepped and draped")
#define CODE_DCM_PatientConnectedToContinuousMonitoring                    DSRBasicCodedEntry("122009", "DCM", "Patient connected to continuous monitoring")
#define CODE_DCM_PatientTransferredToHoldingArea                           DSRBasicCodedEntry("122010", "DCM", "Patient transferred to holding area")
#define CODE_DCM_PatientTransferredToSurgery                               DSRBasicCodedEntry("122011", "DCM", "Patient transferred to surgery")
#define CODE_DCM_PatientTransferredToCCU                                   DSRBasicCodedEntry("122012", "DCM", "Patient transferred to CCU")
#define CODE_DCM_PatientDisoriented                                        DSRBasicCodedEntry("122020", "DCM", "Patient disoriented")
#define CODE_DCM_PatientReportsNausea                                      DSRBasicCodedEntry("122021", "DCM", "Patient reports nausea")
#define CODE_DCM_PatientReportsDiscomfort                                  DSRBasicCodedEntry("122022", "DCM", "Patient reports discomfort")
#define CODE_DCM_PatientReportsChestPain                                   DSRBasicCodedEntry("122023", "DCM", "Patient reports chest pain")
#define CODE_DCM_PatientReportsNoPain                                      DSRBasicCodedEntry("122024", "DCM", "Patient reports no pain")
#define CODE_DCM_PatientAlert                                              DSRBasicCodedEntry("122025", "DCM", "Patient alert")
#define CODE_DCM_PatientRestless                                           DSRBasicCodedEntry("122026", "DCM", "Patient restless")
#define CODE_DCM_PatientSedated                                            DSRBasicCodedEntry("122027", "DCM", "Patient sedated")
#define CODE_DCM_PatientAsleep                                             DSRBasicCodedEntry("122028", "DCM", "Patient asleep")
#define CODE_DCM_PatientUnresponsive                                       DSRBasicCodedEntry("122029", "DCM", "Patient unresponsive")
#define CODE_DCM_PatientHasRespiratoryDifficulty                           DSRBasicCodedEntry("122030", "DCM", "Patient has respiratory difficulty")
#define CODE_DCM_PatientCoughed                                            DSRBasicCodedEntry("122031", "DCM", "Patient coughed")
#define CODE_DCM_PatientDisconnectedFromContinuousMonitoring               DSRBasicCodedEntry("122032", "DCM", "Patient disconnected from continuous monitoring")
#define CODE_DCM_HemostasisAchieved                                        DSRBasicCodedEntry("122033", "DCM", "Hemostasis achieved")
#define CODE_DCM_HemostasisNotAchieved_oozing                              DSRBasicCodedEntry("122034", "DCM", "Hemostasis not achieved - oozing")
#define CODE_DCM_HemostasisNotAchieved_activelyBleeding                    DSRBasicCodedEntry("122035", "DCM", "Hemostasis not achieved - actively bleeding")
#define CODE_DCM_PatientGivenPostProcedureInstruction                      DSRBasicCodedEntry("122036", "DCM", "Patient given post-procedure instruction")
#define CODE_DCM_PatientDischargedFromDepartment                           DSRBasicCodedEntry("122037", "DCM", "Patient discharged from department")
#define CODE_DCM_PatientPronouncedDead                                     DSRBasicCodedEntry("122038", "DCM", "Patient pronounced dead")
#define CODE_DCM_PatientTransferredToMorgue                                DSRBasicCodedEntry("122039", "DCM", "Patient transferred to morgue")
#define CODE_DCM_PersonnelArrived                                          DSRBasicCodedEntry("122041", "DCM", "Personnel Arrived")
#define CODE_DCM_PersonnelDeparted                                         DSRBasicCodedEntry("122042", "DCM", "Personnel Departed")
#define CODE_DCM_PageSentTo                                                DSRBasicCodedEntry("122043", "DCM", "Page Sent To")
#define CODE_DCM_ConsultationWith                                          DSRBasicCodedEntry("122044", "DCM", "Consultation With")
#define CODE_DCM_OfficeCalled                                              DSRBasicCodedEntry("122045", "DCM", "Office called")
#define CODE_DCM_RETIRED_EquipmentFailure                                  DSRBasicCodedEntry("122046", "DCM", "Equipment failure")
#define CODE_DCM_EquipmentBroughtToProcedureRoom                           DSRBasicCodedEntry("122047", "DCM", "Equipment brought to procedure room")
#define CODE_DCM_EquipmentReady                                            DSRBasicCodedEntry("122048", "DCM", "Equipment ready")
#define CODE_DCM_EquipmentRemoved                                          DSRBasicCodedEntry("122049", "DCM", "Equipment removed")
#define CODE_DCM_Bioptome                                                  DSRBasicCodedEntry("122052", "DCM", "Bioptome")
#define CODE_DCM_ValvularIntervention                                      DSRBasicCodedEntry("122053", "DCM", "Valvular Intervention")
#define CODE_DCM_AorticIntervention                                        DSRBasicCodedEntry("122054", "DCM", "Aortic Intervention")
#define CODE_DCM_SeptalDefectIntervention                                  DSRBasicCodedEntry("122055", "DCM", "Septal Defect Intervention")
#define CODE_DCM_VascularIntervention                                      DSRBasicCodedEntry("122056", "DCM", "Vascular Intervention")
#define CODE_DCM_MyocardialBiopsy                                          DSRBasicCodedEntry("122057", "DCM", "Myocardial biopsy")
#define CODE_DCM_ArterialConduitAngiography                                DSRBasicCodedEntry("122058", "DCM", "Arterial conduit angiography")
#define CODE_DCM_SinglePlaneAngiography                                    DSRBasicCodedEntry("122059", "DCM", "Single plane Angiography")
#define CODE_DCM_BiPlaneAngiography                                        DSRBasicCodedEntry("122060", "DCM", "Bi-plane Angiography")
#define CODE_DCM_PercutaneousCoronaryIntervention                          DSRBasicCodedEntry("122061", "DCM", "Percutaneous Coronary Intervention")
#define CODE_DCM_RETIRED_15LeadECG                                         DSRBasicCodedEntry("122062", "DCM", "15-Lead ECG")
#define CODE_DCM_PreProcedureLog                                           DSRBasicCodedEntry("122072", "DCM", "Pre-procedure log")
#define CODE_DCM_CurrentProcedureEvidence                                  DSRBasicCodedEntry("122073", "DCM", "Current procedure evidence")
#define CODE_DCM_PriorReportForCurrentPatient                              DSRBasicCodedEntry("122075", "DCM", "Prior report for current patient")
#define CODE_DCM_ConsumableTakenFromInventory                              DSRBasicCodedEntry("122076", "DCM", "Consumable taken from inventory")
#define CODE_DCM_ConsumableReturnedToInventory                             DSRBasicCodedEntry("122077", "DCM", "Consumable returned to inventory")
#define CODE_DCM_RemainingConsumableDisposed                               DSRBasicCodedEntry("122078", "DCM", "Remaining consumable disposed")
#define CODE_DCM_ConsumableUnusable                                        DSRBasicCodedEntry("122079", "DCM", "Consumable unusable")
#define CODE_DCM_DrugStart                                                 DSRBasicCodedEntry("122081", "DCM", "Drug start")
#define CODE_DCM_DrugEnd                                                   DSRBasicCodedEntry("122082", "DCM", "Drug end")
#define CODE_DCM_DrugAdministered                                          DSRBasicCodedEntry("122083", "DCM", "Drug administered")
#define CODE_DCM_ContrastStart                                             DSRBasicCodedEntry("122084", "DCM", "Contrast start")
#define CODE_DCM_ContrastEnd                                               DSRBasicCodedEntry("122085", "DCM", "Contrast end")
#define CODE_DCM_ContrastAdministered                                      DSRBasicCodedEntry("122086", "DCM", "Contrast administered")
#define CODE_DCM_InfusateStart                                             DSRBasicCodedEntry("122087", "DCM", "Infusate start")
#define CODE_DCM_InfusateEnd                                               DSRBasicCodedEntry("122088", "DCM", "Infusate end")
#define CODE_DCM_DeviceCrossedLesion                                       DSRBasicCodedEntry("122089", "DCM", "Device crossed lesion")
#define CODE_DCM_InterventionAction                                        DSRBasicCodedEntry("122090", "DCM", "Intervention Action")
#define CODE_DCM_VolumeAdministered                                        DSRBasicCodedEntry("122091", "DCM", "Volume administered")
#define CODE_DCM_UndilutedDoseAdministered                                 DSRBasicCodedEntry("122092", "DCM", "Undiluted dose administered")
#define CODE_DCM_Concentration                                             DSRBasicCodedEntry("122093", "DCM", "Concentration")
#define CODE_DCM_RateOfAdministration                                      DSRBasicCodedEntry("122094", "DCM", "Rate of administration")
#define CODE_DCM_DurationOfAdministration                                  DSRBasicCodedEntry("122095", "DCM", "Duration of administration")
#define CODE_DCM_VolumeUnadministeredOrDiscarded                           DSRBasicCodedEntry("122096", "DCM", "Volume unadministered or discarded")
#define CODE_DCM_CatheterCurve                                             DSRBasicCodedEntry("122097", "DCM", "Catheter Curve")
#define CODE_DCM_TransmitFrequency                                         DSRBasicCodedEntry("122098", "DCM", "Transmit Frequency")
#define CODE_DCM_STChangeFromBaseline                                      DSRBasicCodedEntry("122099", "DCM", "ST change from baseline")
#define CODE_DCM_AneurysmonCitedVessel                                     DSRBasicCodedEntry("122101", "DCM", "Aneurysm on cited vessel")
#define CODE_DCM_GraftToCitedSegment_proximalSection                       DSRBasicCodedEntry("122102", "DCM", "Graft to cited segment, proximal section")
#define CODE_DCM_GraftToCitedSegment_midSection                            DSRBasicCodedEntry("122103", "DCM", "Graft to cited segment, mid section")
#define CODE_DCM_GraftToCitedSegment_distalSection                         DSRBasicCodedEntry("122104", "DCM", "Graft to cited segment, distal section")
#define CODE_DCM_DateTimeOfIntervention                                    DSRBasicCodedEntry("122105", "DCM", "DateTime of Intervention")
#define CODE_DCM_DurationOfIntervention                                    DSRBasicCodedEntry("122106", "DCM", "Duration of Intervention")
#define CODE_DCM_RETIRED_BaselineStenosisMeasurement                       DSRBasicCodedEntry("122107", "DCM", "Baseline Stenosis Measurement")
#define CODE_DCM_RETIRED_PostInterventionStenosisMeasurement               DSRBasicCodedEntry("122108", "DCM", "Post-Intervention Stenosis Measurement")
#define CODE_DCM_BaselineTIMIFlow                                          DSRBasicCodedEntry("122109", "DCM", "Baseline TIMI Flow")
#define CODE_DCM_PostInterventionTIMIFlow                                  DSRBasicCodedEntry("122110", "DCM", "Post-Intervention TIMI Flow")
#define CODE_DCM_PrimaryInterventionDevice                                 DSRBasicCodedEntry("122111", "DCM", "Primary Intervention Device")
#define CODE_DCM_NormalMyocardium                                          DSRBasicCodedEntry("122112", "DCM", "Normal Myocardium")
#define CODE_DCM_ScarredMyocardium                                         DSRBasicCodedEntry("122113", "DCM", "Scarred Myocardium")
#define CODE_DCM_ThinningMyocardium                                        DSRBasicCodedEntry("122114", "DCM", "Thinning Myocardium")
#define CODE_DCM_HemodynamicsReport                                        DSRBasicCodedEntry("122120", "DCM", "Hemodynamics Report")
#define CODE_DCM_AtrialPressureMeasurements                                DSRBasicCodedEntry("122121", "DCM", "Atrial pressure measurements")
#define CODE_DCM_VentricularPressureMeasurements                           DSRBasicCodedEntry("122122", "DCM", "Ventricular pressure measurements")
#define CODE_DCM_GradientAssessment                                        DSRBasicCodedEntry("122123", "DCM", "Gradient assessment")
#define CODE_DCM_BloodVelocityMeasurements                                 DSRBasicCodedEntry("122124", "DCM", "Blood velocity measurements")
#define CODE_DCM_BloodLabMeasurements                                      DSRBasicCodedEntry("122125", "DCM", "Blood lab measurements")
#define CODE_DCM_DerivedHemodynamicMeasurements                            DSRBasicCodedEntry("122126", "DCM", "Derived Hemodynamic Measurements")
#define CODE_DCM_ClinicalContext                                           DSRBasicCodedEntry("122127", "DCM", "Clinical Context")
#define CODE_DCM_PatientTransferredFrom                                    DSRBasicCodedEntry("122128", "DCM", "Patient Transferred From")
#define CODE_DCM_PCIDuringThisProcedure                                    DSRBasicCodedEntry("122129", "DCM", "PCI during this procedure")
#define CODE_DCM_DoseAreaProduct                                           DSRBasicCodedEntry("122130", "DCM", "Dose Area Product")
#define CODE_DCM_DegreeOfThrombus                                          DSRBasicCodedEntry("122131", "DCM", "Degree of Thrombus")
#define CODE_DCM_SeverityOfCalcification                                   DSRBasicCodedEntry("122132", "DCM", "Severity of Calcification")
#define CODE_DCM_LesionMorphology                                          DSRBasicCodedEntry("122133", "DCM", "Lesion Morphology")
#define CODE_DCM_VesselMorphology                                          DSRBasicCodedEntry("122134", "DCM", "Vessel Morphology")
#define CODE_DCM_CirculatorySupport                                        DSRBasicCodedEntry("122138", "DCM", "Circulatory Support")
#define CODE_DCM_ReasonForExam                                             DSRBasicCodedEntry("122139", "DCM", "Reason for Exam")
#define CODE_DCM_ComparisonWithPriorExamDone                               DSRBasicCodedEntry("122140", "DCM", "Comparison with Prior Exam Done")
#define CODE_DCM_ElectrodePlacement                                        DSRBasicCodedEntry("122141", "DCM", "Electrode Placement")
#define CODE_DCM_AcquisitionDeviceType                                     DSRBasicCodedEntry("122142", "DCM", "Acquisition Device Type")
#define CODE_DCM_AcquisitionDeviceID                                       DSRBasicCodedEntry("122143", "DCM", "Acquisition Device ID")
#define CODE_DCM_QuantitativeAnalysis                                      DSRBasicCodedEntry("122144", "DCM", "Quantitative Analysis")
#define CODE_DCM_QualitativeAnalysis                                       DSRBasicCodedEntry("122145", "DCM", "Qualitative Analysis")
#define CODE_DCM_ProcedureDateTime                                         DSRBasicCodedEntry("122146", "DCM", "Procedure DateTime")
#define CODE_DCM_ClinicalInterpretation                                    DSRBasicCodedEntry("122147", "DCM", "Clinical Interpretation")
#define CODE_DCM_LeadID                                                    DSRBasicCodedEntry("122148", "DCM", "Lead ID")
#define CODE_DCM_BeatNumber                                                DSRBasicCodedEntry("122149", "DCM", "Beat Number")
#define CODE_DCM_CompoundStatement                                         DSRBasicCodedEntry("122150", "DCM", "Compound Statement")
#define CODE_DCM_Trend                                                     DSRBasicCodedEntry("122151", "DCM", "Trend")
#define CODE_DCM_Statement                                                 DSRBasicCodedEntry("122152", "DCM", "Statement")
#define CODE_DCM_StatementModifier                                         DSRBasicCodedEntry("122153", "DCM", "Statement Modifier")
#define CODE_DCM_ConjunctiveTerm                                           DSRBasicCodedEntry("122154", "DCM", "Conjunctive Term")
#define CODE_DCM_Probability                                               DSRBasicCodedEntry("122157", "DCM", "Probability")
#define CODE_DCM_ECGGlobalMeasurements                                     DSRBasicCodedEntry("122158", "DCM", "ECG Global Measurements")
#define CODE_DCM_ECGLeadMeasurements                                       DSRBasicCodedEntry("122159", "DCM", "ECG Lead Measurements")
#define CODE_DCM_DerivedArea_NonValve                                      DSRBasicCodedEntry("122160", "DCM", "Derived Area, Non-Valve")
#define CODE_DCM_PulmonaryFlow                                             DSRBasicCodedEntry("122161", "DCM", "Pulmonary Flow")
#define CODE_DCM_SystemicFlow                                              DSRBasicCodedEntry("122162", "DCM", "Systemic Flow")
#define CODE_DCM_DischargeDateTime                                         DSRBasicCodedEntry("122163", "DCM", "Discharge DateTime")
#define CODE_DCM_CoronaryArteryBypassDuringThisAdmission                   DSRBasicCodedEntry("122164", "DCM", "Coronary Artery Bypass During This Admission")
#define CODE_DCM_DateTimeOfDeath                                           DSRBasicCodedEntry("122165", "DCM", "DateTime of Death")
#define CODE_DCM_DeathDuringThisAdmission                                  DSRBasicCodedEntry("122166", "DCM", "Death During This Admission")
#define CODE_DCM_DeathDuringCatheterization                                DSRBasicCodedEntry("122167", "DCM", "Death During Catheterization")
#define CODE_DCM_TypeOfMyocardialInfarction                                DSRBasicCodedEntry("122170", "DCM", "Type of Myocardial Infarction")
#define CODE_DCM_CoronaryLesionGreaterThanOrEqual50PercentStenosis         DSRBasicCodedEntry("122171", "DCM", "Coronary lesion > = 50% stenosis")
#define CODE_DCM_AcuteMIPresent                                            DSRBasicCodedEntry("122172", "DCM", "Acute MI Present")
#define CODE_DCM_STElevationOnsetDateTime                                  DSRBasicCodedEntry("122173", "DCM", "ST Elevation Onset DateTime")
#define CODE_DCM_NumberOfLesionInterventionsAttempted                      DSRBasicCodedEntry("122175", "DCM", "Number of lesion interventions attempted")
#define CODE_DCM_NumberOfLesionInterventionsSuccessful                     DSRBasicCodedEntry("122176", "DCM", "Number of lesion interventions successful")
#define CODE_DCM_ProcedureResult                                           DSRBasicCodedEntry("122177", "DCM", "Procedure Result")
#define CODE_DCM_LesionInterventionInformation                             DSRBasicCodedEntry("122178", "DCM", "Lesion Intervention Information")
#define CODE_DCM_PeriProceduralMIOccurred                                  DSRBasicCodedEntry("122179", "DCM", "Peri-procedural MI occurred")
#define CODE_DCM_CKMBBaseline                                              DSRBasicCodedEntry("122180", "DCM", "CK-MB baseline")
#define CODE_DCM_CKMBPeak                                                  DSRBasicCodedEntry("122181", "DCM", "CK-MB peak")
#define CODE_DCM_RRInterval                                                DSRBasicCodedEntry("122182", "DCM", "R-R interval")
#define CODE_DCM_BloodTemperature                                          DSRBasicCodedEntry("122183", "DCM", "Blood temperature")
#define CODE_DCM_BloodOxygenContent                                        DSRBasicCodedEntry("122185", "DCM", "Blood Oxygen content")
#define CODE_DCM_BloodCarbonDioxideSaturation                              DSRBasicCodedEntry("122187", "DCM", "Blood Carbon dioxide saturation")
#define CODE_DCM_PulmonaryArterialContent_FCpa                             DSRBasicCodedEntry("122188", "DCM", "Pulmonary Arterial Content (FCpa)")
#define CODE_DCM_PulmonaryVenousContent_FCpv                               DSRBasicCodedEntry("122189", "DCM", "Pulmonary Venous Content (FCpv)")
#define CODE_DCM_MaxDpDtP                                                  DSRBasicCodedEntry("122190", "DCM", "Max dp/dt/P")
#define CODE_DCM_VentricularEndDiastolicPressure                           DSRBasicCodedEntry("122191", "DCM", "Ventricular End Diastolic pressure")
#define CODE_DCM_IndicatorAppearanceTime                                   DSRBasicCodedEntry("122192", "DCM", "Indicator appearance time")
#define CODE_DCM_MaximumPressureAcceleration                               DSRBasicCodedEntry("122193", "DCM", "Maximum pressure acceleration")
#define CODE_DCM_VentricularSystolicBloodPressure                          DSRBasicCodedEntry("122194", "DCM", "Ventricular Systolic blood pressure")
#define CODE_DCM_PulseStrength                                             DSRBasicCodedEntry("122195", "DCM", "Pulse Strength")
#define CODE_DCM_CWavePressure                                             DSRBasicCodedEntry("122196", "DCM", "C wave pressure")
#define CODE_DCM_GradientPressure_average                                  DSRBasicCodedEntry("122197", "DCM", "Gradient pressure, average")
#define CODE_DCM_GradientPressure_peak                                     DSRBasicCodedEntry("122198", "DCM", "Gradient pressure, peak")
#define CODE_DCM_PressureAtDpDtMax                                         DSRBasicCodedEntry("122199", "DCM", "Pressure at dp/dt max")
#define CODE_DCM_DiastolicBloodVelocity_mean                               DSRBasicCodedEntry("122201", "DCM", "Diastolic blood velocity, mean")
#define CODE_DCM_DiastolicBloodVelocity_peak                               DSRBasicCodedEntry("122202", "DCM", "Diastolic blood velocity, peak")
#define CODE_DCM_SystolicBloodVelocity_mean                                DSRBasicCodedEntry("122203", "DCM", "Systolic blood velocity, mean")
#define CODE_DCM_SystolicBloodVelocity_peak                                DSRBasicCodedEntry("122204", "DCM", "Systolic blood velocity, peak")
#define CODE_DCM_BloodVelocity_mean                                        DSRBasicCodedEntry("122205", "DCM", "Blood velocity, mean")
#define CODE_DCM_BloodVelocity_minimum                                     DSRBasicCodedEntry("122206", "DCM", "Blood velocity, minimum")
#define CODE_DCM_BloodVelocity_peak                                        DSRBasicCodedEntry("122207", "DCM", "Blood velocity, peak")
#define CODE_DCM_XDescentPressure                                          DSRBasicCodedEntry("122208", "DCM", "x-descent pressure")
#define CODE_DCM_YDescentPressure                                          DSRBasicCodedEntry("122209", "DCM", "y-descent pressure")
#define CODE_DCM_ZPointPressure                                            DSRBasicCodedEntry("122210", "DCM", "z-point pressure")
#define CODE_DCM_LeftVentricularEjectionTime                               DSRBasicCodedEntry("122211", "DCM", "Left Ventricular ejection time")
#define CODE_DCM_LeftVentricularFillingTime                                DSRBasicCodedEntry("122212", "DCM", "Left Ventricular filling time")
#define CODE_DCM_RightVentricularEjectionTime                              DSRBasicCodedEntry("122213", "DCM", "Right Ventricular ejection time")
#define CODE_DCM_RightVentricularFillingTime                               DSRBasicCodedEntry("122214", "DCM", "Right Ventricular filling time")
#define CODE_DCM_TotalPulmonaryResistance                                  DSRBasicCodedEntry("122215", "DCM", "Total Pulmonary Resistance")
#define CODE_DCM_TotalVascularResistance                                   DSRBasicCodedEntry("122216", "DCM", "Total Vascular Resistance")
#define CODE_DCM_CoronaryFlowReserve                                       DSRBasicCodedEntry("122217", "DCM", "Coronary Flow reserve")
#define CODE_DCM_DiastolicSystolicVelocityRatio                            DSRBasicCodedEntry("122218", "DCM", "Diastolic/Systolic velocity ratio")
#define CODE_DCM_HyperemicRatio                                            DSRBasicCodedEntry("122219", "DCM", "Hyperemic ratio")
#define CODE_DCM_HemodynamicResistanceIndex                                DSRBasicCodedEntry("122220", "DCM", "Hemodynamic Resistance Index")
#define CODE_DCM_ThoraxDiameter_sagittal                                   DSRBasicCodedEntry("122221", "DCM", "Thorax diameter, sagittal")
#define CODE_DCM_ProcedureEnvironmentalCharacteristics                     DSRBasicCodedEntry("122222", "DCM", "Procedure Environmental Characteristics")
#define CODE_DCM_RoomOxygenConcentration                                   DSRBasicCodedEntry("122223", "DCM", "Room oxygen concentration")
#define CODE_DCM_RoomTemperature                                           DSRBasicCodedEntry("122224", "DCM", "Room temperature")
#define CODE_DCM_RoomBarometricPressure                                    DSRBasicCodedEntry("122225", "DCM", "Room Barometric pressure")
#define CODE_DCM_LeftToRightFlow                                           DSRBasicCodedEntry("122227", "DCM", "Left to Right Flow")
#define CODE_DCM_RightToLeftFlow                                           DSRBasicCodedEntry("122228", "DCM", "Right to Left Flow")
#define CODE_DCM_ArteriovenousDifference                                   DSRBasicCodedEntry("122229", "DCM", "Arteriovenous difference")
#define CODE_DCM_10YearCHDRisk                                             DSRBasicCodedEntry("122230", "DCM", "10 Year CHD Risk")
#define CODE_DCM_ComparativeAverage10YearCHDRisk                           DSRBasicCodedEntry("122231", "DCM", "Comparative Average10 Year CHD Risk")
#define CODE_DCM_ComparativeLow10YearCHDRisk                               DSRBasicCodedEntry("122232", "DCM", "Comparative Low10 Year CHD Risk")
#define CODE_DCM_LDLCholesterolScoreSheetForMen                            DSRBasicCodedEntry("122233", "DCM", "LDL Cholesterol Score Sheet for Men")
#define CODE_DCM_LDLCholesterolScoreSheetForWomen                          DSRBasicCodedEntry("122234", "DCM", "LDL Cholesterol Score Sheet for Women")
#define CODE_DCM_TotalCholesterolScoreSheetForMen                          DSRBasicCodedEntry("122235", "DCM", "Total Cholesterol Score Sheet for Men")
#define CODE_DCM_TotalCholesterolScoreSheetForWomen                        DSRBasicCodedEntry("122236", "DCM", "Total Cholesterol Score Sheet for Women")
#define CODE_DCM_CorrectedSinusNodeRecoveryTime                            DSRBasicCodedEntry("122237", "DCM", "Corrected Sinus Node Recovery Time")
#define CODE_DCM_MaxVolumeNormalizedTo50mmHgPulsePressure                  DSRBasicCodedEntry("122238", "DCM", "Max volume normalized to 50mmHg pulse pressure")
#define CODE_DCM_OxygenConsumption                                         DSRBasicCodedEntry("122239", "DCM", "Oxygen Consumption")
#define CODE_DCM_122240                                                    DSRBasicCodedEntry("122240", "DCM", "BSA = 0.003207*WT^(0.7285-0.0188*log(WT))*HT^0.3")
#define CODE_DCM_122241                                                    DSRBasicCodedEntry("122241", "DCM", "BSA = 0.007184*WT^0.425*HT^0.725")
#define CODE_DCM_122242                                                    DSRBasicCodedEntry("122242", "DCM", "BSA = 0.0235*WT^0.51456*HT^0.42246")
#define CODE_DCM_122243                                                    DSRBasicCodedEntry("122243", "DCM", "BSA = 0.024265*WT^0.5378*HT^0.3964")
#define CODE_DCM_122244                                                    DSRBasicCodedEntry("122244", "DCM", "BSA = (HT*WT/36)^0.5")
#define CODE_DCM_122245                                                    DSRBasicCodedEntry("122245", "DCM", "BSA = 1321+0.3433*WT")
#define CODE_DCM_122246                                                    DSRBasicCodedEntry("122246", "DCM", "BSA = 0.0004688*WT^(0.8168-0.0154*log(WT))")
#define CODE_DCM_122247                                                    DSRBasicCodedEntry("122247", "DCM", "VO2male = BSA (138.1 - 11.49 * loge(age) + 0.378 * HRf)")
#define CODE_DCM_122248                                                    DSRBasicCodedEntry("122248", "DCM", "VO2female = BSA (138.1 - 17.04 * loge(age) + 0.378 * HRf)")
#define CODE_DCM_122249                                                    DSRBasicCodedEntry("122249", "DCM", "VO2 = VeSTPD * 10 * (FIO2 - FE02)")
#define CODE_DCM_122250                                                    DSRBasicCodedEntry("122250", "DCM", "VO2 = 152 * BSA")
#define CODE_DCM_122251                                                    DSRBasicCodedEntry("122251", "DCM", "VO2 = 175 * BSA")
#define CODE_DCM_122252                                                    DSRBasicCodedEntry("122252", "DCM", "VO2 = 176 * BSA")
#define CODE_DCM_RobertsonAndReidTable                                     DSRBasicCodedEntry("122253", "DCM", "Robertson & Reid table")
#define CODE_DCM_FleischTable                                              DSRBasicCodedEntry("122254", "DCM", "Fleisch table")
#define CODE_DCM_BoothbyTable                                              DSRBasicCodedEntry("122255", "DCM", "Boothby table")
#define CODE_DCM_122256                                                    DSRBasicCodedEntry("122256", "DCM", "if (prem age< 3days) P50 = 19.9")
#define CODE_DCM_122257                                                    DSRBasicCodedEntry("122257", "DCM", "if (age < 1day) P50 = 21.6")
#define CODE_DCM_122258                                                    DSRBasicCodedEntry("122258", "DCM", "if (age < 30day) P50 = 24.6")
#define CODE_DCM_122259                                                    DSRBasicCodedEntry("122259", "DCM", "if (age < 18y) P50 = 27.2")
#define CODE_DCM_122260                                                    DSRBasicCodedEntry("122260", "DCM", "if (age < 40y) P50 = 27.4")
#define CODE_DCM_122261                                                    DSRBasicCodedEntry("122261", "DCM", "if (age > 60y) P50 = 29.3")
#define CODE_DCM_122262                                                    DSRBasicCodedEntry("122262", "DCM", "Area = Flow / 44.5 * sqrt(Gradient[mmHg])")
#define CODE_DCM_122263                                                    DSRBasicCodedEntry("122263", "DCM", "MVA = Flow / 38.0 * sqrt(Gradient[mmHg])")
#define CODE_DCM_122265                                                    DSRBasicCodedEntry("122265", "DCM", "BMI = Wt / Ht ^ 2")
#define CODE_DCM_122266                                                    DSRBasicCodedEntry("122266", "DCM", "BSA = 0.007358*WT^0.425*HT^0.725")
#define CODE_DCM_122267                                                    DSRBasicCodedEntry("122267", "DCM", "BSA = 0.010265*WT^0.423*HT^0.651")
#define CODE_DCM_122268                                                    DSRBasicCodedEntry("122268", "DCM", "BSA = 0.008883*WT^0.444*HT^0.663")
#define CODE_DCM_122269                                                    DSRBasicCodedEntry("122269", "DCM", "BSA = 0.038189*WT^0.423*HT^0.362")
#define CODE_DCM_122270                                                    DSRBasicCodedEntry("122270", "DCM", "BSA = 0.009568*WT^0.473*HT^0.655")
#define CODE_DCM_SkinConditionWarm                                         DSRBasicCodedEntry("122271", "DCM", "Skin Condition Warm")
#define CODE_DCM_SkinConditionCool                                         DSRBasicCodedEntry("122272", "DCM", "Skin Condition Cool")
#define CODE_DCM_SkinConditionCold                                         DSRBasicCodedEntry("122273", "DCM", "Skin Condition Cold")
#define CODE_DCM_SkinConditionDry                                          DSRBasicCodedEntry("122274", "DCM", "Skin Condition Dry")
#define CODE_DCM_SkinConditionClammy                                       DSRBasicCodedEntry("122275", "DCM", "Skin Condition Clammy")
#define CODE_DCM_SkinConditionDiaphoretic                                  DSRBasicCodedEntry("122276", "DCM", "Skin Condition Diaphoretic")
#define CODE_DCM_SkinConditionFlush                                        DSRBasicCodedEntry("122277", "DCM", "Skin Condition Flush")
#define CODE_DCM_SkinConditionMottled                                      DSRBasicCodedEntry("122278", "DCM", "Skin Condition Mottled")
#define CODE_DCM_SkinConditionPale                                         DSRBasicCodedEntry("122279", "DCM", "Skin Condition Pale")
#define CODE_DCM_AirwayUnobstructed                                        DSRBasicCodedEntry("122281", "DCM", "Airway unobstructed")
#define CODE_DCM_AirwayPartiallyObstructed                                 DSRBasicCodedEntry("122282", "DCM", "Airway partially obstructed")
#define CODE_DCM_AirwaySeverelyObstructed                                  DSRBasicCodedEntry("122283", "DCM", "Airway severely obstructed")
#define CODE_DCM_NotVisualized                                             DSRBasicCodedEntry("122288", "DCM", "Not Visualized")
#define CODE_DCM_QuantitativeArteriographyReport                           DSRBasicCodedEntry("122291", "DCM", "Quantitative Arteriography Report")
#define CODE_DCM_QuantitativeVentriculographyReport                        DSRBasicCodedEntry("122292", "DCM", "Quantitative Ventriculography Report")
#define CODE_DCM_GuidewireCrossingLesionUnsuccessful                       DSRBasicCodedEntry("122301", "DCM", "Guidewire crossing lesion unsuccessful")
#define CODE_DCM_GuidewireCrossingLesionSuccessful                         DSRBasicCodedEntry("122302", "DCM", "Guidewire crossing lesion successful")
#define CODE_DCM_AngioplastyBalloonInflated                                DSRBasicCodedEntry("122303", "DCM", "Angioplasty balloon inflated")
#define CODE_DCM_AngioplastyBalloonDeflated                                DSRBasicCodedEntry("122304", "DCM", "Angioplasty balloon deflated")
#define CODE_DCM_DeviceDeployed                                            DSRBasicCodedEntry("122305", "DCM", "Device deployed")
#define CODE_DCM_StentReExpanded                                           DSRBasicCodedEntry("122306", "DCM", "Stent re-expanded")
#define CODE_DCM_ObjectRemoved                                             DSRBasicCodedEntry("122307", "DCM", "Object removed")
#define CODE_DCM_RadiationApplied                                          DSRBasicCodedEntry("122308", "DCM", "Radiation applied")
#define CODE_DCM_RadiationRemoved                                          DSRBasicCodedEntry("122309", "DCM", "Radiation removed")
#define CODE_DCM_InterventionalDevicePlacementUnsuccessful                 DSRBasicCodedEntry("122310", "DCM", "Interventional device placement unsuccessful")
#define CODE_DCM_InterventionalDevicePlaced                                DSRBasicCodedEntry("122311", "DCM", "Interventional device placed")
#define CODE_DCM_InterventionPerformed                                     DSRBasicCodedEntry("122312", "DCM", "Intervention performed")
#define CODE_DCM_InterventionalDeviceWithdrawn                             DSRBasicCodedEntry("122313", "DCM", "Interventional device withdrawn")
#define CODE_DCM_CatheterSize                                              DSRBasicCodedEntry("122319", "DCM", "Catheter Size")
#define CODE_DCM_InjectateTemperature                                      DSRBasicCodedEntry("122320", "DCM", "Injectate Temperature")
#define CODE_DCM_InjectateVolume                                           DSRBasicCodedEntry("122321", "DCM", "Injectate Volume")
#define CODE_DCM_CalibrationFactor                                         DSRBasicCodedEntry("122322", "DCM", "Calibration Factor")
#define CODE_DCM_IVUSReport                                                DSRBasicCodedEntry("122325", "DCM", "IVUS Report")
#define CODE_DCM_EEMDiameter                                               DSRBasicCodedEntry("122330", "DCM", "EEM Diameter")
#define CODE_DCM_PlaquePlusMediaThickness                                  DSRBasicCodedEntry("122331", "DCM", "Plaque Plus Media Thickness")
#define CODE_DCM_LumenPerimeter                                            DSRBasicCodedEntry("122332", "DCM", "Lumen Perimeter")
#define CODE_DCM_EEMCrossSectionalArea                                     DSRBasicCodedEntry("122333", "DCM", "EEM Cross-Sectional Area")
#define CODE_DCM_PlaquePlusMediaCrossSectionalArea                         DSRBasicCodedEntry("122334", "DCM", "Plaque plus Media Cross-Sectional Area")
#define CODE_DCM_InStentNeointimalCrossSectionalArea                       DSRBasicCodedEntry("122335", "DCM", "In-Stent Neointimal Cross-Sectional Area")
#define CODE_DCM_VascularVolumeMeasurementLength                           DSRBasicCodedEntry("122336", "DCM", "Vascular Volume measurement length")
#define CODE_DCM_RelativePosition                                          DSRBasicCodedEntry("122337", "DCM", "Relative position")
#define CODE_DCM_StentVolumeObstruction                                    DSRBasicCodedEntry("122339", "DCM", "Stent Volume Obstruction")
#define CODE_DCM_FiducialFeature                                           DSRBasicCodedEntry("122340", "DCM", "Fiducial feature")
#define CODE_DCM_CalciumLength                                             DSRBasicCodedEntry("122341", "DCM", "Calcium Length")
#define CODE_DCM_LumenEccentricityIndex                                    DSRBasicCodedEntry("122343", "DCM", "Lumen Eccentricity Index")
#define CODE_DCM_PlaquePlusMediaEccentricityIndex                          DSRBasicCodedEntry("122344", "DCM", "Plaque plus Media Eccentricity Index")
#define CODE_DCM_RemodelingIndex                                           DSRBasicCodedEntry("122345", "DCM", "Remodeling Index")
#define CODE_DCM_StentSymmetryIndex                                        DSRBasicCodedEntry("122346", "DCM", "Stent Symmetry Index")
#define CODE_DCM_StentExpansionIndex                                       DSRBasicCodedEntry("122347", "DCM", "Stent Expansion Index")
#define CODE_DCM_LumenShapeIndex                                           DSRBasicCodedEntry("122348", "DCM", "Lumen Shape Index")
#define CODE_DCM_LumenDiameterRatio                                        DSRBasicCodedEntry("122350", "DCM", "Lumen Diameter Ratio")
#define CODE_DCM_StentDiameterRatio                                        DSRBasicCodedEntry("122351", "DCM", "Stent Diameter Ratio")
#define CODE_DCM_EEMDiameterRatio                                          DSRBasicCodedEntry("122352", "DCM", "EEM Diameter Ratio")
#define CODE_DCM_PlaqueBurden                                              DSRBasicCodedEntry("122354", "DCM", "Plaque Burden")
#define CODE_DCM_ArcOfCalcium                                              DSRBasicCodedEntry("122355", "DCM", "Arc of Calcium")
#define CODE_DCM_SoftPlaque                                                DSRBasicCodedEntry("122356", "DCM", "Soft plaque")
#define CODE_DCM_InStentNeointima                                          DSRBasicCodedEntry("122357", "DCM", "In-Stent Neointima")
#define CODE_DCM_TrueLumen                                                 DSRBasicCodedEntry("122360", "DCM", "True Lumen")
#define CODE_DCM_FalseLumen                                                DSRBasicCodedEntry("122361", "DCM", "False Lumen")
#define CODE_DCM_PlaqueRupture                                             DSRBasicCodedEntry("122363", "DCM", "Plaque Rupture")
#define CODE_DCM_StentGap                                                  DSRBasicCodedEntry("122364", "DCM", "Stent Gap")
#define CODE_DCM_T1Worst                                                   DSRBasicCodedEntry("122367", "DCM", "T-1 Worst")
#define CODE_DCM_T2Secondary                                               DSRBasicCodedEntry("122368", "DCM", "T-2 Secondary")
#define CODE_DCM_T3Secondary                                               DSRBasicCodedEntry("122369", "DCM", "T-3 Secondary")
#define CODE_DCM_T4Secondary                                               DSRBasicCodedEntry("122370", "DCM", "T-4 Secondary")
#define CODE_DCM_EEMVolume                                                 DSRBasicCodedEntry("122371", "DCM", "EEM Volume")
#define CODE_DCM_LumenVolume                                               DSRBasicCodedEntry("122372", "DCM", "Lumen Volume")
#define CODE_DCM_InStentNeointimalVolume                                   DSRBasicCodedEntry("122374", "DCM", "In-Stent Neointimal Volume")
#define CODE_DCM_NativePlaqueVolume                                        DSRBasicCodedEntry("122375", "DCM", "Native Plaque Volume")
#define CODE_DCM_TotalPlaqueVolume                                         DSRBasicCodedEntry("122376", "DCM", "Total Plaque Volume")
#define CODE_DCM_ProximalReference                                         DSRBasicCodedEntry("122380", "DCM", "Proximal Reference")
#define CODE_DCM_DistalReference                                           DSRBasicCodedEntry("122381", "DCM", "Distal Reference")
#define CODE_DCM_SiteOfLumenMinimum                                        DSRBasicCodedEntry("122382", "DCM", "Site of Lumen Minimum")
#define CODE_DCM_EntirePullback                                            DSRBasicCodedEntry("122383", "DCM", "Entire Pullback")
#define CODE_DCM_StentedRegion                                             DSRBasicCodedEntry("122384", "DCM", "Stented Region")
#define CODE_DCM_ProximalStentMargin                                       DSRBasicCodedEntry("122385", "DCM", "Proximal Stent Margin")
#define CODE_DCM_DistalStentMargin                                         DSRBasicCodedEntry("122386", "DCM", "Distal Stent Margin")
#define CODE_DCM_DissectionClassification                                  DSRBasicCodedEntry("122387", "DCM", "Dissection Classification")
#define CODE_DCM_IntraStentDissection                                      DSRBasicCodedEntry("122388", "DCM", "Intra-stent Dissection")
#define CODE_DCM_VulnerablePlaque                                          DSRBasicCodedEntry("122389", "DCM", "Vulnerable Plaque")
#define CODE_DCM_ErodedPlaque                                              DSRBasicCodedEntry("122390", "DCM", "Eroded Plaque")
#define CODE_DCM_RelativeStenosisSeverity                                  DSRBasicCodedEntry("122391", "DCM", "Relative Stenosis Severity")
#define CODE_DCM_RestenoticLesion                                          DSRBasicCodedEntry("122393", "DCM", "Restenotic Lesion")
#define CODE_DCM_FibroLipidicPlaque                                        DSRBasicCodedEntry("122394", "DCM", "Fibro-Lipidic Plaque")
#define CODE_DCM_NecroticLipidicPlaque                                     DSRBasicCodedEntry("122395", "DCM", "Necrotic-Lipidic Plaque")
#define CODE_DCM_AdventitialDissection                                     DSRBasicCodedEntry("122397", "DCM", "Adventitial Dissection")
#define CODE_DCM_IntimalDissection                                         DSRBasicCodedEntry("122398", "DCM", "Intimal Dissection")
#define CODE_DCM_MedialDissection                                          DSRBasicCodedEntry("122399", "DCM", "Medial Dissection")
#define CODE_DCM_SimultaneouslyAcquired                                    DSRBasicCodedEntry("122400", "DCM", "Simultaneously Acquired")
#define CODE_DCM_SameAnatomy                                               DSRBasicCodedEntry("122401", "DCM", "Same Anatomy")
#define CODE_DCM_SameIndication                                            DSRBasicCodedEntry("122402", "DCM", "Same Indication")
#define CODE_DCM_ForAttenuationCorrection                                  DSRBasicCodedEntry("122403", "DCM", "For Attenuation Correction")
#define CODE_DCM_Reconstructed                                             DSRBasicCodedEntry("122404", "DCM", "Reconstructed")
#define CODE_DCM_AlgorithmManufacturer                                     DSRBasicCodedEntry("122405", "DCM", "Algorithm Manufacturer")
#define CODE_DCM_LeftAtrialEjectionFractionByAngiography                   DSRBasicCodedEntry("122406", "DCM", "Left Atrial Ejection Fraction by Angiography")
#define CODE_DCM_LeftAtrialEDVolume                                        DSRBasicCodedEntry("122407", "DCM", "Left Atrial ED Volume")
#define CODE_DCM_LeftAtrialESVolume                                        DSRBasicCodedEntry("122408", "DCM", "Left Atrial ES Volume")
#define CODE_DCM_ContourRealignment                                        DSRBasicCodedEntry("122410", "DCM", "Contour Realignment")
#define CODE_DCM_ThresholdValue                                            DSRBasicCodedEntry("122411", "DCM", "Threshold Value")
#define CODE_DCM_RegionalAbnormalWallMotion                                DSRBasicCodedEntry("122417", "DCM", "Regional Abnormal Wall Motion")
#define CODE_DCM_CalibrationObject                                         DSRBasicCodedEntry("122421", "DCM", "Calibration Object")
#define CODE_DCM_CalibrationMethod                                         DSRBasicCodedEntry("122422", "DCM", "Calibration Method")
#define CODE_DCM_CalibrationObjectSize                                     DSRBasicCodedEntry("122423", "DCM", "Calibration Object Size")
#define CODE_DCM_AreaLengthMethod                                          DSRBasicCodedEntry("122428", "DCM", "Area Length Method")
#define CODE_DCM_VolumeMethod                                              DSRBasicCodedEntry("122429", "DCM", "Volume Method")
#define CODE_DCM_ReferenceMethod                                           DSRBasicCodedEntry("122430", "DCM", "Reference Method")
#define CODE_DCM_RegressionSlopeED                                         DSRBasicCodedEntry("122431", "DCM", "Regression Slope ED")
#define CODE_DCM_RegressionOffsetED                                        DSRBasicCodedEntry("122432", "DCM", "Regression Offset ED")
#define CODE_DCM_RegressionSlopeES                                         DSRBasicCodedEntry("122433", "DCM", "Regression Slope ES")
#define CODE_DCM_RegressionOffsetES                                        DSRBasicCodedEntry("122434", "DCM", "Regression Offset ES")
#define CODE_DCM_RegressionVolumeExponent                                  DSRBasicCodedEntry("122435", "DCM", "Regression Volume Exponent")
#define CODE_DCM_ReferencePoints                                           DSRBasicCodedEntry("122438", "DCM", "Reference Points")
#define CODE_DCM_WallThickness                                             DSRBasicCodedEntry("122445", "DCM", "Wall Thickness")
#define CODE_DCM_WallVolume                                                DSRBasicCodedEntry("122446", "DCM", "Wall Volume")
#define CODE_DCM_WallMass                                                  DSRBasicCodedEntry("122447", "DCM", "Wall Mass")
#define CODE_DCM_WallStress                                                DSRBasicCodedEntry("122448", "DCM", "Wall Stress")
#define CODE_DCM_CenterlineWallMotionAnalysis                              DSRBasicCodedEntry("122449", "DCM", "Centerline Wall Motion Analysis")
#define CODE_DCM_NormalizedChordLength                                     DSRBasicCodedEntry("122450", "DCM", "Normalized Chord Length")
#define CODE_DCM_AbnormalRegion                                            DSRBasicCodedEntry("122451", "DCM", "Abnormal Region")
#define CODE_DCM_FirstChordOfAbnormalRegion                                DSRBasicCodedEntry("122452", "DCM", "First Chord of Abnormal Region")
#define CODE_DCM_LastChordOfAbnormalRegion                                 DSRBasicCodedEntry("122453", "DCM", "Last Chord of Abnormal Region")
#define CODE_DCM_TerritoryRegionSeverity                                   DSRBasicCodedEntry("122459", "DCM", "Territory Region Severity")
#define CODE_DCM_OppositeRegionSeverity                                    DSRBasicCodedEntry("122461", "DCM", "Opposite Region Severity")
#define CODE_DCM_LADRegionInRAOProjection                                  DSRBasicCodedEntry("122464", "DCM", "LAD Region in RAO Projection")
#define CODE_DCM_RCARegionInROAProjection                                  DSRBasicCodedEntry("122465", "DCM", "RCA Region in ROA Projection")
#define CODE_DCM_SingleLADRegionInRAOProjection                            DSRBasicCodedEntry("122466", "DCM", "Single LAD Region in RAO Projection")
#define CODE_DCM_SingleRCARegionInRAOProjection                            DSRBasicCodedEntry("122467", "DCM", "Single RCA Region in RAO Projection")
#define CODE_DCM_MultipleLADRegionInRAOProjection                          DSRBasicCodedEntry("122468", "DCM", "Multiple LAD Region in RAO Projection")
#define CODE_DCM_MultipleRCARegionInRAOProjection                          DSRBasicCodedEntry("122469", "DCM", "Multiple RCA Region in RAO Projection")
#define CODE_DCM_LADRegionInLAOProjection                                  DSRBasicCodedEntry("122470", "DCM", "LAD Region in LAO Projection")
#define CODE_DCM_RCARegionInLAOProjection                                  DSRBasicCodedEntry("122471", "DCM", "RCA Region in LAO Projection")
#define CODE_DCM_CFXRegionInLAOProjection                                  DSRBasicCodedEntry("122472", "DCM", "CFX Region in LAO Projection")
#define CODE_DCM_CircularMethod                                            DSRBasicCodedEntry("122473", "DCM", "Circular Method")
#define CODE_DCM_DensitometricMethod                                       DSRBasicCodedEntry("122474", "DCM", "Densitometric Method")
#define CODE_DCM_CenterOfGravity                                           DSRBasicCodedEntry("122475", "DCM", "Center of Gravity")
#define CODE_DCM_LongAxisBased                                             DSRBasicCodedEntry("122476", "DCM", "Long Axis Based")
#define CODE_DCM_NoRealignment                                             DSRBasicCodedEntry("122477", "DCM", "No Realignment")
#define CODE_DCM_VesselLumenCrossSectionalArea                             DSRBasicCodedEntry("122480", "DCM", "Vessel Lumen Cross-Sectional Area")
#define CODE_DCM_ContourStart                                              DSRBasicCodedEntry("122481", "DCM", "Contour Start")
#define CODE_DCM_ContourEnd                                                DSRBasicCodedEntry("122482", "DCM", "Contour End")
#define CODE_DCM_Sphere                                                    DSRBasicCodedEntry("122485", "DCM", "Sphere")
#define CODE_DCM_GeometricIsocenter                                        DSRBasicCodedEntry("122486", "DCM", "Geometric Isocenter")
#define CODE_DCM_GeometricNonIsocenter                                     DSRBasicCodedEntry("122487", "DCM", "Geometric Non-Isocenter")
#define CODE_DCM_CalibrationObjectUsed                                     DSRBasicCodedEntry("122488", "DCM", "Calibration Object Used")
#define CODE_DCM_CurveFittedReference                                      DSRBasicCodedEntry("122489", "DCM", "Curve Fitted Reference")
#define CODE_DCM_InterpolatedLocalReference                                DSRBasicCodedEntry("122490", "DCM", "Interpolated Local Reference")
#define CODE_DCM_MeanLocalReference                                        DSRBasicCodedEntry("122491", "DCM", "Mean Local Reference")
#define CODE_DCM_RadialBasedWallMotionAnalysis                             DSRBasicCodedEntry("122493", "DCM", "Radial Based Wall Motion Analysis")
#define CODE_DCM_RegionalContributionToEjectionFraction                    DSRBasicCodedEntry("122495", "DCM", "Regional Contribution to Ejection Fraction")
#define CODE_DCM_RadialShortening                                          DSRBasicCodedEntry("122496", "DCM", "Radial Shortening")
#define CODE_DCM_LandmarkBasedWallMotionAnalysis                           DSRBasicCodedEntry("122497", "DCM", "Landmark Based Wall Motion Analysis")
#define CODE_DCM_SliceContributionToEjectionFraction                       DSRBasicCodedEntry("122498", "DCM", "Slice Contribution to Ejection Fraction")
#define CODE_DCM_FrameToFrameAnalysis                                      DSRBasicCodedEntry("122499", "DCM", "Frame to Frame Analysis")
#define CODE_DCM_AreaOfClosedIrregularPolygon                              DSRBasicCodedEntry("122501", "DCM", "Area of closed irregular polygon")
#define CODE_DCM_AreaOfAClosedNURBS                                        DSRBasicCodedEntry("122502", "DCM", "Area of a closed NURBS")
#define CODE_DCM_IntegrationOfSumOfClosedAreasonContiguousSlicesMethodForVolume DSRBasicCodedEntry("122503", "DCM", "Integration of sum of closed areas on contiguous slices method for volume")
#define CODE_DCM_Calibration                                               DSRBasicCodedEntry("122505", "DCM", "Calibration")
#define CODE_DCM_LeftContour                                               DSRBasicCodedEntry("122507", "DCM", "Left Contour")
#define CODE_DCM_RightContour                                              DSRBasicCodedEntry("122508", "DCM", "Right Contour")
#define CODE_DCM_DiameterGraph                                             DSRBasicCodedEntry("122509", "DCM", "Diameter Graph")
#define CODE_DCM_LengthLuminalSegment                                      DSRBasicCodedEntry("122510", "DCM", "Length Luminal Segment")
#define CODE_DCM_GraphIncrement                                            DSRBasicCodedEntry("122511", "DCM", "Graph Increment")
#define CODE_DCM_SiteOfMaximumLuminal                                      DSRBasicCodedEntry("122516", "DCM", "Site of Maximum Luminal")
#define CODE_DCM_DensitometricLuminalCrossSectionalAreaGraph               DSRBasicCodedEntry("122517", "DCM", "Densitometric Luminal Cross-sectional Area Graph")
#define CODE_DCM_PositionOfProximalBorder                                  DSRBasicCodedEntry("122528", "DCM", "Position of Proximal Border")
#define CODE_DCM_PositionOfDistalBorder                                    DSRBasicCodedEntry("122529", "DCM", "Position of Distal Border")
#define CODE_DCM_PlaqueArea                                                DSRBasicCodedEntry("122542", "DCM", "Plaque Area")
#define CODE_DCM_DiameterSymmetry                                          DSRBasicCodedEntry("122544", "DCM", "Diameter Symmetry")
#define CODE_DCM_AreaSymmetry                                              DSRBasicCodedEntry("122545", "DCM", "Area Symmetry")
#define CODE_DCM_InflowAngle                                               DSRBasicCodedEntry("122546", "DCM", "Inflow Angle")
#define CODE_DCM_OutflowAngle                                              DSRBasicCodedEntry("122547", "DCM", "Outflow Angle")
#define CODE_DCM_StenoticFlowReserve                                       DSRBasicCodedEntry("122548", "DCM", "Stenotic Flow Reserve")
#define CODE_DCM_PoiseuilleResistance                                      DSRBasicCodedEntry("122549", "DCM", "Poiseuille Resistance")
#define CODE_DCM_TurbulenceResistance                                      DSRBasicCodedEntry("122550", "DCM", "Turbulence Resistance")
#define CODE_DCM_PressureDropAtSFR                                         DSRBasicCodedEntry("122551", "DCM", "Pressure Drop at SFR")
#define CODE_DCM_SegmentationMethod                                        DSRBasicCodedEntry("122554", "DCM", "Segmentation Method")
#define CODE_DCM_EstimatedNormalFlow                                       DSRBasicCodedEntry("122555", "DCM", "Estimated Normal Flow")
#define CODE_DCM_AreaLengthKennedy                                         DSRBasicCodedEntry("122558", "DCM", "Area Length Kennedy")
#define CODE_DCM_AreaLengthDodge                                           DSRBasicCodedEntry("122559", "DCM", "Area Length Dodge")
#define CODE_DCM_AreaLengthWynne                                           DSRBasicCodedEntry("122560", "DCM", "Area Length Wynne")
#define CODE_DCM_MultipleSlices                                            DSRBasicCodedEntry("122562", "DCM", "Multiple Slices")
#define CODE_DCM_Boak                                                      DSRBasicCodedEntry("122563", "DCM", "Boak")
#define CODE_DCM_TSPyramid                                                 DSRBasicCodedEntry("122564", "DCM", "TS Pyramid")
#define CODE_DCM_TwoChamber                                                DSRBasicCodedEntry("122565", "DCM", "Two Chamber")
#define CODE_DCM_Parallelepiped                                            DSRBasicCodedEntry("122566", "DCM", "Parallelepiped")
#define CODE_DCM_BSA1dot219                                                DSRBasicCodedEntry("122572", "DCM", "BSA^1.219")
#define CODE_DCM_EquidistantMethod                                         DSRBasicCodedEntry("122574", "DCM", "Equidistant method")
#define CODE_DCM_UserSelectedMethod                                        DSRBasicCodedEntry("122575", "DCM", "User selected method")
#define CODE_DCM_LeftVentricularPosterobasalSegment                        DSRBasicCodedEntry("122582", "DCM", "Left ventricular posterobasal segment")
#define CODE_DCM_CardiovascularAnalysisReport                              DSRBasicCodedEntry("122600", "DCM", "Cardiovascular Analysis Report")
#define CODE_DCM_VentricularAnalysis                                       DSRBasicCodedEntry("122601", "DCM", "Ventricular Analysis")
#define CODE_DCM_MyocardialPerfusionAnalysis                               DSRBasicCodedEntry("122602", "DCM", "Myocardial Perfusion Analysis")
#define CODE_DCM_CalciumScoringAnalysis                                    DSRBasicCodedEntry("122603", "DCM", "Calcium Scoring Analysis")
#define CODE_DCM_FlowQuantification                                        DSRBasicCodedEntry("122604", "DCM", "Flow Quantification")
#define CODE_DCM_VascularMorphologicalAnalysis                             DSRBasicCodedEntry("122605", "DCM", "Vascular Morphological Analysis")
#define CODE_DCM_VascularFunctionalAnalysis                                DSRBasicCodedEntry("122606", "DCM", "Vascular Functional Analysis")
#define CODE_DCM_ThickeningAnalysis                                        DSRBasicCodedEntry("122607", "DCM", "Thickening Analysis")
#define CODE_DCM_AbsoluteValuesOfVentricularMeasurements                   DSRBasicCodedEntry("122608", "DCM", "Absolute Values Of Ventricular Measurements")
#define CODE_DCM_NormalizedValuesOfVentricularMeasurements                 DSRBasicCodedEntry("122609", "DCM", "Normalized Values Of Ventricular Measurements")
#define CODE_DCM_ReferencePoint                                            DSRBasicCodedEntry("122611", "DCM", "Reference Point")
#define CODE_DCM_CentralBreathingPosition                                  DSRBasicCodedEntry("122612", "DCM", "Central breathing position")
#define CODE_DCM_PeakEjectionRate                                          DSRBasicCodedEntry("122616", "DCM", "Peak Ejection Rate")
#define CODE_DCM_PeakEjectionTime                                          DSRBasicCodedEntry("122617", "DCM", "Peak Ejection Time")
#define CODE_DCM_PeakFillingRate                                           DSRBasicCodedEntry("122618", "DCM", "Peak Filling Rate")
#define CODE_DCM_PeakFillingTime                                           DSRBasicCodedEntry("122619", "DCM", "Peak Filling Time")
#define CODE_DCM_PapillaryMuscleExcluded                                   DSRBasicCodedEntry("122620", "DCM", "Papillary Muscle Excluded")
#define CODE_DCM_PapillaryMuscleIncluded                                   DSRBasicCodedEntry("122621", "DCM", "Papillary Muscle Included")
#define CODE_DCM_WallThicknessRatioEndSystolicToEndDiastolic               DSRBasicCodedEntry("122624", "DCM", "Wall Thickness Ratio end-systolic to end-diastolic")
#define CODE_DCM_CurveFitMethod                                            DSRBasicCodedEntry("122627", "DCM", "Curve Fit Method")
#define CODE_DCM_BaselineResultCorrection                                  DSRBasicCodedEntry("122628", "DCM", "Baseline Result Correction")
#define CODE_DCM_SignalEarliestPeakTime                                    DSRBasicCodedEntry("122631", "DCM", "Signal Earliest Peak Time")
#define CODE_DCM_SignalIncreaseStartTime                                   DSRBasicCodedEntry("122633", "DCM", "Signal Increase Start Time")
#define CODE_DCM_SignalTimeToPeak                                          DSRBasicCodedEntry("122634", "DCM", "Signal Time to Peak")
#define CODE_DCM_MRPerfusionPeak                                           DSRBasicCodedEntry("122635", "DCM", "MR Perfusion Peak")
#define CODE_DCM_MRPerfusionSlope                                          DSRBasicCodedEntry("122636", "DCM", "MR Perfusion Slope")
#define CODE_DCM_MRPerfusionTimeIntegral                                   DSRBasicCodedEntry("122637", "DCM", "MR Perfusion Time Integral")
#define CODE_DCM_SignalBaselineStart                                       DSRBasicCodedEntry("122638", "DCM", "Signal Baseline Start")
#define CODE_DCM_SignalBaselineEnd                                         DSRBasicCodedEntry("122639", "DCM", "Signal Baseline End")
#define CODE_DCM_ImageInterval                                             DSRBasicCodedEntry("122640", "DCM", "Image Interval")
#define CODE_DCM_VelocityEncodingMinimumValue                              DSRBasicCodedEntry("122642", "DCM", "Velocity Encoding Minimum Value")
#define CODE_DCM_VelocityEncodingMaximumValue                              DSRBasicCodedEntry("122643", "DCM", "Velocity Encoding Maximum Value")
#define CODE_DCM_NetForwardVolume                                          DSRBasicCodedEntry("122645", "DCM", "Net Forward Volume")
#define CODE_DCM_AreaBasedMethod                                           DSRBasicCodedEntry("122650", "DCM", "Area Based Method")
#define CODE_DCM_DiameterBasedMethod                                       DSRBasicCodedEntry("122651", "DCM", "Diameter Based Method")
#define CODE_DCM_VolumeBasedMethod                                         DSRBasicCodedEntry("122652", "DCM", "Volume Based Method")
#define CODE_DCM_NASCET                                                    DSRBasicCodedEntry("122655", "DCM", "NASCET")
#define CODE_DCM_ECST                                                      DSRBasicCodedEntry("122656", "DCM", "ECST")
#define CODE_DCM_AgatstonScoreThreshold                                    DSRBasicCodedEntry("122657", "DCM", "Agatston Score Threshold")
#define CODE_DCM_CalciumMassThreshold                                      DSRBasicCodedEntry("122658", "DCM", "Calcium Mass Threshold")
#define CODE_DCM_CalciumScoringCalibration                                 DSRBasicCodedEntry("122659", "DCM", "Calcium Scoring Calibration")
#define CODE_DCM_CalciumVolume                                             DSRBasicCodedEntry("122660", "DCM", "Calcium Volume")
#define CODE_DCM_CalciumMass                                               DSRBasicCodedEntry("122661", "DCM", "Calcium Mass")
#define CODE_DCM_LateContrastEnhancement                                   DSRBasicCodedEntry("122664", "DCM", "Late Contrast Enhancement")
#define CODE_DCM_TimeIntervalSinceInjectionOfContrastMedia                 DSRBasicCodedEntry("122665", "DCM", "Time interval since injection of contrast media")
#define CODE_DCM_TimeRelativeToRWavePeak                                   DSRBasicCodedEntry("122666", "DCM", "Time relative to R-wave peak")
#define CODE_DCM_BloodVelocityVsTimeOfCardiacCycle                         DSRBasicCodedEntry("122667", "DCM", "Blood velocity vs. time of cardiac cycle")
#define CODE_DCM_TimeIntervalSinceDetectionOfContrastBolus                 DSRBasicCodedEntry("122668", "DCM", "Time interval since detection of contrast bolus")
#define CODE_DCM_PapillaryMuscleIncludedExcluded                           DSRBasicCodedEntry("122670", "DCM", "Papillary Muscle Included/Excluded")
#define CODE_DCM_AnteriorPosterior                                         DSRBasicCodedEntry("122675", "DCM", "Anterior-Posterior")
#define CODE_DCM_Endoleak                                                  DSRBasicCodedEntry("122680", "DCM", "endoleak")
#define CODE_DCM_StentFracture                                             DSRBasicCodedEntry("122683", "DCM", "Stent Fracture")
#define CODE_DCM_StentDisintegration                                       DSRBasicCodedEntry("122684", "DCM", "Stent Disintegration")
#define CODE_DCM_StentComposition                                          DSRBasicCodedEntry("122685", "DCM", "Stent Composition")
#define CODE_DCM_ParentVesselFinding                                       DSRBasicCodedEntry("122686", "DCM", "Parent Vessel Finding")
#define CODE_DCM_SiteOfLumenMaximum                                        DSRBasicCodedEntry("122687", "DCM", "Site of Lumen Maximum")
#define CODE_DCM_XConcept                                                  DSRBasicCodedEntry("122698", "DCM", "X-Concept")
#define CODE_DCM_YConcept                                                  DSRBasicCodedEntry("122699", "DCM", "Y-Concept")
#define CODE_DCM_IndicationsForPharmacologicalStress                       DSRBasicCodedEntry("122700", "DCM", "Indications for Pharmacological Stress")
#define CODE_DCM_ProcedureTimeBase                                         DSRBasicCodedEntry("122701", "DCM", "Procedure time base")
#define CODE_DCM_TreadmillSpeed                                            DSRBasicCodedEntry("122702", "DCM", "Treadmill speed")
#define CODE_DCM_TreadmillGradient                                         DSRBasicCodedEntry("122703", "DCM", "Treadmill gradient")
#define CODE_DCM_ErgometerPower                                            DSRBasicCodedEntry("122704", "DCM", "Ergometer power")
#define CODE_DCM_PharmacologicalStressAgentDoseRate                        DSRBasicCodedEntry("122705", "DCM", "Pharmacological Stress Agent Dose Rate")
#define CODE_DCM_RatingOfPerceivedExertion                                 DSRBasicCodedEntry("122706", "DCM", "Rating of Perceived Exertion")
#define CODE_DCM_NumberOfEctopicBeats                                      DSRBasicCodedEntry("122707", "DCM", "Number of Ectopic Beats")
#define CODE_DCM_DoubleProduct                                             DSRBasicCodedEntry("122708", "DCM", "Double Product")
#define CODE_DCM_ActivityWorkload                                          DSRBasicCodedEntry("122709", "DCM", "Activity workload")
#define CODE_DCM_TimeSinceStartOfStage                                     DSRBasicCodedEntry("122710", "DCM", "Time since start of stage")
#define CODE_DCM_ExerciseDurationAfterStressAgentInjection                 DSRBasicCodedEntry("122711", "DCM", "Exercise duration after stress agent injection")
#define CODE_DCM_ImagingStartDateTime                                      DSRBasicCodedEntry("122712", "DCM", "Imaging Start DateTime")
#define CODE_DCM_AttenuationCorrectionMethod                               DSRBasicCodedEntry("122713", "DCM", "Attenuation correction method")
#define CODE_DCM_PharmacologicalStressAgentDose                            DSRBasicCodedEntry("122715", "DCM", "Pharmacological Stress Agent Dose")
#define CODE_DCM_MaximumPowerOutputAchieved                                DSRBasicCodedEntry("122716", "DCM", "Maximum Power Output Achieved")
#define CODE_DCM_PeakActivityWorkload                                      DSRBasicCodedEntry("122717", "DCM", "Peak activity workload")
#define CODE_DCM_PeakDoubleProduct                                         DSRBasicCodedEntry("122718", "DCM", "Peak Double Product")
#define CODE_DCM_OSEMAlgorithm                                             DSRBasicCodedEntry("122720", "DCM", "OSEM algorithm")
#define CODE_DCM_ChangMethod                                               DSRBasicCodedEntry("122721", "DCM", "Chang method")
#define CODE_DCM_AlgorithmicAttenuationCorrection                          DSRBasicCodedEntry("122726", "DCM", "Algorithmic attenuation correction")
#define CODE_DCM_NMTransmissionAttenuationCorrection                       DSRBasicCodedEntry("122727", "DCM", "NM transmission attenuation correction")
#define CODE_DCM_CTBasedAttenuationCorrection                              DSRBasicCodedEntry("122728", "DCM", "CT-based attenuation correction")
#define CODE_DCM_NoAttenuationCorrection                                   DSRBasicCodedEntry("122729", "DCM", "No Attenuation Correction")
#define CODE_DCM_BazettQTcAlgorithm                                        DSRBasicCodedEntry("122730", "DCM", "Bazett QTc Algorithm")
#define CODE_DCM_HodgesQTcAlgorithm                                        DSRBasicCodedEntry("122731", "DCM", "Hodges QTc Algorithm")
#define CODE_DCM_FridericiaQTcAlgorithm                                    DSRBasicCodedEntry("122732", "DCM", "Fridericia QTc Algorithm")
#define CODE_DCM_FraminghamQTcAlgorithm                                    DSRBasicCodedEntry("122733", "DCM", "Framingham QTc Algorithm")
#define CODE_DCM_BorgRPEScale                                              DSRBasicCodedEntry("122734", "DCM", "Borg RPE Scale")
#define CODE_DCM_BorgCR10Scale                                             DSRBasicCodedEntry("122735", "DCM", "Borg CR10 Scale")
#define CODE_DCM_OverallStudyQuality                                       DSRBasicCodedEntry("122739", "DCM", "Overall study quality")
#define CODE_DCM_ExcellentImageQuality                                     DSRBasicCodedEntry("122740", "DCM", "Excellent image quality")
#define CODE_DCM_GoodImageQuality                                          DSRBasicCodedEntry("122741", "DCM", "Good image quality")
#define CODE_DCM_PoorImageQuality                                          DSRBasicCodedEntry("122742", "DCM", "Poor image quality")
#define CODE_DCM_BodyHabitusAttenuation                                    DSRBasicCodedEntry("122743", "DCM", "Body habitus attenuation")
#define CODE_DCM_BreastAttenuation                                         DSRBasicCodedEntry("122744", "DCM", "Breast attenuation")
#define CODE_DCM_DiaphragmaticAttenuation                                  DSRBasicCodedEntry("122745", "DCM", "Diaphragmatic attenuation")
#define CODE_DCM_FalsePositiveDefectFinding                                DSRBasicCodedEntry("122748", "DCM", "False positive defect finding")
#define CODE_DCM_NonDiagnostic_lowHeartRate                                DSRBasicCodedEntry("122750", "DCM", "Non-diagnostic - low heart rate")
#define CODE_DCM_NonDiagnostic_restingSTAbnormalities                      DSRBasicCodedEntry("122751", "DCM", "Non-diagnostic - resting ST abnormalities")
#define CODE_DCM_NonDiagnostic_ventricularPacingOrLBBB                     DSRBasicCodedEntry("122752", "DCM", "Non-diagnostic - ventricular pacing or LBBB")
#define CODE_DCM_NonDiagnosticECG                                          DSRBasicCodedEntry("122753", "DCM", "Non-diagnostic ECG")
#define CODE_DCM_StronglyPositive                                          DSRBasicCodedEntry("122755", "DCM", "Strongly positive")
#define CODE_DCM_StronglyPositive_STElevation                              DSRBasicCodedEntry("122756", "DCM", "Strongly positive - ST elevation")
#define CODE_DCM_STDepression_Horizontal                                   DSRBasicCodedEntry("122757", "DCM", "ST Depression - Horizontal")
#define CODE_DCM_STDepression_Upsloping                                    DSRBasicCodedEntry("122758", "DCM", "ST Depression - Upsloping")
#define CODE_DCM_STDepression_Downsloping                                  DSRBasicCodedEntry("122759", "DCM", "ST Depression - Downsloping")
#define CODE_DCM_StressTestScore                                           DSRBasicCodedEntry("122760", "DCM", "Stress test score")
#define CODE_DCM_NumberOfDiseasedVesselTerritories                         DSRBasicCodedEntry("122762", "DCM", "Number of diseased vessel territories")
#define CODE_DCM_WeightExceedsEquipmentLimit                               DSRBasicCodedEntry("122764", "DCM", "Weight exceeds equipment limit")
#define CODE_DCM_DifferenceInEjectionFraction                              DSRBasicCodedEntry("122768", "DCM", "Difference in Ejection Fraction")
#define CODE_DCM_DifferenceInEDLVVolume                                    DSRBasicCodedEntry("122769", "DCM", "Difference in ED LV Volume")
#define CODE_DCM_RatioOfAchievedToPredictedMaximalOxygenConsumption        DSRBasicCodedEntry("122770", "DCM", "Ratio of achieved to predicted maximal oxygen consumption")
#define CODE_DCM_RatioOfAchievedToPredictedFunctionalCapacity              DSRBasicCodedEntry("122771", "DCM", "Ratio of achieved to predicted functional capacity")
#define CODE_DCM_AerobicIndex                                              DSRBasicCodedEntry("122772", "DCM", "Aerobic index")
#define CODE_DCM_STHRIndex                                                 DSRBasicCodedEntry("122773", "DCM", "ST/HR Index")
#define CODE_DCM_AgreementWithPriorFindings                                DSRBasicCodedEntry("122775", "DCM", "Agreement with prior findings")
#define CODE_DCM_DisagreementWithPriorFindings                             DSRBasicCodedEntry("122776", "DCM", "Disagreement with prior findings")
#define CODE_DCM_RestThalliumStressTechnetiumProcedure                     DSRBasicCodedEntry("122781", "DCM", "Rest thallium/stress technetium procedure")
#define CODE_DCM_RestTechnetiumStressTechnetium1DayProcedure               DSRBasicCodedEntry("122782", "DCM", "Rest technetium/stress technetium 1 day procedure")
#define CODE_DCM_RestTechnetiumStressTechnetium2DayProcedure               DSRBasicCodedEntry("122783", "DCM", "Rest technetium/stress technetium 2 day procedure")
#define CODE_DCM_StressTechnetiumRestTechnetium1DayProcedure               DSRBasicCodedEntry("122784", "DCM", "Stress technetium/rest technetium 1 day procedure")
#define CODE_DCM_NMMyocardialViabilityProcedure                            DSRBasicCodedEntry("122785", "DCM", "NM Myocardial Viability procedure")
#define CODE_DCM_PETMyocardialPerfusion_RestOnly                           DSRBasicCodedEntry("122791", "DCM", "PET Myocardial Perfusion, Rest only")
#define CODE_DCM_PETMyocardialPerfusion_StressOnly                         DSRBasicCodedEntry("122792", "DCM", "PET Myocardial Perfusion, Stress only")
#define CODE_DCM_PETMyocardialPerfusion_RestAndStress                      DSRBasicCodedEntry("122793", "DCM", "PET Myocardial Perfusion, Rest and Stress")
#define CODE_DCM_PETMyocardialViability_RestOnly                           DSRBasicCodedEntry("122795", "DCM", "PET Myocardial Viability, Rest only")
#define CODE_DCM_PETMyocardialViability_StressOnly                         DSRBasicCodedEntry("122796", "DCM", "PET Myocardial Viability, Stress only")
#define CODE_DCM_PETMyocardialViability_RestAndStress                      DSRBasicCodedEntry("122797", "DCM", "PET Myocardial Viability, Rest and Stress")
#define CODE_DCM_AnginalEquivalent                                         DSRBasicCodedEntry("122799", "DCM", "Anginal Equivalent")
#define CODE_DCM_RETIRED_Radiopharmaceutical                               DSRBasicCodedEntry("123001", "DCM", "Radiopharmaceutical")
#define CODE_DCM_RadiopharmaceuticalStartDateTime                          DSRBasicCodedEntry("123003", "DCM", "Radiopharmaceutical Start DateTime")
#define CODE_DCM_RadiopharmaceuticalStopDateTime                           DSRBasicCodedEntry("123004", "DCM", "Radiopharmaceutical Stop DateTime")
#define CODE_DCM_RadiopharmaceuticalVolume                                 DSRBasicCodedEntry("123005", "DCM", "Radiopharmaceutical Volume")
#define CODE_DCM_RadionuclideTotalDose                                     DSRBasicCodedEntry("123006", "DCM", "Radionuclide Total Dose")
#define CODE_DCM_RadiopharmaceuticalSpecificActivity                       DSRBasicCodedEntry("123007", "DCM", "Radiopharmaceutical Specific Activity")
#define CODE_DCM_RadionuclideSyringeCounts                                 DSRBasicCodedEntry("123009", "DCM", "Radionuclide Syringe Counts")
#define CODE_DCM_RadionuclideResidualSyringeCounts                         DSRBasicCodedEntry("123010", "DCM", "Radionuclide Residual Syringe Counts")
#define CODE_DCM_ContrastBolusAgent                                        DSRBasicCodedEntry("123011", "DCM", "Contrast/Bolus Agent")
#define CODE_DCM_PreMedication                                             DSRBasicCodedEntry("123012", "DCM", "Pre-Medication")
#define CODE_DCM_TargetRegion                                              DSRBasicCodedEntry("123014", "DCM", "Target Region")
#define CODE_DCM_ImagingDirection                                          DSRBasicCodedEntry("123015", "DCM", "Imaging Direction")
#define CODE_DCM_ImagingConditions                                         DSRBasicCodedEntry("123016", "DCM", "Imaging Conditions")
#define CODE_DCM_Caudal10DegreeDistalCranioproximalOblique                 DSRBasicCodedEntry("123019", "DCM", "Caudal 10 degree distal-cranioproximal oblique")
#define CODE_DCM_NeighborhoodAnalysis                                      DSRBasicCodedEntry("123101", "DCM", "Neighborhood Analysis")
#define CODE_DCM_AdaptiveFiltering                                         DSRBasicCodedEntry("123102", "DCM", "Adaptive Filtering")
#define CODE_DCM_EdgeDetection                                             DSRBasicCodedEntry("123103", "DCM", "Edge Detection")
#define CODE_DCM_MorphologicalOperations                                   DSRBasicCodedEntry("123104", "DCM", "Morphological Operations")
#define CODE_DCM_HistogramAnalysis                                         DSRBasicCodedEntry("123105", "DCM", "Histogram Analysis")
#define CODE_DCM_MultiScaleResolutionFiltering                             DSRBasicCodedEntry("123106", "DCM", "Multi-Scale/Resolution Filtering")
#define CODE_DCM_ClusterAnalysis                                           DSRBasicCodedEntry("123107", "DCM", "Cluster Analysis")
#define CODE_DCM_MultispectralProcessing                                   DSRBasicCodedEntry("123108", "DCM", "Multispectral Processing")
#define CODE_DCM_ManualProcessing                                          DSRBasicCodedEntry("123109", "DCM", "Manual Processing")
#define CODE_DCM_ArtificialIntelligence                                    DSRBasicCodedEntry("123110", "DCM", "Artificial Intelligence")
#define CODE_DCM_DeformableModels                                          DSRBasicCodedEntry("123111", "DCM", "Deformable Models")
#define CODE_DCM_OBGYNUltrasoundProcedureReport                            DSRBasicCodedEntry("125000", "DCM", "OB-GYN Ultrasound Procedure Report")
#define CODE_DCM_FetalBiometryRatios                                       DSRBasicCodedEntry("125001", "DCM", "Fetal Biometry Ratios")
#define CODE_DCM_FetalBiometry                                             DSRBasicCodedEntry("125002", "DCM", "Fetal Biometry")
#define CODE_DCM_FetalLongBones                                            DSRBasicCodedEntry("125003", "DCM", "Fetal Long Bones")
#define CODE_DCM_FetalCranium                                              DSRBasicCodedEntry("125004", "DCM", "Fetal Cranium")
#define CODE_DCM_BiometryGroup                                             DSRBasicCodedEntry("125005", "DCM", "Biometry Group")
#define CODE_DCM_BiophysicalProfile                                        DSRBasicCodedEntry("125006", "DCM", "Biophysical Profile")
#define CODE_DCM_MeasurementGroup                                          DSRBasicCodedEntry("125007", "DCM", "Measurement Group")
#define CODE_DCM_FetusSummary                                              DSRBasicCodedEntry("125008", "DCM", "Fetus Summary")
#define CODE_DCM_EarlyGestation                                            DSRBasicCodedEntry("125009", "DCM", "Early Gestation")
#define CODE_DCM_Identifier                                                DSRBasicCodedEntry("125010", "DCM", "Identifier")
#define CODE_DCM_PelvisAndUterus                                           DSRBasicCodedEntry("125011", "DCM", "Pelvis and Uterus")
#define CODE_DCM_GrowthPercentileRank                                      DSRBasicCodedEntry("125012", "DCM", "Growth Percentile rank")
#define CODE_DCM_GrowthZScore                                              DSRBasicCodedEntry("125013", "DCM", "Growth Z-score")
#define CODE_DCM_FetusCharacteristics                                      DSRBasicCodedEntry("125015", "DCM", "Fetus Characteristics")
#define CODE_DCM_FetalMeasurements                                         DSRBasicCodedEntry("125016", "DCM", "Fetal Measurements")
#define CODE_DCM_FrameOfReferenceIdentity                                  DSRBasicCodedEntry("125021", "DCM", "Frame of Reference Identity")
#define CODE_DCM_FiducialAlignment                                         DSRBasicCodedEntry("125022", "DCM", "Fiducial Alignment")
#define CODE_DCM_AcquisitionEquipmentAlignment                             DSRBasicCodedEntry("125023", "DCM", "Acquisition Equipment Alignment")
#define CODE_DCM_ImageContentBasedAlignment                                DSRBasicCodedEntry("125024", "DCM", "Image Content-based Alignment")
#define CODE_DCM_VisualAlignment                                           DSRBasicCodedEntry("125025", "DCM", "Visual Alignment")
#define CODE_DCM_ImageContentAndFiducialBasedAlignment                     DSRBasicCodedEntry("125026", "DCM", "Image Content and Fiducial Based Alignment")
#define CODE_DCM_DeformedForRegistration                                   DSRBasicCodedEntry("125027", "DCM", "Deformed for Registration")
#define CODE_DCM_SourceDeformableSpatialRegistration                       DSRBasicCodedEntry("125028", "DCM", "Source Deformable Spatial Registration")
#define CODE_DCM_InterHemisphericPlane                                     DSRBasicCodedEntry("125030", "DCM", "Inter-Hemispheric Plane")
#define CODE_DCM_RightHemisphereMostAnterior                               DSRBasicCodedEntry("125031", "DCM", "Right Hemisphere Most Anterior")
#define CODE_DCM_RightHemisphereMostPosterior                              DSRBasicCodedEntry("125032", "DCM", "Right Hemisphere Most Posterior")
#define CODE_DCM_RightHemisphereMostSuperior                               DSRBasicCodedEntry("125033", "DCM", "Right Hemisphere Most Superior")
#define CODE_DCM_RightHemisphereMostInferior                               DSRBasicCodedEntry("125034", "DCM", "Right Hemisphere Most Inferior")
#define CODE_DCM_LeftHemisphereMostAnterior                                DSRBasicCodedEntry("125035", "DCM", "Left Hemisphere Most Anterior")
#define CODE_DCM_LeftHemisphereMostPosterior                               DSRBasicCodedEntry("125036", "DCM", "Left Hemisphere Most Posterior")
#define CODE_DCM_LeftHemisphereMostSuperior                                DSRBasicCodedEntry("125037", "DCM", "Left Hemisphere Most Superior")
#define CODE_DCM_LeftHemisphereMostInferior                                DSRBasicCodedEntry("125038", "DCM", "Left Hemisphere Most Inferior")
#define CODE_DCM_Background                                                DSRBasicCodedEntry("125040", "DCM", "Background")
#define CODE_DCM_RegistrationInput                                         DSRBasicCodedEntry("125041", "DCM", "Registration Input")
#define CODE_DCM_RETIRED_VascularUltrasoundProcedureReport                 DSRBasicCodedEntry("125100", "DCM", "Vascular Ultrasound Procedure Report")
#define CODE_DCM_VesselBranch                                              DSRBasicCodedEntry("125101", "DCM", "Vessel Branch")
#define CODE_DCM_GraftType                                                 DSRBasicCodedEntry("125102", "DCM", "Graft Type")
#define CODE_DCM_MeasurementOrientation                                    DSRBasicCodedEntry("125105", "DCM", "Measurement Orientation")
#define CODE_DCM_DopplerAngle                                              DSRBasicCodedEntry("125106", "DCM", "Doppler Angle")
#define CODE_DCM_SampleVolumeDepth                                         DSRBasicCodedEntry("125107", "DCM", "Sample Volume Depth")
#define CODE_DCM_PediatricCardiacUltrasoundReport                          DSRBasicCodedEntry("125195", "DCM", "Pediatric Cardiac Ultrasound Report")
#define CODE_DCM_FetalCardiacUltrasoundReport                              DSRBasicCodedEntry("125196", "DCM", "Fetal Cardiac Ultrasound Report")
#define CODE_DCM_AdultCongenitalCardiacUltrasoundReport                    DSRBasicCodedEntry("125197", "DCM", "Adult Congenital Cardiac Ultrasound Report")
#define CODE_DCM_AdultEchocardiographyProcedureReport                      DSRBasicCodedEntry("125200", "DCM", "Adult Echocardiography Procedure Report")
#define CODE_DCM_IllustrationOfFinding                                     DSRBasicCodedEntry("125201", "DCM", "Illustration of Finding")
#define CODE_DCM_LVWallMotionScoreIndex                                    DSRBasicCodedEntry("125202", "DCM", "LV Wall Motion Score Index")
#define CODE_DCM_AcquisitionProtocol                                       DSRBasicCodedEntry("125203", "DCM", "Acquisition Protocol")
#define CODE_DCM_AreaLengthBiplane                                         DSRBasicCodedEntry("125204", "DCM", "Area-length biplane")
#define CODE_DCM_AreaLengthSinglePlane                                     DSRBasicCodedEntry("125205", "DCM", "Area-Length Single Plane")
#define CODE_DCM_Cube                                                      DSRBasicCodedEntry("125206", "DCM", "Cube")
#define CODE_DCM_MethodOfDisks_Biplane                                     DSRBasicCodedEntry("125207", "DCM", "Method of Disks, Biplane")
#define CODE_DCM_MethodOfDisks_SinglePlane                                 DSRBasicCodedEntry("125208", "DCM", "Method of Disks, Single Plane")
#define CODE_DCM_Teichholz                                                 DSRBasicCodedEntry("125209", "DCM", "Teichholz")
#define CODE_DCM_AreaByPressureHalfTime                                    DSRBasicCodedEntry("125210", "DCM", "Area by Pressure Half-Time")
#define CODE_DCM_BiplaneEllipse                                            DSRBasicCodedEntry("125211", "DCM", "Biplane Ellipse")
#define CODE_DCM_ContinuityEquation                                        DSRBasicCodedEntry("125212", "DCM", "Continuity Equation")
#define CODE_DCM_ContinuityEquationByMeanVelocity                          DSRBasicCodedEntry("125213", "DCM", "Continuity Equation by Mean Velocity")
#define CODE_DCM_ContinuityEquationByPeakVelocity                          DSRBasicCodedEntry("125214", "DCM", "Continuity Equation by Peak Velocity")
#define CODE_DCM_ContinuityEquationByVelocityTimeIntegral                  DSRBasicCodedEntry("125215", "DCM", "Continuity Equation by Velocity Time Integral")
#define CODE_DCM_ProximalIsovelocitySurfaceArea                            DSRBasicCodedEntry("125216", "DCM", "Proximal Isovelocity Surface Area")
#define CODE_DCM_FullBernoulli                                             DSRBasicCodedEntry("125217", "DCM", "Full Bernoulli")
#define CODE_DCM_SimplifiedBernoulli                                       DSRBasicCodedEntry("125218", "DCM", "Simplified Bernoulli")
#define CODE_DCM_DopplerVolumeFlow                                         DSRBasicCodedEntry("125219", "DCM", "Doppler Volume Flow")
#define CODE_DCM_Planimetry                                                DSRBasicCodedEntry("125220", "DCM", "Planimetry")
#define CODE_DCM_LeftVentricleMassByMMode                                  DSRBasicCodedEntry("125221", "DCM", "Left Ventricle Mass by M-mode")
#define CODE_DCM_LeftVentricleMassByTruncatedEllipse                       DSRBasicCodedEntry("125222", "DCM", "Left Ventricle Mass by Truncated Ellipse")
#define CODE_DCM_4PointSegmentFindingScale                                 DSRBasicCodedEntry("125223", "DCM", "4 Point Segment Finding Scale")
#define CODE_DCM_5PointSegmentFindingScale                                 DSRBasicCodedEntry("125224", "DCM", "5 Point Segment Finding Scale")
#define CODE_DCM_5PointSegmentFindingScaleWithGradedHypokinesis            DSRBasicCodedEntry("125225", "DCM", "5 Point Segment Finding Scale With Graded Hypokinesis")
#define CODE_DCM_SinglePlaneEllipse                                        DSRBasicCodedEntry("125226", "DCM", "Single Plane Ellipse")
#define CODE_DCM_ModifiedSimpson                                           DSRBasicCodedEntry("125227", "DCM", "Modified Simpson")
#define CODE_DCM_BulletMethod                                              DSRBasicCodedEntry("125228", "DCM", "Bullet Method")
#define CODE_DCM_RETIRED_PowerDoppler                                      DSRBasicCodedEntry("125230", "DCM", "Power Doppler")
#define CODE_DCM_RETIRED_3DMode                                            DSRBasicCodedEntry("125231", "DCM", "3D mode")
#define CODE_DCM_StartOfDrugDoseAdministration                             DSRBasicCodedEntry("125233", "DCM", "Start of drug dose administration")
#define CODE_DCM_StartOfContrastAgentAdministration                        DSRBasicCodedEntry("125234", "DCM", "Start of contrast agent administration")
#define CODE_DCM_DestructionOfMicrobubbles                                 DSRBasicCodedEntry("125235", "DCM", "Destruction of microbubbles")
#define CODE_DCM_OnsetOfExercise                                           DSRBasicCodedEntry("125236", "DCM", "Onset of exercise")
#define CODE_DCM_CessationOfExercise                                       DSRBasicCodedEntry("125237", "DCM", "Cessation of exercise")
#define CODE_DCM_OnsetOfStimulation                                        DSRBasicCodedEntry("125238", "DCM", "Onset of stimulation")
#define CODE_DCM_CessationOfStimulation                                    DSRBasicCodedEntry("125239", "DCM", "Cessation of stimulation")
#define CODE_DCM_LineScanPattern                                           DSRBasicCodedEntry("125240", "DCM", "Line scan pattern")
#define CODE_DCM_PlaneScanPattern                                          DSRBasicCodedEntry("125241", "DCM", "Plane scan pattern")
#define CODE_DCM_VolumeScanPattern                                         DSRBasicCodedEntry("125242", "DCM", "Volume scan pattern")
#define CODE_DCM_NonImagingDopplerUltrasoundTransducerGeometry             DSRBasicCodedEntry("125251", "DCM", "Non-imaging Doppler ultrasound transducer geometry")
#define CODE_DCM_LinearUltrasoundTransducerGeometry                        DSRBasicCodedEntry("125252", "DCM", "Linear ultrasound transducer geometry")
#define CODE_DCM_CurvedLinearUltrasoundTransducerGeometry                  DSRBasicCodedEntry("125253", "DCM", "Curved linear ultrasound transducer geometry")
#define CODE_DCM_SectorUltrasoundTransducerGeometry                        DSRBasicCodedEntry("125254", "DCM", "Sector ultrasound transducer geometry")
#define CODE_DCM_RadialUltrasoundTransducerGeometry                        DSRBasicCodedEntry("125255", "DCM", "Radial ultrasound transducer geometry")
#define CODE_DCM_RingUltrasoundTransducerGeometry                          DSRBasicCodedEntry("125256", "DCM", "Ring ultrasound transducer geometry")
#define CODE_DCM_FixedBeamDirection                                        DSRBasicCodedEntry("125257", "DCM", "Fixed beam direction")
#define CODE_DCM_MechanicalBeamSteering                                    DSRBasicCodedEntry("125258", "DCM", "Mechanical beam steering")
#define CODE_DCM_PhasedBeamSteering                                        DSRBasicCodedEntry("125259", "DCM", "Phased beam steering")
#define CODE_DCM_ExternalTransducer                                        DSRBasicCodedEntry("125261", "DCM", "External Transducer")
#define CODE_DCM_TransesophagealTransducer                                 DSRBasicCodedEntry("125262", "DCM", "Transesophageal Transducer")
#define CODE_DCM_EndovaginalTransducer                                     DSRBasicCodedEntry("125263", "DCM", "Endovaginal Transducer")
#define CODE_DCM_EndorectalTransducer                                      DSRBasicCodedEntry("125264", "DCM", "Endorectal Transducer")
#define CODE_DCM_IntravascularTransducer                                   DSRBasicCodedEntry("125265", "DCM", "Intravascular Transducer")
#define CODE_DCM_LeftVentricleMassByAreaLength                             DSRBasicCodedEntry("125270", "DCM", "Left Ventricle Mass by Area Length")
#define CODE_DCM_LeftVentricleMassByMMode_adjustedByHeight                 DSRBasicCodedEntry("125271", "DCM", "Left Ventricle Mass by M-mode - adjusted by Height")
#define CODE_DCM_LeftVentricleMassByTruncatedEllipse_adjustedByHeight      DSRBasicCodedEntry("125272", "DCM", "Left Ventricle Mass by Truncated Ellipse - adjusted by Height")
#define CODE_DCM_LeftVentricleMassByAreaLength_adjustedByHeight            DSRBasicCodedEntry("125273", "DCM", "Left Ventricle Mass by Area Length - adjusted by Height")
#define CODE_DCM_PreCoordinatedMeasurements                                DSRBasicCodedEntry("125301", "DCM", "Pre-coordinated Measurements")
#define CODE_DCM_PostCoordinatedMeasurements                               DSRBasicCodedEntry("125302", "DCM", "Post-coordinated Measurements")
#define CODE_DCM_AdhocMeasurements                                         DSRBasicCodedEntry("125303", "DCM", "Adhoc Measurements")
#define CODE_DCM_UntrackableMeasurement                                    DSRBasicCodedEntry("125304", "DCM", "Untrackable Measurement")
#define CODE_DCM_FindingObservationType                                    DSRBasicCodedEntry("125305", "DCM", "Finding Observation Type")
#define CODE_DCM_MeasurementType                                           DSRBasicCodedEntry("125306", "DCM", "Measurement Type")
#define CODE_DCM_MeasuredProperty                                          DSRBasicCodedEntry("125307", "DCM", "Measured Property")
#define CODE_DCM_MeasurementDivisor                                        DSRBasicCodedEntry("125308", "DCM", "Measurement Divisor")
#define CODE_DCM_ShortLabel                                                DSRBasicCodedEntry("125309", "DCM", "Short Label")
#define CODE_DCM_StagedMeasurements                                        DSRBasicCodedEntry("125310", "DCM", "Staged Measurements")
#define CODE_DCM_StructureOfTheFindingSite                                 DSRBasicCodedEntry("125311", "DCM", "Structure of the Finding Site")
#define CODE_DCM_BehaviorOfTheFindingSite                                  DSRBasicCodedEntry("125312", "DCM", "Behavior of the Finding Site")
#define CODE_DCM_Indexed                                                   DSRBasicCodedEntry("125313", "DCM", "Indexed")
#define CODE_DCM_FractionalChange                                          DSRBasicCodedEntry("125314", "DCM", "Fractional Change")
#define CODE_DCM_Calculated                                                DSRBasicCodedEntry("125315", "DCM", "Calculated")
#define CODE_DCM_DirectlyMeasured                                          DSRBasicCodedEntry("125316", "DCM", "Directly measured")
#define CODE_DCM_RightVentricleOutflowTract_Distal                         DSRBasicCodedEntry("125317", "DCM", "Right Ventricle Outflow Tract, Distal")
#define CODE_DCM_RightVentricleOutflowTract_Proximal                       DSRBasicCodedEntry("125318", "DCM", "Right Ventricle Outflow Tract, Proximal")
#define CODE_DCM_RightVentricleAnteriorWall                                DSRBasicCodedEntry("125319", "DCM", "Right Ventricle Anterior Wall")
#define CODE_DCM_ElectromechanicalDelay                                    DSRBasicCodedEntry("125320", "DCM", "Electromechanical Delay")
#define CODE_DCM_PreEjectionPeriod                                         DSRBasicCodedEntry("125321", "DCM", "Pre-ejection Period")
#define CODE_DCM_AtrialDiastolicFilling_DWave                              DSRBasicCodedEntry("125322", "DCM", "Atrial Diastolic Filling (D-wave)")
#define CODE_DCM_ARWave                                                    DSRBasicCodedEntry("125323", "DCM", "AR-wave")
#define CODE_DCM_FullCardiacCycle                                          DSRBasicCodedEntry("125324", "DCM", "Full Cardiac Cycle")
#define CODE_DCM_DyssynchronyIndex                                         DSRBasicCodedEntry("125325", "DCM", "Dyssynchrony Index")
#define CODE_DCM_EffectiveOrificeArea                                      DSRBasicCodedEntry("125326", "DCM", "Effective Orifice Area")
#define CODE_DCM_ExcursionDistance                                         DSRBasicCodedEntry("125327", "DCM", "Excursion Distance")
#define CODE_DCM_MaximumOrificeArea                                        DSRBasicCodedEntry("125328", "DCM", "Maximum Orifice Area")
#define CODE_DCM_PeakBloodPressure                                         DSRBasicCodedEntry("125329", "DCM", "Peak Blood Pressure")
#define CODE_DCM_PeakTissueVelocity                                        DSRBasicCodedEntry("125330", "DCM", "Peak Tissue Velocity")
#define CODE_DCM_PISARadius                                                DSRBasicCodedEntry("125331", "DCM", "PISA Radius")
#define CODE_DCM_RegurgitationJetArea                                      DSRBasicCodedEntry("125332", "DCM", "Regurgitation Jet Area")
#define CODE_DCM_RegurgitationJetWidth                                     DSRBasicCodedEntry("125333", "DCM", "Regurgitation Jet Width")
#define CODE_DCM_VenaContractaWidth                                        DSRBasicCodedEntry("125334", "DCM", "Vena Contracta Width")
#define CODE_DCM_CARDIOsphere                                              DSRBasicCodedEntry("125901", "DCM", "CARDIOsphere")
#define CODE_DCM_Echovist                                                  DSRBasicCodedEntry("125902", "DCM", "Echovist")
#define CODE_DCM_Imagify                                                   DSRBasicCodedEntry("125903", "DCM", "Imagify")
#define CODE_DCM_Levovist                                                  DSRBasicCodedEntry("125904", "DCM", "Levovist")
#define CODE_DCM_Sonazoid                                                  DSRBasicCodedEntry("125905", "DCM", "Sonazoid")
#define CODE_DCM_SonoVue                                                   DSRBasicCodedEntry("125906", "DCM", "SonoVue")
#define CODE_DCM_TargestarB                                                DSRBasicCodedEntry("125907", "DCM", "Targestar-B")
#define CODE_DCM_TargestarP                                                DSRBasicCodedEntry("125908", "DCM", "Targestar-P")
#define CODE_DCM_ImagingMeasurementReport                                  DSRBasicCodedEntry("126000", "DCM", "Imaging Measurement Report")
#define CODE_DCM_OncologyMeasurementReport                                 DSRBasicCodedEntry("126001", "DCM", "Oncology Measurement Report")
#define CODE_DCM_DynamicContrastMRMeasurementReport                        DSRBasicCodedEntry("126002", "DCM", "Dynamic Contrast MR Measurement Report")
#define CODE_DCM_PETMeasurementReport                                      DSRBasicCodedEntry("126003", "DCM", "PET Measurement Report")
#define CODE_DCM_ImagingMeasurements                                       DSRBasicCodedEntry("126010", "DCM", "Imaging Measurements")
#define CODE_DCM_DerivedImagingMeasurements                                DSRBasicCodedEntry("126011", "DCM", "Derived Imaging Measurements")
#define CODE_DCM_MultiparametricMRI                                        DSRBasicCodedEntry("126020", "DCM", "Multiparametric MRI")
#define CODE_DCM_RETIRED_MultiparametricMRIOfProstate                      DSRBasicCodedEntry("126021", "DCM", "Multiparametric MRI of prostate")
#define CODE_DCM_MultiparametricMRIOfWholeBody                             DSRBasicCodedEntry("126022", "DCM", "Multiparametric MRI of whole body")
#define CODE_DCM_LWHMethodForVolumeOfEllipsoid                             DSRBasicCodedEntry("126029", "DCM", "LWH method for volume of ellipsoid")
#define CODE_DCM_SumOfSegmentedVoxelMethodForVolume                        DSRBasicCodedEntry("126030", "DCM", "Sum of segmented voxel method for volume")
#define CODE_DCM_PeakValueWithinROI                                        DSRBasicCodedEntry("126031", "DCM", "Peak Value Within ROI")
#define CODE_DCM_MetabolicVolume                                           DSRBasicCodedEntry("126032", "DCM", "Metabolic Volume")
#define CODE_DCM_TotalLesionGlycolysis                                     DSRBasicCodedEntry("126033", "DCM", "Total Lesion Glycolysis")
#define CODE_DCM_Glycolysis                                                DSRBasicCodedEntry("126034", "DCM", "Glycolysis")
#define CODE_DCM_TotalLesionProliferation                                  DSRBasicCodedEntry("126035", "DCM", "Total Lesion Proliferation")
#define CODE_DCM_ProliferativeActivity                                     DSRBasicCodedEntry("126036", "DCM", "Proliferative Activity")
#define CODE_DCM_StandardizedAddedMetabolicActivity_SAM                    DSRBasicCodedEntry("126037", "DCM", "Standardized Added Metabolic Activity (SAM)")
#define CODE_DCM_StandardizedAddedMetabolicActivity_SAM_Background         DSRBasicCodedEntry("126038", "DCM", "Standardized Added Metabolic Activity (SAM) Background")
#define CODE_DCM_LesionToBackgroundSUVRatio                                DSRBasicCodedEntry("126039", "DCM", "Lesion to Background SUV Ratio")
#define CODE_DCM_BackgroundForLesionToBackgroundSUVRatio                   DSRBasicCodedEntry("126040", "DCM", "Background for Lesion to Background SUV Ratio")
#define CODE_DCM_FractalDimension                                          DSRBasicCodedEntry("126050", "DCM", "Fractal Dimension")
#define CODE_DCM_Skewness                                                  DSRBasicCodedEntry("126051", "DCM", "Skewness")
#define CODE_DCM_Kurtosis                                                  DSRBasicCodedEntry("126052", "DCM", "Kurtosis")
#define CODE_DCM_RETIRED_JointEntropyOfGLCM                                DSRBasicCodedEntry("126060", "DCM", "Joint Entropy of GLCM")
#define CODE_DCM_RootAngularSecondMomentOfGLCM                             DSRBasicCodedEntry("126061", "DCM", "Root Angular Second Moment of GLCM")
#define CODE_DCM_InverseDifferenceMomentOfGLCM                             DSRBasicCodedEntry("126062", "DCM", "Inverse Difference Moment of GLCM")
#define CODE_DCM_ContrastOfGLCM                                            DSRBasicCodedEntry("126063", "DCM", "Contrast of GLCM")
#define CODE_DCM_DissimilarityOfGLCM                                       DSRBasicCodedEntry("126064", "DCM", "Dissimilarity of GLCM")
#define CODE_DCM_AngularSecondMomentOfGLCM                                 DSRBasicCodedEntry("126065", "DCM", "Angular Second Moment of GLCM")
#define CODE_DCM_CorrelationOfGLCM                                         DSRBasicCodedEntry("126066", "DCM", "Correlation of GLCM")
#define CODE_DCM_GrayLevelCoOccurrenceMatrix                               DSRBasicCodedEntry("126067", "DCM", "Gray Level Co-occurrence Matrix")
#define CODE_DCM_SubjectTimePointIdentifier                                DSRBasicCodedEntry("126070", "DCM", "Subject Time Point Identifier")
#define CODE_DCM_ProtocolTimePointIdentifier                               DSRBasicCodedEntry("126071", "DCM", "Protocol Time Point Identifier")
#define CODE_DCM_TimePointType                                             DSRBasicCodedEntry("126072", "DCM", "Time Point Type")
#define CODE_DCM_TimePointOrder                                            DSRBasicCodedEntry("126073", "DCM", "Time Point Order")
#define CODE_DCM_Posttreatment                                             DSRBasicCodedEntry("126074", "DCM", "Posttreatment")
#define CODE_DCM_Eligibility                                               DSRBasicCodedEntry("126075", "DCM", "Eligibility")
#define CODE_DCM_RECIST1dot0                                               DSRBasicCodedEntry("126080", "DCM", "RECIST 1.0")
#define CODE_DCM_RECIST1dot1                                               DSRBasicCodedEntry("126081", "DCM", "RECIST 1.1")
#define CODE_DCM_RealWorldValueMapUsedForMeasurement                       DSRBasicCodedEntry("126100", "DCM", "Real World Value Map used for measurement")
#define CODE_DCM_ImageLibraryGroup                                         DSRBasicCodedEntry("126200", "DCM", "Image Library Group")
#define CODE_DCM_AcquisitionDate                                           DSRBasicCodedEntry("126201", "DCM", "Acquisition Date")
#define CODE_DCM_AcquisitionTime                                           DSRBasicCodedEntry("126202", "DCM", "Acquisition Time")
#define CODE_DCM_PETRadionuclideIncubationTime                             DSRBasicCodedEntry("126203", "DCM", "PET Radionuclide Incubation Time")
#define CODE_DCM_R2Coefficient                                             DSRBasicCodedEntry("126220", "DCM", "R2-Coefficient")
#define CODE_DCM_ChiSquare                                                 DSRBasicCodedEntry("126221", "DCM", "Chi-square")
#define CODE_DCM_DW                                                        DSRBasicCodedEntry("126222", "DCM", "D-W")
#define CODE_DCM_AIC                                                       DSRBasicCodedEntry("126223", "DCM", "AIC")
#define CODE_DCM_BIC                                                       DSRBasicCodedEntry("126224", "DCM", "BIC")
#define CODE_DCM_PerfusionAnalysisByStableXenonCTTechnique                 DSRBasicCodedEntry("126300", "DCM", "Perfusion analysis by Stable Xenon CT technique")
#define CODE_DCM_PerfusionAnalysisByIVIodinatedContrastCTTechnique         DSRBasicCodedEntry("126301", "DCM", "Perfusion analysis by IV Iodinated Contrast CT technique")
#define CODE_DCM_PerfusionAnalysisByArterialSpinLabelingMRTechnique        DSRBasicCodedEntry("126302", "DCM", "Perfusion analysis by Arterial Spin Labeling MR technique")
#define CODE_DCM_PerfusionAnalysisBySusceptibilityMRTechnique              DSRBasicCodedEntry("126303", "DCM", "Perfusion analysis by Susceptibility MR technique")
#define CODE_DCM_LeastMeanSquare_LMS_deconvolution                         DSRBasicCodedEntry("126310", "DCM", "Least Mean Square (LMS) deconvolution")
#define CODE_DCM_SingularValueDecomposition_SVD_deconvolution              DSRBasicCodedEntry("126311", "DCM", "Singular Value Decomposition (SVD) deconvolution")
#define CODE_DCM_Ktrans                                                    DSRBasicCodedEntry("126312", "DCM", "Ktrans")
#define CODE_DCM_Kep                                                       DSRBasicCodedEntry("126313", "DCM", "kep")
#define CODE_DCM_Ve                                                        DSRBasicCodedEntry("126314", "DCM", "ve")
#define CODE_DCM_IAUC                                                      DSRBasicCodedEntry("126320", "DCM", "IAUC")
#define CODE_DCM_IAUC60                                                    DSRBasicCodedEntry("126321", "DCM", "IAUC60")
#define CODE_DCM_IAUC90                                                    DSRBasicCodedEntry("126322", "DCM", "IAUC90")
#define CODE_DCM_IAUC180                                                   DSRBasicCodedEntry("126323", "DCM", "IAUC180")
#define CODE_DCM_IAUCBN                                                    DSRBasicCodedEntry("126324", "DCM", "IAUCBN")
#define CODE_DCM_IAUCBN60                                                  DSRBasicCodedEntry("126325", "DCM", "IAUCBN60")
#define CODE_DCM_IAUCBN90                                                  DSRBasicCodedEntry("126326", "DCM", "IAUCBN90")
#define CODE_DCM_AUCBN180                                                  DSRBasicCodedEntry("126327", "DCM", "AUCBN180")
#define CODE_DCM_Tau_m                                                     DSRBasicCodedEntry("126330", "DCM", "tau_m")
#define CODE_DCM_Vp                                                        DSRBasicCodedEntry("126331", "DCM", "vp")
#define CODE_DCM_StandardToftsModel                                        DSRBasicCodedEntry("126340", "DCM", "Standard Tofts Model")
#define CODE_DCM_ExtendedToftsModel                                        DSRBasicCodedEntry("126341", "DCM", "Extended Tofts Model")
#define CODE_DCM_ModelFreeConcentrationTimeQuantitification                DSRBasicCodedEntry("126342", "DCM", "Model-free concentration-time quantitification")
#define CODE_DCM_FirstPassLeakageProfile_FPLP_Model                        DSRBasicCodedEntry("126343", "DCM", "First Pass Leakage Profile (FPLP) Model")
#define CODE_DCM_ShutterSpeedModel_SSM                                     DSRBasicCodedEntry("126344", "DCM", "Shutter-Speed Model (SSM)")
#define CODE_DCM_GammaCapillaryTransitTime_GCCT_Model                      DSRBasicCodedEntry("126345", "DCM", "Gamma Capillary Transit Time (GCCT) Model")
#define CODE_DCM_AdiabaticTissueHomogeneity_ATH_Model                      DSRBasicCodedEntry("126346", "DCM", "Adiabatic Tissue Homogeneity (ATH) Model")
#define CODE_DCM_TwoCompartmentExchange_2CX_Model                          DSRBasicCodedEntry("126347", "DCM", "Two Compartment Exchange (2CX) Model")
#define CODE_DCM_T1ByMultipleFlipAngles                                    DSRBasicCodedEntry("126350", "DCM", "T1 by Multiple Flip Angles")
#define CODE_DCM_T1ByInversionRecovery                                     DSRBasicCodedEntry("126351", "DCM", "T1 by Inversion Recovery")
#define CODE_DCM_T1ByFixedValue                                            DSRBasicCodedEntry("126352", "DCM", "T1 by Fixed Value")
#define CODE_DCM_T1UsedForCalculation                                      DSRBasicCodedEntry("126353", "DCM", "T1 Used For Calculation")
#define CODE_DCM_AIFIgnored                                                DSRBasicCodedEntry("126360", "DCM", "AIF Ignored")
#define CODE_DCM_PopulationAveragedAIF                                     DSRBasicCodedEntry("126361", "DCM", "Population Averaged AIF")
#define CODE_DCM_UserDefinedAIFROI                                         DSRBasicCodedEntry("126362", "DCM", "User-defined AIF ROI")
#define CODE_DCM_AutomaticallyDetectedAIFROI                               DSRBasicCodedEntry("126363", "DCM", "Automatically Detected AIF ROI")
#define CODE_DCM_BlindEstimationOfAIF                                      DSRBasicCodedEntry("126364", "DCM", "Blind Estimation of AIF")
#define CODE_DCM_TimeOfPeakConcentration                                   DSRBasicCodedEntry("126370", "DCM", "Time of Peak Concentration")
#define CODE_DCM_BolusArrivalTime                                          DSRBasicCodedEntry("126371", "DCM", "Bolus Arrival Time")
#define CODE_DCM_TimeOfLeadingHalfPeakConcentration                        DSRBasicCodedEntry("126372", "DCM", "Time of Leading Half-Peak Concentration")
#define CODE_DCM_TemporalDerivativeExceedsThreshold                        DSRBasicCodedEntry("126373", "DCM", "Temporal Derivative Exceeds Threshold")
#define CODE_DCM_TemporalDerivativeThreshold                               DSRBasicCodedEntry("126374", "DCM", "Temporal Derivative Threshold")
#define CODE_DCM_MaximumSlope                                              DSRBasicCodedEntry("126375", "DCM", "Maximum Slope")
#define CODE_DCM_MaximumDifference                                         DSRBasicCodedEntry("126376", "DCM", "Maximum Difference")
#define CODE_DCM_TracerConcentration                                       DSRBasicCodedEntry("126377", "DCM", "Tracer Concentration")
#define CODE_DCM_ContrastLongitudinalRelaxivity                            DSRBasicCodedEntry("126380", "DCM", "Contrast Longitudinal Relaxivity")
#define CODE_DCM_AbsoluteRegionalBloodFlow                                 DSRBasicCodedEntry("126390", "DCM", "Absolute Regional Blood Flow")
#define CODE_DCM_AbsoluteRegionalBloodVolume                               DSRBasicCodedEntry("126391", "DCM", "Absolute Regional Blood Volume")
#define CODE_DCM_OxygenExtractionFraction                                  DSRBasicCodedEntry("126392", "DCM", "Oxygen Extraction Fraction")
#define CODE_DCM_R1                                                        DSRBasicCodedEntry("126393", "DCM", "R1")
#define CODE_DCM_R2                                                        DSRBasicCodedEntry("126394", "DCM", "R2")
#define CODE_DCM_R2Star                                                    DSRBasicCodedEntry("126395", "DCM", "R2*")
#define CODE_DCM_MagneticSusceptibility                                    DSRBasicCodedEntry("126396", "DCM", "Magnetic Susceptibility")
#define CODE_DCM_RelativeRegionalBloodFlow                                 DSRBasicCodedEntry("126397", "DCM", "Relative Regional Blood Flow")
#define CODE_DCM_RelativeRegionalBloodVolume                               DSRBasicCodedEntry("126398", "DCM", "Relative Regional Blood Volume")
#define CODE_DCM_StandardizedUptakeValue                                   DSRBasicCodedEntry("126400", "DCM", "Standardized Uptake Value")
#define CODE_DCM_SUVbw                                                     DSRBasicCodedEntry("126401", "DCM", "SUVbw")
#define CODE_DCM_SUVlbm                                                    DSRBasicCodedEntry("126402", "DCM", "SUVlbm")
#define CODE_DCM_SUVbsa                                                    DSRBasicCodedEntry("126403", "DCM", "SUVbsa")
#define CODE_DCM_SUVibw                                                    DSRBasicCodedEntry("126404", "DCM", "SUVibw")
#define CODE_DCM_SUVlbmJanma                                               DSRBasicCodedEntry("126405", "DCM", "SUVlbm(Janma)")
#define CODE_DCM_SUVlbmJames128                                            DSRBasicCodedEntry("126406", "DCM", "SUVlbm(James128)")
#define CODE_DCM_SUVBodyWeightCalculationMethod                            DSRBasicCodedEntry("126410", "DCM", "SUV body weight calculation method")
#define CODE_DCM_SUVLeanBodyMassCalculationMethod                          DSRBasicCodedEntry("126411", "DCM", "SUV lean body mass calculation method")
#define CODE_DCM_SUVBodySurfaceAreaCalculationMethod                       DSRBasicCodedEntry("126412", "DCM", "SUV body surface area calculation method")
#define CODE_DCM_SUVIdealBodyWeightCalculationMethod                       DSRBasicCodedEntry("126413", "DCM", "SUV ideal body weight calculation method")
#define CODE_DCM_SUVLeanBodyMassCalculationJanmahasatianMethod             DSRBasicCodedEntry("126414", "DCM", "SUV lean body mass calculation Janmahasatian method")
#define CODE_DCM_SUVLeanBodyMassCalculationMethodUsing128Multiplier        DSRBasicCodedEntry("126415", "DCM", "SUV lean body mass calculation method using 128 multiplier")
#define CODE_DCM_PittsburghCompoundB_C11                                   DSRBasicCodedEntry("126500", "DCM", "Pittsburgh compound B C^11^")
#define CODE_DCM_Florbetaben_F18                                           DSRBasicCodedEntry("126501", "DCM", "Florbetaben F^18^")
#define CODE_DCM_T807_F18                                                  DSRBasicCodedEntry("126502", "DCM", "T807 F^18^")
#define CODE_DCM_Flubatine_F18                                             DSRBasicCodedEntry("126503", "DCM", "Flubatine F^18^")
#define CODE_DCM_Lutetium177NAcetylaspartylglutamate                       DSRBasicCodedEntry("126509", "DCM", "Lutetium^177^ n-acetylaspartylglutamate")
#define CODE_DCM_MonoclonalAntibody_mAb_64Cu                               DSRBasicCodedEntry("126510", "DCM", "Monoclonal Antibody (mAb) ^64^Cu")
#define CODE_DCM_MonoclonalAntibody_mAb_89Zr                               DSRBasicCodedEntry("126511", "DCM", "Monoclonal Antibody (mAb) ^89^Zr")
#define CODE_DCM_Trastuzumab_89Zr                                          DSRBasicCodedEntry("126512", "DCM", "Trastuzumab ^89^Zr")
#define CODE_DCM_Cetuximab_89Zr                                            DSRBasicCodedEntry("126513", "DCM", "Cetuximab ^89^Zr")
#define CODE_DCM_J591_89Zr                                                 DSRBasicCodedEntry("126514", "DCM", "J591 ^89^Zr")
#define CODE_DCM_CU36_89Zr                                                 DSRBasicCodedEntry("126515", "DCM", "cU36 ^89^Zr")
#define CODE_DCM_Bevacizumab_89Zr                                          DSRBasicCodedEntry("126516", "DCM", "Bevacizumab ^89^Zr")
#define CODE_DCM_CG250Fab2_89Zr                                            DSRBasicCodedEntry("126517", "DCM", "cG250-F(ab')(2) ^89^Zr")
#define CODE_DCM_R1507_89Zr                                                DSRBasicCodedEntry("126518", "DCM", "R1507 ^89^Zr")
#define CODE_DCM_E4G10_89Zr                                                DSRBasicCodedEntry("126519", "DCM", "E4G10 ^89^Zr")
#define CODE_DCM_DfCD45_89Zr                                               DSRBasicCodedEntry("126520", "DCM", "Df-CD45 ^89^Zr")
#define CODE_DCM_44Scandium                                                DSRBasicCodedEntry("126600", "DCM", "^44^Scandium")
#define CODE_DCM_51Manganese                                               DSRBasicCodedEntry("126601", "DCM", "^51^Manganese")
#define CODE_DCM_70Arsenic                                                 DSRBasicCodedEntry("126602", "DCM", "^70^Arsenic")
#define CODE_DCM_90Niobium                                                 DSRBasicCodedEntry("126603", "DCM", "^90^Niobium")
#define CODE_DCM_191mIridium                                               DSRBasicCodedEntry("126604", "DCM", "^191m^Iridium")
#define CODE_DCM_43Scandium                                                DSRBasicCodedEntry("126605", "DCM", "^43^Scandium")
#define CODE_DCM_152Terbium                                                DSRBasicCodedEntry("126606", "DCM", "^152^Terbium")
#define CODE_DCM_52mManganese                                              DSRBasicCodedEntry("126607", "DCM", "^52m^Manganese")
#define CODE_DCM_ATSM_Cu60                                                 DSRBasicCodedEntry("126700", "DCM", "ATSM Cu^60^")
#define CODE_DCM_ATSM_Cu61                                                 DSRBasicCodedEntry("126701", "DCM", "ATSM Cu^61^")
#define CODE_DCM_ATSM_Cu62                                                 DSRBasicCodedEntry("126702", "DCM", "ATSM Cu^62^")
#define CODE_DCM_Choline_C11                                               DSRBasicCodedEntry("126703", "DCM", "Choline C^11^")
#define CODE_DCM_Fallypride_C11                                            DSRBasicCodedEntry("126704", "DCM", "Fallypride C^11^")
#define CODE_DCM_Fallypride_F18                                            DSRBasicCodedEntry("126705", "DCM", "Fallypride F^18^")
#define CODE_DCM_FLB457_C11                                                DSRBasicCodedEntry("126706", "DCM", "FLB 457 C^11^")
#define CODE_DCM_Fluorotriopride_F18                                       DSRBasicCodedEntry("126707", "DCM", "Fluorotriopride F^18^")
#define CODE_DCM_Fluoromisonidazole_FMISO_F18                              DSRBasicCodedEntry("126708", "DCM", "Fluoromisonidazole (FMISO) F^18^")
#define CODE_DCM_Glutamine_C11                                             DSRBasicCodedEntry("126709", "DCM", "Glutamine C^11^")
#define CODE_DCM_Glutamine_C14                                             DSRBasicCodedEntry("126710", "DCM", "Glutamine C^14^")
#define CODE_DCM_Glutamine_F18                                             DSRBasicCodedEntry("126711", "DCM", "Glutamine F^18^")
#define CODE_DCM_RETIRED_Flubatine_F18                                     DSRBasicCodedEntry("126712", "DCM", "Flubatine F^18^")
#define CODE_DCM_2FA_F18                                                   DSRBasicCodedEntry("126713", "DCM", "2FA F^18^")
#define CODE_DCM_Nifene_F18                                                DSRBasicCodedEntry("126714", "DCM", "Nifene F^18^")
#define CODE_DCM_CLR1404_I124                                              DSRBasicCodedEntry("126715", "DCM", "CLR1404 I^124^")
#define CODE_DCM_CLR1404_I131                                              DSRBasicCodedEntry("126716", "DCM", "CLR1404 I^131^")
#define CODE_DCM_RETIRED_THK5351_F18                                       DSRBasicCodedEntry("126717", "DCM", "THK5351 F^18^")
#define CODE_DCM_Flurpiridaz_F18                                           DSRBasicCodedEntry("126718", "DCM", "Flurpiridaz F^18^")
#define CODE_DCM_RO6924963_11C                                             DSRBasicCodedEntry("126719", "DCM", "RO6924963 ^11^C")
#define CODE_DCM_RO6931643_11C                                             DSRBasicCodedEntry("126720", "DCM", "RO6931643 ^11^C")
#define CODE_DCM_Obinituzimab_89Zr                                         DSRBasicCodedEntry("126721", "DCM", "Obinituzimab ^89^Zr")
#define CODE_DCM_Benralizumab_89Zr                                         DSRBasicCodedEntry("126722", "DCM", "Benralizumab ^89^Zr")
#define CODE_DCM_Ocaratuzumab_89Zr                                         DSRBasicCodedEntry("126723", "DCM", "Ocaratuzumab ^89^Zr")
#define CODE_DCM_GlembatumumabVedotin_89Zr                                 DSRBasicCodedEntry("126724", "DCM", "Glembatumumab vedotin ^89^Zr")
#define CODE_DCM_PinatuzumabVedotin_89Zr                                   DSRBasicCodedEntry("126725", "DCM", "Pinatuzumab vedotin ^89^Zr")
#define CODE_DCM_PolatuzumabVedotin_89Zr                                   DSRBasicCodedEntry("126726", "DCM", "Polatuzumab vedotin ^89^Zr")
#define CODE_DCM_Blinatumomab_89Zr                                         DSRBasicCodedEntry("126727", "DCM", "Blinatumomab ^89^Zr")
#define CODE_DCM_Pegdinetanib_89Zr                                         DSRBasicCodedEntry("126728", "DCM", "Pegdinetanib ^89^Zr")
#define CODE_DCM_AGN150998_89Zr                                            DSRBasicCodedEntry("126729", "DCM", "AGN-150998 ^89^Zr")
#define CODE_DCM_MEDI551_89Zr                                              DSRBasicCodedEntry("126730", "DCM", "MEDI-551 ^89^Zr")
#define CODE_DCM_GA201_89Zr                                                DSRBasicCodedEntry("126731", "DCM", "GA201 ^89^Zr")
#define CODE_DCM_Ecromeximab_89Zr                                          DSRBasicCodedEntry("126732", "DCM", "Ecromeximab ^89^Zr")
#define CODE_DCM_Roledumab_89Zr                                            DSRBasicCodedEntry("126733", "DCM", "Roledumab ^89^Zr")
#define CODE_DCM_XmAb5574_89Zr                                             DSRBasicCodedEntry("126734", "DCM", "XmAb5574 ^89^Zr")
#define CODE_DCM_Brentuximab_89Zr                                          DSRBasicCodedEntry("126735", "DCM", "Brentuximab ^89^Zr")
#define CODE_DCM_Panitumumab_89Zr                                          DSRBasicCodedEntry("126736", "DCM", "Panitumumab ^89^Zr")
#define CODE_DCM_Rituximab_89Zr                                            DSRBasicCodedEntry("126737", "DCM", "Rituximab ^89^Zr")
#define CODE_DCM_Mogamulizumab_89Zr                                        DSRBasicCodedEntry("126738", "DCM", "Mogamulizumab ^89^Zr")
#define CODE_DCM_Ublituximab_89Zr                                          DSRBasicCodedEntry("126739", "DCM", "Ublituximab ^89^Zr")
#define CODE_DCM_Margetuximab_89Zr                                         DSRBasicCodedEntry("126740", "DCM", "Margetuximab ^89^Zr")
#define CODE_DCM_SAR3419_89Zr                                              DSRBasicCodedEntry("126741", "DCM", "SAR3419 ^89^Zr")
#define CODE_DCM_Ranibizumab_89Zr                                          DSRBasicCodedEntry("126742", "DCM", "Ranibizumab ^89^Zr")
#define CODE_DCM_CMAbU36_89Zr                                              DSRBasicCodedEntry("126746", "DCM", "cMAb U36 ^89^Zr")
#define CODE_DCM_DN30_89Zr                                                 DSRBasicCodedEntry("126747", "DCM", "DN30 ^89^Zr")
#define CODE_DCM_Fresolimumab_89Zr                                         DSRBasicCodedEntry("126748", "DCM", "Fresolimumab ^89^Zr")
#define CODE_DCM_TRC105_89Zr                                               DSRBasicCodedEntry("126749", "DCM", "TRC105 ^89^Zr")
#define CODE_DCM_7E11_89Zr                                                 DSRBasicCodedEntry("126750", "DCM", "7E11 ^89^Zr")
#define CODE_DCM_7D12_89Zr                                                 DSRBasicCodedEntry("126751", "DCM", "7D12 ^89^Zr")
#define CODE_DCM_28H1_89Zr                                                 DSRBasicCodedEntry("126752", "DCM", "28H1 ^89^Zr")
#define CODE_DCM_NanocolloidalAlbumin_89Zr                                 DSRBasicCodedEntry("126753", "DCM", "Nanocolloidal albumin ^89^Zr")
#define CODE_DCM_AntiB220_89Zr                                             DSRBasicCodedEntry("126754", "DCM", "Anti-B220 ^89^Zr")
#define CODE_DCM_RO5323441_89Zr                                            DSRBasicCodedEntry("126755", "DCM", "RO5323441 ^89^Zr")
#define CODE_DCM_RO542908_89Zr                                             DSRBasicCodedEntry("126756", "DCM", "RO542908 ^89^Zr")
#define CODE_DCM_RO6958948_18F                                             DSRBasicCodedEntry("126757", "DCM", "RO6958948 ^18^F")
#define CODE_DCM_PSMA1007_F18                                              DSRBasicCodedEntry("126758", "DCM", "PSMA-1007 F^18^")
#define CODE_DCM_PSMA617_Ga68                                              DSRBasicCodedEntry("126759", "DCM", "PSMA-617 Ga^68^")
#define CODE_DCM_DfFK_89Zr                                                 DSRBasicCodedEntry("126760", "DCM", "Df-FK ^89^Zr")
#define CODE_DCM_DfFKPEG3_89Zr                                             DSRBasicCodedEntry("126761", "DCM", "Df-FK-PEG(3) ^89^Zr")
#define CODE_DCM_DfFK2_89Zr                                                DSRBasicCodedEntry("126762", "DCM", "Df-[FK](2) ^89^Zr")
#define CODE_DCM_DfFK23PEG4_89Zr                                           DSRBasicCodedEntry("126763", "DCM", "Df-[FK](2)-3PEG(4) ^89^Zr")
#define CODE_DCM_Iodinated_I125DPA713                                      DSRBasicCodedEntry("126764", "DCM", "Iodinated I^125^ DPA-713")
#define CODE_DCM_DPA713_11C                                                DSRBasicCodedEntry("126765", "DCM", "DPA-713 ^11^C")
#define CODE_DCM_DPA714_18F                                                DSRBasicCodedEntry("126766", "DCM", "DPA-714 ^18^F")
#define CODE_DCM_IEC61217PatientSupportContinuousYawAngle                  DSRBasicCodedEntry("126801", "DCM", "IEC61217 Patient Support Continuous Yaw Angle")
#define CODE_DCM_IEC61217TableTopContinuousPitchAngle                      DSRBasicCodedEntry("126802", "DCM", "IEC61217 Table Top Continuous Pitch Angle")
#define CODE_DCM_IEC61217TableTopContinuousRollAngle                       DSRBasicCodedEntry("126803", "DCM", "IEC61217 Table Top Continuous Roll Angle")
#define CODE_DCM_IEC61217TableTopEccentricAxisDistance                     DSRBasicCodedEntry("126804", "DCM", "IEC61217 Table Top Eccentric Axis Distance")
#define CODE_DCM_IEC61217TableTopContinuousEccentricAngle                  DSRBasicCodedEntry("126805", "DCM", "IEC61217 Table Top Continuous Eccentric Angle")
#define CODE_DCM_IEC61217TableTopLateralPosition                           DSRBasicCodedEntry("126806", "DCM", "IEC61217 Table Top Lateral Position")
#define CODE_DCM_IEC61217TableTopLongitudinalPosition                      DSRBasicCodedEntry("126807", "DCM", "IEC61217 Table Top Longitudinal Position")
#define CODE_DCM_IEC61217TableTopVerticalPosition                          DSRBasicCodedEntry("126808", "DCM", "IEC61217 Table Top Vertical Position")
#define CODE_DCM_IEC61217GantryContinuousRollAngle                         DSRBasicCodedEntry("126809", "DCM", "IEC61217 Gantry Continuous Roll Angle")
#define CODE_DCM_IEC61217GantryContinuousPitchAngle                        DSRBasicCodedEntry("126810", "DCM", "IEC61217 Gantry Continuous Pitch Angle")
#define CODE_DCM_IEC61217GantryContinuousYawAngle                          DSRBasicCodedEntry("126811", "DCM", "IEC61217 Gantry Continuous Yaw Angle")
#define CODE_DCM_LeftFirst                                                 DSRBasicCodedEntry("126830", "DCM", "left first")
#define CODE_DCM_RightFirst                                                DSRBasicCodedEntry("126831", "DCM", "right first")
#define CODE_DCM_PosteriorFirst                                            DSRBasicCodedEntry("126832", "DCM", "posterior first")
#define CODE_DCM_AnteriorFirst                                             DSRBasicCodedEntry("126833", "DCM", "anterior first")
#define CODE_DCM_ILCR                                                      DSRBasicCodedEntry("126850", "DCM", "ILCR")
#define CODE_DCM_PreclinicalSmallAnimalImagingAcquisitionContext           DSRBasicCodedEntry("127001", "DCM", "Preclinical Small Animal Imaging Acquisition Context")
#define CODE_DCM_AnimalHandlingDuringSpecifiedPhase                        DSRBasicCodedEntry("127005", "DCM", "Animal handling during specified phase")
#define CODE_DCM_PhaseOfAnimalHandling                                     DSRBasicCodedEntry("127006", "DCM", "Phase of animal handling")
#define CODE_DCM_BiosafetyConditions                                       DSRBasicCodedEntry("127010", "DCM", "Biosafety conditions")
#define CODE_DCM_ReasonForBiosafetyControls                                DSRBasicCodedEntry("127011", "DCM", "Reason for biosafety controls")
#define CODE_DCM_HeatingConditions                                         DSRBasicCodedEntry("127040", "DCM", "Heating conditions")
#define CODE_DCM_CircadianEffects                                          DSRBasicCodedEntry("127050", "DCM", "Circadian effects")
#define CODE_DCM_NoseCone                                                  DSRBasicCodedEntry("127060", "DCM", "Nose cone")
#define CODE_DCM_NasalCannula                                              DSRBasicCodedEntry("127061", "DCM", "Nasal cannula")
#define CODE_DCM_RetroOrbitalRoute                                         DSRBasicCodedEntry("127070", "DCM", "Retro-orbital route")
#define CODE_DCM_InHomeCage                                                DSRBasicCodedEntry("127101", "DCM", "In home cage")
#define CODE_DCM_DuringTransport                                           DSRBasicCodedEntry("127102", "DCM", "During transport")
#define CODE_DCM_StagingPriorToImaging                                     DSRBasicCodedEntry("127103", "DCM", "Staging prior to imaging")
#define CODE_DCM_PreparationForImaging                                     DSRBasicCodedEntry("127104", "DCM", "Preparation for imaging")
#define CODE_DCM_HousingRole                                               DSRBasicCodedEntry("127110", "DCM", "Housing role")
#define CODE_DCM_AnimalHousing                                             DSRBasicCodedEntry("127120", "DCM", "Animal housing")
#define CODE_DCM_AnimalRoomType                                            DSRBasicCodedEntry("127121", "DCM", "Animal room type")
#define CODE_DCM_AnimalRoomIdentifier                                      DSRBasicCodedEntry("127122", "DCM", "Animal room identifier")
#define CODE_DCM_HousingManufacturer                                       DSRBasicCodedEntry("127125", "DCM", "Housing manufacturer")
#define CODE_DCM_HousingRackProductName                                    DSRBasicCodedEntry("127126", "DCM", "Housing rack product name")
#define CODE_DCM_HousingRackProductCode                                    DSRBasicCodedEntry("127127", "DCM", "Housing rack product code")
#define CODE_DCM_HousingUnitProductName                                    DSRBasicCodedEntry("127128", "DCM", "Housing unit product name")
#define CODE_DCM_HousingUnitProductCode                                    DSRBasicCodedEntry("127129", "DCM", "Housing unit product code")
#define CODE_DCM_HousingUnitLidProductName                                 DSRBasicCodedEntry("127130", "DCM", "Housing unit lid product name")
#define CODE_DCM_HousingUnitLidProductCode                                 DSRBasicCodedEntry("127131", "DCM", "Housing unit lid product code")
#define CODE_DCM_NumberOfRacksPerRoom                                      DSRBasicCodedEntry("127140", "DCM", "Number of racks per room")
#define CODE_DCM_NumberOfHousingUnitsPerRack                               DSRBasicCodedEntry("127141", "DCM", "Number of housing units per rack")
#define CODE_DCM_HousingUnitLocationInRack                                 DSRBasicCodedEntry("127142", "DCM", "Housing unit location in rack")
#define CODE_DCM_NumberOfAnimalsWithinSameHousingUnit                      DSRBasicCodedEntry("127143", "DCM", "Number of animals within same housing unit")
#define CODE_DCM_SexOfAnimalsWithinSameHousingUnit                         DSRBasicCodedEntry("127144", "DCM", "Sex of animals within same housing unit")
#define CODE_DCM_SexOfHandler                                              DSRBasicCodedEntry("127145", "DCM", "Sex of handler")
#define CODE_DCM_MixedSex                                                  DSRBasicCodedEntry("127146", "DCM", "Mixed sex")
#define CODE_DCM_TotalDurationInHousing                                    DSRBasicCodedEntry("127150", "DCM", "Total duration in housing")
#define CODE_DCM_HousingChangeInterval                                     DSRBasicCodedEntry("127151", "DCM", "Housing change interval")
#define CODE_DCM_ManualHandlingInterval                                    DSRBasicCodedEntry("127152", "DCM", "Manual handling interval")
#define CODE_DCM_HousingUnitMovement                                       DSRBasicCodedEntry("127153", "DCM", "Housing unit movement")
#define CODE_DCM_HousingUnitWidth                                          DSRBasicCodedEntry("127160", "DCM", "Housing unit width")
#define CODE_DCM_HousingUnitHeight                                         DSRBasicCodedEntry("127161", "DCM", "Housing unit height")
#define CODE_DCM_HousingUnitLength                                         DSRBasicCodedEntry("127162", "DCM", "Housing unit length")
#define CODE_DCM_HousingIndividuallyVentilated                             DSRBasicCodedEntry("127170", "DCM", "Housing individually ventilated")
#define CODE_DCM_AirChanges                                                DSRBasicCodedEntry("127172", "DCM", "Air changes")
#define CODE_DCM_HousingUnitReuse                                          DSRBasicCodedEntry("127175", "DCM", "Housing unit reuse")
#define CODE_DCM_Unused                                                    DSRBasicCodedEntry("127177", "DCM", "Unused")
#define CODE_DCM_Reused                                                    DSRBasicCodedEntry("127178", "DCM", "Reused")
#define CODE_DCM_BeddingManufacturer                                       DSRBasicCodedEntry("127180", "DCM", "Bedding manufacturer")
#define CODE_DCM_BeddingProductName                                        DSRBasicCodedEntry("127181", "DCM", "Bedding product name")
#define CODE_DCM_BeddingProductCode                                        DSRBasicCodedEntry("127182", "DCM", "Bedding product code")
#define CODE_DCM_BeddingVolume                                             DSRBasicCodedEntry("127183", "DCM", "Bedding volume")
#define CODE_DCM_BeddingMass                                               DSRBasicCodedEntry("127184", "DCM", "Bedding mass")
#define CODE_DCM_BeddingDepth                                              DSRBasicCodedEntry("127185", "DCM", "Bedding depth")
#define CODE_DCM_EnrichmentMaterial                                        DSRBasicCodedEntry("127190", "DCM", "Enrichment material")
#define CODE_DCM_EnrichmentManufacturer                                    DSRBasicCodedEntry("127191", "DCM", "Enrichment manufacturer")
#define CODE_DCM_EnrichmentMaterialPresent                                 DSRBasicCodedEntry("127192", "DCM", "Enrichment material present")
#define CODE_DCM_ExerciserDevicePresent                                    DSRBasicCodedEntry("127193", "DCM", "Exerciser device present")
#define CODE_DCM_ShelterType                                               DSRBasicCodedEntry("127195", "DCM", "Shelter type")
#define CODE_DCM_ShelterManufacturer                                       DSRBasicCodedEntry("127196", "DCM", "Shelter manufacturer")
#define CODE_DCM_ShelterProductName                                        DSRBasicCodedEntry("127197", "DCM", "Shelter product name")
#define CODE_DCM_ShelterProductCode                                        DSRBasicCodedEntry("127198", "DCM", "Shelter product code")
#define CODE_DCM_FeedManufacturer                                          DSRBasicCodedEntry("127200", "DCM", "Feed manufacturer")
#define CODE_DCM_FeedProductName                                           DSRBasicCodedEntry("127201", "DCM", "Feed product name")
#define CODE_DCM_FeedProductCode                                           DSRBasicCodedEntry("127202", "DCM", "Feed product code")
#define CODE_DCM_FeedSource                                                DSRBasicCodedEntry("127205", "DCM", "Feed source")
#define CODE_DCM_FeedbackTemperatureRegulation                             DSRBasicCodedEntry("127210", "DCM", "Feedback temperature regulation")
#define CODE_DCM_TotalDurationOfLightDarkCycle                             DSRBasicCodedEntry("127214", "DCM", "Total duration of light-dark cycle")
#define CODE_DCM_LightsonTimeOfDay                                         DSRBasicCodedEntry("127215", "DCM", "Lights on time of day")
#define CODE_DCM_Igloo                                                     DSRBasicCodedEntry("127220", "DCM", "Igloo")
#define CODE_DCM_RedTranslucentIgloo                                       DSRBasicCodedEntry("127221", "DCM", "Red translucent igloo")
#define CODE_DCM_AspenChipBedding                                          DSRBasicCodedEntry("127230", "DCM", "Aspen chip bedding")
#define CODE_DCM_AspenShavingBedding                                       DSRBasicCodedEntry("127231", "DCM", "Aspen shaving bedding")
#define CODE_DCM_CornCobBedding                                            DSRBasicCodedEntry("127232", "DCM", "Corn cob bedding")
#define CODE_DCM_PaperBasedBedding                                         DSRBasicCodedEntry("127233", "DCM", "Paper-based bedding")
#define CODE_DCM_PineChipBedding                                           DSRBasicCodedEntry("127234", "DCM", "Pine chip bedding")
#define CODE_DCM_PineShavingBedding                                        DSRBasicCodedEntry("127235", "DCM", "Pine shaving bedding")
#define CODE_DCM_CarrierTemperatureSensor                                  DSRBasicCodedEntry("127240", "DCM", "Carrier temperature sensor")
#define CODE_DCM_ForcedAirHeater                                           DSRBasicCodedEntry("127250", "DCM", "Forced air heater")
#define CODE_DCM_HeatedImagingDevice                                       DSRBasicCodedEntry("127251", "DCM", "Heated imaging device")
#define CODE_DCM_HeatedPatientSupport                                      DSRBasicCodedEntry("127252", "DCM", "Heated patient support")
#define CODE_DCM_HeatedWaterBlanket                                        DSRBasicCodedEntry("127253", "DCM", "Heated water blanket")
#define CODE_DCM_PreHeatedPad                                              DSRBasicCodedEntry("127254", "DCM", "Pre-heated pad")
#define CODE_DCM_Unheated                                                  DSRBasicCodedEntry("127255", "DCM", "Unheated")
#define CODE_DCM_NIH31                                                     DSRBasicCodedEntry("127270", "DCM", "NIH31")
#define CODE_DCM_NIH07                                                     DSRBasicCodedEntry("127271", "DCM", "NIH07")
#define CODE_DCM_AIN76                                                     DSRBasicCodedEntry("127272", "DCM", "AIN76")
#define CODE_DCM_AIN93G                                                    DSRBasicCodedEntry("127273", "DCM", "AIN93G")
#define CODE_DCM_AIN93M                                                    DSRBasicCodedEntry("127274", "DCM", "AIN93M")
#define CODE_DCM_ReverseOsmosisPurifiedWater                               DSRBasicCodedEntry("127290", "DCM", "Reverse osmosis purified water")
#define CODE_DCM_ReverseOsmosisPurified_HClAcidifiedWater                  DSRBasicCodedEntry("127291", "DCM", "Reverse osmosis purified, HCl acidified water")
#define CODE_DCM_AnesthesiaMethodSet                                       DSRBasicCodedEntry("127300", "DCM", "Anesthesia Method Set")
#define CODE_DCM_AnesthesiaMethod                                          DSRBasicCodedEntry("127301", "DCM", "Anesthesia Method")
#define CODE_DCM_AnesthesiaCategory                                        DSRBasicCodedEntry("127302", "DCM", "Anesthesia Category")
#define CODE_DCM_AnesthesiaSubCategory                                     DSRBasicCodedEntry("127303", "DCM", "Anesthesia SubCategory")
#define CODE_DCM_AirwayManagementSet                                       DSRBasicCodedEntry("127310", "DCM", "Airway Management Set")
#define CODE_DCM_AirwayManagementMethod                                    DSRBasicCodedEntry("127312", "DCM", "Airway Management Method")
#define CODE_DCM_AirwaySubManagementMethod                                 DSRBasicCodedEntry("127313", "DCM", "Airway Sub-Management Method")
#define CODE_DCM_MedicationsSet                                            DSRBasicCodedEntry("127320", "DCM", "Medications Set")
#define CODE_DCM_CarrierGas                                                DSRBasicCodedEntry("127330", "DCM", "Carrier gas")
#define CODE_DCM_AnimalHousingRoom                                         DSRBasicCodedEntry("127370", "DCM", "Animal housing room")
#define CODE_DCM_PreparationRoom                                           DSRBasicCodedEntry("127371", "DCM", "Preparation room")
#define CODE_DCM_ImagingProcedureRoom                                      DSRBasicCodedEntry("127372", "DCM", "Imaging procedure room")
#define CODE_DCM_LocallyManufacturedProduct                                DSRBasicCodedEntry("127390", "DCM", "Locally manufactured product")
#define CODE_DCM_FoodTreat                                                 DSRBasicCodedEntry("127391", "DCM", "Food treat")
#define CODE_DCM_ExogenousSubstance                                        DSRBasicCodedEntry("127400", "DCM", "Exogenous substance")
#define CODE_DCM_TissueOfOrigin                                            DSRBasicCodedEntry("127401", "DCM", "Tissue of origin")
#define CODE_DCM_TaxonomicRankOfOrigin                                     DSRBasicCodedEntry("127402", "DCM", "Taxonomic rank of origin")
#define CODE_DCM_Strain                                                    DSRBasicCodedEntry("127411", "DCM", "Strain")
#define CODE_DCM_StrainDescription                                         DSRBasicCodedEntry("127412", "DCM", "Strain description")
#define CODE_DCM_Nomenclature                                              DSRBasicCodedEntry("127413", "DCM", "Nomenclature")
#define CODE_DCM_GeneticModifications                                      DSRBasicCodedEntry("127414", "DCM", "Genetic modifications")
#define CODE_DCM_GeneticModificationsDescription                           DSRBasicCodedEntry("127415", "DCM", "Genetic modifications description")
#define CODE_DCM_StereotacticCoordinates                                   DSRBasicCodedEntry("127450", "DCM", "Stereotactic coordinates")
#define CODE_DCM_PositionReferenceIndicator                                DSRBasicCodedEntry("127451", "DCM", "Position reference indicator")
#define CODE_DCM_TumorGraft                                                DSRBasicCodedEntry("127460", "DCM", "Tumor graft")
#define CODE_DCM_EmbryonicKidney                                           DSRBasicCodedEntry("127801", "DCM", "Embryonic Kidney")
#define CODE_DCM_HumanAlphaSynucleinPreformedFibrils                       DSRBasicCodedEntry("127851", "DCM", "Human alpha synuclein preformed fibrils")
#define CODE_DCM_MouseAlphaSynucleinPreformedFibrils                       DSRBasicCodedEntry("127852", "DCM", "Mouse alpha synuclein preformed fibrils")
#define CODE_DCM_HumanTauPreformedFibrils                                  DSRBasicCodedEntry("127853", "DCM", "Human Tau preformed fibrils")
#define CODE_DCM_MouseTauPreformedFibrils                                  DSRBasicCodedEntry("127854", "DCM", "Mouse Tau preformed fibrils")
#define CODE_DCM_RETIRED_NonIonicIodinatedContrastAgent                    DSRBasicCodedEntry("127855", "DCM", "Non-ionic iodinated contrast agent")
#define CODE_DCM_HeartValveFlail                                           DSRBasicCodedEntry("127856", "DCM", "Heart valve flail")
#define CODE_DCM_GlucoseMeasurementDate                                    DSRBasicCodedEntry("127857", "DCM", "Glucose Measurement Date")
#define CODE_DCM_GlucoseMeasurementTime                                    DSRBasicCodedEntry("127858", "DCM", "Glucose Measurement Time")
#define CODE_DCM_SPECTOfWholeBody                                          DSRBasicCodedEntry("127901", "DCM", "SPECT of whole body")
#define CODE_DCM_SPECTCTOfWholeBody                                        DSRBasicCodedEntry("127902", "DCM", "SPECT CT of whole body")
#define CODE_DCM_AddAddendumToReport                                       DSRBasicCodedEntry("128001", "DCM", "Add Addendum to Report")
#define CODE_DCM_ModalityToRead                                            DSRBasicCodedEntry("128002", "DCM", "Modality to Read")
#define CODE_DCM_ReaderSpecialty                                           DSRBasicCodedEntry("128003", "DCM", "Reader Specialty")
#define CODE_DCM_ReportRequested                                           DSRBasicCodedEntry("128004", "DCM", "Report Requested")
#define CODE_DCM_FinalReport                                               DSRBasicCodedEntry("128005", "DCM", "Final Report")
#define CODE_DCM_AbdominalImagingSpecialty                                 DSRBasicCodedEntry("128006", "DCM", "Abdominal Imaging Specialty")
#define CODE_DCM_CardiacImagingSpecialty                                   DSRBasicCodedEntry("128007", "DCM", "Cardiac Imaging Specialty")
#define CODE_DCM_HeadAndNeckImagingSpecialty                               DSRBasicCodedEntry("128008", "DCM", "Head and Neck Imaging Specialty")
#define CODE_DCM_MusculoskeletalImagingSpecialty                           DSRBasicCodedEntry("128009", "DCM", "Musculoskeletal Imaging Specialty")
#define CODE_DCM_NeurologySpecialty                                        DSRBasicCodedEntry("128010", "DCM", "Neurology Specialty")
#define CODE_DCM_NeuroradiologicImagingSpecialty                           DSRBasicCodedEntry("128011", "DCM", "Neuroradiologic Imaging Specialty")
#define CODE_DCM_OBGynImagingSpecialty                                     DSRBasicCodedEntry("128012", "DCM", "OB/Gyn Imaging Specialty")
#define CODE_DCM_OncologicImagingSpecialty                                 DSRBasicCodedEntry("128013", "DCM", "Oncologic Imaging Specialty")
#define CODE_DCM_OncologySpecialty                                         DSRBasicCodedEntry("128014", "DCM", "Oncology Specialty")
#define CODE_DCM_ThoracicImagingSpecialty                                  DSRBasicCodedEntry("128015", "DCM", "Thoracic Imaging Specialty")
#define CODE_DCM_PediatricImagingSpecialty                                 DSRBasicCodedEntry("128016", "DCM", "Pediatric Imaging Specialty")
#define CODE_DCM_VascularImagingSpecialty                                  DSRBasicCodedEntry("128017", "DCM", "Vascular Imaging Specialty")
#define CODE_DCM_FWPByGA_Campbell_1991                                     DSRBasicCodedEntry("128040", "DCM", "FWP by GA, Campbell, 1991")
#define CODE_DCM_FWPByGA_Hadlock_1991                                      DSRBasicCodedEntry("128041", "DCM", "FWP by GA, Hadlock, 1991")
#define CODE_DCM_PlaneThroughSuperiorExtent                                DSRBasicCodedEntry("128120", "DCM", "Plane through Superior Extent")
#define CODE_DCM_PlaneThroughInferiorExtent                                DSRBasicCodedEntry("128121", "DCM", "Plane through Inferior Extent")
#define CODE_DCM_PlaneThroughProximalExtent                                DSRBasicCodedEntry("128122", "DCM", "Plane through Proximal Extent")
#define CODE_DCM_PlaneThroughDistalExtent                                  DSRBasicCodedEntry("128123", "DCM", "Plane through Distal Extent")
#define CODE_DCM_PlaneThroughMedialExtent                                  DSRBasicCodedEntry("128124", "DCM", "Plane through Medial Extent")
#define CODE_DCM_PlaneThroughLateralExtent                                 DSRBasicCodedEntry("128125", "DCM", "Plane through Lateral Extent")
#define CODE_DCM_PlaneThroughLeftmostExtent                                DSRBasicCodedEntry("128126", "DCM", "Plane through Leftmost Extent")
#define CODE_DCM_PlaneThroughRightmostExtent                               DSRBasicCodedEntry("128127", "DCM", "Plane through Rightmost Extent")
#define CODE_DCM_PlaneThroughAnteriorExtent                                DSRBasicCodedEntry("128128", "DCM", "Plane through Anterior Extent")
#define CODE_DCM_PlaneThroughPosteriorExtent                               DSRBasicCodedEntry("128129", "DCM", "Plane through Posterior Extent")
#define CODE_DCM_PlaneThroughCenter                                        DSRBasicCodedEntry("128130", "DCM", "Plane through Center")
#define CODE_DCM_GeometricCenterpoint                                      DSRBasicCodedEntry("128137", "DCM", "Geometric Centerpoint")
#define CODE_DCM_CenterOfMass                                              DSRBasicCodedEntry("128138", "DCM", "Center of Mass")
#define CODE_DCM_SeedPoint                                                 DSRBasicCodedEntry("128139", "DCM", "Seed point")
#define CODE_DCM_ImpairedRenalFunction                                     DSRBasicCodedEntry("128144", "DCM", "Impaired Renal Function")
#define CODE_DCM_LaserCrossHairs                                           DSRBasicCodedEntry("128151", "DCM", "Laser Cross-hairs")
#define CODE_DCM_AcquiredVolume                                            DSRBasicCodedEntry("128160", "DCM", "Acquired Volume")
#define CODE_DCM_AbdominalRadiology                                        DSRBasicCodedEntry("128170", "DCM", "Abdominal Radiology")
#define CODE_DCM_BiomedicalEngineering                                     DSRBasicCodedEntry("128171", "DCM", "Biomedical Engineering")
#define CODE_DCM_CardiovascularRadiology                                   DSRBasicCodedEntry("128172", "DCM", "Cardiovascular Radiology")
#define CODE_DCM_InformationTechnology                                     DSRBasicCodedEntry("128173", "DCM", "Information Technology")
#define CODE_DCM_MedicalPhysics                                            DSRBasicCodedEntry("128174", "DCM", "Medical Physics")
#define CODE_DCM_MusculoskeletalRadiology                                  DSRBasicCodedEntry("128175", "DCM", "Musculoskeletal Radiology")
#define CODE_DCM_PediatricRadiology                                        DSRBasicCodedEntry("128177", "DCM", "Pediatric Radiology")
#define CODE_DCM_ThoracicRadiology                                         DSRBasicCodedEntry("128179", "DCM", "Thoracic Radiology")
#define CODE_DCM_ForRTWorkflow                                             DSRBasicCodedEntry("128180", "DCM", "For RT Workflow")
#define CODE_DCM_DiagnosticSourceImages                                    DSRBasicCodedEntry("128181", "DCM", "Diagnostic Source Images")
#define CODE_DCM_SegmentationResult                                        DSRBasicCodedEntry("128182", "DCM", "Segmentation Result")
#define CODE_DCM_RegistrationResult                                        DSRBasicCodedEntry("128183", "DCM", "Registration Result")
#define CODE_DCM_PrePlanningResult                                         DSRBasicCodedEntry("128184", "DCM", "Pre-Planning Result")
#define CODE_DCM_RTPrescriptionResult                                      DSRBasicCodedEntry("128185", "DCM", "RT Prescription Result")
#define CODE_DCM_DoseCalculationImageSeries                                DSRBasicCodedEntry("128186", "DCM", "Dose Calculation Image Series")
#define CODE_DCM_CoordinateAlignmentImageSeries                            DSRBasicCodedEntry("128187", "DCM", "Coordinate Alignment Image Series")
#define CODE_DCM_RTTreatmentSimulationResult                               DSRBasicCodedEntry("128188", "DCM", "RT Treatment Simulation Result")
#define CODE_DCM_RTPlanningResult                                          DSRBasicCodedEntry("128189", "DCM", "RT Planning Result")
#define CODE_DCM_DosimetricResult                                          DSRBasicCodedEntry("128190", "DCM", "Dosimetric Result")
#define CODE_DCM_PatientSetupVerificationResult                            DSRBasicCodedEntry("128191", "DCM", "Patient Setup Verification Result")
#define CODE_DCM_RTTreatmentSessionResult                                  DSRBasicCodedEntry("128192", "DCM", "RT Treatment Session Result")
#define CODE_DCM_RTTreatmentCourseSummary                                  DSRBasicCodedEntry("128193", "DCM", "RT Treatment Course Summary")
#define CODE_DCM_RTTreatmentQAResult                                       DSRBasicCodedEntry("128194", "DCM", "RT Treatment QA Result")
#define CODE_DCM_ForDiagnosis                                              DSRBasicCodedEntry("128195", "DCM", "For Diagnosis")
#define CODE_DCM_ForSegmentation                                           DSRBasicCodedEntry("128196", "DCM", "For Segmentation")
#define CODE_DCM_ForRTPrescription                                         DSRBasicCodedEntry("128197", "DCM", "For RT Prescription")
#define CODE_DCM_ForRTTreatmentPlanning                                    DSRBasicCodedEntry("128198", "DCM", "For RT Treatment Planning")
#define CODE_DCM_ForPlanComparison                                         DSRBasicCodedEntry("128199", "DCM", "For Plan Comparison")
#define CODE_DCM_ForRTPlanSummation                                        DSRBasicCodedEntry("128200", "DCM", "For RT Plan Summation")
#define CODE_DCM_ForPhysicianReview                                        DSRBasicCodedEntry("128201", "DCM", "For Physician Review")
#define CODE_DCM_ForPhysicistReview                                        DSRBasicCodedEntry("128202", "DCM", "For Physicist Review")
#define CODE_DCM_ForTumorBoard                                             DSRBasicCodedEntry("128203", "DCM", "For Tumor Board")
#define CODE_DCM_ForPlanQualityAssurance                                   DSRBasicCodedEntry("128204", "DCM", "For Plan Quality Assurance")
#define CODE_DCM_ForMachineQualityAssurance                                DSRBasicCodedEntry("128205", "DCM", "For Machine Quality Assurance")
#define CODE_DCM_ForPatientSetupVerification                               DSRBasicCodedEntry("128206", "DCM", "For Patient Setup Verification")
#define CODE_DCM_ForClinicalTrialSubmission                                DSRBasicCodedEntry("128207", "DCM", "For Clinical Trial Submission")
#define CODE_DCM_ForTumorRegistry                                          DSRBasicCodedEntry("128208", "DCM", "For Tumor Registry")
#define CODE_DCM_RTWorkflowInputUsed                                       DSRBasicCodedEntry("128209", "DCM", "RT Workflow Input Used")
#define CODE_DCM_RTPrescriptionInputUsed                                   DSRBasicCodedEntry("128210", "DCM", "RT Prescription Input Used")
#define CODE_DCM_RTTreatmentPlanningInputUsed                              DSRBasicCodedEntry("128211", "DCM", "RT Treatment Planning Input Used")
#define CODE_DCM_RTPlanSummationInputUsed                                  DSRBasicCodedEntry("128212", "DCM", "RT Plan Summation Input Used")
#define CODE_DCM_PhysicianReviewInputUsed                                  DSRBasicCodedEntry("128213", "DCM", "Physician Review Input Used")
#define CODE_DCM_PhysicistReviewInputUsed                                  DSRBasicCodedEntry("128214", "DCM", "Physicist Review Input Used")
#define CODE_DCM_PlanQualityAssuranceInputUsed                             DSRBasicCodedEntry("128215", "DCM", "Plan Quality Assurance Input Used")
#define CODE_DCM_MachineQualityAssuranceInputUsed                          DSRBasicCodedEntry("128216", "DCM", "Machine Quality Assurance Input Used")
#define CODE_DCM_PatientSetupVerificationInputUsed                         DSRBasicCodedEntry("128217", "DCM", "Patient Setup Verification Input Used")
#define CODE_DCM_DiagnosisInputUsed                                        DSRBasicCodedEntry("128218", "DCM", "Diagnosis Input Used")
#define CODE_DCM_ContouringInputUsed                                       DSRBasicCodedEntry("128219", "DCM", "Contouring Input Used")
#define CODE_DCM_PlanComparisonInputUsed                                   DSRBasicCodedEntry("128220", "DCM", "Plan Comparison Input Used")
#define CODE_DCM_TumorBoardInputUsed                                       DSRBasicCodedEntry("128221", "DCM", "Tumor Board Input Used")
#define CODE_DCM_TumorRegistryInputUsed                                    DSRBasicCodedEntry("128222", "DCM", "Tumor Registry Input Used")
#define CODE_DCM_ClinicalTrialSubmissionInputUsed                          DSRBasicCodedEntry("128223", "DCM", "Clinical Trial Submission Input Used")
#define CODE_DCM_SourceMeasurement                                         DSRBasicCodedEntry("128224", "DCM", "Source measurement")
#define CODE_DCM_SourceReport                                              DSRBasicCodedEntry("128225", "DCM", "Source report")
#define CODE_DCM_SourceRawData                                             DSRBasicCodedEntry("128226", "DCM", "Source raw data")
#define CODE_DCM_SourceRealWorldValueMap                                   DSRBasicCodedEntry("128227", "DCM", "Source real world value map")
#define CODE_DCM_PulseSequenceName                                         DSRBasicCodedEntry("128230", "DCM", "Pulse Sequence Name")
#define CODE_DCM_StructuralImageForImageProcessing                         DSRBasicCodedEntry("128250", "DCM", "Structural image for image processing")
#define CODE_DCM_FlowImageForImageProcessing                               DSRBasicCodedEntry("128251", "DCM", "Flow image for image processing")
#define CODE_DCM_OCTAAmplitudeDecorrelation                                DSRBasicCodedEntry("128252", "DCM", "OCT-A amplitude decorrelation")
#define CODE_DCM_OCTAComplexVariance                                       DSRBasicCodedEntry("128253", "DCM", "OCT-A complex variance")
#define CODE_DCM_OCTASpeckleVariance                                       DSRBasicCodedEntry("128254", "DCM", "OCT-A speckle variance")
#define CODE_DCM_OCTACorrelationMapping                                    DSRBasicCodedEntry("128255", "DCM", "OCT-A correlation mapping")
#define CODE_DCM_DopplerOCTA                                               DSRBasicCodedEntry("128256", "DCM", "Doppler OCT-A")
#define CODE_DCM_RetinaDepthEncodedVasculatureFlow                         DSRBasicCodedEntry("128257", "DCM", "Retina depth encoded vasculature flow")
#define CODE_DCM_RetinaDepthEncodedStructuralReflectanceMap                DSRBasicCodedEntry("128258", "DCM", "Retina depth encoded structural reflectance map")
#define CODE_DCM_RetinaVasculatureFlow                                     DSRBasicCodedEntry("128259", "DCM", "Retina vasculature flow")
#define CODE_DCM_RetinaStructuralReflectanceMap                            DSRBasicCodedEntry("128260", "DCM", "Retina structural reflectance map")
#define CODE_DCM_VitreousVasculatureFlow                                   DSRBasicCodedEntry("128261", "DCM", "Vitreous vasculature flow")
#define CODE_DCM_VitreousStructuralReflectanceMap                          DSRBasicCodedEntry("128262", "DCM", "Vitreous structural reflectance map")
#define CODE_DCM_RadialPeripapillaryVasculatureFlow                        DSRBasicCodedEntry("128263", "DCM", "Radial peripapillary vasculature flow")
#define CODE_DCM_RadialPeripapillaryStructuralReflectanceMap               DSRBasicCodedEntry("128264", "DCM", "Radial peripapillary structural reflectance map")
#define CODE_DCM_SuperficialRetinaVasculatureFlow                          DSRBasicCodedEntry("128265", "DCM", "Superficial retina vasculature flow")
#define CODE_DCM_SuperficialRetinaStructuralReflectanceMap                 DSRBasicCodedEntry("128266", "DCM", "Superficial retina structural reflectance map")
#define CODE_DCM_MiddleInnerRetinaVasculatureFlow                          DSRBasicCodedEntry("128267", "DCM", "Middle inner retina vasculature flow")
#define CODE_DCM_MiddleInnerStructuralReflectanceMap                       DSRBasicCodedEntry("128268", "DCM", "Middle inner structural reflectance map")
#define CODE_DCM_DeepRetinaVasculatureFlow                                 DSRBasicCodedEntry("128269", "DCM", "Deep retina vasculature flow")
#define CODE_DCM_DeepRetinaStructuralReflectanceMap                        DSRBasicCodedEntry("128270", "DCM", "Deep retina structural reflectance map")
#define CODE_DCM_OuterRetinaVasculatureFlow                                DSRBasicCodedEntry("128271", "DCM", "Outer retina vasculature flow")
#define CODE_DCM_OuterRetinaStructuralReflectanceMap                       DSRBasicCodedEntry("128272", "DCM", "Outer retina structural reflectance map")
#define CODE_DCM_ChoriocapillarisVasculatureFlow                           DSRBasicCodedEntry("128273", "DCM", "Choriocapillaris vasculature flow")
#define CODE_DCM_ChoriocapillarisStructuralReflectanceMap                  DSRBasicCodedEntry("128274", "DCM", "Choriocapillaris structural reflectance map")
#define CODE_DCM_ChoroidVasculatureFlow                                    DSRBasicCodedEntry("128275", "DCM", "Choroid vasculature flow")
#define CODE_DCM_ChoroidStructuralReflectanceMap                           DSRBasicCodedEntry("128276", "DCM", "Choroid structural reflectance map")
#define CODE_DCM_WholeEyeVasculatureFlow                                   DSRBasicCodedEntry("128277", "DCM", "Whole eye vasculature flow")
#define CODE_DCM_WholeEyeStructuralReflectanceMap                          DSRBasicCodedEntry("128278", "DCM", "Whole eye structural reflectance map")
#define CODE_DCM_CubeBScanPattern                                          DSRBasicCodedEntry("128279", "DCM", "Cube B-scan pattern")
#define CODE_DCM_RasterBScanPattern                                        DSRBasicCodedEntry("128280", "DCM", "Raster B-scan pattern")
#define CODE_DCM_LineBScanPattern                                          DSRBasicCodedEntry("128281", "DCM", "Line B-scan pattern")
#define CODE_DCM_RadialBScanPattern                                        DSRBasicCodedEntry("128282", "DCM", "Radial B-scan pattern")
#define CODE_DCM_CrossBScanPattern                                         DSRBasicCodedEntry("128283", "DCM", "Cross B-scan pattern")
#define CODE_DCM_CircleBScanPattern                                        DSRBasicCodedEntry("128284", "DCM", "Circle B-scan pattern")
#define CODE_DCM_ConcentricCircleBScanPattern                              DSRBasicCodedEntry("128285", "DCM", "Concentric circle B-scan pattern")
#define CODE_DCM_CircleRasterBScanPattern                                  DSRBasicCodedEntry("128286", "DCM", "Circle-raster B-scan pattern")
#define CODE_DCM_CircleRadialBScanPattern                                  DSRBasicCodedEntry("128287", "DCM", "Circle-radial B-scan pattern")
#define CODE_DCM_GridBScanPattern                                          DSRBasicCodedEntry("128288", "DCM", "Grid B-scan pattern")
#define CODE_DCM_OuterSurfaceOfRNFL                                        DSRBasicCodedEntry("128289", "DCM", "Outer surface of RNFL")
#define CODE_DCM_OuterSurfaceOfGCL                                         DSRBasicCodedEntry("128290", "DCM", "Outer surface of GCL")
#define CODE_DCM_OuterSurfaceOfIPL                                         DSRBasicCodedEntry("128291", "DCM", "Outer surface of IPL")
#define CODE_DCM_OuterSurfaceOfINL                                         DSRBasicCodedEntry("128292", "DCM", "Outer surface of INL")
#define CODE_DCM_OuterSurfaceOfOPL                                         DSRBasicCodedEntry("128293", "DCM", "Outer surface of OPL")
#define CODE_DCM_OuterSurfaceOfHFL                                         DSRBasicCodedEntry("128294", "DCM", "Outer surface of HFL")
#define CODE_DCM_SurfaceBetweenInnerAndOuterSegmentsOfThePhotoreceptors    DSRBasicCodedEntry("128295", "DCM", "Surface between Inner and Outer Segments of the photoreceptors")
#define CODE_DCM_SurfaceOfTheInterdigitatingZoneBetweenRetinaAndRPE        DSRBasicCodedEntry("128296", "DCM", "Surface of the interdigitating zone between retina and RPE")
#define CODE_DCM_AnteriorSurfaceOfTheRPE                                   DSRBasicCodedEntry("128297", "DCM", "Anterior surface of the RPE")
#define CODE_DCM_SurfaceOfTheCenterOfTheRPE                                DSRBasicCodedEntry("128298", "DCM", "Surface of the center of the RPE")
#define CODE_DCM_PosteriorSurfaceOfTheRPE                                  DSRBasicCodedEntry("128299", "DCM", "Posterior surface of the RPE")
#define CODE_DCM_OuterSurfaceOfTheBM                                       DSRBasicCodedEntry("128300", "DCM", "Outer surface of the BM")
#define CODE_DCM_SurfaceOfTheChoroidScleraInterface                        DSRBasicCodedEntry("128301", "DCM", "Surface of the choroid-sclera interface")
#define CODE_DCM_OuterSurfaceOfTheCC                                       DSRBasicCodedEntry("128302", "DCM", "Outer surface of the CC")
#define CODE_DCM_OCTBScanAnalysis                                          DSRBasicCodedEntry("128303", "DCM", "OCT B-scan analysis")
#define CODE_DCM_OCTAOneSidedRatio_lesser                                  DSRBasicCodedEntry("128304", "DCM", "OCT-A one-sided ratio (lesser)")
#define CODE_DCM_OCTAOneSidedRatio_greater                                 DSRBasicCodedEntry("128305", "DCM", "OCT-A one-sided ratio (greater)")
#define CODE_DCM_PatientRadiationDoseReport                                DSRBasicCodedEntry("128401", "DCM", "Patient Radiation Dose Report")
#define CODE_DCM_RadiationDoseEstimate                                     DSRBasicCodedEntry("128402", "DCM", "Radiation Dose Estimate")
#define CODE_DCM_RadiationDoseEstimateName                                 DSRBasicCodedEntry("128403", "DCM", "Radiation Dose Estimate Name")
#define CODE_DCM_AnthropomorphicModel                                      DSRBasicCodedEntry("128404", "DCM", "Anthropomorphic Model")
#define CODE_DCM_BreastThickness                                           DSRBasicCodedEntry("128405", "DCM", "Breast Thickness")
#define CODE_DCM_BREPRadiationTransportModel                               DSRBasicCodedEntry("128406", "DCM", "BREP Radiation Transport Model")
#define CODE_DCM_DgN                                                       DSRBasicCodedEntry("128407", "DCM", "DgN")
#define CODE_DCM_PatientAPDimension                                        DSRBasicCodedEntry("128408", "DCM", "Patient AP Dimension")
#define CODE_DCM_PatientLateralDimension                                   DSRBasicCodedEntry("128409", "DCM", "Patient Lateral Dimension")
#define CODE_DCM_SSDEConversionFactor                                      DSRBasicCodedEntry("128410", "DCM", "SSDE Conversion Factor")
#define CODE_DCM_Backscatter                                               DSRBasicCodedEntry("128411", "DCM", "Backscatter")
#define CODE_DCM_RadiationDoseEstimateRepresentation                       DSRBasicCodedEntry("128412", "DCM", "Radiation Dose Estimate Representation")
#define CODE_DCM_DistributionRepresentation                                DSRBasicCodedEntry("128413", "DCM", "Distribution Representation")
#define CODE_DCM_RadiationDoseRepresentationData                           DSRBasicCodedEntry("128414", "DCM", "Radiation Dose Representation Data")
#define CODE_DCM_RadiationDoseEstimateMethodology                          DSRBasicCodedEntry("128415", "DCM", "Radiation Dose Estimate Methodology")
#define CODE_DCM_SRInstanceUsed                                            DSRBasicCodedEntry("128416", "DCM", "SR Instance Used")
#define CODE_DCM_PatientModelType                                          DSRBasicCodedEntry("128417", "DCM", "Patient Model Type")
#define CODE_DCM_SimpleObjectModel                                         DSRBasicCodedEntry("128418", "DCM", "Simple Object Model")
#define CODE_DCM_RadiationTransportModelType                               DSRBasicCodedEntry("128420", "DCM", "Radiation Transport Model Type")
#define CODE_DCM_GeometricRadiationTransportModel                          DSRBasicCodedEntry("128421", "DCM", "Geometric Radiation Transport Model")
#define CODE_DCM_VoxelizedRadiationTransportModel                          DSRBasicCodedEntry("128422", "DCM", "Voxelized Radiation Transport Model")
#define CODE_DCM_MeshRadiationTransportModel                               DSRBasicCodedEntry("128423", "DCM", "Mesh Radiation Transport Model")
#define CODE_DCM_NURBSRadiationTransportModel                              DSRBasicCodedEntry("128424", "DCM", "NURBS Radiation Transport Model")
#define CODE_DCM_PatientRadiationDoseModelData                             DSRBasicCodedEntry("128425", "DCM", "Patient Radiation Dose Model Data")
#define CODE_DCM_PatientRadiationDoseModelReference                        DSRBasicCodedEntry("128426", "DCM", "Patient Radiation Dose Model Reference")
#define CODE_DCM_PatientModelDemographics                                  DSRBasicCodedEntry("128427", "DCM", "Patient Model Demographics")
#define CODE_DCM_ModelMinimumAge                                           DSRBasicCodedEntry("128428", "DCM", "Model Minimum Age")
#define CODE_DCM_EventUIDUsed                                              DSRBasicCodedEntry("128429", "DCM", "Event UID Used")
#define CODE_DCM_ModelMaximumAge                                           DSRBasicCodedEntry("128430", "DCM", "Model Maximum Age")
#define CODE_DCM_BeamBlock                                                 DSRBasicCodedEntry("128431", "DCM", "Beam Block")
#define CODE_DCM_TissueAirRatio                                            DSRBasicCodedEntry("128433", "DCM", "Tissue Air Ratio")
#define CODE_DCM_RadiationDoseEstimateParameters                           DSRBasicCodedEntry("128434", "DCM", "Radiation Dose Estimate Parameters")
#define CODE_DCM_RadiationDoseCompositeParameters                          DSRBasicCodedEntry("128436", "DCM", "Radiation Dose Composite Parameters")
#define CODE_DCM_ModelPatientSex                                           DSRBasicCodedEntry("128437", "DCM", "Model Patient Sex")
#define CODE_DCM_ModelMinimumWeight                                        DSRBasicCodedEntry("128438", "DCM", "Model Minimum Weight")
#define CODE_DCM_ModelMinimumHeight                                        DSRBasicCodedEntry("128439", "DCM", "Model Minimum Height")
#define CODE_DCM_ModelMaximumWeight                                        DSRBasicCodedEntry("128441", "DCM", "Model Maximum Weight")
#define CODE_DCM_ModelMaximumHeight                                        DSRBasicCodedEntry("128442", "DCM", "Model Maximum Height")
#define CODE_DCM_SpatialRegistrationReference                              DSRBasicCodedEntry("128444", "DCM", "Spatial Registration Reference")
#define CODE_DCM_RegistrationMethod                                        DSRBasicCodedEntry("128446", "DCM", "Registration Method")
#define CODE_DCM_SpatialFiducials_128447                                   DSRBasicCodedEntry("128447", "DCM", "Spatial Fiducials")
#define CODE_DCM_CorrectionFactor                                          DSRBasicCodedEntry("128452", "DCM", "Correction Factor")
#define CODE_DCM_CurveFitParameter                                         DSRBasicCodedEntry("128453", "DCM", "Curve Fit Parameter")
#define CODE_DCM_HomogeneityFactor                                         DSRBasicCodedEntry("128455", "DCM", "Homogeneity Factor")
#define CODE_DCM_PatientModelRegistration                                  DSRBasicCodedEntry("128456", "DCM", "Patient Model Registration")
#define CODE_DCM_XRayBeamAttenuator                                        DSRBasicCodedEntry("128457", "DCM", "X-Ray Beam Attenuator")
#define CODE_DCM_AttenuatorCategory                                        DSRBasicCodedEntry("128458", "DCM", "Attenuator Category")
#define CODE_DCM_Table                                                     DSRBasicCodedEntry("128459", "DCM", "Table")
#define CODE_DCM_TableCore                                                 DSRBasicCodedEntry("128460", "DCM", "Table Core")
#define CODE_DCM_TableOuterLiner                                           DSRBasicCodedEntry("128461", "DCM", "Table Outer Liner")
#define CODE_DCM_TablePad                                                  DSRBasicCodedEntry("128462", "DCM", "Table Pad")
#define CODE_DCM_RadiationDoseEstimationParameterType                      DSRBasicCodedEntry("128464", "DCM", "Radiation Dose Estimation Parameter Type")
#define CODE_DCM_EquivalentAttenuatorMaterial                              DSRBasicCodedEntry("128465", "DCM", "Equivalent Attenuator Material")
#define CODE_DCM_AttenuatorDescription                                     DSRBasicCodedEntry("128468", "DCM", "Attenuator Description")
#define CODE_DCM_EquivalentAttenuatorThickness                             DSRBasicCodedEntry("128469", "DCM", "Equivalent Attenuator Thickness")
#define CODE_DCM_XRayAttenuatorModelData                                   DSRBasicCodedEntry("128470", "DCM", "X-Ray Attenuator Model Data")
#define CODE_DCM_XRayBeamAttenuatorModel                                   DSRBasicCodedEntry("128472", "DCM", "X-Ray Beam Attenuator Model")
#define CODE_DCM_XRayBeamAttenuatorModelReference                          DSRBasicCodedEntry("128474", "DCM", "X-Ray Beam Attenuator Model Reference")
#define CODE_DCM_XRayBeamAttenuatorModelRegistration                       DSRBasicCodedEntry("128475", "DCM", "X-Ray Beam Attenuator Model Registration")
#define CODE_DCM_RadiationDoseEstimateMethod                               DSRBasicCodedEntry("128476", "DCM", "Radiation Dose Estimate Method")
#define CODE_DCM_RadiationDoseEstimateMethodType                           DSRBasicCodedEntry("128477", "DCM", "Radiation Dose Estimate Method Type")
#define CODE_DCM_TabularDataAlgorithm                                      DSRBasicCodedEntry("128479", "DCM", "Tabular Data Algorithm")
#define CODE_DCM_AnalyticalAlgorithm                                       DSRBasicCodedEntry("128480", "DCM", "Analytical Algorithm")
#define CODE_DCM_EmpiricalAlgorithm                                        DSRBasicCodedEntry("128481", "DCM", "Empirical Algorithm")
#define CODE_DCM_RadiationDoseEstimateMethodReference                      DSRBasicCodedEntry("128482", "DCM", "Radiation Dose Estimate Method Reference")
#define CODE_DCM_Isodose                                                   DSRBasicCodedEntry("128484", "DCM", "Isodose")
#define CODE_DCM_SkinDoseMap                                               DSRBasicCodedEntry("128485", "DCM", "Skin Dose Map")
#define CODE_DCM_3DDoseMap                                                 DSRBasicCodedEntry("128487", "DCM", "3D Dose Map")
#define CODE_DCM_DoseGradient                                              DSRBasicCodedEntry("128488", "DCM", "Dose Gradient")
#define CODE_DCM_PhysicalSupport                                           DSRBasicCodedEntry("128492", "DCM", "Physical Support")
#define CODE_DCM_PatientSegmentedModel                                     DSRBasicCodedEntry("128494", "DCM", "Patient Segmented Model")
#define CODE_DCM_DosePointCloud                                            DSRBasicCodedEntry("128496", "DCM", "Dose Point Cloud")
#define CODE_DCM_MeasuredRadiationDose                                     DSRBasicCodedEntry("128497", "DCM", "Measured Radiation Dose")
#define CODE_DCM_PatientRadiationDoseModel                                 DSRBasicCodedEntry("128500", "DCM", "Patient Radiation Dose Model")
#define CODE_DCM_ReferenceToUncertaintyDeterminationMethod                 DSRBasicCodedEntry("128511", "DCM", "Reference to Uncertainty Determination Method")
#define CODE_DCM_EquivalentDose                                            DSRBasicCodedEntry("128512", "DCM", "Equivalent Dose")
#define CODE_DCM_AbsorbedDose                                              DSRBasicCodedEntry("128513", "DCM", "Absorbed Dose")
#define CODE_DCM_NormalizationFactor                                       DSRBasicCodedEntry("128522", "DCM", "Normalization Factor")
#define CODE_DCM_OffsetFactor                                              DSRBasicCodedEntry("128523", "DCM", "Offset Factor")
#define CODE_DCM_TissueFraction                                            DSRBasicCodedEntry("128526", "DCM", "Tissue Fraction")
#define CODE_DCM_DistanceCorrection                                        DSRBasicCodedEntry("128527", "DCM", "Distance Correction")
#define CODE_DCM_ConversionFactor                                          DSRBasicCodedEntry("128528", "DCM", "Conversion Factor")
#define CODE_DCM_MaximumAbsorbedRadiationDose                              DSRBasicCodedEntry("128531", "DCM", "Maximum Absorbed Radiation Dose")
#define CODE_DCM_MinimumAbsorbedRadiationDose                              DSRBasicCodedEntry("128532", "DCM", "Minimum Absorbed Radiation Dose")
#define CODE_DCM_MeanAbsorbedRadiationDose                                 DSRBasicCodedEntry("128533", "DCM", "Mean Absorbed Radiation Dose")
#define CODE_DCM_ModeAbsorbedRadiationDose                                 DSRBasicCodedEntry("128534", "DCM", "Mode Absorbed Radiation Dose")
#define CODE_DCM_MaximumEquivalentRadiationDose                            DSRBasicCodedEntry("128535", "DCM", "Maximum Equivalent Radiation Dose")
#define CODE_DCM_MinimumEquivalentRadiationDose                            DSRBasicCodedEntry("128536", "DCM", "Minimum Equivalent Radiation Dose")
#define CODE_DCM_MeanEquivalentRadiationDose                               DSRBasicCodedEntry("128537", "DCM", "Mean Equivalent Radiation Dose")
#define CODE_DCM_ModeEquivalentRadiationDose                               DSRBasicCodedEntry("128538", "DCM", "Mode Equivalent Radiation Dose")
#define CODE_DCM_MedianAbsorbedRadiationDose                               DSRBasicCodedEntry("128539", "DCM", "Median Absorbed Radiation Dose")
#define CODE_DCM_MedianEquivalentRadiationDose                             DSRBasicCodedEntry("128540", "DCM", "Median Equivalent Radiation Dose")
#define CODE_DCM_IsRepeatedAcquisition                                     DSRBasicCodedEntry("128551", "DCM", "Is Repeated Acquisition")
#define CODE_DCM_ReasonForRepeatingAcquisition                             DSRBasicCodedEntry("128552", "DCM", "Reason for Repeating Acquisition")
#define CODE_DCM_PatientMotion                                             DSRBasicCodedEntry("128553", "DCM", "Patient motion")
#define CODE_DCM_SuboptimalContrastTiming                                  DSRBasicCodedEntry("128554", "DCM", "Suboptimal contrast timing")
#define CODE_DCM_AppropriateForTheIndications                              DSRBasicCodedEntry("128601", "DCM", "Appropriate for the indications")
#define CODE_DCM_ConsistentWithLabelingOfTheDevice                         DSRBasicCodedEntry("128602", "DCM", "Consistent with labeling of the device")
#define CODE_DCM_ApprovedForUseAtTheInstitution                            DSRBasicCodedEntry("128603", "DCM", "Approved for use at the institution")
#define CODE_DCM_ApprovedForUseInTheClinicalTrial                          DSRBasicCodedEntry("128604", "DCM", "Approved for use in the clinical trial")
#define CODE_DCM_ApprovedForUseonPregnantPatients                          DSRBasicCodedEntry("128605", "DCM", "Approved for use on pregnant patients")
#define CODE_DCM_AppropriateForTheDevice                                   DSRBasicCodedEntry("128606", "DCM", "Appropriate for the device")
#define CODE_DCM_InsideOperationalLimitsOfTheDevice                        DSRBasicCodedEntry("128607", "DCM", "Inside operational limits of the device")
#define CODE_DCM_OptimizedForTheDeviceInstance                             DSRBasicCodedEntry("128608", "DCM", "Optimized for the device instance")
#define CODE_DCM_DisapprovedForAnyUse                                      DSRBasicCodedEntry("128609", "DCM", "Disapproved for any use")
#define CODE_DCM_DeprecatedProtocol                                        DSRBasicCodedEntry("128610", "DCM", "Deprecated protocol")
#define CODE_DCM_ApprovedForExperimentalUse                                DSRBasicCodedEntry("128611", "DCM", "Approved for experimental use")
#define CODE_DCM_DisapprovedForExperimentalUse                             DSRBasicCodedEntry("128612", "DCM", "Disapproved for experimental use")
#define CODE_DCM_EligibleForReimbursement                                  DSRBasicCodedEntry("128613", "DCM", "Eligible for reimbursement")
#define CODE_DCM_EligibleForReimbursementonPerPatientBasis                 DSRBasicCodedEntry("128614", "DCM", "Eligible for reimbursement on per patient basis")
#define CODE_DCM_IneligibleForReimbursement                                DSRBasicCodedEntry("128615", "DCM", "Ineligible for reimbursement")
#define CODE_DCM_DisapprovedForUseonPregnantPatients                       DSRBasicCodedEntry("128617", "DCM", "Disapproved for use on pregnant patients")
#define CODE_DCM_InappropriateForTheDevice                                 DSRBasicCodedEntry("128618", "DCM", "Inappropriate for the device")
#define CODE_DCM_OutsideOperationalLimitsOfTheDevice                       DSRBasicCodedEntry("128619", "DCM", "Outside operational limits of the device")
#define CODE_DCM_NotOptimizedForTheDeviceInstance                          DSRBasicCodedEntry("128620", "DCM", "Not optimized for the device instance")
#define CODE_DCM_InappropriateForTheIndications                            DSRBasicCodedEntry("128621", "DCM", "Inappropriate for the indications")
#define CODE_DCM_InconsistentWithLabelingOfTheDevice                       DSRBasicCodedEntry("128622", "DCM", "Inconsistent with labeling of the device")
#define CODE_DCM_DisapprovedForUseAtTheInstitution                         DSRBasicCodedEntry("128623", "DCM", "Disapproved for use at the institution")
#define CODE_DCM_DisapprovedForUseInTheClinicalTrial                       DSRBasicCodedEntry("128624", "DCM", "Disapproved for use in the clinical trial")
#define CODE_DCM_HeadOfRadiology                                           DSRBasicCodedEntry("128670", "DCM", "Head of Radiology")
#define CODE_DCM_ChairOfProtocolCommittee                                  DSRBasicCodedEntry("128671", "DCM", "Chair of Protocol Committee")
#define CODE_DCM_AdministratorOfRadiologyDepartment                        DSRBasicCodedEntry("128673", "DCM", "Administrator of Radiology Department")
#define CODE_DCM_LeadRadiologicTechnologist                                DSRBasicCodedEntry("128674", "DCM", "Lead Radiologic Technologist")
#define CODE_DCM_HeadOfCardiology                                          DSRBasicCodedEntry("128675", "DCM", "Head of Cardiology")
#define CODE_DCM_RepresentativeOfProtocolCommittee                         DSRBasicCodedEntry("128676", "DCM", "Representative of Protocol Committee")
#define CODE_DCM_RepresentativeOfEthicsCommittee                           DSRBasicCodedEntry("128677", "DCM", "Representative of Ethics Committee")
#define CODE_DCM_3DGel                                                     DSRBasicCodedEntry("128701", "DCM", "3D Gel")
#define CODE_DCM_DiodeArray                                                DSRBasicCodedEntry("128702", "DCM", "Diode Array")
#define CODE_DCM_IonChamberArray                                           DSRBasicCodedEntry("128703", "DCM", "Ion Chamber Array")
#define CODE_DCM_Diode                                                     DSRBasicCodedEntry("128704", "DCM", "Diode")
#define CODE_DCM_LiquidIonChamber                                          DSRBasicCodedEntry("128705", "DCM", "Liquid Ion Chamber")
#define CODE_DCM_OSLD                                                      DSRBasicCodedEntry("128706", "DCM", "OSLD")
#define CODE_DCM_IonChamber                                                DSRBasicCodedEntry("128707", "DCM", "Ion Chamber")
#define CODE_DCM_DiamondDetector                                           DSRBasicCodedEntry("128708", "DCM", "Diamond Detector")
#define CODE_DCM_ForTeachingFileExport                                     DSRBasicCodedEntry("128710", "DCM", "For Teaching File Export")
#define CODE_DCM_ForClinicalTrialExport                                    DSRBasicCodedEntry("128711", "DCM", "For Clinical Trial Export")
#define CODE_DCM_AdditionalTeachingFileInformation                         DSRBasicCodedEntry("128712", "DCM", "Additional Teaching File Information")
#define CODE_DCM_ForResearchCollectionExport                               DSRBasicCodedEntry("128713", "DCM", "For Research Collection Export")
#define CODE_DCM_ForPublicationExport                                      DSRBasicCodedEntry("128714", "DCM", "For Publication Export")
#define CODE_DCM_DelayExportUntilFinalReportIsAvailable                    DSRBasicCodedEntry("128715", "DCM", "Delay export until final report is available")
#define CODE_DCM_DelayExportUntilClinicalInformationIsAvailable            DSRBasicCodedEntry("128716", "DCM", "Delay export until clinical information is available")
#define CODE_DCM_DelayExportUntilConfirmationOfDiagnosisIsAvailable        DSRBasicCodedEntry("128717", "DCM", "Delay export until confirmation of diagnosis is available")
#define CODE_DCM_DelayExportUntilHistopathologyIsAvailable                 DSRBasicCodedEntry("128718", "DCM", "Delay export until histopathology is available")
#define CODE_DCM_DelayExportUntilOtherLaboratoryResultsAreAvailable        DSRBasicCodedEntry("128719", "DCM", "Delay export until other laboratory results are available")
#define CODE_DCM_DelayExportUntilPatientIsDischarged                       DSRBasicCodedEntry("128720", "DCM", "Delay export until patient is discharged")
#define CODE_DCM_DelayExportUntilPatientDies                               DSRBasicCodedEntry("128721", "DCM", "Delay export until patient dies")
#define CODE_DCM_DelayExportUntilExpertReviewIsAvailable                   DSRBasicCodedEntry("128722", "DCM", "Delay export until expert review is available")
#define CODE_DCM_TeachingFileCategory                                      DSRBasicCodedEntry("128723", "DCM", "Teaching File Category")
#define CODE_DCM_LevelOfDifficulty                                         DSRBasicCodedEntry("128724", "DCM", "Level of Difficulty")
#define CODE_DCM_PrimaryLevel                                              DSRBasicCodedEntry("128725", "DCM", "Primary level")
#define CODE_DCM_IntermediateLevel                                         DSRBasicCodedEntry("128726", "DCM", "Intermediate level")
#define CODE_DCM_AdvancedLevel                                             DSRBasicCodedEntry("128727", "DCM", "Advanced level")
#define CODE_DCM_MusculoskeletalImagingSubjectMatter                       DSRBasicCodedEntry("128728", "DCM", "Musculoskeletal imaging subject matter")
#define CODE_DCM_PulmonaryImagingSubjectMatter                             DSRBasicCodedEntry("128729", "DCM", "Pulmonary imaging subject matter")
#define CODE_DCM_CardiovascularImagingSubjectMatter                        DSRBasicCodedEntry("128730", "DCM", "Cardiovascular imaging subject matter")
#define CODE_DCM_GastrointestinalImagingSubjectMatter                      DSRBasicCodedEntry("128731", "DCM", "Gastrointestinal imaging subject matter")
#define CODE_DCM_GenitourinaryImagingSubjectMatter                         DSRBasicCodedEntry("128732", "DCM", "Genitourinary imaging subject matter")
#define CODE_DCM_NeuroimagingSubjectMatter                                 DSRBasicCodedEntry("128733", "DCM", "Neuroimaging subject matter")
#define CODE_DCM_VascularAndInterventionalImagingSubjectMatter             DSRBasicCodedEntry("128734", "DCM", "Vascular and interventional imaging subject matter")
#define CODE_DCM_NuclearMedicineImagingSubjectMatter                       DSRBasicCodedEntry("128735", "DCM", "Nuclear medicine imaging subject matter")
#define CODE_DCM_UltrasoundImagingSubjectMatter                            DSRBasicCodedEntry("128736", "DCM", "Ultrasound imaging subject matter")
#define CODE_DCM_PediatricImagingSubjectMatter                             DSRBasicCodedEntry("128737", "DCM", "Pediatric imaging subject matter")
#define CODE_DCM_BreastImagingSubjectMatter                                DSRBasicCodedEntry("128738", "DCM", "Breast imaging subject matter")
#define CODE_DCM_UDI                                                       DSRBasicCodedEntry("128739", "DCM", "UDI")
#define CODE_DCM_LongitudinalTemporalOffsetFromEvent                       DSRBasicCodedEntry("128740", "DCM", "Longitudinal Temporal Offset from Event")
#define CODE_DCM_LongitudinalTemporalEventType                             DSRBasicCodedEntry("128741", "DCM", "Longitudinal Temporal Event Type")
#define CODE_DCM_EquipmentLandmark                                         DSRBasicCodedEntry("128750", "DCM", "Equipment Landmark")
#define CODE_DCM_CenterOfTableHead                                         DSRBasicCodedEntry("128751", "DCM", "Center of Table Head")
#define CODE_DCM_EquipmentLandmarkXPosition                                DSRBasicCodedEntry("128752", "DCM", "Equipment Landmark X Position")
#define CODE_DCM_EquipmentLandmarkZPosition                                DSRBasicCodedEntry("128753", "DCM", "Equipment Landmark Z Position")
#define CODE_DCM_PatientLocationFiducial                                   DSRBasicCodedEntry("128754", "DCM", "Patient Location Fiducial")
#define CODE_DCM_EquipmentLandmarkToPatientFiducialZDistance               DSRBasicCodedEntry("128756", "DCM", "Equipment Landmark to Patient Fiducial Z Distance")
#define CODE_DCM_PositionerIsocenterPrimaryAngle                           DSRBasicCodedEntry("128757", "DCM", "Positioner Isocenter Primary Angle")
#define CODE_DCM_PositionerIsocenterSecondaryAngle                         DSRBasicCodedEntry("128758", "DCM", "Positioner Isocenter Secondary Angle")
#define CODE_DCM_PositionerIsocenterDetectorRotationAngle                  DSRBasicCodedEntry("128759", "DCM", "Positioner Isocenter Detector Rotation Angle")
#define CODE_DCM_PositionerIsocenterPrimaryEndAngle                        DSRBasicCodedEntry("128760", "DCM", "Positioner Isocenter Primary End Angle")
#define CODE_DCM_PositionerIsocenterSecondaryEndAngle                      DSRBasicCodedEntry("128761", "DCM", "Positioner Isocenter Secondary End Angle")
#define CODE_DCM_PositionerIsocenterDetectorRotationEndAngle               DSRBasicCodedEntry("128762", "DCM", "Positioner Isocenter Detector Rotation End Angle")
#define CODE_DCM_TableHeadTiltEndAngle                                     DSRBasicCodedEntry("128763", "DCM", "Table Head Tilt End Angle")
#define CODE_DCM_TableHorizontalRotationEndAngle                           DSRBasicCodedEntry("128764", "DCM", "Table Horizontal Rotation End Angle")
#define CODE_DCM_TableCradleTiltEndAngle                                   DSRBasicCodedEntry("128765", "DCM", "Table Cradle Tilt End Angle")
#define CODE_DCM_TableXPositionToIsocenter                                 DSRBasicCodedEntry("128766", "DCM", "Table X Position to Isocenter")
#define CODE_DCM_TableYPositionToIsocenter                                 DSRBasicCodedEntry("128767", "DCM", "Table Y Position to Isocenter")
#define CODE_DCM_TableZPositionToIsocenter                                 DSRBasicCodedEntry("128768", "DCM", "Table Z Position to Isocenter")
#define CODE_DCM_TableXEndPositionToIsocenter                              DSRBasicCodedEntry("128769", "DCM", "Table X End Position to Isocenter")
#define CODE_DCM_TableYEndPositionToIsocenter                              DSRBasicCodedEntry("128770", "DCM", "Table Y End Position to Isocenter")
#define CODE_DCM_TableZEndPositionToIsocenter                              DSRBasicCodedEntry("128771", "DCM", "Table Z End Position to Isocenter")
#define CODE_DCM_ReferenceBasis                                            DSRBasicCodedEntry("128772", "DCM", "Reference Basis")
#define CODE_DCM_ReferenceGeometry                                         DSRBasicCodedEntry("128773", "DCM", "Reference Geometry")
#define CODE_DCM_PersonObserverLoginName                                   DSRBasicCodedEntry("128774", "DCM", "Person Observer's Login Name")
#define CODE_DCM_IdentifierWithinPersonObserverRole                        DSRBasicCodedEntry("128775", "DCM", "Identifier within Person Observer's Role")
#define CODE_DCM_GrayLevelRunLengthMatrix                                  DSRBasicCodedEntry("128776", "DCM", "Gray Level Run Length Matrix")
#define CODE_DCM_GrayLevelSizeZoneMatrix                                   DSRBasicCodedEntry("128777", "DCM", "Gray Level Size Zone Matrix")
#define CODE_DCM_GrayLevelDistanceZoneMatrix                               DSRBasicCodedEntry("128778", "DCM", "Gray Level Distance Zone Matrix")
#define CODE_DCM_NeighbourhoodGreyToneDifferenceMatrix                     DSRBasicCodedEntry("128779", "DCM", "Neighbourhood Grey Tone Difference Matrix")
#define CODE_DCM_NeighbouringGreyLevelDependenceMatrix                     DSRBasicCodedEntry("128780", "DCM", "Neighbouring Grey Level Dependence Matrix")
#define CODE_DCM_RETIRED_JointMaximumOfGLCM                                DSRBasicCodedEntry("128781", "DCM", "Joint Maximum of GLCM")
#define CODE_DCM_RETIRED_JointAverageOfGLCM                                DSRBasicCodedEntry("128782", "DCM", "Joint Average of GLCM")
#define CODE_DCM_RETIRED_JointVarianceOfGLCM                               DSRBasicCodedEntry("128783", "DCM", "Joint Variance of GLCM")
#define CODE_DCM_RETIRED_DifferenceAverageOfGLCM                           DSRBasicCodedEntry("128784", "DCM", "Difference Average of GLCM")
#define CODE_DCM_RETIRED_DifferenceVarianceOfGLCM                          DSRBasicCodedEntry("128785", "DCM", "Difference Variance of GLCM")
#define CODE_DCM_RETIRED_DifferenceEntropyOfGLCM                           DSRBasicCodedEntry("128786", "DCM", "Difference Entropy of GLCM")
#define CODE_DCM_RETIRED_SumAverageOfGLCM                                  DSRBasicCodedEntry("128787", "DCM", "Sum Average of GLCM")
#define CODE_DCM_RETIRED_SumVarianceOfGLCM                                 DSRBasicCodedEntry("128788", "DCM", "Sum Variance of GLCM")
#define CODE_DCM_RETIRED_SumEntropyOfGLCM                                  DSRBasicCodedEntry("128789", "DCM", "Sum Entropy of GLCM")
#define CODE_DCM_InverseDifferenceOfGLCM                                   DSRBasicCodedEntry("128790", "DCM", "Inverse Difference of GLCM")
#define CODE_DCM_InverseDifferenceNormalizedOfGLCM                         DSRBasicCodedEntry("128791", "DCM", "Inverse Difference Normalized of GLCM")
#define CODE_DCM_InverseDifferenceMomentNormalizedOfGLCM                   DSRBasicCodedEntry("128792", "DCM", "Inverse Difference Moment Normalized of GLCM")
#define CODE_DCM_RETIRED_InverseVarianceOfGLCM                             DSRBasicCodedEntry("128793", "DCM", "Inverse Variance of GLCM")
#define CODE_DCM_RETIRED_AutocorrelationOfGLCM                             DSRBasicCodedEntry("128794", "DCM", "Autocorrelation of GLCM")
#define CODE_DCM_RETIRED_ClusterTendencyOfGLCM                             DSRBasicCodedEntry("128795", "DCM", "Cluster Tendency of GLCM")
#define CODE_DCM_RETIRED_ClusterShadeOfGLCM                                DSRBasicCodedEntry("128796", "DCM", "Cluster Shade of GLCM")
#define CODE_DCM_RETIRED_ClusterProminenceOfGLCM                           DSRBasicCodedEntry("128797", "DCM", "Cluster Prominence of GLCM")
#define CODE_DCM_RETIRED_FirstMeasureOfInformationCorrelationOfGLCM        DSRBasicCodedEntry("128798", "DCM", "First Measure of Information Correlation of GLCM")
#define CODE_DCM_RETIRED_SecondMeasureOfInformationCorrelationOfGLCM       DSRBasicCodedEntry("128799", "DCM", "Second Measure of Information Correlation of GLCM")
#define CODE_DCM_RETIRED_ShortRunsEmphasis                                 DSRBasicCodedEntry("128801", "DCM", "Short Runs Emphasis")
#define CODE_DCM_RETIRED_LongRunsEmphasis                                  DSRBasicCodedEntry("128802", "DCM", "Long Runs Emphasis")
#define CODE_DCM_RETIRED_LowGrayLevelRunEmphasis                           DSRBasicCodedEntry("128803", "DCM", "Low Gray Level Run Emphasis")
#define CODE_DCM_RETIRED_HighGrayLevelRunEmphasis                          DSRBasicCodedEntry("128804", "DCM", "High Gray Level Run Emphasis")
#define CODE_DCM_RETIRED_ShortRunLowGrayLevelEmphasis                      DSRBasicCodedEntry("128805", "DCM", "Short Run Low Gray Level Emphasis")
#define CODE_DCM_RETIRED_ShortRunHighGrayLevelEmphasis                     DSRBasicCodedEntry("128806", "DCM", "Short Run High Gray Level Emphasis")
#define CODE_DCM_RETIRED_LongRunLowGrayLevelEmphasis                       DSRBasicCodedEntry("128807", "DCM", "Long Run Low Gray Level Emphasis")
#define CODE_DCM_RETIRED_LongRunHighGrayLevelEmphasis                      DSRBasicCodedEntry("128808", "DCM", "Long Run High Gray Level Emphasis")
#define CODE_DCM_RETIRED_GrayLevelNonuniformityInRuns                      DSRBasicCodedEntry("128809", "DCM", "Gray Level Nonuniformity in Runs")
#define CODE_DCM_GrayLevelNonuniformityInRunsNormalized                    DSRBasicCodedEntry("128810", "DCM", "Gray Level Nonuniformity in Runs Normalized")
#define CODE_DCM_RETIRED_RunLengthNonuniformity                            DSRBasicCodedEntry("128811", "DCM", "Run Length Nonuniformity")
#define CODE_DCM_RunLengthNonuniformityNormalized                          DSRBasicCodedEntry("128812", "DCM", "Run Length Nonuniformity Normalized")
#define CODE_DCM_RETIRED_RunPercentage                                     DSRBasicCodedEntry("128813", "DCM", "Run Percentage")
#define CODE_DCM_RETIRED_GrayLevelVarianceInRuns                           DSRBasicCodedEntry("128814", "DCM", "Gray Level Variance in Runs")
#define CODE_DCM_RETIRED_RunLengthVariance                                 DSRBasicCodedEntry("128815", "DCM", "Run Length Variance")
#define CODE_DCM_RETIRED_RunEntropy                                        DSRBasicCodedEntry("128816", "DCM", "Run Entropy")
#define CODE_DCM_RETIRED_SmallZoneEmphasis                                 DSRBasicCodedEntry("128821", "DCM", "Small Zone Emphasis")
#define CODE_DCM_RETIRED_LargeZoneEmphasis                                 DSRBasicCodedEntry("128822", "DCM", "Large Zone Emphasis")
#define CODE_DCM_RETIRED_LowGrayLevelZoneEmphasis                          DSRBasicCodedEntry("128823", "DCM", "Low Gray Level Zone Emphasis")
#define CODE_DCM_RETIRED_HighGrayLevelZoneEmphasis                         DSRBasicCodedEntry("128824", "DCM", "High Gray Level Zone Emphasis")
#define CODE_DCM_RETIRED_SmallZoneLowGrayLevelEmphasis                     DSRBasicCodedEntry("128825", "DCM", "Small Zone Low Gray Level Emphasis")
#define CODE_DCM_RETIRED_SmallZoneHighGrayLevelEmphasis                    DSRBasicCodedEntry("128826", "DCM", "Small Zone High Gray Level Emphasis")
#define CODE_DCM_RETIRED_LargeZoneLowGrayLevelEmphasis                     DSRBasicCodedEntry("128827", "DCM", "Large Zone Low Gray Level Emphasis")
#define CODE_DCM_RETIRED_LargeZoneHighGrayLevelEmphasis                    DSRBasicCodedEntry("128828", "DCM", "Large Zone High Gray Level Emphasis")
#define CODE_DCM_RETIRED_GrayLevelNonuniformityOfZoneCounts                DSRBasicCodedEntry("128829", "DCM", "Gray Level Nonuniformity of Zone Counts")
#define CODE_DCM_GrayLevelNonuniformityOfZoneCountsNormalized              DSRBasicCodedEntry("128830", "DCM", "Gray Level Nonuniformity of Zone Counts Normalized")
#define CODE_DCM_RETIRED_ZoneSizeNonuniformity                             DSRBasicCodedEntry("128831", "DCM", "Zone Size Nonuniformity")
#define CODE_DCM_ZoneSizeNonuniformityNormalized                           DSRBasicCodedEntry("128832", "DCM", "Zone Size Nonuniformity Normalized")
#define CODE_DCM_RETIRED_ZonePercentage                                    DSRBasicCodedEntry("128833", "DCM", "Zone Percentage")
#define CODE_DCM_RETIRED_GrayLevelVarianceInZones                          DSRBasicCodedEntry("128834", "DCM", "Gray Level Variance in Zones")
#define CODE_DCM_RETIRED_ZoneSizeVariance                                  DSRBasicCodedEntry("128835", "DCM", "Zone Size Variance")
#define CODE_DCM_RETIRED_ZoneSizeEntropy                                   DSRBasicCodedEntry("128836", "DCM", "Zone Size Entropy")
#define CODE_DCM_EligibilityReader                                         DSRBasicCodedEntry("129001", "DCM", "Eligibility Reader")
#define CODE_DCM_Designator                                                DSRBasicCodedEntry("129002", "DCM", "Designator")
#define CODE_DCM_ImageQualityController                                    DSRBasicCodedEntry("129003", "DCM", "Image Quality Controller")
#define CODE_DCM_ResultsQualityController                                  DSRBasicCodedEntry("129004", "DCM", "Results Quality Controller")
#define CODE_DCM_EditedModel                                               DSRBasicCodedEntry("129010", "DCM", "Edited Model")
#define CODE_DCM_ComponentModel                                            DSRBasicCodedEntry("129011", "DCM", "Component Model")
#define CODE_DCM_EducationalIntent                                         DSRBasicCodedEntry("129012", "DCM", "Educational Intent")
#define CODE_DCM_PlanningIntent                                            DSRBasicCodedEntry("129013", "DCM", "Planning Intent")
#define CODE_DCM_ToolFabrication                                           DSRBasicCodedEntry("129014", "DCM", "Tool Fabrication")
#define CODE_DCM_ProstheticFabrication                                     DSRBasicCodedEntry("129015", "DCM", "Prosthetic Fabrication")
#define CODE_DCM_ImplantFabrication                                        DSRBasicCodedEntry("129016", "DCM", "Implant Fabrication")
#define CODE_DCM_SimulationIntent                                          DSRBasicCodedEntry("129017", "DCM", "Simulation Intent")
#define CODE_DCM_US3DCAMModel                                              DSRBasicCodedEntry("129018", "DCM", "US 3D CAM model")
#define CODE_DCM_MixedModality3DCAMModel                                   DSRBasicCodedEntry("129019", "DCM", "Mixed Modality 3D CAM model")
#define CODE_DCM_PhotogrammetricImaging3DCAMModel                          DSRBasicCodedEntry("129020", "DCM", "Photogrammetric Imaging 3D CAM model")
#define CODE_DCM_LaserScanning3DCAMModel                                   DSRBasicCodedEntry("129021", "DCM", "Laser Scanning 3D CAM model")
#define CODE_DCM_FatFraction                                               DSRBasicCodedEntry("129100", "DCM", "Fat fraction")
#define CODE_DCM_WaterFatInPhase                                           DSRBasicCodedEntry("129101", "DCM", "Water/fat in phase")
#define CODE_DCM_WaterFatOutOfPhase                                        DSRBasicCodedEntry("129102", "DCM", "Water/fat out of phase")
#define CODE_DCM_WaterFraction                                             DSRBasicCodedEntry("129103", "DCM", "Water fraction")
#define CODE_DCM_PerfusionImageAnalysis                                    DSRBasicCodedEntry("129104", "DCM", "Perfusion image analysis")
#define CODE_DCM_DiffusionImageAnalysis                                    DSRBasicCodedEntry("129105", "DCM", "Diffusion image analysis")
#define CODE_DCM_DiffusionTractography                                     DSRBasicCodedEntry("129106", "DCM", "Diffusion tractography")
#define CODE_DCM_ImageUsedForTreatmentPlanning                             DSRBasicCodedEntry("129201", "DCM", "Image used for Treatment Planning")
#define CODE_DCM_ImageUsedForDoseCalculation                               DSRBasicCodedEntry("129202", "DCM", "Image used for Dose Calculation")
#define CODE_DCM_ImageAcquiredDuringTreatment                              DSRBasicCodedEntry("129203", "DCM", "Image Acquired during Treatment")
#define CODE_DCM_ImageUsedAsReferenceImageForTreatment                     DSRBasicCodedEntry("129204", "DCM", "Image used as Reference Image for Treatment")
#define CODE_DCM_RegistrationUsedInPlanning                                DSRBasicCodedEntry("129210", "DCM", "Registration used in Planning")
#define CODE_DCM_RegistrationCreatedDuringTreatment                        DSRBasicCodedEntry("129211", "DCM", "Registration created during Treatment")
#define CODE_DCM_CoilMarker                                                DSRBasicCodedEntry("129301", "DCM", "Coil Marker")
#define CODE_DCM_CylinderMarker                                            DSRBasicCodedEntry("129303", "DCM", "Cylinder Marker")
#define CODE_DCM_WireMarker                                                DSRBasicCodedEntry("129305", "DCM", "Wire Marker")
#define CODE_DCM_TransponderMarker                                         DSRBasicCodedEntry("129306", "DCM", "Transponder Marker")
#define CODE_DCM_MRMarker                                                  DSRBasicCodedEntry("129308", "DCM", "MR Marker")
#define CODE_DCM_InfraredReflectorMarker                                   DSRBasicCodedEntry("129309", "DCM", "Infrared Reflector Marker")
#define CODE_DCM_VisibleReflectorMarker                                    DSRBasicCodedEntry("129310", "DCM", "Visible Reflector Marker")
#define CODE_DCM_EffectiveAtomicNumber                                     DSRBasicCodedEntry("129320", "DCM", "Effective Atomic Number")
#define CODE_DCM_ModifiedHounsfieldUnit                                    DSRBasicCodedEntry("129321", "DCM", "Modified Hounsfield Unit")
#define CODE_DCM_ValueBasedImage                                           DSRBasicCodedEntry("129322", "DCM", "Value-based Image")
#define CODE_DCM_MaterialSpecificImage                                     DSRBasicCodedEntry("129323", "DCM", "Material Specific Image")
#define CODE_DCM_MaterialRemovedImage                                      DSRBasicCodedEntry("129324", "DCM", "Material Removed Image")
#define CODE_DCM_MaterialHighlightedImage                                  DSRBasicCodedEntry("129325", "DCM", "Material Highlighted Image")
#define CODE_DCM_MaterialSuppressedImage                                   DSRBasicCodedEntry("129326", "DCM", "Material Suppressed Image")
#define CODE_DCM_MaterialRecalculatedImage                                 DSRBasicCodedEntry("129327", "DCM", "Material Recalculated Image")
#define CODE_DCM_VolumeOccupancyImage                                      DSRBasicCodedEntry("129328", "DCM", "Volume Occupancy Image")
#define CODE_DCM_MassOccupancyImage                                        DSRBasicCodedEntry("129329", "DCM", "Mass Occupancy Image")
#define CODE_DCM_MinimumSurfaceRadiationDose                               DSRBasicCodedEntry("130001", "DCM", "Minimum Surface Radiation Dose")
#define CODE_DCM_MaximumSurfaceRadiationDose                               DSRBasicCodedEntry("130002", "DCM", "Maximum Surface Radiation Dose")
#define CODE_DCM_MinimumRadiationDose                                      DSRBasicCodedEntry("130003", "DCM", "Minimum Radiation Dose")
#define CODE_DCM_MaximumRadiationDose                                      DSRBasicCodedEntry("130004", "DCM", "Maximum Radiation Dose")
#define CODE_DCM_MinimumMeanRadiationDose                                  DSRBasicCodedEntry("130005", "DCM", "Minimum Mean Radiation Dose")
#define CODE_DCM_MaximumMeanRadiationDose                                  DSRBasicCodedEntry("130006", "DCM", "Maximum Mean Radiation Dose")
#define CODE_DCM_MinimumEquivalentUniformDose                              DSRBasicCodedEntry("130007", "DCM", "Minimum Equivalent Uniform Dose")
#define CODE_DCM_MaximumEquivalentUniformDose                              DSRBasicCodedEntry("130008", "DCM", "Maximum Equivalent Uniform Dose")
#define CODE_DCM_PrescriptionRadiationDose                                 DSRBasicCodedEntry("130009", "DCM", "Prescription Radiation Dose")
#define CODE_DCM_MinimumConformityIndex                                    DSRBasicCodedEntry("130010", "DCM", "Minimum Conformity Index")
#define CODE_DCM_MinimumHealthyTissueConformityIndex                       DSRBasicCodedEntry("130011", "DCM", "Minimum Healthy Tissue Conformity Index")
#define CODE_DCM_MinimumConformationNumber                                 DSRBasicCodedEntry("130012", "DCM", "Minimum Conformation Number")
#define CODE_DCM_MaximumHomogeneityIndex                                   DSRBasicCodedEntry("130013", "DCM", "Maximum Homogeneity Index")
#define CODE_DCM_MinimumPercentVolumeAtRadiationDose                       DSRBasicCodedEntry("130014", "DCM", "Minimum Percent Volume at Radiation Dose")
#define CODE_DCM_MaximumPercentVolumeAtRadiationDose                       DSRBasicCodedEntry("130015", "DCM", "Maximum Percent Volume at Radiation Dose")
#define CODE_DCM_MinimumAbsoluteVolumeAtRadiationDose                      DSRBasicCodedEntry("130016", "DCM", "Minimum Absolute Volume at Radiation Dose")
#define CODE_DCM_MaximumAbsoluteVolumeAtRadiationDose                      DSRBasicCodedEntry("130017", "DCM", "Maximum Absolute Volume at Radiation Dose")
#define CODE_DCM_MinimizeMeterset                                          DSRBasicCodedEntry("130018", "DCM", "Minimize Meterset")
#define CODE_DCM_SpecifiedRadiationDose                                    DSRBasicCodedEntry("130019", "DCM", "Specified Radiation Dose")
#define CODE_DCM_SpecifiedVolumeSize                                       DSRBasicCodedEntry("130020", "DCM", "Specified Volume Size")
#define CODE_DCM_SpecifiedVolumePercentage                                 DSRBasicCodedEntry("130021", "DCM", "Specified Volume Percentage")
#define CODE_DCM_RadiationCharacteristicsNote                              DSRBasicCodedEntry("130022", "DCM", "Radiation Characteristics Note")
#define CODE_DCM_BeamShapingNote                                           DSRBasicCodedEntry("130023", "DCM", "Beam Shaping Note")
#define CODE_DCM_TreatmentPlanningNote                                     DSRBasicCodedEntry("130024", "DCM", "Treatment Planning Note")
#define CODE_DCM_SpecialProcedureNote                                      DSRBasicCodedEntry("130025", "DCM", "Special Procedure Note")
#define CODE_DCM_PatientPositioningNote                                    DSRBasicCodedEntry("130026", "DCM", "Patient Positioning Note")
#define CODE_DCM_4DRadiationTreatmentNote                                  DSRBasicCodedEntry("130027", "DCM", "4D Radiation Treatment Note")
#define CODE_DCM_PatientSetupNote                                          DSRBasicCodedEntry("130028", "DCM", "Patient Setup Note")
#define CODE_DCM_PreviousTreatmentNote                                     DSRBasicCodedEntry("130029", "DCM", "Previous Treatment Note")
#define CODE_DCM_PlanningImagingNote                                       DSRBasicCodedEntry("130030", "DCM", "Planning Imaging Note")
#define CODE_DCM_DeliveryVerificationNote                                  DSRBasicCodedEntry("130031", "DCM", "Delivery Verification Note")
#define CODE_DCM_SimulationNote                                            DSRBasicCodedEntry("130032", "DCM", "Simulation Note")
#define CODE_DCM_RadiationTherapyParticle                                  DSRBasicCodedEntry("130033", "DCM", "Radiation Therapy Particle")
#define CODE_DCM_RTBeamEnergy                                              DSRBasicCodedEntry("130034", "DCM", "RT Beam Energy")
#define CODE_DCM_PatientPositioningProcedureNote                           DSRBasicCodedEntry("130035", "DCM", "Patient Positioning Procedure Note")
#define CODE_DCM_QAProcessNote                                             DSRBasicCodedEntry("130036", "DCM", "QA Process Note")
#define CODE_DCM_IonTherapyParticle                                        DSRBasicCodedEntry("130037", "DCM", "Ion Therapy Particle")
#define CODE_DCM_BrachytherapyIsotope                                      DSRBasicCodedEntry("130038", "DCM", "Brachytherapy Isotope")
#define CODE_DCM_AdaptiveRadiationTherapyNote                              DSRBasicCodedEntry("130039", "DCM", "Adaptive Radiation Therapy Note")
#define CODE_DCM_TeletherapyIsotope                                        DSRBasicCodedEntry("130040", "DCM", "Teletherapy Isotope")
#define CODE_DCM_RTTarget                                                  DSRBasicCodedEntry("130041", "DCM", "RT Target")
#define CODE_DCM_RTDoseCalculationStructure                                DSRBasicCodedEntry("130042", "DCM", "RT Dose Calculation Structure")
#define CODE_DCM_RTGeometricInformation                                    DSRBasicCodedEntry("130043", "DCM", "RT Geometric Information")
#define CODE_DCM_FixationOrPositioningDevice                               DSRBasicCodedEntry("130044", "DCM", "Fixation or Positioning Device")
#define CODE_DCM_BrachytherapyDevice                                       DSRBasicCodedEntry("130045", "DCM", "Brachytherapy Device")
#define CODE_DCM_NonSpecificVolume                                         DSRBasicCodedEntry("130046", "DCM", "Non-specific Volume")
#define CODE_DCM_ExternalBodyStructure                                     DSRBasicCodedEntry("130047", "DCM", "External Body Structure")
#define CODE_DCM_UnclassifiedVolume                                        DSRBasicCodedEntry("130048", "DCM", "Unclassified Volume")
#define CODE_DCM_CTVNodal                                                  DSRBasicCodedEntry("130049", "DCM", "CTV Nodal")
#define CODE_DCM_CTVPrimary                                                DSRBasicCodedEntry("130050", "DCM", "CTV Primary")
#define CODE_DCM_GTVNodal                                                  DSRBasicCodedEntry("130051", "DCM", "GTV Nodal")
#define CODE_DCM_GTVPrimary                                                DSRBasicCodedEntry("130052", "DCM", "GTV Primary")
#define CODE_DCM_PTVNodal                                                  DSRBasicCodedEntry("130053", "DCM", "PTV Nodal")
#define CODE_DCM_PTVPrimary                                                DSRBasicCodedEntry("130054", "DCM", "PTV Primary")
#define CODE_DCM_EntireBodyTargetVolume                                    DSRBasicCodedEntry("130055", "DCM", "Entire Body Target Volume")
#define CODE_DCM_ITV                                                       DSRBasicCodedEntry("130056", "DCM", "ITV")
#define CODE_DCM_PlanningOrganAtRiskVolume                                 DSRBasicCodedEntry("130057", "DCM", "Planning Organ At Risk Volume")
#define CODE_DCM_AvoidanceVolume                                           DSRBasicCodedEntry("130058", "DCM", "Avoidance Volume")
#define CODE_DCM_TreatedVolume                                             DSRBasicCodedEntry("130059", "DCM", "Treated Volume")
#define CODE_DCM_OrganAtRisk                                               DSRBasicCodedEntry("130060", "DCM", "Organ At Risk")
#define CODE_DCM_RadiationDoseShapingVolume                                DSRBasicCodedEntry("130061", "DCM", "Radiation Dose Shaping Volume")
#define CODE_DCM_ConformalityShell                                         DSRBasicCodedEntry("130062", "DCM", "Conformality Shell")
#define CODE_DCM_RadiationDoseNormalizationPoint                           DSRBasicCodedEntry("130063", "DCM", "Radiation Dose Normalization Point")
#define CODE_DCM_RadiationDoseReferencePoint                               DSRBasicCodedEntry("130064", "DCM", "Radiation Dose Reference Point")
#define CODE_DCM_DoseCalculationBoundingVolume                             DSRBasicCodedEntry("130065", "DCM", "Dose Calculation Bounding Volume")
#define CODE_DCM_RadiationInteractionVolume                                DSRBasicCodedEntry("130066", "DCM", "Radiation Interaction Volume")
#define CODE_DCM_PatientAnatomyModel                                       DSRBasicCodedEntry("130067", "DCM", "Patient Anatomy Model")
#define CODE_DCM_ExtendedPatientAnatomyModel                               DSRBasicCodedEntry("130068", "DCM", "Extended Patient Anatomy Model")
#define CODE_DCM_PatientSetupPoint                                         DSRBasicCodedEntry("130069", "DCM", "Patient Setup Point")
#define CODE_DCM_RoomLaserPatientSetupPoint                                DSRBasicCodedEntry("130070", "DCM", "Room Laser Patient Setup Point")
#define CODE_DCM_MoveableLaserPatientSetupPoint                            DSRBasicCodedEntry("130071", "DCM", "Moveable Laser Patient Setup Point")
#define CODE_DCM_ReferenceAcquisitionPoint                                 DSRBasicCodedEntry("130072", "DCM", "Reference Acquisition Point")
#define CODE_DCM_IsocentricTreatmentLocationPoint                          DSRBasicCodedEntry("130073", "DCM", "Isocentric Treatment Location Point")
#define CODE_DCM_SpecifiedConformityIndex                                  DSRBasicCodedEntry("130074", "DCM", "Specified Conformity Index")
#define CODE_DCM_SpecifiedHealthyTissueConformityIndex                     DSRBasicCodedEntry("130075", "DCM", "Specified Healthy Tissue Conformity Index")
#define CODE_DCM_SpecifiedConformationNumber                               DSRBasicCodedEntry("130076", "DCM", "Specified Conformation Number")
#define CODE_DCM_SpecifiedHomogeneityIndex                                 DSRBasicCodedEntry("130077", "DCM", "Specified Homogeneity Index")
#define CODE_DCM_BrachytherapySourceApplicator                             DSRBasicCodedEntry("130078", "DCM", "Brachytherapy Source Applicator")
#define CODE_DCM_BrachytherapyChannelShield                                DSRBasicCodedEntry("130079", "DCM", "Brachytherapy Channel Shield")
#define CODE_DCM_BrachytherapyChannel                                      DSRBasicCodedEntry("130080", "DCM", "Brachytherapy Channel")
#define CODE_DCM_UnclassifiedCombination                                   DSRBasicCodedEntry("130081", "DCM", "Unclassified Combination")
#define CODE_DCM_RelativeMassDensity                                       DSRBasicCodedEntry("130082", "DCM", "Relative Mass Density")
#define CODE_DCM_RelativeElectronDensity                                   DSRBasicCodedEntry("130083", "DCM", "Relative Electron Density")
#define CODE_DCM_EffectiveZ                                                DSRBasicCodedEntry("130084", "DCM", "Effective Z")
#define CODE_DCM_EffectiveZPerA                                            DSRBasicCodedEntry("130085", "DCM", "Effective Z per A")
#define CODE_DCM_RelativeLinearStoppingPower                               DSRBasicCodedEntry("130086", "DCM", "Relative Linear Stopping Power")
#define CODE_DCM_ReferenceEnergy                                           DSRBasicCodedEntry("130087", "DCM", "Reference Energy")
#define CODE_DCM_LinearCellKillFactor                                      DSRBasicCodedEntry("130088", "DCM", "Linear Cell Kill Factor")
#define CODE_DCM_QuadraticCellKillFactor                                   DSRBasicCodedEntry("130089", "DCM", "Quadratic Cell Kill Factor")
#define CODE_DCM_HighDoseFractionLinearCellKillFactor                      DSRBasicCodedEntry("130090", "DCM", "High Dose Fraction Linear Cell Kill Factor")
#define CODE_DCM_HalfTimeForTissueRepair                                   DSRBasicCodedEntry("130091", "DCM", "Half-time for Tissue Repair")
#define CODE_DCM_HighDoseFractionTransitionDose                            DSRBasicCodedEntry("130092", "DCM", "High Dose Fraction Transition Dose")
#define CODE_DCM_AtomicNumber                                              DSRBasicCodedEntry("130093", "DCM", "Atomic Number")
#define CODE_DCM_ElementalCompositionAtomicMassFraction                    DSRBasicCodedEntry("130094", "DCM", "Elemental Composition Atomic Mass Fraction")
#define CODE_DCM_AlphaGEUDValue                                            DSRBasicCodedEntry("130095", "DCM", "alpha gEUD Value")
#define CODE_DCM_SingleFraction                                            DSRBasicCodedEntry("130096", "DCM", "Single Fraction")
#define CODE_DCM_StandardFractionation                                     DSRBasicCodedEntry("130097", "DCM", "Standard Fractionation")
#define CODE_DCM_HypoFractionation                                         DSRBasicCodedEntry("130098", "DCM", "Hypo-fractionation")
#define CODE_DCM_HyperFractionation                                        DSRBasicCodedEntry("130099", "DCM", "Hyper-fractionation")
#define CODE_DCM_ContinuousTemporary                                       DSRBasicCodedEntry("130100", "DCM", "Continuous Temporary")
#define CODE_DCM_ContinuousPermanent                                       DSRBasicCodedEntry("130101", "DCM", "Continuous Permanent")
#define CODE_DCM_StaticBeam                                                DSRBasicCodedEntry("130102", "DCM", "Static Beam")
#define CODE_DCM_ArcBeam                                                   DSRBasicCodedEntry("130103", "DCM", "Arc Beam")
#define CODE_DCM_ConformalArcBeam                                          DSRBasicCodedEntry("130104", "DCM", "Conformal Arc Beam")
#define CODE_DCM_StepAndShootBeam                                          DSRBasicCodedEntry("130105", "DCM", "Step and Shoot Beam")
#define CODE_DCM_SlidingWindowBeam                                         DSRBasicCodedEntry("130106", "DCM", "Sliding Window Beam")
#define CODE_DCM_VMAT                                                      DSRBasicCodedEntry("130107", "DCM", "VMAT")
#define CODE_DCM_HelicalBeam                                               DSRBasicCodedEntry("130108", "DCM", "Helical Beam")
#define CODE_DCM_TopographicBeam                                           DSRBasicCodedEntry("130109", "DCM", "Topographic Beam")
#define CODE_DCM_Headframe                                                 DSRBasicCodedEntry("130110", "DCM", "Headframe")
#define CODE_DCM_HeadMask                                                  DSRBasicCodedEntry("130111", "DCM", "Head Mask")
#define CODE_DCM_HeadAndNeckMask                                           DSRBasicCodedEntry("130112", "DCM", "Head and Neck Mask")
#define CODE_DCM_Mold                                                      DSRBasicCodedEntry("130113", "DCM", "Mold")
#define CODE_DCM_Cast                                                      DSRBasicCodedEntry("130114", "DCM", "Cast")
#define CODE_DCM_BreastBoard                                               DSRBasicCodedEntry("130116", "DCM", "Breast Board")
#define CODE_DCM_BodyFrame                                                 DSRBasicCodedEntry("130117", "DCM", "Body Frame")
#define CODE_DCM_VacuumMold                                                DSRBasicCodedEntry("130118", "DCM", "Vacuum Mold")
#define CODE_DCM_WholeBodyPod                                              DSRBasicCodedEntry("130119", "DCM", "Whole Body Pod")
#define CODE_DCM_RectalBalloon                                             DSRBasicCodedEntry("130120", "DCM", "Rectal Balloon")
#define CODE_DCM_VaginalCylinder                                           DSRBasicCodedEntry("130121", "DCM", "Vaginal Cylinder")
#define CODE_DCM_ApertureBlock                                             DSRBasicCodedEntry("130123", "DCM", "Aperture Block")
#define CODE_DCM_AccessoryTray                                             DSRBasicCodedEntry("130124", "DCM", "Accessory Tray")
#define CODE_DCM_RadiotherapyApplicator                                    DSRBasicCodedEntry("130125", "DCM", "Radiotherapy Applicator")
#define CODE_DCM_RadiationTransportBasedMethods                            DSRBasicCodedEntry("130126", "DCM", "Radiation transport-based methods")
#define CODE_DCM_FractionationBasedOrTemporallyBasedMethods                DSRBasicCodedEntry("130127", "DCM", "Fractionation-based or temporally-based methods")
#define CODE_DCM_LocalEffectModel                                          DSRBasicCodedEntry("130128", "DCM", "Local Effect Model")
#define CODE_DCM_MicrodosimetricKineticModel                               DSRBasicCodedEntry("130129", "DCM", "Microdosimetric Kinetic Model")
#define CODE_DCM_Equivalent2GrayFractionsModel                             DSRBasicCodedEntry("130130", "DCM", "Equivalent 2-Gray Fractions Model")
#define CODE_DCM_LinearQuadraticModel                                      DSRBasicCodedEntry("130131", "DCM", "Linear-Quadratic Model")
#define CODE_DCM_LinearQuadraticModelWithTimeFactor                        DSRBasicCodedEntry("130132", "DCM", "Linear-Quadratic Model with Time Factor")
#define CODE_DCM_LinearQuadraticLinearModel                                DSRBasicCodedEntry("130133", "DCM", "Linear-Quadratic-Linear Model")
#define CODE_DCM_LinearQuadraticModelForLowDoseRateBrachytherapy           DSRBasicCodedEntry("130134", "DCM", "Linear-Quadratic Model for Low-Dose Rate Brachytherapy")
#define CODE_DCM_HistoricalRTPrescription                                  DSRBasicCodedEntry("130135", "DCM", "Historical RT Prescription")
#define CODE_DCM_RTPrescriptionInputImages                                 DSRBasicCodedEntry("130136", "DCM", "RT Prescription Input Images")
#define CODE_DCM_RTTreatmentPlanningInputImages                            DSRBasicCodedEntry("130137", "DCM", "RT Treatment Planning Input Images")
#define CODE_DCM_MultipleFixedSources                                      DSRBasicCodedEntry("130138", "DCM", "Multiple Fixed Sources")
#define CODE_DCM_SynchronizedRoboticTreatment                              DSRBasicCodedEntry("130139", "DCM", "Synchronized Robotic Treatment")
#define CODE_DCM_NonSynchronizedRoboticTreatment                           DSRBasicCodedEntry("130140", "DCM", "Non-Synchronized Robotic Treatment")
#define CODE_DCM_3HeliumNucleus                                            DSRBasicCodedEntry("130141", "DCM", "^3^Helium nucleus")
#define CODE_DCM_4HeliumNucleus                                            DSRBasicCodedEntry("130142", "DCM", "^4^Helium nucleus")
#define CODE_DCM_12CarbonNucleus                                           DSRBasicCodedEntry("130143", "DCM", "^12^Carbon nucleus")
#define CODE_DCM_16OxygenNucleus                                           DSRBasicCodedEntry("130144", "DCM", "^16^Oxygen nucleus")
#define CODE_DCM_PressureAboveWarningLimit                                 DSRBasicCodedEntry("130150", "DCM", "Pressure above warning limit")
#define CODE_DCM_PressureAboveAdjustmentLimit                              DSRBasicCodedEntry("130151", "DCM", "Pressure above adjustment limit")
#define CODE_DCM_FlowRateAboveWarningLimit                                 DSRBasicCodedEntry("130152", "DCM", "Flow rate above warning limit")
#define CODE_DCM_FlowRateAboveAdjustmentLimit                              DSRBasicCodedEntry("130153", "DCM", "Flow rate above adjustment limit")
#define CODE_DCM_TerminatedDueToRequestFromOperator                        DSRBasicCodedEntry("130154", "DCM", "Terminated due to request from operator")
#define CODE_DCM_FixedDurationPauseEnded                                   DSRBasicCodedEntry("130155", "DCM", "Fixed duration pause ended")
#define CODE_DCM_TerminatedDueToPressureAboveTerminationLimit              DSRBasicCodedEntry("130156", "DCM", "Terminated due to pressure above termination limit")
#define CODE_DCM_TerminatedDueToFlowRateAboveTerminationLimit              DSRBasicCodedEntry("130157", "DCM", "Terminated due to flow rate above termination limit")
#define CODE_DCM_TerminatedDueToExcessiveDurationPause                     DSRBasicCodedEntry("130158", "DCM", "Terminated due to excessive duration pause")
#define CODE_DCM_TerminatedDueToInjectorCommunicationLoss                  DSRBasicCodedEntry("130159", "DCM", "Terminated due to injector communication loss")
#define CODE_DCM_TerminatedDueToUnspecifiedInjectorFailure                 DSRBasicCodedEntry("130160", "DCM", "Terminated due to unspecified injector failure")
#define CODE_DCM_KeepVeinOpenStarted                                       DSRBasicCodedEntry("130161", "DCM", "Keep vein open started")
#define CODE_DCM_KeepVeinOpenEnded                                         DSRBasicCodedEntry("130162", "DCM", "Keep vein open ended")
#define CODE_DCM_SyringeAttached                                           DSRBasicCodedEntry("130163", "DCM", "Syringe attached")
#define CODE_DCM_SyringeDetached                                           DSRBasicCodedEntry("130164", "DCM", "Syringe detached")
#define CODE_DCM_TotalKeepVeinOpenVolumeAdministered                       DSRBasicCodedEntry("130165", "DCM", "Total Keep Vein Open Volume Administered")
#define CODE_DCM_AutomaticProgrammedAdministrationPhase                    DSRBasicCodedEntry("130168", "DCM", "Automatic Programmed Administration Phase")
#define CODE_DCM_AutomaticProgrammedDelayPhase                             DSRBasicCodedEntry("130169", "DCM", "Automatic Programmed Delay Phase")
#define CODE_DCM_RETIRED_AutomaticWithManualHoldPhase                      DSRBasicCodedEntry("130170", "DCM", "Automatic with Manual Hold Phase")
#define CODE_DCM_AutomatedManualInjectPhase                                DSRBasicCodedEntry("130171", "DCM", "Automated Manual Inject Phase")
#define CODE_DCM_ManuallyTriggeredInjectionInformation                     DSRBasicCodedEntry("130172", "DCM", "Manually Triggered Injection Information")
#define CODE_DCM_AutomatedAdministration                                   DSRBasicCodedEntry("130173", "DCM", "Automated Administration")
#define CODE_DCM_ManualAdministration                                      DSRBasicCodedEntry("130174", "DCM", "Manual Administration")
#define CODE_DCM_AirDetected                                               DSRBasicCodedEntry("130175", "DCM", "Air detected")
#define CODE_DCM_TerminatedDueToAirDetected                                DSRBasicCodedEntry("130176", "DCM", "Terminated due to air detected")
#define CODE_DCM_TerminatedByScanner                                       DSRBasicCodedEntry("130177", "DCM", "Terminated by scanner")
#define CODE_DCM_TerminatedDueToCriticalBatteryLevel                       DSRBasicCodedEntry("130178", "DCM", "Terminated due to critical battery level")
#define CODE_DCM_TerminatedDueToConsumableRemoval                          DSRBasicCodedEntry("130179", "DCM", "Terminated due to consumable removal")
#define CODE_DCM_AdministrationMode                                        DSRBasicCodedEntry("130181", "DCM", "Administration Mode")
#define CODE_DCM_PlannedImagingAgentAdministrationProcedureReport          DSRBasicCodedEntry("130182", "DCM", "Planned Imaging Agent Administration Procedure Report")
#define CODE_DCM_ImagingAgentInformation                                   DSRBasicCodedEntry("130183", "DCM", "Imaging Agent Information")
#define CODE_DCM_OsmolalityAt37C                                           DSRBasicCodedEntry("130184", "DCM", "Osmolality at 37C")
#define CODE_DCM_OsmolarityAt37C                                           DSRBasicCodedEntry("130185", "DCM", "Osmolarity at 37C")
#define CODE_DCM_ViscosityAt37C                                            DSRBasicCodedEntry("130186", "DCM", "Viscosity at 37C")
#define CODE_DCM_ImagingAgentWarmed                                        DSRBasicCodedEntry("130187", "DCM", "Imaging Agent Warmed")
#define CODE_DCM_ContrastTransverseRelaxivity                              DSRBasicCodedEntry("130188", "DCM", "Contrast Transverse Relaxivity")
#define CODE_DCM_IsIonic                                                   DSRBasicCodedEntry("130189", "DCM", "Is Ionic")
#define CODE_DCM_DosingFactor                                              DSRBasicCodedEntry("130190", "DCM", "Dosing Factor")
#define CODE_DCM_ImagingAgentComponentUsage                                DSRBasicCodedEntry("130191", "DCM", "Imaging Agent Component Usage")
#define CODE_DCM_ImagingAgentAdministrationSteps                           DSRBasicCodedEntry("130192", "DCM", "Imaging Agent Administration Steps")
#define CODE_DCM_PressureLimit                                             DSRBasicCodedEntry("130193", "DCM", "Pressure Limit")
#define CODE_DCM_TimeAfterTheStartOfInjection                              DSRBasicCodedEntry("130194", "DCM", "Time after the start of injection")
#define CODE_DCM_ImagingAgentAdministrationStep                            DSRBasicCodedEntry("130195", "DCM", "Imaging Agent Administration Step")
#define CODE_DCM_ImagingAgentAdministrationStepIdentifier                  DSRBasicCodedEntry("130196", "DCM", "Imaging Agent Administration Step Identifier")
#define CODE_DCM_ImagingAgentAdministrationDelay                           DSRBasicCodedEntry("130197", "DCM", "Imaging Agent Administration Delay")
#define CODE_DCM_ScanDelay                                                 DSRBasicCodedEntry("130198", "DCM", "Scan Delay")
#define CODE_DCM_ImagingAgentAdministrationStepsDescription                DSRBasicCodedEntry("130199", "DCM", "Imaging Agent Administration Steps Description")
#define CODE_DCM_ImagingAgentAdministrationProtocolName                    DSRBasicCodedEntry("130200", "DCM", "Imaging Agent Administration Protocol Name")
#define CODE_DCM_ImagingAgentAdministrationPhase                           DSRBasicCodedEntry("130202", "DCM", "Imaging Agent Administration Phase")
#define CODE_DCM_ImagingAgentAdministrationPhaseIdentifier                 DSRBasicCodedEntry("130203", "DCM", "Imaging Agent Administration Phase Identifier")
#define CODE_DCM_ImagingAgentAdministrationPhaseType                       DSRBasicCodedEntry("130204", "DCM", "Imaging Agent Administration Phase Type")
#define CODE_DCM_InitialVolumeOfImagingAgentInContainer                    DSRBasicCodedEntry("130205", "DCM", "Initial Volume of Imaging Agent in Container")
#define CODE_DCM_ResidualVolumeOfImagingAgentInContainer                   DSRBasicCodedEntry("130206", "DCM", "Residual Volume of Imaging Agent in Container")
#define CODE_DCM_RiseTime                                                  DSRBasicCodedEntry("130207", "DCM", "Rise Time")
#define CODE_DCM_StartingFlowRateOfAdministration                          DSRBasicCodedEntry("130208", "DCM", "Starting Flow Rate of administration")
#define CODE_DCM_EndingFlowRateOfAdministration                            DSRBasicCodedEntry("130209", "DCM", "Ending Flow Rate of administration")
#define CODE_DCM_BolusShapingCurve                                         DSRBasicCodedEntry("130210", "DCM", "Bolus Shaping Curve")
#define CODE_DCM_ImagingAgentAdministrationCompletionStatus                DSRBasicCodedEntry("130211", "DCM", "Imaging Agent Administration Completion Status")
#define CODE_DCM_ImagingAgentAdministrationAdverseEvents                   DSRBasicCodedEntry("130212", "DCM", "Imaging Agent Administration Adverse Events")
#define CODE_DCM_EstimatedExtravasationVolume                              DSRBasicCodedEntry("130214", "DCM", "Estimated Extravasation Volume")
#define CODE_DCM_AdverseEventDetectionDateTime                             DSRBasicCodedEntry("130215", "DCM", "Adverse Event Detection DateTime")
#define CODE_DCM_ReferencedImagingAgentAdministrationStepUID               DSRBasicCodedEntry("130216", "DCM", "Referenced Imaging Agent Administration Step UID")
#define CODE_DCM_ReferencedImagingAgentAdministrationPhaseIdentifier       DSRBasicCodedEntry("130217", "DCM", "Referenced Imaging Agent Administration Phase Identifier")
#define CODE_DCM_ProgrammableInjectorDevice                                DSRBasicCodedEntry("130218", "DCM", "Programmable Injector Device")
#define CODE_DCM_NumberOfInjectorHeads                                     DSRBasicCodedEntry("130219", "DCM", "Number of Injector Heads")
#define CODE_DCM_AdministrationDiscontinued                                DSRBasicCodedEntry("130220", "DCM", "Administration discontinued")
#define CODE_DCM_ImagingAgentVolumePerUnitOfPresentation                   DSRBasicCodedEntry("130221", "DCM", "Imaging Agent Volume per Unit of Presentation")
#define CODE_DCM_ImagingAgentAdministrationConsumable                      DSRBasicCodedEntry("130222", "DCM", "Imaging Agent Administration Consumable")
#define CODE_DCM_ImagingAgentAdministrationConsumableType                  DSRBasicCodedEntry("130223", "DCM", "Imaging Agent Administration Consumable Type")
#define CODE_DCM_ConsumableIsNew                                           DSRBasicCodedEntry("130224", "DCM", "Consumable is New")
#define CODE_DCM_PlannedImagingAgentAdministration                         DSRBasicCodedEntry("130226", "DCM", "Planned Imaging Agent Administration")
#define CODE_DCM_PerformedImagingAgentAdministration                       DSRBasicCodedEntry("130227", "DCM", "Performed Imaging Agent Administration")
#define CODE_DCM_ContrastVolumeLimit                                       DSRBasicCodedEntry("130228", "DCM", "Contrast Volume Limit")
#define CODE_DCM_FlowRateVsTime                                            DSRBasicCodedEntry("130229", "DCM", "Flow Rate vs Time")
#define CODE_DCM_PressureVsTime                                            DSRBasicCodedEntry("130230", "DCM", "Pressure vs Time")
#define CODE_DCM_BarcodeValue                                              DSRBasicCodedEntry("130231", "DCM", "Barcode Value")
#define CODE_DCM_ImagingAgentAdministrationGraph                           DSRBasicCodedEntry("130232", "DCM", "Imaging Agent Administration Graph")
#define CODE_DCM_ImagingAgentAdministrationInjectorEvents                  DSRBasicCodedEntry("130233", "DCM", "Imaging Agent Administration Injector Events")
#define CODE_DCM_ImagingAgentAdministrationInjectorEventType               DSRBasicCodedEntry("130234", "DCM", "Imaging Agent Administration Injector Event Type")
#define CODE_DCM_InjectorEventDetectionDateTime                            DSRBasicCodedEntry("130235", "DCM", "Injector Event Detection DateTime")
#define CODE_DCM_PlannedImagingAgentAdministrationSOPInstance              DSRBasicCodedEntry("130236", "DCM", "Planned Imaging Agent Administration SOP Instance")
#define CODE_DCM_ImagingAgentAdministrationActivity                        DSRBasicCodedEntry("130237", "DCM", "Imaging Agent Administration Activity")
#define CODE_DCM_ImagingAgentComponent                                     DSRBasicCodedEntry("130238", "DCM", "Imaging Agent Component")
#define CODE_DCM_ComponentVolume                                           DSRBasicCodedEntry("130239", "DCM", "Component Volume")
#define CODE_DCM_TotalPhaseVolumeAdministered                              DSRBasicCodedEntry("130240", "DCM", "Total Phase Volume Administered")
#define CODE_DCM_TotalStepVolumeAdministered                               DSRBasicCodedEntry("130241", "DCM", "Total Step Volume Administered")
#define CODE_DCM_TotalNumberOfManuallyTriggeredInjections                  DSRBasicCodedEntry("130242", "DCM", "Total number of manually triggered injections")
#define CODE_DCM_PeakFlowRateInPhaseActivity                               DSRBasicCodedEntry("130244", "DCM", "Peak Flow Rate in Phase Activity")
#define CODE_DCM_PeakPressureInPhaseActivity                               DSRBasicCodedEntry("130245", "DCM", "Peak Pressure in Phase Activity")
#define CODE_DCM_ImagingAgentAdministrationPerformedStepUID                DSRBasicCodedEntry("130246", "DCM", "Imaging Agent Administration Performed Step UID")
#define CODE_DCM_PatencyTestInjection                                      DSRBasicCodedEntry("130247", "DCM", "Patency Test Injection")
#define CODE_DCM_TransitTimeTestInjection                                  DSRBasicCodedEntry("130248", "DCM", "Transit Time Test Injection")
#define CODE_DCM_DiagnosticAdministration                                  DSRBasicCodedEntry("130249", "DCM", "Diagnostic Administration")
#define CODE_DCM_AdministrationStepType                                    DSRBasicCodedEntry("130250", "DCM", "Administration Step Type")
#define CODE_DCM_FlushAdministration                                       DSRBasicCodedEntry("130251", "DCM", "Flush Administration")
#define CODE_DCM_NegativeExponential                                       DSRBasicCodedEntry("130252", "DCM", "Negative exponential")
#define CODE_DCM_LinearCurve                                               DSRBasicCodedEntry("130253", "DCM", "Linear Curve")
#define CODE_DCM_ImagingAgentIdentifier                                    DSRBasicCodedEntry("130254", "DCM", "Imaging Agent Identifier")
#define CODE_DCM_ReferencedImagingAgentIdentifier                          DSRBasicCodedEntry("130255", "DCM", "Referenced Imaging Agent Identifier")
#define CODE_DCM_ConsumableCatheterType                                    DSRBasicCodedEntry("130257", "DCM", "Consumable Catheter Type")
#define CODE_DCM_ContrastReactionProphylacticAgent                         DSRBasicCodedEntry("130259", "DCM", "Contrast Reaction Prophylactic Agent")
#define CODE_DCM_ImagingAgentAdministrationPerformedPhaseUID               DSRBasicCodedEntry("130261", "DCM", "Imaging Agent Administration Performed Phase UID")
#define CODE_DCM_ReferencedImagingAgentAdministrationPhaseUID              DSRBasicCodedEntry("130262", "DCM", "Referenced Imaging Agent Administration Phase UID")
#define CODE_DCM_AutomaticProgrammedWaitPhase                              DSRBasicCodedEntry("130263", "DCM", "Automatic Programmed Wait Phase")
#define CODE_DCM_ImagingAgentAdministrationInjectorPhaseIdentifier         DSRBasicCodedEntry("130264", "DCM", "Imaging Agent Administration Injector Phase Identifier")
#define CODE_DCM_ImagingAgentAdministrationPhaseWithManualHold             DSRBasicCodedEntry("130265", "DCM", "Imaging Agent Administration Phase with Manual Hold")
#define CODE_DCM_ProgrammedHoldStarted                                     DSRBasicCodedEntry("130266", "DCM", "Programmed hold started")
#define CODE_DCM_ManualHoldStarted                                         DSRBasicCodedEntry("130267", "DCM", "Manual hold started")
#define CODE_DCM_ManualResumeFromHold                                      DSRBasicCodedEntry("130268", "DCM", "Manual resume from hold")
#define CODE_DCM_TerminatedHoldDueToTimeout                                DSRBasicCodedEntry("130269", "DCM", "Terminated hold due to timeout")
#define CODE_DCM_Median                                                    DSRBasicCodedEntry("130290", "DCM", "Median")
#define CODE_DCM_SkinOfParaspinalAreaOfTheNeck                             DSRBasicCodedEntry("130300", "DCM", "Skin of paraspinal area of the neck")
#define CODE_DCM_SkinOfParaspinalAreaOfTheSuperiorBack                     DSRBasicCodedEntry("130301", "DCM", "Skin of paraspinal area of the superior back")
#define CODE_DCM_SkinOfUpperParaspinalRegion                               DSRBasicCodedEntry("130302", "DCM", "Skin of upper paraspinal region")
#define CODE_DCM_SkinOfMidParaspinalRegion                                 DSRBasicCodedEntry("130303", "DCM", "Skin of mid paraspinal region")
#define CODE_DCM_SkinOfLowerParaspinalRegion                               DSRBasicCodedEntry("130304", "DCM", "Skin of lower paraspinal region")
#define CODE_DCM_SkinOfAnteriorHelixOfEar                                  DSRBasicCodedEntry("130305", "DCM", "Skin of anterior helix of ear")
#define CODE_DCM_SkinOfCaruncleOfEye                                       DSRBasicCodedEntry("130306", "DCM", "Skin of caruncle of eye")
#define CODE_DCM_SkinOfInferiorHelixOfEar                                  DSRBasicCodedEntry("130307", "DCM", "Skin of inferior helix of ear")
#define CODE_DCM_SkinOfInferiorPosteriorSurfaceOfThePinna                  DSRBasicCodedEntry("130308", "DCM", "Skin of inferior posterior surface of the pinna")
#define CODE_DCM_SkinOfLateralPartOfDorsumOfFoot                           DSRBasicCodedEntry("130309", "DCM", "Skin of lateral part of dorsum of foot")
#define CODE_DCM_SkinOfLowerAntihelixOfEar                                 DSRBasicCodedEntry("130310", "DCM", "Skin of lower antihelix of ear")
#define CODE_DCM_SkinOfLowerEyelidMargin                                   DSRBasicCodedEntry("130311", "DCM", "Skin of lower eyelid margin")
#define CODE_DCM_SkinOfInfraalarGroove                                     DSRBasicCodedEntry("130312", "DCM", "Skin of infraalar groove")
#define CODE_DCM_SkinOfMedialPartOfDorsumOfFoot                            DSRBasicCodedEntry("130313", "DCM", "Skin of medial part of dorsum of foot")
#define CODE_DCM_SkinOfParanasalCheek                                      DSRBasicCodedEntry("130314", "DCM", "Skin of paranasal cheek")
#define CODE_DCM_SkinOfPosteriorHelixOfEar                                 DSRBasicCodedEntry("130315", "DCM", "Skin of posterior helix of ear")
#define CODE_DCM_SkinOfPosteriorLobuleOfTheEar                             DSRBasicCodedEntry("130316", "DCM", "Skin of posterior lobule of the ear")
#define CODE_DCM_SkinOfSoleOfForefoot                                      DSRBasicCodedEntry("130317", "DCM", "Skin of sole of forefoot")
#define CODE_DCM_SkinOfSuperiorAntihelixOfEar                              DSRBasicCodedEntry("130318", "DCM", "Skin of superior antihelix of ear")
#define CODE_DCM_SkinOfSuperiorPosteriorHelixOfEar                         DSRBasicCodedEntry("130319", "DCM", "Skin of superior posterior helix of ear")
#define CODE_DCM_SkinOfSuperiorPosteriorSurfaceOfThePinna                  DSRBasicCodedEntry("130320", "DCM", "Skin of superior posterior surface of the pinna")
#define CODE_DCM_SkinOfUpperAntihelixOfEar                                 DSRBasicCodedEntry("130321", "DCM", "Skin of upper antihelix of ear")
#define CODE_DCM_SkinOfUpperEyelidMargin                                   DSRBasicCodedEntry("130322", "DCM", "Skin of upper eyelid margin")
#define CODE_DCM_SkinOfMidBack                                             DSRBasicCodedEntry("130323", "DCM", "Skin of mid back")
#define CODE_DCM_FunctionalConditionPresentDuringAcquisition               DSRBasicCodedEntry("130324", "DCM", "Functional condition present during acquisition")
#define CODE_DCM_JawPair                                                   DSRBasicCodedEntry("130330", "DCM", "Jaw Pair")
#define CODE_DCM_LeafPairs                                                 DSRBasicCodedEntry("130331", "DCM", "Leaf Pairs")
#define CODE_DCM_VariableCircularCollimator                                DSRBasicCodedEntry("130332", "DCM", "Variable Circular Collimator")
#define CODE_DCM_SingleLeaves                                              DSRBasicCodedEntry("130333", "DCM", "Single Leaves")
#define CODE_DCM_XOrientation                                              DSRBasicCodedEntry("130334", "DCM", "X Orientation")
#define CODE_DCM_YOrientation                                              DSRBasicCodedEntry("130335", "DCM", "Y Orientation")
#define CODE_DCM_PhysicalCompensator                                       DSRBasicCodedEntry("130340", "DCM", "Physical Compensator")
#define CODE_DCM_TotalBodyIrradiation                                      DSRBasicCodedEntry("130341", "DCM", "Total Body Irradiation")
#define CODE_DCM_TotalSkinIrradiation                                      DSRBasicCodedEntry("130342", "DCM", "Total Skin Irradiation")
#define CODE_DCM_IsocentricPatientSupportContinuousPitchAngle              DSRBasicCodedEntry("126812", "DCM", "Isocentric Patient Support Continuous Pitch Angle")
#define CODE_DCM_IsocentricPatientSupportContinuousRollAngle               DSRBasicCodedEntry("126813", "DCM", "Isocentric Patient Support Continuous Roll Angle")
#define CODE_DCM_IsocentricPatientSupportContinuousYawAngle                DSRBasicCodedEntry("126814", "DCM", "Isocentric Patient Support Continuous Yaw Angle")
#define CODE_DCM_IsocentricPatientSupportLateralPosition                   DSRBasicCodedEntry("126815", "DCM", "Isocentric Patient Support Lateral Position")
#define CODE_DCM_IsocentricPatientSupportLongitudinalPosition              DSRBasicCodedEntry("126816", "DCM", "Isocentric Patient Support Longitudinal Position")
#define CODE_DCM_IsocentricPatientSupportVerticalPosition                  DSRBasicCodedEntry("126817", "DCM", "Isocentric Patient Support Vertical Position")
#define CODE_DCM_ElectronFixedAperture                                     DSRBasicCodedEntry("130343", "DCM", "Electron Fixed Aperture")
#define CODE_DCM_PhotonFixedAperture                                       DSRBasicCodedEntry("130344", "DCM", "Photon Fixed Aperture")
#define CODE_DCM_IntraoperativeFixedAperture                               DSRBasicCodedEntry("130345", "DCM", "Intraoperative Fixed Aperture")
#define CODE_DCM_HardWedge                                                 DSRBasicCodedEntry("130346", "DCM", "Hard Wedge")
#define CODE_DCM_MotorizedWedge                                            DSRBasicCodedEntry("130347", "DCM", "Motorized Wedge")
#define CODE_DCM_DynamicWedge                                              DSRBasicCodedEntry("130348", "DCM", "Dynamic Wedge")
#define CODE_DCM_Graticule                                                 DSRBasicCodedEntry("130349", "DCM", "Graticule")
#define CODE_DCM_Reticle                                                   DSRBasicCodedEntry("130350", "DCM", "Reticle")
#define CODE_DCM_ImageDetector                                             DSRBasicCodedEntry("130351", "DCM", "Image Detector")
#define CODE_DCM_FilmHolder                                                DSRBasicCodedEntry("130352", "DCM", "Film Holder")
#define CODE_DCM_WinstonLutzPointer                                        DSRBasicCodedEntry("130353", "DCM", "Winston-Lutz Pointer")
#define CODE_DCM_BowtieFilter                                              DSRBasicCodedEntry("130354", "DCM", "Bowtie Filter")
#define CODE_DCM_FlatteningFilterBeam                                      DSRBasicCodedEntry("130355", "DCM", "Flattening Filter Beam")
#define CODE_DCM_NonFlatteningFilterBeam                                   DSRBasicCodedEntry("130356", "DCM", "Non-Flattening Filter Beam")
#define CODE_DCM_PartialFlatteningFilterBeam                               DSRBasicCodedEntry("130357", "DCM", "Partial Flattening Filter Beam")
#define CODE_DCM_PhysicsAssistant                                          DSRBasicCodedEntry("128678", "DCM", "Physics Assistant")
#define CODE_DCM_NominalRadiationSourceLocation                            DSRBasicCodedEntry("130358", "DCM", "Nominal Radiation Source Location")
#define CODE_DCM_TreatmentMachineIsocenter                                 DSRBasicCodedEntry("130359", "DCM", "Treatment Machine Isocenter")
#define CODE_DCM_FixedLaserSetupPoint                                      DSRBasicCodedEntry("130360", "DCM", "Fixed Laser Setup Point")
#define CODE_DCM_RadiotherapyTreatmentDevice                               DSRBasicCodedEntry("130361", "DCM", "Radiotherapy Treatment Device")
#define CODE_DCM_HeadNodeSet                                               DSRBasicCodedEntry("130362", "DCM", "Head Node Set")
#define CODE_DCM_BodyNodeSet                                               DSRBasicCodedEntry("130363", "DCM", "Body Node Set")
#define CODE_DCM_TrigeminalNodeSet                                         DSRBasicCodedEntry("130364", "DCM", "Trigeminal Node Set")
#define CODE_DCM_QANodePair                                                DSRBasicCodedEntry("130365", "DCM", "QA Node Pair")
#define CODE_DCM_QANode                                                    DSRBasicCodedEntry("130366", "DCM", "QA Node")
#define CODE_DCM_RTVRendition                                              DSRBasicCodedEntry("130370", "DCM", "RTV Rendition")
#define CODE_DCM_RTVAudioAndVideoRendition                                 DSRBasicCodedEntry("130371", "DCM", "RTV Audio and Video Rendition")
#define CODE_DCM_RTVStereoVideoRendition                                   DSRBasicCodedEntry("130372", "DCM", "RTV Stereo Video Rendition")
#define CODE_DCM_RTVAudioAndStereoVideoRendition                           DSRBasicCodedEntry("130373", "DCM", "RTV Audio and Stereo Video Rendition")
#define CODE_DCM_GeometricPurposeOfRegion                                  DSRBasicCodedEntry("130400", "DCM", "Geometric purpose of region")
#define CODE_DCM_VisualExplanation                                         DSRBasicCodedEntry("130401", "DCM", "Visual explanation")
#define CODE_DCM_ClassActivation                                           DSRBasicCodedEntry("130402", "DCM", "Class activation")
#define CODE_DCM_GradientWeightedClassActivation                           DSRBasicCodedEntry("130403", "DCM", "Gradient-weighted class activation")
#define CODE_DCM_Saliency                                                  DSRBasicCodedEntry("130404", "DCM", "Saliency")
#define CODE_DCM_PatientAttachedDoseControlObject                          DSRBasicCodedEntry("130405", "DCM", "Patient-Attached Dose Control Object")
#define CODE_DCM_NonUterineLeiomyosarcoma                                  DSRBasicCodedEntry("130406", "DCM", "Non-uterine leiomyosarcoma")
#define CODE_DCM_BoneAndSoftTissue                                         DSRBasicCodedEntry("130407", "DCM", "Bone and soft tissue")
#define CODE_DCM_PerivascularAdiposeTissueFatAttenuationIndex              DSRBasicCodedEntry("130408", "DCM", "Perivascular adipose tissue fat attenuation index")
#define CODE_DCM_PatientPosition                                           DSRBasicCodedEntry("130410", "DCM", "Patient position")
#define CODE_DCM_PatientRotationLongitudinal                               DSRBasicCodedEntry("130411", "DCM", "Patient rotation longitudinal")
#define CODE_DCM_PatientElevation                                          DSRBasicCodedEntry("130412", "DCM", "Patient elevation")
#define CODE_DCM_HyperventilationBegin                                     DSRBasicCodedEntry("130413", "DCM", "Hyperventilation begin")
#define CODE_DCM_HyperventilationEnd                                       DSRBasicCodedEntry("130414", "DCM", "Hyperventilation end")
#define CODE_DCM_PostHyperventilation                                      DSRBasicCodedEntry("130415", "DCM", "Post-hyperventilation")
#define CODE_DCM_AirflowThermistor                                         DSRBasicCodedEntry("130416", "DCM", "Airflow Thermistor")
#define CODE_DCM_AirflowThermocouple                                       DSRBasicCodedEntry("130417", "DCM", "Airflow Thermocouple")
#define CODE_DCM_AirflowNasalProng                                         DSRBasicCodedEntry("130418", "DCM", "Airflow Nasal Prong")
#define CODE_DCM_AirflowPVDF                                               DSRBasicCodedEntry("130419", "DCM", "Airflow PVDF")
#define CODE_DCM_AirflowCPAP                                               DSRBasicCodedEntry("130420", "DCM", "Airflow CPAP")
#define CODE_DCM_Airflow                                                   DSRBasicCodedEntry("130421", "DCM", "Airflow")
#define CODE_DCM_PAPPressure                                               DSRBasicCodedEntry("130422", "DCM", "PAP Pressure")
#define CODE_DCM_PAPLeakPressure                                           DSRBasicCodedEntry("130423", "DCM", "PAP Leak Pressure")
#define CODE_DCM_PAPTidalVolume                                            DSRBasicCodedEntry("130424", "DCM", "PAP Tidal Volume")
#define CODE_DCM_EsophagealPressure                                        DSRBasicCodedEntry("130425", "DCM", "Esophageal Pressure")
#define CODE_DCM_RespiratoryPressure                                       DSRBasicCodedEntry("130426", "DCM", "Respiratory Pressure")
#define CODE_DCM_ThoracicRespiratoryInductance                             DSRBasicCodedEntry("130427", "DCM", "Thoracic Respiratory Inductance")
#define CODE_DCM_AbdominalRespiratoryInductance                            DSRBasicCodedEntry("130428", "DCM", "Abdominal Respiratory Inductance")
#define CODE_DCM_ThoracicRespiratoryPVDF                                   DSRBasicCodedEntry("130429", "DCM", "Thoracic Respiratory PVDF")
#define CODE_DCM_AbdominalRespiratoryPVDF                                  DSRBasicCodedEntry("130430", "DCM", "Abdominal Respiratory PVDF")
#define CODE_DCM_ThoracicRespiratoryEffort                                 DSRBasicCodedEntry("130431", "DCM", "Thoracic Respiratory Effort")
#define CODE_DCM_AbdominalRespiratoryEffort                                DSRBasicCodedEntry("130432", "DCM", "Abdominal Respiratory Effort")
#define CODE_DCM_RespiratoryEffort                                         DSRBasicCodedEntry("130433", "DCM", "Respiratory Effort")
#define CODE_DCM_CO2Transcutaneous                                         DSRBasicCodedEntry("130434", "DCM", "CO2 Transcutaneous")
#define CODE_DCM_CO2WaveformEndTidalMainStream                             DSRBasicCodedEntry("130435", "DCM", "CO2 Waveform End-tidal Main-stream")
#define CODE_DCM_CO2TrendEndTidalMainStream                                DSRBasicCodedEntry("130436", "DCM", "CO2 Trend End-tidal Main-stream")
#define CODE_DCM_CO2WaveformEndTidalSideStream                             DSRBasicCodedEntry("130437", "DCM", "CO2 Waveform End-tidal Side-stream")
#define CODE_DCM_CO2TrendEndTidalSideStream                                DSRBasicCodedEntry("130438", "DCM", "CO2 Trend End-tidal Side-stream")
#define CODE_DCM_CO2WaveformMainStream                                     DSRBasicCodedEntry("130439", "DCM", "CO2 Waveform Main-stream")
#define CODE_DCM_CO2WaveformSideStream                                     DSRBasicCodedEntry("130440", "DCM", "CO2 Waveform Side-stream")
#define CODE_DCM_CO2TrendMainStream                                        DSRBasicCodedEntry("130441", "DCM", "CO2 Trend Main-stream")
#define CODE_DCM_CO2TrendSideStream                                        DSRBasicCodedEntry("130442", "DCM", "CO2 Trend Side-stream")
#define CODE_DCM_CO2Respiration                                            DSRBasicCodedEntry("130443", "DCM", "CO2 Respiration")
#define CODE_DCM_RTTreatmentWithAdHocPlanning                              DSRBasicCodedEntry("130444", "DCM", "RT Treatment with Ad Hoc Planning")
#define CODE_DCM_ImagingAgentAdministrationStepSequenceNumber              DSRBasicCodedEntry("130445", "DCM", "Imaging Agent Administration Step Sequence Number")
#define CODE_DCM_OperatorDecisionToTerminateTreatment                      DSRBasicCodedEntry("130450", "DCM", "Operator decision to terminate treatment")
#define CODE_DCM_PatientDecisionToTerminateTreatment                       DSRBasicCodedEntry("130451", "DCM", "Patient decision to terminate treatment")
#define CODE_DCM_PhysicianDecisionToTerminateTreatment                     DSRBasicCodedEntry("130452", "DCM", "Physician decision to terminate treatment")
#define CODE_DCM_TreatmentTerminated                                       DSRBasicCodedEntry("130453", "DCM", "Treatment Terminated")
#define CODE_DCM_ResolvedByOverridingInterlock                             DSRBasicCodedEntry("130454", "DCM", "Resolved by overriding Interlock")
#define CODE_DCM_ResolvedByRepositioningPatient                            DSRBasicCodedEntry("130455", "DCM", "Resolved by repositioning Patient")
#define CODE_DCM_BolusPresent                                              DSRBasicCodedEntry("130456", "DCM", "Bolus Present")
#define CODE_DCM_ConePresent                                               DSRBasicCodedEntry("130457", "DCM", "Cone Present")
#define CODE_DCM_BlockPresent                                              DSRBasicCodedEntry("130458", "DCM", "Block Present")
#define CODE_DCM_ApplicatorPresent                                         DSRBasicCodedEntry("130459", "DCM", "Applicator Present")
#define CODE_DCM_HeadframePresent                                          DSRBasicCodedEntry("130460", "DCM", "Headframe Present")
#define CODE_DCM_InappropriatePatientOrientation                           DSRBasicCodedEntry("130461", "DCM", "Inappropriate Patient Orientation")
#define CODE_DCM_InappropriatePatientPosition                              DSRBasicCodedEntry("130462", "DCM", "Inappropriate Patient Position")
#define CODE_DCM_MachineNotAvailable                                       DSRBasicCodedEntry("130463", "DCM", "Machine Not Available")
#define CODE_DCM_ChangeInPatientAnatomy                                    DSRBasicCodedEntry("130464", "DCM", "Change in Patient Anatomy")
#define CODE_DCM_MachineCalibrationAdjustment                              DSRBasicCodedEntry("130465", "DCM", "Machine Calibration Adjustment")
#define CODE_DCM_UnavailabilityOfABeamModifier                             DSRBasicCodedEntry("130466", "DCM", "Unavailability of a Beam Modifier")
#define CODE_DCM_MachineCapabilityLicenseExpired                           DSRBasicCodedEntry("130467", "DCM", "Machine Capability License Expired")
#define CODE_DCM_BeamTargetingToleranceViolation                           DSRBasicCodedEntry("130468", "DCM", "Beam Targeting Tolerance Violation")
#define CODE_DCM_MetersetToleranceViolation                                DSRBasicCodedEntry("130469", "DCM", "Meterset Tolerance Violation")
#define CODE_DCM_DeliveryRateToleranceViolation                            DSRBasicCodedEntry("130470", "DCM", "Delivery Rate Tolerance Violation")
#define CODE_DCM_JawPositionToleranceViolation                             DSRBasicCodedEntry("130471", "DCM", "Jaw Position Tolerance Violation")
#define CODE_DCM_MLCPositionToleranceViolation                             DSRBasicCodedEntry("130472", "DCM", "MLC Position Tolerance Violation")
#define CODE_DCM_SourcePositionToleranceViolation                          DSRBasicCodedEntry("130473", "DCM", "Source Position Tolerance Violation")
#define CODE_DCM_DoseRateToleranceViolation                                DSRBasicCodedEntry("130474", "DCM", "Dose Rate Tolerance Violation")
#define CODE_DCM_PrimaryFluenceMonitoringSystemInterlock                   DSRBasicCodedEntry("130475", "DCM", "Primary Fluence Monitoring System Interlock")
#define CODE_DCM_SecondaryFluenceMonitoringSystemInterlock                 DSRBasicCodedEntry("130476", "DCM", "Secondary Fluence Monitoring System Interlock")
#define CODE_DCM_TimerInterlock                                            DSRBasicCodedEntry("130477", "DCM", "Timer Interlock")
#define CODE_DCM_DoorInterlock                                             DSRBasicCodedEntry("130478", "DCM", "Door Interlock")
#define CODE_DCM_PatientMotionInterlock                                    DSRBasicCodedEntry("130479", "DCM", "Patient Motion Interlock")
#define CODE_DCM_FamilyHistoryOfNonMelanomaSkinCancer                      DSRBasicCodedEntry("130480", "DCM", "Family history of non-melanoma skin cancer")
#define CODE_DCM_FamilyHistoryOfMelanomaInSitu                             DSRBasicCodedEntry("130481", "DCM", "Family history of melanoma in situ")
#define CODE_DCM_HistoryOfNonMelanomaSkinCancer                            DSRBasicCodedEntry("130482", "DCM", "History of non-melanoma skin cancer")
#define CODE_DCM_NumberOfMalignantMelanomas                                DSRBasicCodedEntry("130483", "DCM", "Number of malignant melanomas")
#define CODE_DCM_NumberOfMelanomasInSitu                                   DSRBasicCodedEntry("130484", "DCM", "Number of melanomas in situ")
#define CODE_DCM_FirmSkinLesion                                            DSRBasicCodedEntry("130485", "DCM", "Firm skin lesion")
#define CODE_DCM_RaisedSkinLesion                                          DSRBasicCodedEntry("130486", "DCM", "Raised skin lesion")
#define CODE_DCM_NumberOfFirstDegreeRelativesAffectedByMalignantMelanoma   DSRBasicCodedEntry("130487", "DCM", "Number of first-degree relatives affected by malignant melanoma")
#define CODE_DCM_RegionInSpace                                             DSRBasicCodedEntry("130488", "DCM", "Region in Space")
#define CODE_DCM_ReferencedRegionOfInterestIdentifier                      DSRBasicCodedEntry("130489", "DCM", "Referenced Region of Interest Identifier")
#define CODE_DCM_Centerline                                                DSRBasicCodedEntry("130490", "DCM", "Centerline")
#define CODE_DCM_StimulationMode                                           DSRBasicCodedEntry("130491", "DCM", "Stimulation Mode")
#define CODE_DCM_StimulusSamplePosition                                    DSRBasicCodedEntry("130492", "DCM", "Stimulus Sample Position")
#define CODE_DCM_StimulusTimeOffset                                        DSRBasicCodedEntry("130493", "DCM", "Stimulus Time Offset")
#define CODE_DCM_NumberOfStimulusEvents                                    DSRBasicCodedEntry("130494", "DCM", "Number of Stimulus Events")
#define CODE_DCM_FrequencyOfStimulusEvents                                 DSRBasicCodedEntry("130495", "DCM", "Frequency of Stimulus Events")
#define CODE_DCM_AccumulatedDoseData                                       DSRBasicCodedEntry("130500", "DCM", "Accumulated Dose Data")
#define CODE_DCM_IrradiationEventSummaryData                               DSRBasicCodedEntry("130501", "DCM", "Irradiation Event Summary Data")
#define CODE_DCM_ReferencePointDosimetry                                   DSRBasicCodedEntry("130502", "DCM", "Reference Point Dosimetry")
#define CODE_DCM_IsRejectedAcquisition                                     DSRBasicCodedEntry("130503", "DCM", "Is Rejected Acquisition")
#define CODE_DCM_ReasonForRejectingAcquisition                             DSRBasicCodedEntry("130504", "DCM", "Reason for Rejecting Acquisition")
#define CODE_DCM_IrradiationDetails                                        DSRBasicCodedEntry("130505", "DCM", "Irradiation Details")
#define CODE_DCM_RDSRFrameOfReferenceOrigin                                DSRBasicCodedEntry("130506", "DCM", "RDSR Frame of Reference Origin")
#define CODE_DCM_RDSRFrameOfReferenceDescription                           DSRBasicCodedEntry("130507", "DCM", "RDSR Frame of Reference Description")
#define CODE_DCM_RadiationSourceCharacteristics                            DSRBasicCodedEntry("130508", "DCM", "Radiation Source Characteristics")
#define CODE_DCM_XRayFilterThickness                                       DSRBasicCodedEntry("130509", "DCM", "X-Ray Filter Thickness")
#define CODE_DCM_ReportedValueType                                         DSRBasicCodedEntry("130510", "DCM", "Reported Value Type")
#define CODE_DCM_RadiationTechnique                                        DSRBasicCodedEntry("130511", "DCM", "Radiation Technique")
#define CODE_DCM_Filtration                                                DSRBasicCodedEntry("130512", "DCM", "Filtration")
#define CODE_DCM_Attenuators                                               DSRBasicCodedEntry("130513", "DCM", "Attenuators")
#define CODE_DCM_RadiationOutput                                           DSRBasicCodedEntry("130514", "DCM", "Radiation Output")
#define CODE_DCM_AirKermaAtOutputMeasurementPoint                          DSRBasicCodedEntry("130515", "DCM", "Air Kerma at Output Measurement Point")
#define CODE_DCM_RadiationFieldArea                                        DSRBasicCodedEntry("130516", "DCM", "Radiation Field Area")
#define CODE_DCM_RadiationFieldOutline                                     DSRBasicCodedEntry("130517", "DCM", "Radiation Field Outline")
#define CODE_DCM_ValueTiming                                               DSRBasicCodedEntry("130518", "DCM", "Value Timing")
#define CODE_DCM_XRaySourceReferenceCoordinateSystem                       DSRBasicCodedEntry("130519", "DCM", "X-Ray Source Reference Coordinate System")
#define CODE_DCM_TransformationMatrix                                      DSRBasicCodedEntry("130520", "DCM", "Transformation Matrix")
#define CODE_DCM_CenterOfRotation                                          DSRBasicCodedEntry("130521", "DCM", "Center of Rotation")
#define CODE_DCM_RotationPlaneNormalPoint                                  DSRBasicCodedEntry("130522", "DCM", "Rotation Plane Normal Point")
#define CODE_DCM_RotationAngle                                             DSRBasicCodedEntry("130523", "DCM", "Rotation Angle")
#define CODE_DCM_BeamPosition                                              DSRBasicCodedEntry("130524", "DCM", "Beam Position")
#define CODE_DCM_OutputMeasurementPointPosition                            DSRBasicCodedEntry("130525", "DCM", "Output Measurement Point Position")
#define CODE_DCM_ReferencePointPosition                                    DSRBasicCodedEntry("130526", "DCM", "Reference Point Position")
#define CODE_DCM_IdentificationOfTheAttenuator                             DSRBasicCodedEntry("130527", "DCM", "Identification of the Attenuator")
#define CODE_DCM_AttenuatorPosition                                        DSRBasicCodedEntry("130528", "DCM", "Attenuator Position")
#define CODE_DCM_PatientAttenuationCharacteristics                         DSRBasicCodedEntry("130529", "DCM", "Patient Attenuation Characteristics")
#define CODE_DCM_ProcedureCharacteristics                                  DSRBasicCodedEntry("130530", "DCM", "Procedure Characteristics")
#define CODE_DCM_AttenuatorCharacteristics                                 DSRBasicCodedEntry("130531", "DCM", "Attenuator Characteristics")
#define CODE_DCM_DurationOfTimePeriod                                      DSRBasicCodedEntry("130532", "DCM", "Duration of Time Period")
#define CODE_DCM_BeginningOfTimePeriod                                     DSRBasicCodedEntry("130533", "DCM", "Beginning of Time Period")
#define CODE_DCM_EndOfTimePeriod                                           DSRBasicCodedEntry("130534", "DCM", "End of Time Period")
#define CODE_DCM_MiddleOfTimePeriod                                        DSRBasicCodedEntry("130535", "DCM", "Middle of Time Period")
#define CODE_DCM_RoomOrigin                                                DSRBasicCodedEntry("130536", "DCM", "Room Origin")
#define CODE_DCM_EquipmentOrigin                                           DSRBasicCodedEntry("130537", "DCM", "Equipment Origin")
#define CODE_DCM_PatientSupportOrigin                                      DSRBasicCodedEntry("130538", "DCM", "Patient Support Origin")
#define CODE_DCM_IsocenterOrigin                                           DSRBasicCodedEntry("130539", "DCM", "Isocenter Origin")
#define CODE_DCM_PatientCoordinateSystemOrigin                             DSRBasicCodedEntry("130540", "DCM", "Patient Coordinate System Origin")
#define CODE_DCM_10cmDosimetryPhantom                                      DSRBasicCodedEntry("130541", "DCM", "10 cm Dosimetry Phantom")
#define CODE_DCM_MagneticFieldStrength                                     DSRBasicCodedEntry("130542", "DCM", "Magnetic field strength")
#define CODE_DCM_EndorectalCoilUsed                                        DSRBasicCodedEntry("130543", "DCM", "Endorectal coil used")
#define CODE_DCM_EndorectalCoilType                                        DSRBasicCodedEntry("130544", "DCM", "Endorectal coil type")
#define CODE_DCM_InflatableEndorectalCoilFillSubstance                     DSRBasicCodedEntry("130545", "DCM", "Inflatable endorectal coil fill substance")
#define CODE_DCM_CrossSectionalScanPlaneOrientation                        DSRBasicCodedEntry("130546", "DCM", "Cross-sectional scan plane orientation")
#define CODE_DCM_DynamicContrastEnhancedTemporalResolution                 DSRBasicCodedEntry("130547", "DCM", "Dynamic contrast-enhanced temporal resolution")
#define CODE_DCM_GenitourinaryHistory                                      DSRBasicCodedEntry("130548", "DCM", "Genitourinary History")
#define CODE_DCM_ImagingStudyQuality                                       DSRBasicCodedEntry("130549", "DCM", "Imaging Study Quality")
#define CODE_DCM_ImagingSeriesQuality                                      DSRBasicCodedEntry("130550", "DCM", "Imaging Series Quality")
#define CODE_DCM_ReportingSystem                                           DSRBasicCodedEntry("130551", "DCM", "Reporting system")
#define CODE_DCM_ProstateMRIRelevantProcedureInformation                   DSRBasicCodedEntry("130552", "DCM", "Prostate MRI relevant procedure information")
#define CODE_DCM_ProstateImagingFindings                                   DSRBasicCodedEntry("130553", "DCM", "Prostate Imaging Findings")
#define CODE_DCM_OverallProstateFinding                                    DSRBasicCodedEntry("130554", "DCM", "Overall Prostate Finding")
#define CODE_DCM_LocalizedProstateFinding                                  DSRBasicCodedEntry("130555", "DCM", "Localized Prostate Finding")
#define CODE_DCM_ProstateRelationalMeasurements                            DSRBasicCodedEntry("130556", "DCM", "Prostate relational measurements")
#define CODE_DCM_DistanceFromNeurovascularBundle                           DSRBasicCodedEntry("130557", "DCM", "Distance from neurovascular bundle")
#define CODE_DCM_LesionCapsularContactLength                               DSRBasicCodedEntry("130558", "DCM", "Lesion capsular contact length")
#define CODE_DCM_ExtraProstaticFinding                                     DSRBasicCodedEntry("130559", "DCM", "Extra-prostatic Finding")
#define CODE_DCM_PIRADSLocalizedAbnormalityAssessment                      DSRBasicCodedEntry("130560", "DCM", "PI-RADS Localized Abnormality Assessment")
#define CODE_DCM_PIRADST2WILesionAssessment                                DSRBasicCodedEntry("130561", "DCM", "PI-RADS T2WI Lesion Assessment")
#define CODE_DCM_PIRADSDWILesionAssessment                                 DSRBasicCodedEntry("130562", "DCM", "PI-RADS DWI Lesion Assessment")
#define CODE_DCM_PIRADSDCELesionAssessment                                 DSRBasicCodedEntry("130563", "DCM", "PI-RADS DCE Lesion Assessment")
#define CODE_DCM_PIRADSV2dot0                                              DSRBasicCodedEntry("130564", "DCM", "PI-RADS v2.0")
#define CODE_DCM_PIRADSV2dot1                                              DSRBasicCodedEntry("130565", "DCM", "PI-RADS v2.1")
#define CODE_DCM_DiffusionWeightedAcquisitionHighestBValueImage            DSRBasicCodedEntry("130566", "DCM", "Diffusion-weighted Acquisition Highest b-value image")
#define CODE_DCM_DynamicContrastEnhancedAcquisition                        DSRBasicCodedEntry("130567", "DCM", "Dynamic Contrast-Enhanced Acquisition")
#define CODE_DCM_DynamicContrastEnhancedAcquisitionSubtractionImage        DSRBasicCodedEntry("130568", "DCM", "Dynamic Contrast-Enhanced Acquisition Subtraction image")
#define CODE_DCM_UtricleCyst                                               DSRBasicCodedEntry("130569", "DCM", "Utricle cyst")
#define CODE_DCM_ProtocolNotFollowed                                       DSRBasicCodedEntry("130570", "DCM", "Protocol not followed")
#define CODE_DCM_CoilPlacementConcern                                      DSRBasicCodedEntry("130571", "DCM", "Coil placement concern")
#define CODE_DCM_CoilSelectionConcern                                      DSRBasicCodedEntry("130572", "DCM", "Coil selection concern")
#define CODE_DCM_StudyPerformedDidNotMatchRequest                          DSRBasicCodedEntry("130573", "DCM", "Study performed did not match request")
#define CODE_DCM_IncompleteStudy                                           DSRBasicCodedEntry("130574", "DCM", "Incomplete study")
#define CODE_DCM_SuboptimalPatientPreparation                              DSRBasicCodedEntry("130575", "DCM", "Suboptimal patient preparation")
#define CODE_DCM_AnatomyCoverageIncomplete                                 DSRBasicCodedEntry("130576", "DCM", "Anatomy coverage incomplete")
#define CODE_DCM_PoorFOVSelection                                          DSRBasicCodedEntry("130577", "DCM", "Poor FOV selection")
#define CODE_DCM_PoorSNR                                                   DSRBasicCodedEntry("130578", "DCM", "Poor SNR")
#define CODE_DCM_PoorContrastTiming                                        DSRBasicCodedEntry("130579", "DCM", "Poor contrast timing")
#define CODE_DCM_InadequateContrastEnhancement                             DSRBasicCodedEntry("130580", "DCM", "Inadequate contrast enhancement")
#define CODE_DCM_SubtractionImageMissing                                   DSRBasicCodedEntry("130581", "DCM", "Subtraction image missing")
#define CODE_DCM_UnwantedSubtractionImages                                 DSRBasicCodedEntry("130582", "DCM", "Unwanted subtraction images")
#define CODE_DCM_ExpectedBValueIsMissing                                   DSRBasicCodedEntry("130583", "DCM", "Expected b-value is missing")
#define CODE_DCM_SevereDistortionInTheAreaOfInterest                       DSRBasicCodedEntry("130584", "DCM", "Severe distortion in the area of interest")
#define CODE_DCM_ExpectedADCMapIsMissing                                   DSRBasicCodedEntry("130585", "DCM", "Expected ADC map is missing")
#define CODE_DCM_DistortionArtifactInTheAreaOfInterest                     DSRBasicCodedEntry("130586", "DCM", "Distortion artifact in the area of interest")
#define CODE_DCM_NoFamilyHistoryOfProstateCancer                           DSRBasicCodedEntry("130587", "DCM", "No family history of prostate cancer")
#define CODE_DCM_PreBiopsyLocalizationOfProstateLesion                     DSRBasicCodedEntry("130588", "DCM", "Pre-biopsy localization of prostate lesion")
#define CODE_DCM_ActiveSurveillanceOfProstateCancer                        DSRBasicCodedEntry("130589", "DCM", "Active surveillance of prostate cancer")
#define CODE_DCM_AssessChange                                              DSRBasicCodedEntry("130590", "DCM", "Assess change")
#define CODE_DCM_FocalAbnormality                                          DSRBasicCodedEntry("130591", "DCM", "Focal abnormality")
#define CODE_DCM_NonFocalAbnormality                                       DSRBasicCodedEntry("130592", "DCM", "Non-focal abnormality")
#define CODE_DCM_PartiallyEncapsulated                                     DSRBasicCodedEntry("130593", "DCM", "Partially encapsulated")
#define CODE_DCM_CompletelyEncapsulated                                    DSRBasicCodedEntry("130594", "DCM", "Completely encapsulated")
#define CODE_DCM_ADCHyperintense                                           DSRBasicCodedEntry("130595", "DCM", "ADC Hyperintense")
#define CODE_DCM_ADCHypointense                                            DSRBasicCodedEntry("130596", "DCM", "ADC Hypointense")
#define CODE_DCM_PersistentDelayedPhase_Type1Curve                         DSRBasicCodedEntry("130597", "DCM", "Persistent delayed phase: Type 1 curve")
#define CODE_DCM_PlateauDelayedPhase_Type2Curve                            DSRBasicCodedEntry("130598", "DCM", "Plateau delayed phase: Type 2 curve")
#define CODE_DCM_WashoutDelayedPhase_Type3Curve                            DSRBasicCodedEntry("130599", "DCM", "Washout delayed phase: Type 3 curve")
#define CODE_DCM_PositiveDCE                                               DSRBasicCodedEntry("130600", "DCM", "Positive DCE")
#define CODE_DCM_NegativeDCE                                               DSRBasicCodedEntry("130601", "DCM", "Negative DCE")
#define CODE_DCM_EarlyContrastEnhancement                                  DSRBasicCodedEntry("130602", "DCM", "Early Contrast Enhancement")
#define CODE_DCM_DiffuseContrastEnhancement                                DSRBasicCodedEntry("130603", "DCM", "Diffuse Contrast Enhancement")
#define CODE_DCM_FocalContrastEnhancement                                  DSRBasicCodedEntry("130604", "DCM", "Focal Contrast Enhancement")
#define CODE_DCM_Perfluorocarbon                                           DSRBasicCodedEntry("130605", "DCM", "Perfluorocarbon")
#define CODE_DCM_ESUR2012ProstateMRIAcquisitionRequirements                DSRBasicCodedEntry("130606", "DCM", "ESUR 2012 prostate MRI acquisition requirements")
#define CODE_DCM_PIRADS2dot0ProstateMRIAcquisitionRequirements             DSRBasicCodedEntry("130607", "DCM", "PI-RADS 2.0 prostate MRI acquisition requirements")
#define CODE_DCM_PIRADS2dot1ProstateMRIAcquisitionRequirements             DSRBasicCodedEntry("130608", "DCM", "PI-RADS 2.1 prostate MRI acquisition requirements")
#define CODE_DCM_2DShearWaveElastography                                   DSRBasicCodedEntry("130609", "DCM", "2D Shear Wave Elastography")
#define CODE_DCM_3DShearWaveElastography                                   DSRBasicCodedEntry("130610", "DCM", "3D Shear Wave Elastography")
#define CODE_DCM_ShearWaveSpeed                                            DSRBasicCodedEntry("130611", "DCM", "Shear Wave Speed")
#define CODE_DCM_ShearWaveDispersionSlope                                  DSRBasicCodedEntry("130612", "DCM", "Shear Wave Dispersion Slope")
#define CODE_DCM_ROIDepth                                                  DSRBasicCodedEntry("130613", "DCM", "ROI Depth")
#define CODE_DCM_InterquartileRangeOfPopulation                            DSRBasicCodedEntry("130614", "DCM", "Interquartile Range of population")
#define CODE_DCM_InterquartileRangeToMedianRatioOfPopulation               DSRBasicCodedEntry("130615", "DCM", "Interquartile Range to Median Ratio of population")
#define CODE_DCM_PointShearWaveElastography                                DSRBasicCodedEntry("130616", "DCM", "Point Shear Wave Elastography")
#define CODE_DCM_LeftVentricleApicalAnteroseptalSegment                    DSRBasicCodedEntry("130620", "DCM", "left ventricle apical anteroseptal segment")
#define CODE_DCM_LeftVentricleApicalInferoseptalSegment                    DSRBasicCodedEntry("130621", "DCM", "left ventricle apical inferoseptal segment")
#define CODE_DCM_LeftVentricleApicalInferolateralSegment                   DSRBasicCodedEntry("130622", "DCM", "left ventricle apical inferolateral segment")
#define CODE_DCM_LeftVentricleApicalAnterolateralSegment                   DSRBasicCodedEntry("130623", "DCM", "left ventricle apical anterolateral segment")
#define CODE_DCM_IsocentricSetupMethod                                     DSRBasicCodedEntry("130630", "DCM", "Isocentric Setup Method")
#define CODE_DCM_ControlledSSDSetupMethod                                  DSRBasicCodedEntry("130631", "DCM", "Controlled SSD Setup Method")
#define CODE_DCM_TBISetupMethod                                            DSRBasicCodedEntry("130632", "DCM", "TBI Setup Method")
#define CODE_DCM_StereotacticSetupMethod                                   DSRBasicCodedEntry("130633", "DCM", "Stereotactic Setup Method")
#define CODE_DCM_SkinAppositionSetupMethod                                 DSRBasicCodedEntry("130634", "DCM", "Skin Apposition Setup Method")
#define CODE_DCM_OcularGazeSetupMethod                                     DSRBasicCodedEntry("130635", "DCM", "Ocular Gaze Setup Method")
#define CODE_DCM_PatientShieldingProcedure                                 DSRBasicCodedEntry("130636", "DCM", "Patient Shielding Procedure")
#define CODE_DCM_PatientFixationProcedure                                  DSRBasicCodedEntry("130637", "DCM", "Patient Fixation Procedure")
#define CODE_DCM_PatientAlignmentProcedure                                 DSRBasicCodedEntry("130638", "DCM", "Patient Alignment Procedure")
#define CODE_DCM_PatientMotionManagementSetupProcedure                     DSRBasicCodedEntry("130639", "DCM", "Patient Motion Management Setup Procedure")
#define CODE_DCM_CavityRadiationShield                                     DSRBasicCodedEntry("130640", "DCM", "Cavity radiation shield")
#define CODE_DCM_IndependentRadiationShield                                DSRBasicCodedEntry("130641", "DCM", "Independent radiation shield")
#define CODE_DCM_OpticalDistanceMeter                                      DSRBasicCodedEntry("130642", "DCM", "Optical Distance Meter")
#define CODE_DCM_MechanicalPointer                                         DSRBasicCodedEntry("130643", "DCM", "Mechanical Pointer")
#define CODE_DCM_RadiofrequencyTransponder                                 DSRBasicCodedEntry("130644", "DCM", "Radiofrequency Transponder")
#define CODE_DCM_InfraredMarker                                            DSRBasicCodedEntry("130645", "DCM", "Infrared Marker")
#define CODE_DCM_RadioactiveMarker                                         DSRBasicCodedEntry("130646", "DCM", "Radioactive Marker")
#define CODE_DCM_ThermalImager                                             DSRBasicCodedEntry("130647", "DCM", "Thermal Imager")
#define CODE_DCM_CombinedStructuredLightThermalImager                      DSRBasicCodedEntry("130648", "DCM", "Combined Structured Light/Thermal Imager")
#define CODE_DCM_OcularFixationLight                                       DSRBasicCodedEntry("130649", "DCM", "Ocular Fixation Light")
#define CODE_DCM_CoachingDevice                                            DSRBasicCodedEntry("130650", "DCM", "Coaching Device")
#define CODE_DCM_PatientDistractionDevice                                  DSRBasicCodedEntry("130651", "DCM", "Patient Distraction Device")
#define CODE_DCM_CollisionChecks                                           DSRBasicCodedEntry("130652", "DCM", "Collision checks")
#define CODE_DCM_BreastBridge                                              DSRBasicCodedEntry("130653", "DCM", "Breast Bridge")
#define CODE_DCM_AbdominalCompressionBelt                                  DSRBasicCodedEntry("130654", "DCM", "Abdominal Compression Belt")
#define CODE_DCM_AbdominalCompressionArch                                  DSRBasicCodedEntry("130655", "DCM", "Abdominal Compression Arch")
#define CODE_DCM_HeadFixationBoard                                         DSRBasicCodedEntry("130656", "DCM", "Head Fixation Board")
#define CODE_DCM_CouchIndexLabel                                           DSRBasicCodedEntry("130657", "DCM", "Couch Index Label")
#define CODE_DCM_FixationDeviceAngle                                       DSRBasicCodedEntry("130658", "DCM", "Fixation Device Angle")
#define CODE_DCM_AbdominalCompressionPlatePositionNumber                   DSRBasicCodedEntry("130659", "DCM", "Abdominal Compression Plate Position Number")
#define CODE_DCM_AbdominalCompressionBeltLength                            DSRBasicCodedEntry("130660", "DCM", "Abdominal Compression Belt Length")
#define CODE_DCM_AbdominalCompressionBeltPressure                          DSRBasicCodedEntry("130661", "DCM", "Abdominal Compression Belt Pressure")
#define CODE_DCM_ReferencedPatientAlignmentReference                       DSRBasicCodedEntry("130662", "DCM", "Referenced Patient Alignment Reference")
#define CODE_DCM_RTRadiationPreviouslyDelivered                            DSRBasicCodedEntry("130663", "DCM", "RT Radiation previously delivered")
#define CODE_DCM_TreatmentUnnecessary                                      DSRBasicCodedEntry("130664", "DCM", "Treatment unnecessary")
#define CODE_DCM_TreatmentExceedsPatientTolerance                          DSRBasicCodedEntry("130665", "DCM", "Treatment exceeds patient tolerance")
#define CODE_DCM_RadiotherapyFiducial                                      DSRBasicCodedEntry("130666", "DCM", "Radiotherapy Fiducial")
#define CODE_DCM_LongitudinalLagrangianStrain                              DSRBasicCodedEntry("130670", "DCM", "Longitudinal Lagrangian Strain")
#define CODE_DCM_PeakLongitudinalLagrangianStrain                          DSRBasicCodedEntry("130671", "DCM", "Peak Longitudinal Lagrangian Strain")
#define CODE_DCM_TimeToPeakLongitudinalLagrangianStrain                    DSRBasicCodedEntry("130672", "DCM", "Time to Peak Longitudinal Lagrangian Strain")
#define CODE_DCM_MechanicalDispersion                                      DSRBasicCodedEntry("130673", "DCM", "Mechanical Dispersion")
#define CODE_DCM_LongitudinalLagrangianStrainRate                          DSRBasicCodedEntry("130674", "DCM", "Longitudinal Lagrangian Strain Rate")
#define CODE_DCM_RadialLagrangianStrain                                    DSRBasicCodedEntry("130675", "DCM", "Radial Lagrangian Strain")
#define CODE_DCM_RadialLagrangianStrainRate                                DSRBasicCodedEntry("130676", "DCM", "Radial Lagrangian Strain Rate")
#define CODE_DCM_CircumferentialLagrangianStrain                           DSRBasicCodedEntry("130677", "DCM", "Circumferential Lagrangian Strain")
#define CODE_DCM_CircumferentialLagrangianStrainRate                       DSRBasicCodedEntry("130678", "DCM", "Circumferential Lagrangian Strain Rate")
#define CODE_DCM_2DSpeckleTracking                                         DSRBasicCodedEntry("130679", "DCM", "2D Speckle Tracking")
#define CODE_DCM_3DSpeckleTracking                                         DSRBasicCodedEntry("130680", "DCM", "3D Speckle Tracking")
#define CODE_DCM_ApicalFourChamberRVFocused                                DSRBasicCodedEntry("130681", "DCM", "Apical four chamber RV Focused")
#define CODE_DCM_ApicalFourChamberRVModified                               DSRBasicCodedEntry("130682", "DCM", "Apical four chamber RV Modified")
#define CODE_DCM_EndocardialMethod                                         DSRBasicCodedEntry("130683", "DCM", "Endocardial Method")
#define CODE_DCM_EpicardialMethod                                          DSRBasicCodedEntry("130684", "DCM", "Epicardial Method")
#define CODE_DCM_MyocardialMidlayerMethod                                  DSRBasicCodedEntry("130685", "DCM", "Myocardial Midlayer Method")
#define CODE_DCM_LVEndSystolicGLSMultiviewMean_Endocardial                 DSRBasicCodedEntry("130686", "DCM", "LV End-systolic GLS Multiview Mean (Endocardial)")
#define CODE_DCM_LVEndSystolicGLS4CH_Endocardial                           DSRBasicCodedEntry("130687", "DCM", "LV End-systolic GLS 4CH (Endocardial)")
#define CODE_DCM_LVEndSystolicGLS2CH_Endocardial                           DSRBasicCodedEntry("130688", "DCM", "LV End-systolic GLS 2CH (Endocardial)")
#define CODE_DCM_LVEndSystolicGLSALAX_Endocardial                          DSRBasicCodedEntry("130689", "DCM", "LV End-systolic GLS ALAX (Endocardial)")
#define CODE_DCM_LVPeakSystolicGLSMultiviewMean_Endocardial                DSRBasicCodedEntry("130690", "DCM", "LV Peak Systolic GLS Multiview Mean (Endocardial)")
#define CODE_DCM_LVPeakSystolicGLS4CH_Endocardial                          DSRBasicCodedEntry("130691", "DCM", "LV Peak Systolic GLS 4CH (Endocardial)")
#define CODE_DCM_LVPeakSystolicGLS2CH_Endocardial                          DSRBasicCodedEntry("130692", "DCM", "LV Peak Systolic GLS 2CH (Endocardial)")
#define CODE_DCM_LVPeakSystolicGLSALAX_Endocardial                         DSRBasicCodedEntry("130693", "DCM", "LV Peak Systolic GLS ALAX (Endocardial)")
#define CODE_DCM_LVPeakGLSMultiviewMean_Endocardial                        DSRBasicCodedEntry("130694", "DCM", "LV Peak GLS Multiview Mean (Endocardial)")
#define CODE_DCM_LVPeakGLS4CH_Endocardial                                  DSRBasicCodedEntry("130695", "DCM", "LV Peak GLS 4CH (Endocardial)")
#define CODE_DCM_LVPeakGLS2CH_Endocardial                                  DSRBasicCodedEntry("130696", "DCM", "LV Peak GLS 2CH (Endocardial)")
#define CODE_DCM_LVPeakGLSALAX_Endocardial                                 DSRBasicCodedEntry("130697", "DCM", "LV Peak GLS ALAX (Endocardial)")
#define CODE_DCM_LVEndSystolicMechanicalDispersion                         DSRBasicCodedEntry("130698", "DCM", "LV End-systolic Mechanical Dispersion")
#define CODE_DCM_MitralValveClosure                                        DSRBasicCodedEntry("130699", "DCM", "Mitral Valve Closure")
#define CODE_DCM_MitralValveOpening                                        DSRBasicCodedEntry("130700", "DCM", "Mitral Valve Opening")
#define CODE_DCM_AorticValveClosure                                        DSRBasicCodedEntry("130701", "DCM", "Aortic Valve Closure")
#define CODE_DCM_AorticValveOpening                                        DSRBasicCodedEntry("130702", "DCM", "Aortic Valve Opening")
#define CODE_DCM_Fp9                                                       DSRBasicCodedEntry("130710", "DCM", "Fp9")
#define CODE_DCM_Fp10                                                      DSRBasicCodedEntry("130711", "DCM", "Fp10")
#define CODE_DCM_AF9                                                       DSRBasicCodedEntry("130712", "DCM", "AF9")
#define CODE_DCM_AF10                                                      DSRBasicCodedEntry("130713", "DCM", "AF10")
#define CODE_DCM_PO9                                                       DSRBasicCodedEntry("130714", "DCM", "PO9")
#define CODE_DCM_PO10                                                      DSRBasicCodedEntry("130715", "DCM", "PO10")
#define CODE_DCM_O9                                                        DSRBasicCodedEntry("130716", "DCM", "O9")
#define CODE_DCM_O10                                                       DSRBasicCodedEntry("130717", "DCM", "O10")
#define CODE_DCM_CoronaryArteryDiseaseAssessment                           DSRBasicCodedEntry("130720", "DCM", "Coronary Artery Disease Assessment")
#define CODE_DCM_OronaryArteryDiseaseAssessmentModifier                    DSRBasicCodedEntry("130721", "DCM", "oronary Artery Disease Assessment Modifier")
#define CODE_DCM_CoronaryArteryDiseaseStenosisAssessmentModifier           DSRBasicCodedEntry("130722", "DCM", "Coronary Artery Disease Stenosis Assessment Modifier")
#define CODE_DCM_0_DocumentedAbsenceOfCAD                                  DSRBasicCodedEntry("130723", "DCM", "0 - Documented absence of CAD")
#define CODE_DCM_1_MinimalNonObstructiveCAD                                DSRBasicCodedEntry("130724", "DCM", "1 - Minimal non-obstructive CAD")
#define CODE_DCM_2_MildNonObstructiveCAD                                   DSRBasicCodedEntry("130725", "DCM", "2 - Mild non-obstructive CAD")
#define CODE_DCM_3_ModerateStenosis                                        DSRBasicCodedEntry("130726", "DCM", "3 - Moderate stenosis")
#define CODE_DCM_4_SevereStenosis                                          DSRBasicCodedEntry("130727", "DCM", "4 - Severe stenosis")
#define CODE_DCM_4A_SevereStenosis                                         DSRBasicCodedEntry("130728", "DCM", "4A - Severe stenosis")
#define CODE_DCM_4B_SevereStenosis                                         DSRBasicCodedEntry("130729", "DCM", "4B - Severe stenosis")
#define CODE_DCM_5_TotalCoronaryOcclusion                                  DSRBasicCodedEntry("130730", "DCM", "5 - Total coronary occlusion")
#define CODE_DCM_N_NonDiagnosticStudy                                      DSRBasicCodedEntry("130731", "DCM", "N - Non-diagnostic study")
#define CODE_DCM_N_NonDiagnosticSegments                                   DSRBasicCodedEntry("130732", "DCM", "N - Non-diagnostic segments")
#define CODE_DCM_S_Stent                                                   DSRBasicCodedEntry("130733", "DCM", "S - Stent")
#define CODE_DCM_G_Graft                                                   DSRBasicCodedEntry("130734", "DCM", "G - Graft")
#define CODE_DCM_V_VulnerablePlaque                                        DSRBasicCodedEntry("130735", "DCM", "V - Vulnerable plaque")
#define CODE_DCM_TitaniumAlloy_TitaniumMolybdenum15Zirconium5Aluminium3    DSRBasicCodedEntry("130736", "DCM", "Titanium alloy (Titanium Molybdenum-15 Zirconium-5 Aluminium-3)")
#define CODE_DCM_RTSegmentMaterial                                         DSRBasicCodedEntry("130737", "DCM", "RT Segment Material")
#define CODE_DCM_DoseLimitInterlock                                        DSRBasicCodedEntry("130738", "DCM", "Dose Limit Interlock")
#define CODE_DCM_ClearanceInterlock                                        DSRBasicCodedEntry("130739", "DCM", "Clearance Interlock")
#define CODE_DCM_MachineClearanceInterlock                                 DSRBasicCodedEntry("130740", "DCM", "Machine Clearance Interlock")
#define CODE_DCM_PatientClearanceInterlock                                 DSRBasicCodedEntry("130741", "DCM", "Patient Clearance Interlock")
#define CODE_DCM_AccessoryClearanceInterlock                               DSRBasicCodedEntry("130742", "DCM", "Accessory Clearance Interlock")
#define CODE_DCM_OutOfToleranceInterlock                                   DSRBasicCodedEntry("130743", "DCM", "Out of Tolerance Interlock")
#define CODE_DCM_InterlockResolved                                         DSRBasicCodedEntry("130744", "DCM", "Interlock Resolved")
#define CODE_DCM_CTDoseLengthProductSubTotal                               DSRBasicCodedEntry("130745", "DCM", "CT Dose Length Product Sub-Total")
#define CODE_DCM_RTRegistrationMark                                        DSRBasicCodedEntry("130746", "DCM", "RT Registration Mark")
#define CODE_DCM_IsodoseVolume                                             DSRBasicCodedEntry("130747", "DCM", "Isodose Volume")
#define CODE_DCM_RadiotherapyDoseRegion                                    DSRBasicCodedEntry("130748", "DCM", "Radiotherapy Dose Region")
#define CODE_DCM_QualityControlMaterialImage                               DSRBasicCodedEntry("130750", "DCM", "Quality control material image")
#define CODE_DCM_TissueNotOfInterest                                       DSRBasicCodedEntry("130751", "DCM", "Tissue not of interest")
#define CODE_DCM_DataNotAccessibleFromStorage                              DSRBasicCodedEntry("130752", "DCM", "Data Not Accessible from Storage")
#define CODE_DCM_ProcessedKeyObjectSelection                               DSRBasicCodedEntry("130753", "DCM", "Processed Key Object Selection")
#define CODE_DCM_ReplacedByAlternateRepresentation                         DSRBasicCodedEntry("130754", "DCM", "Replaced by Alternate Representation")
#define CODE_DCM_ReferenceMeasurementGroup                                 DSRBasicCodedEntry("130755", "DCM", "Reference Measurement Group")
#define CODE_DCM_ParticleDisplacementMethod                                DSRBasicCodedEntry("130756", "DCM", "Particle Displacement Method")
#define CODE_DCM_ParticleVelocityMethod                                    DSRBasicCodedEntry("130757", "DCM", "Particle Velocity Method")
#define CODE_DCM_ShearWaveDispersionSlopeCenterFrequency                   DSRBasicCodedEntry("130758", "DCM", "Shear Wave Dispersion Slope Center Frequency")
#define CODE_DCM_ShearWaveDetectionMethod                                  DSRBasicCodedEntry("130759", "DCM", "Shear Wave Detection Method")
#define CODE_DCM_ButterworthFilter                                         DSRBasicCodedEntry("130760", "DCM", "Butterworth filter")
#define CODE_DCM_ChebyshevFilter                                           DSRBasicCodedEntry("130761", "DCM", "Chebyshev filter")
#define CODE_DCM_EllipticFilter                                            DSRBasicCodedEntry("130762", "DCM", "Elliptic filter")
#define CODE_DCM_BesselFilter                                              DSRBasicCodedEntry("130763", "DCM", "Bessel filter")
#define CODE_DCM_GaussianFilter                                            DSRBasicCodedEntry("130764", "DCM", "Gaussian filter")
#define CODE_DCM_KTypeFilter                                               DSRBasicCodedEntry("130765", "DCM", "K-type filter")
#define CODE_DCM_MDerivedFilter                                            DSRBasicCodedEntry("130766", "DCM", "M-derived filter")
#define CODE_DCM_DoubleMDerivedFilter                                      DSRBasicCodedEntry("130767", "DCM", "Double-m-derived filter")
#define CODE_DCM_BodeFilter                                                DSRBasicCodedEntry("130768", "DCM", "Bode filter")
#define CODE_DCM_ZobelFilter                                               DSRBasicCodedEntry("130769", "DCM", "Zobel filter")
#define CODE_DCM_FIRFilter                                                 DSRBasicCodedEntry("130770", "DCM", "FIR filter")
#define CODE_DCM_CICFilter                                                 DSRBasicCodedEntry("130771", "DCM", "CIC filter")
#define CODE_DCM_IIRFilter                                                 DSRBasicCodedEntry("130772", "DCM", "IIR filter")
#define CODE_DCM_BiquadFilter                                              DSRBasicCodedEntry("130773", "DCM", "Biquad filter")
#define CODE_DCM_HzNormalized                                              DSRBasicCodedEntry("130774", "DCM", "Hz normalized")
#define CODE_DCM_HzAngular                                                 DSRBasicCodedEntry("130775", "DCM", "Hz angular")
#define CODE_DCM_MagnitudeNormalized                                       DSRBasicCodedEntry("130776", "DCM", "Magnitude normalized")

#endif
