/*
 * SourceTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  1.3
 * Created by suhler on 04/03/22
 * Last modified by suhler on 04/12/07 09:47:06
 */

package sunlabs.brazil.sunlabs;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.io.IOException;
import sunlabs.brazil.handler.ResourceHandler;
import sunlabs.brazil.template.Template;
import sunlabs.brazil.template.RewriteContext;
import sunlabs.brazil.util.http.HttpInputStream;
import sunlabs.brazil.util.Format;

/**
 * Template class for incorporating the content of a local file.
 * <pre>
 *  &lt;import src=file [encoding=enc name=property eval=true|false]&gt;
 * </pre>
 * Attributes:
 * <dl class=attribute>
 * <dt>src<dd>Where to find the document to source.  Unless starting with
 * "/", it is assumed to be relative to the document root.
 * <dt>eval<dd>If true, all ${...} are evaluated before incorporating the src
 * <dt>encoding<dd>Specifies the character encoding to use.  If not specified
 * or invalid, the default encoding is used.
 * <dt>name<dd>If set, the content is placed in the named variable instead
 * of being inserted inline.
 *</dl>
 * @author Stephen Uhler
 * SCCS: @(#) SourceTemplate.java 1.3 04/12/07 09:47:06
 */

public class SourceTemplate extends Template {

    public void
    tag_source(RewriteContext hr) {
	String src = hr.get("src");	// the file to fetch
	String enc = hr.get("encoding");	// character encoding
	String name = hr.get("name");	// property to store content in
	boolean shouldEval=hr.isTrue("eval"); // run through subst()
        debug(hr);
        hr.killToken();

	if (src == null) {
	    debug(hr, "\"src\" not specified");
	    return;
	}

	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	String result = null;
	try {
	    HttpInputStream hin = new HttpInputStream(
		    ResourceHandler.getResourceStream(
			hr.request.props, hr.prefix, src));
	    hin.copyTo(baos);
	    hin.close();
	} catch (IOException e) {
	    debug(hr, "Bad import file: " + e);
	    return;
	}
	if (enc != null) {
	    try {
		result= baos.toString(enc);
	    } catch (UnsupportedEncodingException e) {
		debug(hr, "Bad encoding format: " + enc);
	    }
	}
	if (result == null) {
	    result = baos.toString();
	}
	if (shouldEval) {
	    result = Format.subst(hr.request.props, result);
	}
	if (name != null) {
	    hr.request.props.put(name, result);
	} else {
	    hr.append(result);
	}
    }
}
