/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.tools.ant.Project;

public class DemuxOutputStream
extends OutputStream {
    private static final int MAX_SIZE = 1024;
    private Hashtable buffers = new Hashtable();
    private Project project;
    private boolean isErrorStream;

    public DemuxOutputStream(Project project, boolean isErrorStream) {
        this.project = project;
        this.isErrorStream = isErrorStream;
    }

    private BufferInfo getBufferInfo() {
        Thread current = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(current);
        if (bufferInfo == null) {
            bufferInfo = new BufferInfo();
            bufferInfo.buffer = new ByteArrayOutputStream();
            bufferInfo.skip = false;
            this.buffers.put(current, bufferInfo);
        }
        return bufferInfo;
    }

    private void resetBufferInfo() {
        Thread current = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(current);
        try {
            bufferInfo.buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bufferInfo.buffer = new ByteArrayOutputStream();
        bufferInfo.skip = false;
    }

    private void removeBuffer() {
        Thread current = Thread.currentThread();
        this.buffers.remove(current);
    }

    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        BufferInfo bufferInfo = this.getBufferInfo();
        if (c == 10 || c == 13) {
            if (!bufferInfo.skip) {
                this.processBuffer(bufferInfo.buffer);
            }
        } else {
            bufferInfo.buffer.write(cc);
            if (bufferInfo.buffer.size() > 1024) {
                this.processBuffer(bufferInfo.buffer);
            }
        }
        bufferInfo.skip = c == 13;
    }

    protected void processBuffer(ByteArrayOutputStream buffer) {
        String output = buffer.toString();
        this.project.demuxOutput(output, this.isErrorStream);
        this.resetBufferInfo();
    }

    public void close() throws IOException {
        this.flush();
        this.removeBuffer();
    }

    public void flush() throws IOException {
        BufferInfo bufferInfo = this.getBufferInfo();
        if (bufferInfo.buffer.size() > 0) {
            this.processBuffer(bufferInfo.buffer);
        }
    }

    private static class BufferInfo {
        private ByteArrayOutputStream buffer;
        private boolean skip = false;

        private BufferInfo() {
        }
    }
}

