/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RutaRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleMatch
extends AbstractRuleMatch<RutaRule> {
    private RuleMatchComparator ruleElementComparator = new RuleMatchComparator();
    private boolean applied = false;
    private Map<AbstractRutaAction, ScriptApply> delegateApply = new HashMap<AbstractRutaAction, ScriptApply>(0);
    private ComposedRuleElementMatch rootMatch;

    public RuleMatch(RutaRule rule) {
        super(rule);
    }

    public boolean processMatchInfo(RuleElement ruleElement, List<RuleElementMatch> ruleElementMatches, RutaStream stream) {
        boolean result = false;
        return result;
    }

    @Override
    public boolean matchedCompletely() {
        return this.matched && this.rootMatch.matched();
    }

    public List<AnnotationFS> getMatchedAnnotationsOf(RuleElement element, RutaStream stream) {
        return this.getMatchedAnnotations(stream, element.getSelfIndexList(), element.getContainer());
    }

    @Override
    public List<AnnotationFS> getMatchedAnnotationsOfRoot(RutaStream stream) {
        return this.getMatchedAnnotationsOf(((RutaRule)this.getRule()).getRoot(), stream);
    }

    public List<AnnotationFS> getMatchedAnnotations(RutaStream stream, List<Integer> indexes, RuleElementContainer container) {
        List<AnnotationFS> textsMatched;
        List<RuleElementMatch> list;
        RuleElement ruleElement;
        List<List<RuleElementMatch>> matchInfo;
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        indexes = RuleMatch.extendIndexes(indexes);
        if (container == null) {
            container = ((RutaRule)this.rule).getRoot();
        }
        if (indexes == null) {
            List<RuleElement> ruleElements = container.getRuleElements();
            indexes = new ArrayList<Integer>();
            for (RuleElement ruleElement2 : ruleElements) {
                indexes.add(ruleElements.indexOf(ruleElement2) + 1);
            }
        }
        if (indexes.size() == 1 && (matchInfo = this.getMatchInfo(ruleElement = container.getRuleElements().get(indexes.get(0) - 1))).size() == 1 && (list = matchInfo.get(0)) != null && list.size() == 1 && (textsMatched = list.get(0).getTextsMatched()).size() == 1) {
            return textsMatched;
        }
        ArrayList reverseList = new ArrayList();
        for (Integer n : indexes) {
            if (n > container.getRuleElements().size()) continue;
            RuleElement ruleElement3 = container.getRuleElements().get(n - 1);
            List<List<RuleElementMatch>> matchInfo2 = this.getMatchInfo(ruleElement3);
            int i = 0;
            for (List<RuleElementMatch> list2 : matchInfo2) {
                if (reverseList.size() <= i) {
                    reverseList.add(new ArrayList());
                }
                List l = (List)reverseList.get(i);
                l.add(list2);
                ++i;
            }
        }
        for (List list2 : reverseList) {
            int begin = Integer.MAX_VALUE;
            int end = 0;
            for (List list3 : list2) {
                if (list3 == null) continue;
                for (RuleElementMatch ruleElementMatch : list3) {
                    List<AnnotationFS> textsMatched2 = ruleElementMatch.getTextsMatched();
                    if (textsMatched2 == null || textsMatched2.isEmpty()) continue;
                    begin = Math.min(textsMatched2.get(0).getBegin(), begin);
                    end = Math.max(textsMatched2.get(textsMatched2.size() - 1).getEnd(), end);
                }
            }
            if (stream.getJCas() == null || end == 0) continue;
            Annotation annotation = new Annotation(stream.getJCas());
            annotation.setBegin(begin);
            annotation.setEnd(end);
            result.add((AnnotationFS)annotation);
        }
        return result;
    }

    public static List<Integer> extendIndexes(List<Integer> indexes) {
        if (indexes == null || indexes.size() <= 1) {
            return indexes;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int pointer = indexes.get(0);
        for (Integer each : indexes) {
            while (pointer < each - 1) {
                result.add(++pointer);
            }
            result.add(each);
            pointer = each;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.matched ? "Matched : " : "Not Matched :");
        result.append(this.getRootMatch());
        return result.toString();
    }

    public Map<AbstractRutaAction, ScriptApply> getDelegateApply() {
        return this.delegateApply;
    }

    public void addDelegateApply(AbstractRutaAction action, ScriptApply scriptApply) {
        this.delegateApply.put(action, scriptApply);
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public RuleMatch copy(ComposedRuleElementMatch extendedContainerMatch) {
        RuleMatch copy = new RuleMatch((RutaRule)this.rule);
        copy.setMatched(this.matched);
        if (extendedContainerMatch.getContainerMatch() == null) {
            copy.setRootMatch(extendedContainerMatch);
        } else {
            copy.setRootMatch(this.rootMatch.copy(extendedContainerMatch));
        }
        HashMap<AbstractRutaAction, ScriptApply> newDelegateApply = new HashMap<AbstractRutaAction, ScriptApply>(this.delegateApply);
        copy.setDelegateApply(newDelegateApply);
        return copy;
    }

    public void update(ComposedRuleElementMatch extendedContainerMatch) {
        if (extendedContainerMatch.getContainerMatch() == null) {
            this.setRootMatch(extendedContainerMatch);
        } else {
            this.rootMatch.update(extendedContainerMatch);
        }
    }

    public void setDelegateApply(Map<AbstractRutaAction, ScriptApply> delegateApply) {
        this.delegateApply = delegateApply;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public ComposedRuleElementMatch getRootMatch() {
        return this.rootMatch;
    }

    public void setRootMatch(ComposedRuleElementMatch rootMatch) {
        this.rootMatch = rootMatch;
    }

    public List<List<RuleElementMatch>> getMatchInfo(RuleElement element) {
        return this.getMatchInfo(this.rootMatch, element);
    }

    public List<List<RuleElementMatch>> getMatchInfo(RuleElementMatch rootMatch, RuleElement element) {
        ArrayList<List<RuleElementMatch>> result = new ArrayList<List<RuleElementMatch>>();
        RuleElement root = rootMatch.getRuleElement();
        if (element.equals(root)) {
            ArrayList<RuleElementMatch> list = new ArrayList<RuleElementMatch>(1);
            list.add(rootMatch);
            result.add(list);
        } else if (rootMatch instanceof ComposedRuleElementMatch) {
            ComposedRuleElementMatch crem = (ComposedRuleElementMatch)rootMatch;
            Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = crem.getInnerMatches().entrySet();
            for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
                List<RuleElementMatch> value = entry.getValue();
                if (element.equals(entry.getKey())) {
                    result.add(value);
                    continue;
                }
                if (value == null) continue;
                for (RuleElementMatch eachMatch : value) {
                    result.addAll(this.getMatchInfo(eachMatch, element));
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleMatchComparator
    implements Comparator<RuleElementMatch> {
        private RuleMatchComparator() {
        }

        @Override
        public int compare(RuleElementMatch rem1, RuleElementMatch rem2) {
            AnnotationFS fs1 = rem1.getTextsMatched().get(0);
            AnnotationFS fs2 = rem2.getTextsMatched().get(0);
            return fs1.getBegin() < fs2.getBegin() ? -1 : 1;
        }
    }
}

