/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.preferences;

import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.testing.preferences.DescriptionRadioGroupFieldEditor;
import org.apache.uima.ruta.testing.preferences.IDescriptionChangedListener;
import org.apache.uima.ruta.testing.preferences.TestingPreferenceConstants;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TestingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.apache.uima.ruta.testing.preferences";
    private Text desc;
    private Label evalHeadline;
    private DescriptionRadioGroupFieldEditor evaluators;
    private BooleanFieldEditor sync;
    private BooleanFieldEditor oldResults;

    public TestingPreferencePage() {
        IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 16384);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new GridLayout());
        this.sync = new BooleanFieldEditor("AUTOMATED_FILE_SYNCRONIZATION", "Synchronize Test-Files and Workspace automatically", top);
        this.sync.setPage((DialogPage)this);
        this.sync.setPreferenceStore(this.getPreferenceStore());
        this.sync.load();
        this.oldResults = new BooleanFieldEditor("LOAD_OLD_TEST_RESULTS", "Load test results from previous sessions", top);
        this.oldResults.setPage((DialogPage)this);
        this.oldResults.setPreferenceStore(this.getPreferenceStore());
        this.oldResults.load();
        this.evaluators = new DescriptionRadioGroupFieldEditor("EVALUATOR_FACTORY", "Evaluator :", 1, TestingPreferenceConstants.EVALUATORS, top);
        this.evaluators.setPage((DialogPage)this);
        this.evaluators.setPreferenceStore(this.getPreferenceStore());
        this.evaluators.load();
        IDescriptionChangedListener listener = new IDescriptionChangedListener(){

            public void descriptionChanged(String s) {
                String text = RutaAddonsPlugin.getCasEvaluatorFactoryById(s).getDescription();
                TestingPreferencePage.this.desc.setText(text);
                TestingPreferencePage.this.desc.update();
                TestingPreferencePage.this.desc.redraw();
            }
        };
        this.evaluators.setDescriptionChangedListener(listener);
        this.evalHeadline = new Label(top, 0);
        this.evalHeadline.setText("Description:");
        this.desc = new Text(top, 2634);
        this.desc.setText(this.getEvalDesc());
        this.desc.setBackground(this.getControl().getDisplay().getSystemColor(1));
        this.desc.setLayoutData((Object)new GridData(1808));
        return top;
    }

    public String getEvalDesc() {
        return RutaAddonsPlugin.getCasEvaluatorFactoryById(this.getPreferenceStore().getString("EVALUATOR_FACTORY")).getDescription();
    }

    protected void loadDefaults() {
        this.sync.loadDefault();
        this.oldResults.loadDefault();
        this.evaluators.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.sync.store();
        this.oldResults.store();
        this.evaluators.store();
        return super.performOk();
    }
}

