/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.upload;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.fulcrum.upload.UploadService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUploadService
extends AbstractLogEnabled
implements UploadService,
Initializable,
Configurable,
Contextualizable {
    private DiskFileItemFactory itemFactory;
    private int sizeThreshold;
    private int sizeMax;
    private String repositoryPath;
    private String headerEncoding;
    private String applicationRoot;

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public long getSizeThreshold() {
        return this.itemFactory.getSizeThreshold();
    }

    @Override
    public String getRepository() {
        return this.itemFactory.getRepository().getAbsolutePath();
    }

    @Override
    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req) throws ServiceException {
        return this.parseRequest(req, this.sizeMax, this.itemFactory);
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req, String path) throws ServiceException {
        return this.parseRequest(req, this.sizeThreshold, this.sizeMax, path);
    }

    @Override
    public List<FileItem> parseRequest(HttpServletRequest req, int sizeThreshold, int sizeMax, String path) throws ServiceException {
        return this.parseRequest(req, sizeMax, new DiskFileItemFactory(sizeThreshold, new File(path)));
    }

    protected List<FileItem> parseRequest(HttpServletRequest req, int sizeMax, DiskFileItemFactory factory) throws ServiceException {
        try {
            ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
            fileUpload.setSizeMax((long)sizeMax);
            fileUpload.setHeaderEncoding(this.headerEncoding);
            return fileUpload.parseRequest(req);
        }
        catch (FileUploadException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public FileItemIterator getItemIterator(HttpServletRequest req) throws ServiceException {
        ServletFileUpload upload = new ServletFileUpload();
        try {
            return upload.getItemIterator(req);
        }
        catch (FileUploadException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException(UploadService.ROLE, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isMultipart(HttpServletRequest req) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)req);
    }

    private String getRealPath(String path) {
        String absolutePath = null;
        absolutePath = this.applicationRoot == null ? new File(path).getAbsolutePath() : new File(this.applicationRoot, path).getAbsolutePath();
        return absolutePath;
    }

    public void configure(Configuration conf) {
        this.repositoryPath = conf.getAttribute("repository", ".");
        this.headerEncoding = conf.getAttribute("headerEncoding", "ISO-8859-1");
        this.sizeMax = conf.getAttributeAsInteger("sizeMax", 0x100000);
        this.sizeThreshold = conf.getAttributeAsInteger("sizeThreshold", 10240);
    }

    public void initialize() throws Exception {
        String testPath = this.getRealPath(this.repositoryPath);
        File testDir = new File(testPath);
        if (testDir.exists()) {
            this.repositoryPath = testPath;
        }
        this.getLogger().debug("Upload Service: REPOSITORY_KEY => " + this.repositoryPath);
        this.itemFactory = new DiskFileItemFactory(this.sizeThreshold, new File(this.repositoryPath));
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }
}

