/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Organization
implements Serializable,
InputLocationTracker {
    final String name;
    final String url;
    final Map<Object, InputLocation> locations;

    Organization(String name, String url, Map<Object, InputLocation> locations) {
        this.name = name;
        this.url = url;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Organization.newBuilder(this);
    }

    @Nonnull
    public Organization withName(String name) {
        return Organization.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Organization withUrl(String url) {
        return Organization.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public static Organization newInstance() {
        return Organization.newInstance(true);
    }

    @Nonnull
    public static Organization newInstance(boolean withDefaults) {
        return Organization.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Organization.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Organization from) {
        return Organization.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Organization from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "Organization {name=" + this.getName() + ", url=" + this.getUrl() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        Organization base;
        String name;
        String url;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Organization base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Organization build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            Object location = null;
            Object nameLocation = null;
            Object urlLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Organization(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), locations != null ? locations : (this.base != null ? this.base.locations : null));
        }
    }
}

