/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.impl.SimpleLogger;

public class MavenSimpleLogger
extends SimpleLogger {
    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return MessageUtils.level().debug("TRACE");
            }
            case 10: {
                return MessageUtils.level().debug("DEBUG");
            }
            case 20: {
                return MessageUtils.level().info("INFO");
            }
            case 30: {
                return MessageUtils.level().warning("WARNING");
            }
        }
        return MessageUtils.level().error("ERROR");
    }

    @Override
    protected void writeThrowable(Throwable t, PrintStream stream) {
        if (t == null) {
            return;
        }
        stream.print(MessageUtils.buffer().failure((Object)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
        }
        stream.println();
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                stream.print("    ");
                stream.print(MessageUtils.buffer().strong((Object)"at"));
                stream.print(" " + e.getClassName() + "." + e.getMethodName());
                stream.print(MessageUtils.buffer().a((CharSequence)" (").strong((Object)this.getLocation(e)).a((CharSequence)")"));
                stream.println();
            }
            if ((t = t.getCause()) == null) continue;
            stream.print(MessageUtils.buffer().strong((Object)"Caused by").a((CharSequence)": ").a((CharSequence)t.getClass().getName()));
            if (t.getMessage() != null) {
                stream.print(": ");
                stream.print(MessageUtils.buffer().failure((Object)t.getMessage()));
            }
            stream.println();
        }
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }
}

