/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactCoordinateFactory;
import org.apache.maven.api.services.ArtifactCoordinateFactoryRequest;
import org.apache.maven.internal.impl.DefaultArtifactCoordinate;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.shared.utils.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;

@Named
@Singleton
public class DefaultArtifactCoordinateFactory
implements ArtifactCoordinateFactory {
    public ArtifactCoordinate create(@Nonnull ArtifactCoordinateFactoryRequest request) {
        String classifier;
        Utils.nonNull(request, "request can not be null");
        DefaultSession session = Utils.cast(DefaultSession.class, request.getSession(), "request.session should be a " + DefaultSession.class);
        ArtifactType type = null;
        if (request.getType() != null) {
            type = session.getSession().getArtifactTypeRegistry().get(request.getType());
        }
        String string = StringUtils.isNotEmpty((String)request.getClassifier()) ? request.getClassifier() : (classifier = type != null ? type.getClassifier() : "");
        String extension = StringUtils.isNotEmpty((String)request.getExtension()) ? request.getExtension() : (type != null ? type.getExtension() : "");
        return new DefaultArtifactCoordinate(session, (Artifact)new DefaultArtifact(request.getGroupId(), request.getArtifactId(), classifier, extension, request.getVersion(), type));
    }
}

