/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.SPFExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousSPFExecutor
implements SPFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousSPFExecutor.class);
    private DNSService dnsProbe;

    public AsynchronousSPFExecutor(DNSService service) {
        this.dnsProbe = service;
    }

    @Override
    public void execute(SPFSession session, FutureSPFResult result) {
        SPFChecker checker;
        while ((checker = session.popChecker()) != null) {
            LOGGER.debug("Executing checker: {}", (Object)checker);
            SPFChecker finalChecker = checker;
            try {
                DNSLookupContinuation cont = checker.checkSPF(session);
                this.dnsProbe.getRecordsAsync(cont.getRequest()).thenAccept(results -> {
                    try {
                        cont.getListener().onDNSResponse(new DNSResponse((List<String>)results), session);
                    }
                    catch (NeutralException | NoneException | PermErrorException | TempErrorException e) {
                        this.handleError(session, finalChecker, e);
                    }
                }).exceptionally(e -> {
                    if (e instanceof TimeoutException) {
                        try {
                            cont.getListener().onDNSResponse(new DNSResponse((TimeoutException)e), session);
                        }
                        catch (NeutralException | NoneException | PermErrorException | TempErrorException ex2) {
                            this.handleError(session, finalChecker, ex2);
                        }
                    }
                    return null;
                });
            }
            catch (Exception e2) {
                this.handleError(session, checker, e2);
            }
        }
        result.setSPFResult(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(SPFSession session, SPFChecker checker, Exception e) {
        while (e != null) {
            while (checker == null || !(checker instanceof SPFCheckerExceptionCatcher)) {
                checker = session.popChecker();
            }
            try {
                ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e, session);
                e = null;
            }
            catch (SPFResultException ex) {
                e = ex;
            }
            finally {
                checker = null;
            }
        }
    }
}

