<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

How To Create A Release
========================================================================================================================
<!-- line width set to 120 characters. please break lines so that this file also looks good in vi -->

<!-- MACRO{toc} -->

Prerequisites for release managers
----------------------------------
You need to be a Jackrabbit committer to prepare and perform a release, but anyone is welcome to help test the release
candidates and comment on the release plans.

You should have a code signing key that is included in the Jackrabbit KEYS file. See [Appendix A](#A) at the end of 
this page for more details.

You also need to tell Maven your Apache LDAP credentials needed for deploying artifacts to the Nexus server at 
https://repository.apache.org/. See [Appendix B](#B) for the required settings.

Release management tasks
------------------------
1. Make sure that an appropriate version for the release is entered in [Jira][3] and that all the related issues have
   been resolved.
   
1. Create or update a `RELEASE-NOTES.txt` file in the root folder of the project to be released. When done, commit the
   file. See previous release notes for examples of what to include. The release note report in [Jira][3] is a useful
   source of required information.
   
1. Build and deploy the release artifacts with Maven (see below).

    The release is built using the Maven release plugin. See the [Releasing a Maven project][4] guide for more
    details. Make sure you have added the pgp key information in you maven settings file, especially if you have 
    more than one key installed locally. See [Appendix B](#B) for the details.
    
    1. (optional, prepare your environment. e.g.: `$ export version=3.1.36`)
    2. Execute `mvn clean deploy -Papache-release -Dmaven.deploy.skip=true`. This tests if the release would work.
    3. Execute `mvn release:prepare`. This will update the POM files and tag the release in Git after asking for the release version number.
    4. Execute `mvn release:perform`. This will build the tagged release and deploy the artifacts to
        a new staging repository on _repository.apache.org_. 
        After the build, login to [https://repository.apache.org/][2] and you should see it there.

        The non-Maven release artifacts are automatically copied to `/.../target/checkout/target/$version`

1. Close the [staged repository][2] on <https://repository.apache.org>.

1. Upload the artifacts to https://dist.apache.org/repos/dist/dev/jackrabbit/filevault via SVN
       
        svn co https://dist.apache.org/repos/dist/dev/jackrabbit/filevault dist-dev-filevault
        cd dist-dev-filevault
        cp -r /path/to/jackrabbit/target/checkout/target/$version $version
        svn add $version
        svn commit -m "Apache Jackrabbit Filevault $version release candidate" $version
       
1. Start the vote thread, wait **72 hours**. See the `vote.txt` template generated by the Maven build.

1. If the vote fails (easy case first):
    1. remove the release tag from Git
    2. delete the RC from _dist.apache.org_
    3. and drop the [staged repository][2]
    4. done 
 
1. If the vote is successful, close the vote by publishing the results

1. copy the release candidate from `dev/jackrabbit` to `release/jackrabbit` in 
   <https://dist.apache.org/repos/dist/>, and delete any older releases from the same branch 
   (they're automatically archived):

    ```` 
    svn move -m "Apache Jackrabbit FileVault $version" \
        https://dist.apache.org/repos/dist/dev/jackrabbit/filevault/$version \
        https://dist.apache.org/repos/dist/release/jackrabbit/filevault/$version
    ````

1. release the [staged repository][2] for synchronization to Maven Central.

1. update the website by first checking out the released tag, then execute `mvn clean site` on the reactor project. Afterwards check the generated site and publish it via `mvn site-deploy`

1. mark the version as released in [Jira][3]:
    _Jira Project Home_ -> _Project Summary_ -> _Administer Project_. 
        
    Under Versions, you'll see all the defined project versions. 
    From the settings menu, choose *Release* on the version.

1. Close all the issues included in the release: 
    _Jira Project Home_ -> _Change Log_ -> Choose the released version. 
        
    From the issue list you have the option to bulk update all of the included issues. 
    Just *Transition Issues* from *Resolved* to *Closed* and you are done!

1. Update the Jackrabbit web site to point to the new release in <http://svn.apache.org/repos/asf/jackrabbit/site/trunk/src/site/markdown/downloads.md>.

1. Send the release announcement **once** the web site and download mirrors have been synced.


Related Links
-------------
* http://www.apache.org/dev/release.html
* http://www.apache.org/dev/release-signing.html
* http://wiki.apache.org/incubator/SigningReleases
* http://www.apache.org/dev/repository-faq.html

  
<a name="A"></a>
Appendix A: Create and add your key to the Jackrabbit KEYS file
---------------------------------------------------------------
Follow these instructions to generate your code signing key and to add it to the Jackrabbit KEYS file.

1. [Generate a code signing key][0] using your _@apache.org_ address as the email and `CODE SIGNING KEY` as the
   comment.
    
2. The Jackrabbit KEYS file is managed in https://svn.apache.org/repos/asf/jackrabbit/dist/KEYS. To modify the file,
   first checkout the `dist` directory:

        svn checkout https://svn.apache.org/repos/asf/jackrabbit/dist
    
3. See the beginning of the KEYS file for instructions on how to append your key to the file.

4. Once you've committed the changes, update the KEYS file on `people.apache.org`:

        umask 002; svn update /www/www.apache.org/dist/jackrabbit
    
5. You are **DONE**, but to see the changes on http://www.apache.org/dist/jackrabbit/KEYS you must wait 2 hours

You should get your key [linked to the Apache web of trust][1]. Once other people have signed your key, you can
update the KEYS file with the signatures you've received.


<a name="B"></a>
Appendix B: Maven settings
--------------------------

    <settings>
    ...
      <servers>
        <!-- To deploy a Jackrabbit snapshot -->
        <server>
          <id>apache.snapshots.https</id>
          <username> <!-- YOUR APACHE LDAP USERNAME --> </username>
          <password> <!-- YOUR APACHE LDAp PASSWORD --> </password>
        </server>
        <!-- To stage a Jackrabbit release -->
        <server>
          <id>apache.releases.https</id>
          <username> <!-- YOUR APACHE LDAP USERNAME --> </username>
          <password> <!-- YOUR APACHE LDAP PASSWORD --> </password>
        </server>
        ...
        <profiles>
          <profile>
            <id>apache-release</id>
            <properties>
              <gpg.keyname><!-- enough of the key id to id it --></gpg.keyname>
    
              <!-- pick one of the following -->
    
              <!-- either you feel comfortable with the passphrase on disk -->
              <gpg.passphrase><!-- your passphrase for your gpg key goes here--></gpg.passphrase>
    
              <!-- or you use an agent-->
              <gpg.useagent>true</gpg.useagent>
    
            </properties>
          </profile>
          ...
        </profiles>
      </servers>
    </settings>


[0]: http://www.apache.org/dev/release-signing.html#generate
[1]: http://www.apache.org/dev/release-signing.html#apache-wot
[2]: https://repository.apache.org/index.html#stagingRepositories
[3]: https://issues.apache.org/jira/browse/JCRVLT
[4]: https://maven.apache.org/developers/release/releasing.html
