/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorPersistenceMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private float walLoggingRate;
    private float walWritingRate;
    private int walArchiveSegments;
    private float walFsyncTimeAvg;
    private long walBufPollSpinRate;
    private long walSz;
    private long walLastRollOverTm;
    private long cpTotalTm;
    private long lastCpDuration;
    private long lastCpStart;
    private long lastCpLockWaitDuration;
    private long lastCpMmarkDuration;
    private long lastCpPagesWriteDuration;
    private long lastCpFsyncDuration;
    private long lastCpTotalPages;
    private long lastCpDataPages;
    private long lastCpCowPages;
    private long dirtyPages;
    private long pagesRead;
    private long pagesWritten;
    private long pagesReplaced;
    private long offHeapSz;
    private long offheapUsedSz;
    private long usedCpBufPages;
    private long usedCpBufSz;
    private long cpBufSz;
    private long totalSz;
    private long storageSize;
    private long sparseStorageSize;

    public VisorPersistenceMetrics() {
    }

    public VisorPersistenceMetrics(DataStorageMetrics m) {
        this.walLoggingRate = m.getWalLoggingRate();
        this.walWritingRate = m.getWalWritingRate();
        this.walArchiveSegments = m.getWalArchiveSegments();
        this.walFsyncTimeAvg = m.getWalFsyncTimeAverage();
        this.walBufPollSpinRate = m.getWalBuffPollSpinsRate();
        this.walSz = m.getWalTotalSize();
        this.walLastRollOverTm = m.getWalLastRollOverTime();
        this.cpTotalTm = m.getCheckpointTotalTime();
        this.lastCpDuration = m.getLastCheckpointDuration();
        this.lastCpStart = m.getLastCheckpointStarted();
        this.lastCpLockWaitDuration = m.getLastCheckpointLockWaitDuration();
        this.lastCpMmarkDuration = m.getLastCheckpointMarkDuration();
        this.lastCpPagesWriteDuration = m.getLastCheckpointPagesWriteDuration();
        this.lastCpFsyncDuration = m.getLastCheckpointFsyncDuration();
        this.lastCpTotalPages = m.getLastCheckpointTotalPagesNumber();
        this.lastCpDataPages = m.getLastCheckpointDataPagesNumber();
        this.lastCpCowPages = m.getLastCheckpointCopiedOnWritePagesNumber();
        this.dirtyPages = m.getDirtyPages();
        this.pagesRead = m.getPagesRead();
        this.pagesWritten = m.getPagesWritten();
        this.pagesReplaced = m.getPagesReplaced();
        this.offHeapSz = m.getOffHeapSize();
        this.offheapUsedSz = m.getOffheapUsedSize();
        this.usedCpBufPages = m.getUsedCheckpointBufferPages();
        this.usedCpBufSz = m.getUsedCheckpointBufferSize();
        this.cpBufSz = m.getCheckpointBufferSize();
        this.totalSz = m.getTotalAllocatedSize();
        this.storageSize = m.getStorageSize();
        this.sparseStorageSize = m.getSparseStorageSize();
    }

    public float getWalLoggingRate() {
        return this.walLoggingRate;
    }

    public float getWalWritingRate() {
        return this.walWritingRate;
    }

    public int getWalArchiveSegments() {
        return this.walArchiveSegments;
    }

    public float getWalFsyncTimeAverage() {
        return this.walFsyncTimeAvg;
    }

    public long getWalBuffPollSpinsRate() {
        return this.walBufPollSpinRate;
    }

    public long getWalTotalSize() {
        return this.walSz;
    }

    public long getWalLastRollOverTime() {
        return this.walLastRollOverTm;
    }

    public long getCheckpointTotalTime() {
        return this.cpTotalTm;
    }

    public long getLastCheckpointingDuration() {
        return this.lastCpDuration;
    }

    public long getLastCheckpointStarted() {
        return this.lastCpStart;
    }

    public long getLastCheckpointLockWaitDuration() {
        return this.lastCpLockWaitDuration;
    }

    public long getLastCheckpointMarkDuration() {
        return this.lastCpMmarkDuration;
    }

    public long getLastCheckpointPagesWriteDuration() {
        return this.lastCpPagesWriteDuration;
    }

    public long getLastCheckpointFsyncDuration() {
        return this.lastCpFsyncDuration;
    }

    public long getLastCheckpointTotalPagesNumber() {
        return this.lastCpTotalPages;
    }

    public long getLastCheckpointDataPagesNumber() {
        return this.lastCpDataPages;
    }

    public long getLastCheckpointCopiedOnWritePagesNumber() {
        return this.lastCpCowPages;
    }

    public long getDirtyPages() {
        return this.dirtyPages;
    }

    public long getPagesRead() {
        return this.pagesRead;
    }

    public long getPagesWritten() {
        return this.pagesWritten;
    }

    public long getPagesReplaced() {
        return this.pagesReplaced;
    }

    public long getOffHeapSize() {
        return this.offHeapSz;
    }

    public long getOffheapUsedSize() {
        return this.offheapUsedSz;
    }

    public long getUsedCheckpointBufferPages() {
        return this.usedCpBufPages;
    }

    public long getUsedCheckpointBufferSize() {
        return this.usedCpBufSz;
    }

    public long getCheckpointBufferSize() {
        return this.cpBufSz;
    }

    public long getTotalAllocatedSize() {
        return this.totalSz;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public long getSparseStorageSize() {
        return this.sparseStorageSize;
    }

    @Override
    public byte getProtocolVersion() {
        return 4;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeFloat(this.walLoggingRate);
        out.writeFloat(this.walWritingRate);
        out.writeInt(this.walArchiveSegments);
        out.writeFloat(this.walFsyncTimeAvg);
        out.writeLong(this.lastCpDuration);
        out.writeLong(this.lastCpLockWaitDuration);
        out.writeLong(this.lastCpMmarkDuration);
        out.writeLong(this.lastCpPagesWriteDuration);
        out.writeLong(this.lastCpFsyncDuration);
        out.writeLong(this.lastCpTotalPages);
        out.writeLong(this.lastCpDataPages);
        out.writeLong(this.lastCpCowPages);
        out.writeLong(this.walBufPollSpinRate);
        out.writeLong(this.walSz);
        out.writeLong(this.walLastRollOverTm);
        out.writeLong(this.cpTotalTm);
        out.writeLong(this.dirtyPages);
        out.writeLong(this.pagesRead);
        out.writeLong(this.pagesWritten);
        out.writeLong(this.pagesReplaced);
        out.writeLong(this.offHeapSz);
        out.writeLong(this.offheapUsedSz);
        out.writeLong(this.usedCpBufPages);
        out.writeLong(this.usedCpBufSz);
        out.writeLong(this.cpBufSz);
        out.writeLong(this.totalSz);
        out.writeLong(this.storageSize);
        out.writeLong(this.sparseStorageSize);
        out.writeLong(this.lastCpStart);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.walLoggingRate = in.readFloat();
        this.walWritingRate = in.readFloat();
        this.walArchiveSegments = in.readInt();
        this.walFsyncTimeAvg = in.readFloat();
        this.lastCpDuration = in.readLong();
        this.lastCpLockWaitDuration = in.readLong();
        this.lastCpMmarkDuration = in.readLong();
        this.lastCpPagesWriteDuration = in.readLong();
        this.lastCpFsyncDuration = in.readLong();
        this.lastCpTotalPages = in.readLong();
        this.lastCpDataPages = in.readLong();
        this.lastCpCowPages = in.readLong();
        if (protoVer > 1) {
            this.walBufPollSpinRate = in.readLong();
            this.walSz = in.readLong();
            this.walLastRollOverTm = in.readLong();
            this.cpTotalTm = in.readLong();
            this.dirtyPages = in.readLong();
            this.pagesRead = in.readLong();
            this.pagesWritten = in.readLong();
            this.pagesReplaced = in.readLong();
            this.offHeapSz = in.readLong();
            this.offheapUsedSz = in.readLong();
            this.usedCpBufPages = in.readLong();
            this.usedCpBufSz = in.readLong();
            this.cpBufSz = in.readLong();
            this.totalSz = in.readLong();
        }
        if (protoVer > 2) {
            this.storageSize = in.readLong();
            this.sparseStorageSize = in.readLong();
        }
        if (protoVer > 3) {
            this.lastCpStart = in.readLong();
        }
    }

    public String toString() {
        return S.toString(VisorPersistenceMetrics.class, this);
    }
}

