/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcIndexMeta
implements JdbcRawBinarylizable {
    private String schemaName;
    private String tblName;
    private String idxName;
    private QueryIndexType type;
    private List<String> fields;
    private List<Boolean> fieldsAsc;

    JdbcIndexMeta() {
    }

    JdbcIndexMeta(String schemaName, String tblName, GridQueryIndexDescriptor idx) {
        assert (tblName != null);
        assert (idx != null);
        assert (idx.fields() != null);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.idxName = idx.name();
        this.type = idx.type();
        this.fields = new ArrayList<String>(idx.fields());
        this.fieldsAsc = new ArrayList<Boolean>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fieldsAsc.add(!idx.descending(this.fields.get(i)));
        }
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String indexName() {
        return this.idxName;
    }

    public QueryIndexType type() {
        return this.type;
    }

    public List<String> fields() {
        return this.fields;
    }

    public List<Boolean> fieldsAsc() {
        return this.fieldsAsc;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        writer.writeString(this.idxName);
        writer.writeByte((byte)this.type.ordinal());
        JdbcUtils.writeStringCollection(writer, this.fields);
        if (this.fieldsAsc == null) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.fieldsAsc.size());
            for (Boolean b : this.fieldsAsc) {
                writer.writeBoolean(b);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        this.idxName = reader.readString();
        this.type = QueryIndexType.fromOrdinal(reader.readByte());
        this.fields = JdbcUtils.readStringList(reader);
        int size = reader.readInt();
        if (size > 0) {
            this.fieldsAsc = new ArrayList<Boolean>(size);
            for (int i = 0; i < size; ++i) {
                this.fieldsAsc.add(reader.readBoolean());
            }
        } else {
            this.fieldsAsc = Collections.emptyList();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcIndexMeta meta = (JdbcIndexMeta)o;
        return F.eq(this.schemaName, meta.schemaName) && F.eq(this.tblName, meta.tblName) && F.eq(this.idxName, meta.idxName);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + this.tblName.hashCode();
        result = 31 * result + this.idxName.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(JdbcIndexMeta.class, this);
    }
}

