/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class LongRunningTxTimeDumpSettingsClosure
implements IgniteRunnable {
    private static final long serialVersionUID = 0L;
    private final Long timeoutThreshold;
    private final Double samplesCoefficient;
    private final Integer samplesPerSecondLimit;
    @IgniteInstanceResource
    private Ignite ignite;

    public LongRunningTxTimeDumpSettingsClosure(Long timeoutThreshold, Double samplesCoefficient, Integer samplesPerSecondLimit) {
        this.timeoutThreshold = timeoutThreshold;
        this.samplesCoefficient = samplesCoefficient;
        this.samplesPerSecondLimit = samplesPerSecondLimit;
    }

    @Override
    public void run() {
        IgniteTxManager tm = ((IgniteEx)this.ignite).context().cache().context().tm();
        if (this.timeoutThreshold != null) {
            tm.longTransactionTimeDumpThreshold(this.timeoutThreshold);
        }
        if (this.samplesCoefficient != null) {
            tm.transactionTimeDumpSamplesCoefficient(this.samplesCoefficient);
        }
        if (this.samplesPerSecondLimit != null) {
            tm.transactionTimeDumpSamplesPerSecondLimit(this.samplesPerSecondLimit);
        }
    }
}

