/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.io.Serializable;
import java.util.Objects;

public class GroupKey {
    private final int id;
    private final Serializable key;

    public GroupKey(int id, Serializable key) {
        this.id = id;
        this.key = key;
    }

    public byte id() {
        return (byte)this.id;
    }

    public int unsignedId() {
        return this.id & 0xFF;
    }

    public Serializable key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupKey grpKey = (GroupKey)o;
        return this.id == grpKey.id && Objects.equals(this.key, grpKey.key);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key);
    }

    public String toString() {
        return "GroupKey [id=" + this.id + ']';
    }
}

