/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.tasks;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataMarshalled;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class MetadataUpdateTask
extends VisorMultiNodeTask<MetadataMarshalled, MetadataMarshalled, MetadataMarshalled> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<MetadataMarshalled, MetadataMarshalled> job(MetadataMarshalled arg) {
        return new MetadataUpdateJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected MetadataMarshalled reduce0(List<ComputeJobResult> results) {
        if (results.size() != 1) {
            throw new IgniteException("Invalid job results. Expected exactly 1 result, but was: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (MetadataMarshalled)results.get(0).getData();
    }

    private static class MetadataUpdateJob
    extends VisorJob<MetadataMarshalled, MetadataMarshalled> {
        private static final long serialVersionUID = 0L;

        protected MetadataUpdateJob(@Nullable MetadataMarshalled arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected MetadataMarshalled run(@Nullable MetadataMarshalled arg) throws IgniteException {
            this.ignite.context().security().authorize(null, SecurityPermission.ADMIN_METADATA_OPS);
            assert (Objects.nonNull(arg));
            byte[] marshalled = arg.metadataMarshalled();
            try {
                BinaryMetadata meta = (BinaryMetadata)U.unmarshal(this.ignite.context(), marshalled, U.resolveClassLoader(this.ignite.context().config()));
                ((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryContext().updateMetadata(meta.typeId(), meta, false);
                return new MetadataMarshalled(null, meta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }
}

