/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.tasks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MetadataTypeArgs
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String TYPE_NAME = "--typeName";
    public static final String TYPE_ID = "--typeId";
    private String typeName;
    private Integer typeId;

    public MetadataTypeArgs() {
    }

    public MetadataTypeArgs(String typeName, Integer typeId) {
        assert (typeName != null ^ typeId != null);
        this.typeName = typeName;
        this.typeId = typeId;
    }

    public String typeName() {
        return this.typeName;
    }

    public int typeId(GridKernalContext ctx) {
        if (this.typeId != null) {
            return this.typeId;
        }
        return ctx.cacheObjects().typeId(this.typeName);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.typeName != null);
        if (this.typeName != null) {
            U.writeString(out, this.typeName);
        } else {
            out.writeInt(this.typeId);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        boolean useName = in.readBoolean();
        if (useName) {
            this.typeName = U.readString(in);
        } else {
            this.typeId = in.readInt();
        }
    }

    public String toString() {
        return this.typeId != null ? this.printInt(this.typeId) : this.typeName;
    }

    private String printInt(int val) {
        return "0x" + Integer.toHexString(val).toUpperCase() + " (" + val + ')';
    }
}

