/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacAlgorithmsTest;
import org.apache.commons.codec.digest.HmacUtils;
import org.junit.Assert;
import org.junit.Test;

public class HmacUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testEmptyKey() {
        HmacUtils.getHmacMd5((byte[])new byte[0]);
    }

    @Test
    public void testGetHMac() {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.getHmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.getHmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.getHmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.getHmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES).doFinal(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
    }

    @Test
    public void testHmacMd5Hex() throws IOException {
        Assert.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)"750c783e6ab0b503eaa86e310a5db738", (Object)HmacUtils.hmacMd5Hex((String)"Jefe", (String)"what do ya want for nothing?"));
        Assert.assertEquals((Object)"750c783e6ab0b503eaa86e310a5db738", (Object)HmacUtils.hmacMd5Hex((byte[])"Jefe".getBytes(), (InputStream)new ByteArrayInputStream("what do ya want for nothing?".getBytes())));
    }

    @Test
    public void testHmacSha1Hex() throws IOException {
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)""));
        Assert.assertEquals((Object)"effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", (Object)HmacUtils.hmacSha1Hex((String)"Jefe", (String)"what do ya want for nothing?"));
        Assert.assertEquals((Object)"effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", (Object)HmacUtils.hmacSha1Hex((byte[])"Jefe".getBytes(), (InputStream)new ByteArrayInputStream("what do ya want for nothing?".getBytes())));
    }

    @Test
    public void testHmacSha1UpdateWithByteArray() {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (byte[])"".getBytes());
        Assert.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testHmacSha1UpdateWithInpustream() throws IOException {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (InputStream)new ByteArrayInputStream("".getBytes()));
        Assert.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testHmacSha1UpdateWithString() {
        Mac mac = HmacUtils.getHmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        HmacUtils.updateHmac((Mac)mac, (String)"The quick brown fox jumps over the lazy dog");
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
        HmacUtils.updateHmac((Mac)mac, (String)"");
        Assert.assertEquals((Object)"f42bb0eeb018ebbd4597ae7213711ec60760843f", (Object)Hex.encodeHexString((byte[])mac.doFinal()));
    }

    @Test
    public void testInitializedMac() {
        Mac md5Mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_MD5, (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        Mac md5Mac2 = HmacUtils.getInitializedMac((String)"HmacMD5", (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.updateHmac((Mac)md5Mac, (String)"The quick brown fox jumps over the lazy dog").doFinal());
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.updateHmac((Mac)md5Mac2, (String)"The quick brown fox jumps over the lazy dog").doFinal());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitializedMacNullAlgo() {
        HmacUtils.getInitializedMac((String)null, (byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitializedMacNullKey() {
        HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_MD5, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInternalNoSuchAlgorithmException() {
        HmacUtils.getInitializedMac((String)"Bogus Bogus", (byte[])StringUtils.getBytesUtf8((String)"akey"));
    }

    @Test
    public void testMd5HMac() throws IOException {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_MD5_RESULT_BYTES, (byte[])HmacUtils.hmacMd5((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertEquals((Object)"80070713463e7749b90c2dc24911e275", (Object)HmacUtils.hmacMd5Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMd5HMacFail() {
        HmacUtils.hmacMd5((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKey() {
        HmacUtils.getHmacMd5(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecretKeySpecAllowsEmtyKeys() {
        new SecretKeySpec(new byte[0], "HmacMD5");
    }

    @Test
    public void testSha1HMac() throws IOException {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA1_RESULT_BYTES, (byte[])HmacUtils.hmacSha1((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertEquals((Object)"de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9", (Object)HmacUtils.hmacSha1Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha1HMacFail() {
        HmacUtils.hmacSha1((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
    }

    @Test
    public void testSha256HMac() throws IOException {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA256_RESULT_BYTES, (byte[])HmacUtils.hmacSha256((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertEquals((Object)"f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", (Object)HmacUtils.hmacSha256Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha256HMacFail() {
        HmacUtils.hmacSha256((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
    }

    @Test
    public void testSha384HMac() throws IOException {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA384_RESULT_BYTES, (byte[])HmacUtils.hmacSha384((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA384_RESULT_STRING, (Object)HmacUtils.hmacSha384Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha384HMacFail() {
        HmacUtils.hmacSha384((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
    }

    @Test
    public void testSha512HMac() throws IOException {
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertArrayEquals((byte[])HmacAlgorithmsTest.STANDARD_SHA512_RESULT_BYTES, (byte[])HmacUtils.hmacSha512((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((byte[])HmacAlgorithmsTest.STANDARD_KEY_BYTES, (InputStream)new ByteArrayInputStream(HmacAlgorithmsTest.STANDARD_PHRASE_BYTES)));
        Assert.assertEquals((Object)HmacAlgorithmsTest.STANDARD_SHA512_RESULT_STRING, (Object)HmacUtils.hmacSha512Hex((String)"key", (String)"The quick brown fox jumps over the lazy dog"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSha512HMacFail() {
        HmacUtils.hmacSha512((byte[])null, (byte[])HmacAlgorithmsTest.STANDARD_PHRASE_BYTES);
    }
}

