/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.BaseNCodecTest;
import org.apache.commons.codec.binary.BaseNTestData;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class Base64Test {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    static final String[] BASE64_IMPOSSIBLE_CASES = new String[]{"ZE==", "ZmC=", "Zm9vYE==", "Zm9vYmC=", "AB"};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private final Random random = new Random();

    public Random getRandom() {
        return this.random;
    }

    @Test
    public void testIsStringBase64() {
        String nullString = null;
        String emptyString = "";
        String validString = "abc===defg\n\r123456\r789\r\rABC\n\nDEF==GHI\r\nJKL==============";
        String invalidString = "abc===defg\n\r123456\r789\r\rABC\n\nDEF==GHI\r\nJKL==============\u0000";
        try {
            Base64.isBase64(nullString);
            Assert.fail((String)"Base64.isStringBase64() should not be null-safe.");
        }
        catch (NullPointerException npe) {
            Assert.assertNotNull((String)"Base64.isStringBase64() should not be null-safe.", (Object)npe);
        }
        Assert.assertTrue((String)"Base64.isStringBase64(empty-string) is true", (boolean)Base64.isBase64((String)""));
        Assert.assertTrue((String)"Base64.isStringBase64(valid-string) is true", (boolean)Base64.isBase64((String)"abc===defg\n\r123456\r789\r\rABC\n\nDEF==GHI\r\nJKL=============="));
        Assert.assertFalse((String)"Base64.isStringBase64(invalid-string) is false", (boolean)Base64.isBase64((String)"abc===defg\n\r123456\r789\r\rABC\n\nDEF==GHI\r\nJKL==============\u0000"));
    }

    @Test
    public void testBase64() {
        String content = "Hello World";
        byte[] encodedBytes = Base64.encodeBase64((byte[])StringUtils.getBytesUtf8((String)"Hello World"));
        String encodedContent = StringUtils.newStringUtf8((byte[])encodedBytes);
        Assert.assertEquals((String)"encoding hello world", (Object)"SGVsbG8gV29ybGQ=", (Object)encodedContent);
        Base64 b64 = new Base64(76, null);
        encodedBytes = b64.encode(StringUtils.getBytesUtf8((String)"Hello World"));
        encodedContent = StringUtils.newStringUtf8((byte[])encodedBytes);
        Assert.assertEquals((String)"encoding hello world", (Object)"SGVsbG8gV29ybGQ=", (Object)encodedContent);
        b64 = new Base64(0, null);
        encodedBytes = b64.encode(StringUtils.getBytesUtf8((String)"Hello World"));
        encodedContent = StringUtils.newStringUtf8((byte[])encodedBytes);
        Assert.assertEquals((String)"encoding hello world", (Object)"SGVsbG8gV29ybGQ=", (Object)encodedContent);
        byte[] decode = b64.decode("SGVsbG{\u00e9\u00e9\u00e9\u00e9\u00e9\u00e9}8gV29ybGQ=");
        String decodeString = StringUtils.newStringUtf8((byte[])decode);
        Assert.assertEquals((String)"decode hello world", (Object)"Hello World", (Object)decodeString);
    }

    @Test
    public void testBase64AtBufferStart() {
        this.testBase64InBuffer(0, 100);
    }

    @Test
    public void testBase64AtBufferEnd() {
        this.testBase64InBuffer(100, 0);
    }

    @Test
    public void testBase64AtBufferMiddle() {
        this.testBase64InBuffer(100, 100);
    }

    private void testBase64InBuffer(int startPasSize, int endPadSize) {
        String content = "Hello World";
        byte[] bytesUtf8 = StringUtils.getBytesUtf8((String)"Hello World");
        byte[] buffer = ArrayUtils.addAll((byte[])bytesUtf8, (byte[])new byte[endPadSize]);
        buffer = ArrayUtils.addAll((byte[])new byte[startPasSize], (byte[])buffer);
        byte[] encodedBytes = new Base64().encode(buffer, startPasSize, bytesUtf8.length);
        String encodedContent = StringUtils.newStringUtf8((byte[])encodedBytes);
        Assert.assertEquals((String)"encoding hello world", (Object)"SGVsbG8gV29ybGQ=", (Object)encodedContent);
    }

    @Test
    public void testDecodeWithInnerPad() {
        String content = "SGVsbG8gV29ybGQ=SGVsbG8gV29ybGQ=";
        byte[] result = Base64.decodeBase64((String)"SGVsbG8gV29ybGQ=SGVsbG8gV29ybGQ=");
        byte[] shouldBe = StringUtils.getBytesUtf8((String)"Hello World");
        Assert.assertTrue((String)"decode should halt at pad (=)", (boolean)Arrays.equals(result, shouldBe));
    }

    @Test
    public void testChunkedEncodeMultipleOf76() {
        byte[] expectedEncode = Base64.encodeBase64((byte[])BaseNTestData.DECODED, (boolean)true);
        String actualResult = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9xA7c/FHypWcl\nrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+qBpTsPpepW8DNVYy1c02/1wy\nC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYdivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6\n+WAELKvm/UovvyaOi+OdMUfjQ0JLiLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQd\ngciIHnpdd4VUTPGRUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+K\nZJSoAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/Qoqf92UH\n/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp251IUxBGA4cUxh0eaxk3OD\nWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1thMavm4nDc4vaNoSE1RnZNYwbiUVlVPM\n9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjv\nB5MYQlOlaaTtQrRApXa5Z4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKW\nC3KuiOS9BJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvfDnqi\ncYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK++S7Y0VXUgoYYrBV4\nY7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUElepjs1QdV3fEV1LJtiywA3ubVNQJ\nRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35IcaOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p\n088l3/93qGR5593NCiuPPWcsDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2\nWcypAiOIEkBsH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG/6YAHZilo8at\n0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq3CLZXdZFZ/VrqXeVjtOAu2A=\n".replaceAll("\n", "\r\n");
        byte[] actualEncode = StringUtils.getBytesUtf8((String)actualResult);
        Assert.assertTrue((String)"chunkedEncodeMultipleOf76", (boolean)Arrays.equals(expectedEncode, actualEncode));
    }

    @Test
    public void testCodec68() {
        byte[] x = new byte[]{110, 65, 61, 61, -100};
        Base64.decodeBase64((byte[])x);
    }

    @Test
    public void testCodeInteger1() {
        String encodedInt1 = "li7dzDacuo67Jg7mtqEm2TRuOMU=";
        BigInteger bigInt1 = new BigInteger("857393771208094202104259627990318636601332086981");
        Assert.assertEquals((Object)"li7dzDacuo67Jg7mtqEm2TRuOMU=", (Object)new String(Base64.encodeInteger((BigInteger)bigInt1)));
        Assert.assertEquals((Object)bigInt1, (Object)Base64.decodeInteger((byte[])"li7dzDacuo67Jg7mtqEm2TRuOMU=".getBytes(CHARSET_UTF8)));
    }

    @Test
    public void testCodeInteger2() {
        String encodedInt2 = "9B5ypLY9pMOmtxCeTDHgwdNFeGs=";
        BigInteger bigInt2 = new BigInteger("1393672757286116725466646726891466679477132949611");
        Assert.assertEquals((Object)"9B5ypLY9pMOmtxCeTDHgwdNFeGs=", (Object)new String(Base64.encodeInteger((BigInteger)bigInt2)));
        Assert.assertEquals((Object)bigInt2, (Object)Base64.decodeInteger((byte[])"9B5ypLY9pMOmtxCeTDHgwdNFeGs=".getBytes(CHARSET_UTF8)));
    }

    @Test
    public void testCodeInteger3() {
        String encodedInt3 = "FKIhdgaG5LGKiEtF1vHy4f3y700zaD6QwDS3IrNVGzNp2rY+1LFWTK6D44AyiC1n8uWz1itkYMZF0/aKDK0Yjg==";
        BigInteger bigInt3 = new BigInteger("1080654815409387346195174854511969891364164488058190793635243098977490449581124171362405574495062430572478766856090958495998158114332651671116876320938126");
        Assert.assertEquals((Object)"FKIhdgaG5LGKiEtF1vHy4f3y700zaD6QwDS3IrNVGzNp2rY+1LFWTK6D44AyiC1n8uWz1itkYMZF0/aKDK0Yjg==", (Object)new String(Base64.encodeInteger((BigInteger)bigInt3)));
        Assert.assertEquals((Object)bigInt3, (Object)Base64.decodeInteger((byte[])"FKIhdgaG5LGKiEtF1vHy4f3y700zaD6QwDS3IrNVGzNp2rY+1LFWTK6D44AyiC1n8uWz1itkYMZF0/aKDK0Yjg==".getBytes(CHARSET_UTF8)));
    }

    @Test
    public void testCodeInteger4() {
        String encodedInt4 = "ctA8YGxrtngg/zKVvqEOefnwmViFztcnPBYPlJsvh6yKI4iDm68fnp4Mi3RrJ6bZAygFrUIQLxLjV+OJtgJAEto0xAs+Mehuq1DkSFEpP3oDzCTOsrOiS1DwQe4oIb7zVk/9l7aPtJMHW0LVlMdwZNFNNJoqMcT2ZfCPrfvYvQ0=";
        BigInteger bigInt4 = new BigInteger("80624726256040348115552042320696813500187275370942441977258669395023235020055564647117594451929708788598704081077890850726227289270230377442285367559774800853404089092381420228663316324808605521697655145608801533888071381819208887705771753016938104409283940243801509765453542091716518238707344493641683483917");
        Assert.assertEquals((Object)"ctA8YGxrtngg/zKVvqEOefnwmViFztcnPBYPlJsvh6yKI4iDm68fnp4Mi3RrJ6bZAygFrUIQLxLjV+OJtgJAEto0xAs+Mehuq1DkSFEpP3oDzCTOsrOiS1DwQe4oIb7zVk/9l7aPtJMHW0LVlMdwZNFNNJoqMcT2ZfCPrfvYvQ0=", (Object)new String(Base64.encodeInteger((BigInteger)bigInt4)));
        Assert.assertEquals((Object)bigInt4, (Object)Base64.decodeInteger((byte[])"ctA8YGxrtngg/zKVvqEOefnwmViFztcnPBYPlJsvh6yKI4iDm68fnp4Mi3RrJ6bZAygFrUIQLxLjV+OJtgJAEto0xAs+Mehuq1DkSFEpP3oDzCTOsrOiS1DwQe4oIb7zVk/9l7aPtJMHW0LVlMdwZNFNNJoqMcT2ZfCPrfvYvQ0=".getBytes(CHARSET_UTF8)));
    }

    @Test
    public void testCodeIntegerEdgeCases() {
    }

    @Test
    public void testCodeIntegerNull() {
        try {
            Base64.encodeInteger(null);
            Assert.fail((String)"Exception not thrown when passing in null to encodeInteger(BigInteger)");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Incorrect Exception caught when passing in null to encodeInteger(BigInteger)");
        }
    }

    @Test
    public void testConstructors() {
        Base64 base64 = new Base64();
        base64 = new Base64(-1);
        base64 = new Base64(-1, new byte[0]);
        base64 = new Base64(64, new byte[0]);
        try {
            base64 = new Base64(-1, new byte[]{65});
            Assert.fail((String)"Should have rejected attempt to use 'A' as a line separator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            base64 = new Base64(64, new byte[]{65});
            Assert.fail((String)"Should have rejected attempt to use 'A' as a line separator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            base64 = new Base64(64, new byte[]{61});
            Assert.fail((String)"Should have rejected attempt to use '=' as a line separator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        base64 = new Base64(64, new byte[]{36});
        try {
            base64 = new Base64(64, new byte[]{65, 36});
            Assert.fail((String)"Should have rejected attempt to use 'A$' as a line separator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        base64 = new Base64(64, new byte[]{32, 36, 10, 13, 9});
        Assert.assertNotNull((Object)base64);
    }

    @Test
    public void testConstructor_Int_ByteArray_Boolean() {
        Base64 base64 = new Base64(65, new byte[]{9}, false);
        byte[] encoded = base64.encode(BaseNTestData.DECODED);
        String expectedResult = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n";
        expectedResult = expectedResult.replace('\n', '\t');
        String result = StringUtils.newStringUtf8((byte[])encoded);
        Assert.assertEquals((String)"new Base64(65, \\t, false)", (Object)expectedResult, (Object)result);
    }

    @Test
    public void testConstructor_Int_ByteArray_Boolean_UrlSafe() {
        Base64 base64 = new Base64(64, new byte[]{9}, true);
        byte[] encoded = base64.encode(BaseNTestData.DECODED);
        String expectedResult = "9IPNKwUvdLiIAp6ctz12SiQmOGstWyYvSPeevufDhrzaws65voykKjbIj33YWTa9\nxA7c/FHypWclrZhQ7onfc3JE93BJ5fT4R9zAEdjbjy1hv4ZYNnET4WJeXMLJ/5p+\nqBpTsPpepW8DNVYy1c02/1wyC+kgA6CvRUd9cSr/lt88AEdsTV4GMCn1+EwuAiYd\nivxuzn+cLM8q2jewqlI52tP9J7Cs8vqG71s6+WAELKvm/UovvyaOi+OdMUfjQ0JL\niLkHu6p9OwUgvQqiDKzEv/Augo0dTPZzYGEyCP5GVrle3QQdgciIHnpdd4VUTPGR\nUbXeKbh++U3fbJIng/sQXM3IYByMZ7xt9HWS1LUcRdQ7Prwn/IlQWxOMeq+KZJSo\nAviWtdserXyHbIEa//hmr4p/j80k0g9q35hq1ayGM9984ALTSaZ8WeyFbZx1CxC/\nQoqf92UH/ylBRnSJNn4sS0oa3uUbNvOnpkB4D9V7Ut9atinCJrw+wiJcMl+9kp25\n1IUxBGA4cUxh0eaxk3ODWnwI95EktmWOKwCSP0xjWwIMxDjygwAG5R8fk9H9bVi1\nthMavm4nDc4vaNoSE1RnZNYwbiUVlVPM9EclvJWTWd6igWeA0MxHAA8iOM5Vnmqp\n/WGM7UDq59rBIdNQCoeTJaAkEtAuLL5zogOa5e+MzVjvB5MYQlOlaaTtQrRApXa5\nZ4VfEanu9UK2fi1T8jJPFC2PmXebxp0bnO+VW+bgyEdIIkIQCaZq1MKWC3KuiOS9\nBJ1t7O0A2JKJKvoE4UNulzV2TGCC+KAnmjRqQBqXlJmgjHQAoHNZKOma/uIQOsvf\nDnqicYdDmfyCYuV89HjA1H8tiDJ85VfsrFHdcbPAoNCpi65awJSHfdPO1NDONOK+\n+S7Y0VXUgoYYrBV4Y7YbC8wg/nqcimr3lm3tRyp+QsgKzdREbfNRk0F5PLyLfsUE\nlepjs1QdV3fEV1LJtiywA3ubVNQJRxhbYxa/C/Xy2qxpm6vvdL92l3q1ccev35Ic\naOiSx7Im+/GxV2lVKdaOvYVGDD1zBRe6Y2CwQb9p088l3/93qGR5593NCiuPPWcs\nDWwUShM1EyW0FNX1F8bnzHnYijoyE/jf4s/l9bBd7yJdRWRCyih2WcypAiOIEkBs\nH+dCTgalu8sRDoMh4ZIBBdgHfoZUycLqReQFLZZ4Sl4zSmzt5vQxQFhEKb9+ff/4\nrb1KAo6wifengxVfIsa2b5ljXzAqXs7JkPvmC6fa7X4ZZndRokaxYlu3cg8OV+uG\n/6YAHZilo8at0OpkkNdNFuhwuGlkBqrZKNUj/gSiYYc06gF/r/z6iWAjpXJRW1qq\n3CLZXdZFZ/VrqXeVjtOAu2A=\n";
        expectedResult = expectedResult.replaceAll("=", "");
        expectedResult = expectedResult.replace('\n', '\t');
        expectedResult = expectedResult.replace('+', '-');
        expectedResult = expectedResult.replace('/', '_');
        String result = StringUtils.newStringUtf8((byte[])encoded);
        Assert.assertEquals((String)"new Base64(64, \\t, true)", (Object)result, (Object)expectedResult);
    }

    @Test
    public void testDecodePadMarkerIndex2() {
        Assert.assertEquals((Object)"A", (Object)new String(Base64.decodeBase64((byte[])"QQ==".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testDecodePadMarkerIndex3() {
        Assert.assertEquals((Object)"AA", (Object)new String(Base64.decodeBase64((byte[])"QUE=".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"AAA", (Object)new String(Base64.decodeBase64((byte[])"QUFB".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testDecodePadOnly() {
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"====".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((Object)"", (Object)new String(Base64.decodeBase64((byte[])"====".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"===".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"==".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"=".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"".getBytes(CHARSET_UTF8)).length);
    }

    @Test
    public void testDecodePadOnlyChunked() {
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"====\n".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((Object)"", (Object)new String(Base64.decodeBase64((byte[])"====\n".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"===\n".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"==\n".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"=\n".getBytes(CHARSET_UTF8)).length);
        Assert.assertEquals((long)0L, (long)Base64.decodeBase64((byte[])"\n".getBytes(CHARSET_UTF8)).length);
    }

    @Test
    public void testDecodeWithWhitespace() throws Exception {
        String orig = "I am a late night coder.";
        byte[] encodedArray = Base64.encodeBase64((byte[])"I am a late night coder.".getBytes(CHARSET_UTF8));
        StringBuilder intermediate = new StringBuilder(new String(encodedArray));
        intermediate.insert(2, ' ');
        intermediate.insert(5, '\t');
        intermediate.insert(10, '\r');
        intermediate.insert(15, '\n');
        byte[] encodedWithWS = intermediate.toString().getBytes(CHARSET_UTF8);
        byte[] decodedWithWS = Base64.decodeBase64((byte[])encodedWithWS);
        String dest = new String(decodedWithWS);
        Assert.assertEquals((String)"Dest string doesn't equal the original", (Object)"I am a late night coder.", (Object)dest);
    }

    @Test
    public void testEmptyBase64() {
        byte[] empty = new byte[]{};
        byte[] result = Base64.encodeBase64((byte[])empty);
        Assert.assertEquals((String)"empty base64 encode", (long)0L, (long)result.length);
        Assert.assertEquals((String)"empty base64 encode", null, (Object)Base64.encodeBase64(null));
        result = new Base64().encode(empty, 0, 1);
        Assert.assertEquals((String)"empty base64 encode", (long)0L, (long)result.length);
        Assert.assertEquals((String)"empty base64 encode", null, (Object)new Base64().encode(null, 0, 1));
        empty = new byte[]{};
        result = Base64.decodeBase64((byte[])empty);
        Assert.assertEquals((String)"empty base64 decode", (long)0L, (long)result.length);
        Assert.assertEquals((String)"empty base64 encode", null, (Object)Base64.decodeBase64((byte[])null));
    }

    @Test
    public void testEncodeDecodeRandom() {
        for (int i = 1; i < 5; ++i) {
            byte[] data = new byte[this.getRandom().nextInt(10000) + 1];
            this.getRandom().nextBytes(data);
            byte[] enc = Base64.encodeBase64((byte[])data);
            Assert.assertTrue((boolean)Base64.isBase64((byte[])enc));
            byte[] data2 = Base64.decodeBase64((byte[])enc);
            Assert.assertTrue((boolean)Arrays.equals(data, data2));
        }
    }

    @Test
    public void testEncodeDecodeSmall() {
        for (int i = 0; i < 12; ++i) {
            byte[] data = new byte[i];
            this.getRandom().nextBytes(data);
            byte[] enc = Base64.encodeBase64((byte[])data);
            Assert.assertTrue((String)("\"" + new String(enc) + "\" is Base64 data."), (boolean)Base64.isBase64((byte[])enc));
            byte[] data2 = Base64.decodeBase64((byte[])enc);
            Assert.assertTrue((String)(this.toString(data) + " equals " + this.toString(data2)), (boolean)Arrays.equals(data, data2));
        }
    }

    @Test
    public void testEncodeOverMaxSize() throws Exception {
        this.testEncodeOverMaxSize(-1);
        this.testEncodeOverMaxSize(0);
        this.testEncodeOverMaxSize(1);
        this.testEncodeOverMaxSize(2);
    }

    @Test
    public void testCodec112() {
        byte[] in = new byte[]{0};
        byte[] out = Base64.encodeBase64((byte[])in);
        Base64.encodeBase64((byte[])in, (boolean)false, (boolean)false, (int)out.length);
    }

    private void testEncodeOverMaxSize(int maxSize) throws Exception {
        try {
            Base64.encodeBase64((byte[])BaseNTestData.DECODED, (boolean)true, (boolean)false, (int)maxSize);
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIgnoringNonBase64InDecode() throws Exception {
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dogs.", (Object)new String(Base64.decodeBase64((byte[])"VGhlIH@$#$@%F1aWN@#@#@@rIGJyb3duIGZve\n\r\t%#%#%#%CBqd##$#$W1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testIsArrayByteBase64() {
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{-128}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{-125}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{-10}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{0}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{64, 127}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{127}));
        Assert.assertTrue((boolean)Base64.isBase64((byte[])new byte[]{65}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{65, -128}));
        Assert.assertTrue((boolean)Base64.isBase64((byte[])new byte[]{65, 90, 97}));
        Assert.assertTrue((boolean)Base64.isBase64((byte[])new byte[]{47, 61, 43}));
        Assert.assertFalse((boolean)Base64.isBase64((byte[])new byte[]{36}));
    }

    @Test
    public void testIsUrlSafe() {
        Base64 base64Standard = new Base64(false);
        Base64 base64URLSafe = new Base64(true);
        Assert.assertFalse((String)"Base64.isUrlSafe=false", (boolean)base64Standard.isUrlSafe());
        Assert.assertTrue((String)"Base64.isUrlSafe=true", (boolean)base64URLSafe.isUrlSafe());
        byte[] whiteSpace = new byte[]{32, 10, 13, 9};
        Assert.assertTrue((String)"Base64.isBase64(whiteSpace)=true", (boolean)Base64.isBase64((byte[])whiteSpace));
    }

    @Test
    public void testKnownDecodings() {
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dogs.", (Object)new String(Base64.decodeBase64((byte[])"VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"It was the best of times, it was the worst of times.", (Object)new String(Base64.decodeBase64((byte[])"SXQgd2FzIHRoZSBiZXN0IG9mIHRpbWVzLCBpdCB3YXMgdGhlIHdvcnN0IG9mIHRpbWVzLg==".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"http://jakarta.apache.org/commmons", (Object)new String(Base64.decodeBase64((byte[])"aHR0cDovL2pha2FydGEuYXBhY2hlLm9yZy9jb21tbW9ucw==".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz", (Object)new String(Base64.decodeBase64((byte[])"QWFCYkNjRGRFZUZmR2dIaElpSmpLa0xsTW1Obk9vUHBRcVJyU3NUdFV1VnZXd1h4WXlaeg==".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }", (Object)new String(Base64.decodeBase64((byte[])"eyAwLCAxLCAyLCAzLCA0LCA1LCA2LCA3LCA4LCA5IH0=".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"xyzzy!", (Object)new String(Base64.decodeBase64((byte[])"eHl6enkh".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testKnownEncodings() {
        Assert.assertEquals((Object)"VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==", (Object)new String(Base64.encodeBase64((byte[])"The quick brown fox jumped over the lazy dogs.".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"YmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJs\r\nYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFo\r\nIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBi\r\nbGFoIGJsYWg=\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])"blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"SXQgd2FzIHRoZSBiZXN0IG9mIHRpbWVzLCBpdCB3YXMgdGhlIHdvcnN0IG9mIHRpbWVzLg==", (Object)new String(Base64.encodeBase64((byte[])"It was the best of times, it was the worst of times.".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"aHR0cDovL2pha2FydGEuYXBhY2hlLm9yZy9jb21tbW9ucw==", (Object)new String(Base64.encodeBase64((byte[])"http://jakarta.apache.org/commmons".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"QWFCYkNjRGRFZUZmR2dIaElpSmpLa0xsTW1Obk9vUHBRcVJyU3NUdFV1VnZXd1h4WXlaeg==", (Object)new String(Base64.encodeBase64((byte[])"AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"eyAwLCAxLCAyLCAzLCA0LCA1LCA2LCA3LCA4LCA5IH0=", (Object)new String(Base64.encodeBase64((byte[])"{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }".getBytes(CHARSET_UTF8))));
        Assert.assertEquals((Object)"eHl6enkh", (Object)new String(Base64.encodeBase64((byte[])"xyzzy!".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testNonBase64Test() throws Exception {
        byte[] bArray = new byte[]{37};
        Assert.assertFalse((String)"Invalid Base64 array was incorrectly validated as an array of Base64 encoded data", (boolean)Base64.isBase64((byte[])bArray));
        try {
            Base64 b64 = new Base64();
            byte[] result = b64.decode(bArray);
            Assert.assertEquals((String)"The result should be empty as the test encoded content did not contain any valid base 64 characters", (long)0L, (long)result.length);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception was thrown when trying to decode invalid base64 encoded data - RFC 2045 requires that all non base64 character be discarded, an exception should not have been thrown");
        }
    }

    @Test
    public void testObjectDecodeWithInvalidParameter() throws Exception {
        Base64 b64 = new Base64();
        try {
            b64.decode((Object)5);
            Assert.fail((String)"decode(Object) didn't throw an exception when passed an Integer object");
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectDecodeWithValidParameter() throws Exception {
        String original = "Hello World!";
        byte[] o = Base64.encodeBase64((byte[])"Hello World!".getBytes(CHARSET_UTF8));
        Base64 b64 = new Base64();
        Object oDecoded = b64.decode((Object)o);
        byte[] baDecoded = (byte[])oDecoded;
        String dest = new String(baDecoded);
        Assert.assertEquals((String)"dest string does not equal original", (Object)"Hello World!", (Object)dest);
    }

    @Test
    public void testObjectEncodeWithInvalidParameter() throws Exception {
        Base64 b64 = new Base64();
        try {
            b64.encode((Object)"Yadayadayada");
            Assert.fail((String)"encode(Object) didn't throw an exception when passed a String object");
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectEncodeWithValidParameter() throws Exception {
        String original = "Hello World!";
        byte[] origObj = "Hello World!".getBytes(CHARSET_UTF8);
        Base64 b64 = new Base64();
        Object oEncoded = b64.encode((Object)origObj);
        byte[] bArray = Base64.decodeBase64((byte[])((byte[])oEncoded));
        String dest = new String(bArray);
        Assert.assertEquals((String)"dest string does not equal original", (Object)"Hello World!", (Object)dest);
    }

    @Test
    public void testObjectEncode() throws Exception {
        Base64 b64 = new Base64();
        Assert.assertEquals((Object)"SGVsbG8gV29ybGQ=", (Object)new String(b64.encode("Hello World".getBytes(CHARSET_UTF8))));
    }

    @Test
    public void testPairs() {
        Assert.assertEquals((Object)"AAA=", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0})));
        for (int i = -128; i <= 127; ++i) {
            byte[] test = new byte[]{(byte)i, (byte)i};
            Assert.assertTrue((boolean)Arrays.equals(test, Base64.decodeBase64((byte[])Base64.encodeBase64((byte[])test))));
        }
    }

    @Test
    public void testRfc2045Section2Dot1CrLfDefinition() {
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{13, 10}, Base64.CHUNK_SEPARATOR));
    }

    @Test
    public void testRfc2045Section6Dot8ChunkSizeDefinition() {
        Assert.assertEquals((long)76L, (long)76L);
    }

    @Test
    public void testRfc1421Section6Dot8ChunkSizeDefinition() {
        Assert.assertEquals((long)64L, (long)64L);
    }

    @Test
    public void testRfc4648Section10Decode() {
        Assert.assertEquals((Object)"", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"")));
        Assert.assertEquals((Object)"f", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zg==")));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zm8=")));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zm9v")));
        Assert.assertEquals((Object)"foob", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zm9vYg==")));
        Assert.assertEquals((Object)"fooba", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zm9vYmE=")));
        Assert.assertEquals((Object)"foobar", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)"Zm9vYmFy")));
    }

    @Test
    public void testRfc4648Section10DecodeWithCrLf() {
        String CRLF = StringUtils.newStringUsAscii((byte[])Base64.CHUNK_SEPARATOR);
        Assert.assertEquals((Object)"", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("" + CRLF))));
        Assert.assertEquals((Object)"f", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zg==" + CRLF))));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zm8=" + CRLF))));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zm9v" + CRLF))));
        Assert.assertEquals((Object)"foob", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zm9vYg==" + CRLF))));
        Assert.assertEquals((Object)"fooba", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zm9vYmE=" + CRLF))));
        Assert.assertEquals((Object)"foobar", (Object)StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)("Zm9vYmFy" + CRLF))));
    }

    @Test
    public void testRfc4648Section10Encode() {
        Assert.assertEquals((Object)"", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"")));
        Assert.assertEquals((Object)"Zg==", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"f")));
        Assert.assertEquals((Object)"Zm8=", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"fo")));
        Assert.assertEquals((Object)"Zm9v", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"foo")));
        Assert.assertEquals((Object)"Zm9vYg==", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"foob")));
        Assert.assertEquals((Object)"Zm9vYmE=", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"fooba")));
        Assert.assertEquals((Object)"Zm9vYmFy", (Object)Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)"foobar")));
    }

    @Test
    public void testRfc4648Section10DecodeEncode() {
        this.testDecodeEncode("");
        this.testDecodeEncode("Zg==");
        this.testDecodeEncode("Zm8=");
        this.testDecodeEncode("Zm9v");
        this.testDecodeEncode("Zm9vYg==");
        this.testDecodeEncode("Zm9vYmE=");
        this.testDecodeEncode("Zm9vYmFy");
    }

    private void testDecodeEncode(String encodedText) {
        String decodedText = StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)encodedText));
        String encodedText2 = Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)decodedText));
        Assert.assertEquals((Object)encodedText, (Object)encodedText2);
    }

    @Test
    public void testRfc4648Section10EncodeDecode() {
        this.testEncodeDecode("");
        this.testEncodeDecode("f");
        this.testEncodeDecode("fo");
        this.testEncodeDecode("foo");
        this.testEncodeDecode("foob");
        this.testEncodeDecode("fooba");
        this.testEncodeDecode("foobar");
    }

    private void testEncodeDecode(String plainText) {
        String encodedText = Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)plainText));
        String decodedText = StringUtils.newStringUsAscii((byte[])Base64.decodeBase64((String)encodedText));
        Assert.assertEquals((Object)plainText, (Object)decodedText);
    }

    @Test
    public void testSingletons() {
        Assert.assertEquals((Object)"AA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0})));
        Assert.assertEquals((Object)"AQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{1})));
        Assert.assertEquals((Object)"Ag==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{2})));
        Assert.assertEquals((Object)"Aw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{3})));
        Assert.assertEquals((Object)"BA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{4})));
        Assert.assertEquals((Object)"BQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{5})));
        Assert.assertEquals((Object)"Bg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{6})));
        Assert.assertEquals((Object)"Bw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{7})));
        Assert.assertEquals((Object)"CA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{8})));
        Assert.assertEquals((Object)"CQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{9})));
        Assert.assertEquals((Object)"Cg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{10})));
        Assert.assertEquals((Object)"Cw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{11})));
        Assert.assertEquals((Object)"DA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{12})));
        Assert.assertEquals((Object)"DQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{13})));
        Assert.assertEquals((Object)"Dg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{14})));
        Assert.assertEquals((Object)"Dw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{15})));
        Assert.assertEquals((Object)"EA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{16})));
        Assert.assertEquals((Object)"EQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{17})));
        Assert.assertEquals((Object)"Eg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{18})));
        Assert.assertEquals((Object)"Ew==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{19})));
        Assert.assertEquals((Object)"FA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{20})));
        Assert.assertEquals((Object)"FQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{21})));
        Assert.assertEquals((Object)"Fg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{22})));
        Assert.assertEquals((Object)"Fw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{23})));
        Assert.assertEquals((Object)"GA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{24})));
        Assert.assertEquals((Object)"GQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{25})));
        Assert.assertEquals((Object)"Gg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{26})));
        Assert.assertEquals((Object)"Gw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{27})));
        Assert.assertEquals((Object)"HA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{28})));
        Assert.assertEquals((Object)"HQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{29})));
        Assert.assertEquals((Object)"Hg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{30})));
        Assert.assertEquals((Object)"Hw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{31})));
        Assert.assertEquals((Object)"IA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{32})));
        Assert.assertEquals((Object)"IQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{33})));
        Assert.assertEquals((Object)"Ig==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{34})));
        Assert.assertEquals((Object)"Iw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{35})));
        Assert.assertEquals((Object)"JA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{36})));
        Assert.assertEquals((Object)"JQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{37})));
        Assert.assertEquals((Object)"Jg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{38})));
        Assert.assertEquals((Object)"Jw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{39})));
        Assert.assertEquals((Object)"KA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{40})));
        Assert.assertEquals((Object)"KQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{41})));
        Assert.assertEquals((Object)"Kg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{42})));
        Assert.assertEquals((Object)"Kw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{43})));
        Assert.assertEquals((Object)"LA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{44})));
        Assert.assertEquals((Object)"LQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{45})));
        Assert.assertEquals((Object)"Lg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{46})));
        Assert.assertEquals((Object)"Lw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{47})));
        Assert.assertEquals((Object)"MA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{48})));
        Assert.assertEquals((Object)"MQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{49})));
        Assert.assertEquals((Object)"Mg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{50})));
        Assert.assertEquals((Object)"Mw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{51})));
        Assert.assertEquals((Object)"NA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{52})));
        Assert.assertEquals((Object)"NQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{53})));
        Assert.assertEquals((Object)"Ng==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{54})));
        Assert.assertEquals((Object)"Nw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{55})));
        Assert.assertEquals((Object)"OA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{56})));
        Assert.assertEquals((Object)"OQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{57})));
        Assert.assertEquals((Object)"Og==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{58})));
        Assert.assertEquals((Object)"Ow==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{59})));
        Assert.assertEquals((Object)"PA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{60})));
        Assert.assertEquals((Object)"PQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{61})));
        Assert.assertEquals((Object)"Pg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{62})));
        Assert.assertEquals((Object)"Pw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{63})));
        Assert.assertEquals((Object)"QA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{64})));
        Assert.assertEquals((Object)"QQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{65})));
        Assert.assertEquals((Object)"Qg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{66})));
        Assert.assertEquals((Object)"Qw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{67})));
        Assert.assertEquals((Object)"RA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{68})));
        Assert.assertEquals((Object)"RQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{69})));
        Assert.assertEquals((Object)"Rg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{70})));
        Assert.assertEquals((Object)"Rw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{71})));
        Assert.assertEquals((Object)"SA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{72})));
        Assert.assertEquals((Object)"SQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{73})));
        Assert.assertEquals((Object)"Sg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{74})));
        Assert.assertEquals((Object)"Sw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{75})));
        Assert.assertEquals((Object)"TA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{76})));
        Assert.assertEquals((Object)"TQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{77})));
        Assert.assertEquals((Object)"Tg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{78})));
        Assert.assertEquals((Object)"Tw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{79})));
        Assert.assertEquals((Object)"UA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{80})));
        Assert.assertEquals((Object)"UQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{81})));
        Assert.assertEquals((Object)"Ug==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{82})));
        Assert.assertEquals((Object)"Uw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{83})));
        Assert.assertEquals((Object)"VA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{84})));
        Assert.assertEquals((Object)"VQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{85})));
        Assert.assertEquals((Object)"Vg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{86})));
        Assert.assertEquals((Object)"Vw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{87})));
        Assert.assertEquals((Object)"WA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{88})));
        Assert.assertEquals((Object)"WQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{89})));
        Assert.assertEquals((Object)"Wg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{90})));
        Assert.assertEquals((Object)"Ww==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{91})));
        Assert.assertEquals((Object)"XA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{92})));
        Assert.assertEquals((Object)"XQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{93})));
        Assert.assertEquals((Object)"Xg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{94})));
        Assert.assertEquals((Object)"Xw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{95})));
        Assert.assertEquals((Object)"YA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{96})));
        Assert.assertEquals((Object)"YQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{97})));
        Assert.assertEquals((Object)"Yg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{98})));
        Assert.assertEquals((Object)"Yw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{99})));
        Assert.assertEquals((Object)"ZA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{100})));
        Assert.assertEquals((Object)"ZQ==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{101})));
        Assert.assertEquals((Object)"Zg==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{102})));
        Assert.assertEquals((Object)"Zw==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{103})));
        Assert.assertEquals((Object)"aA==", (Object)new String(Base64.encodeBase64((byte[])new byte[]{104})));
        for (int i = -128; i <= 127; ++i) {
            byte[] test = new byte[]{(byte)i};
            Assert.assertTrue((boolean)Arrays.equals(test, Base64.decodeBase64((byte[])Base64.encodeBase64((byte[])test))));
        }
    }

    @Test
    public void testSingletonsChunked() {
        Assert.assertEquals((Object)"AA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0})));
        Assert.assertEquals((Object)"AQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{1})));
        Assert.assertEquals((Object)"Ag==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{2})));
        Assert.assertEquals((Object)"Aw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{3})));
        Assert.assertEquals((Object)"BA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{4})));
        Assert.assertEquals((Object)"BQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{5})));
        Assert.assertEquals((Object)"Bg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{6})));
        Assert.assertEquals((Object)"Bw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{7})));
        Assert.assertEquals((Object)"CA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{8})));
        Assert.assertEquals((Object)"CQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{9})));
        Assert.assertEquals((Object)"Cg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{10})));
        Assert.assertEquals((Object)"Cw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{11})));
        Assert.assertEquals((Object)"DA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{12})));
        Assert.assertEquals((Object)"DQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{13})));
        Assert.assertEquals((Object)"Dg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{14})));
        Assert.assertEquals((Object)"Dw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{15})));
        Assert.assertEquals((Object)"EA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{16})));
        Assert.assertEquals((Object)"EQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{17})));
        Assert.assertEquals((Object)"Eg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{18})));
        Assert.assertEquals((Object)"Ew==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{19})));
        Assert.assertEquals((Object)"FA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{20})));
        Assert.assertEquals((Object)"FQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{21})));
        Assert.assertEquals((Object)"Fg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{22})));
        Assert.assertEquals((Object)"Fw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{23})));
        Assert.assertEquals((Object)"GA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{24})));
        Assert.assertEquals((Object)"GQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{25})));
        Assert.assertEquals((Object)"Gg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{26})));
        Assert.assertEquals((Object)"Gw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{27})));
        Assert.assertEquals((Object)"HA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{28})));
        Assert.assertEquals((Object)"HQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{29})));
        Assert.assertEquals((Object)"Hg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{30})));
        Assert.assertEquals((Object)"Hw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{31})));
        Assert.assertEquals((Object)"IA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{32})));
        Assert.assertEquals((Object)"IQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{33})));
        Assert.assertEquals((Object)"Ig==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{34})));
        Assert.assertEquals((Object)"Iw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{35})));
        Assert.assertEquals((Object)"JA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{36})));
        Assert.assertEquals((Object)"JQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{37})));
        Assert.assertEquals((Object)"Jg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{38})));
        Assert.assertEquals((Object)"Jw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{39})));
        Assert.assertEquals((Object)"KA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{40})));
        Assert.assertEquals((Object)"KQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{41})));
        Assert.assertEquals((Object)"Kg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{42})));
        Assert.assertEquals((Object)"Kw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{43})));
        Assert.assertEquals((Object)"LA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{44})));
        Assert.assertEquals((Object)"LQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{45})));
        Assert.assertEquals((Object)"Lg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{46})));
        Assert.assertEquals((Object)"Lw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{47})));
        Assert.assertEquals((Object)"MA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{48})));
        Assert.assertEquals((Object)"MQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{49})));
        Assert.assertEquals((Object)"Mg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{50})));
        Assert.assertEquals((Object)"Mw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{51})));
        Assert.assertEquals((Object)"NA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{52})));
        Assert.assertEquals((Object)"NQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{53})));
        Assert.assertEquals((Object)"Ng==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{54})));
        Assert.assertEquals((Object)"Nw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{55})));
        Assert.assertEquals((Object)"OA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{56})));
        Assert.assertEquals((Object)"OQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{57})));
        Assert.assertEquals((Object)"Og==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{58})));
        Assert.assertEquals((Object)"Ow==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{59})));
        Assert.assertEquals((Object)"PA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{60})));
        Assert.assertEquals((Object)"PQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{61})));
        Assert.assertEquals((Object)"Pg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{62})));
        Assert.assertEquals((Object)"Pw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{63})));
        Assert.assertEquals((Object)"QA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{64})));
        Assert.assertEquals((Object)"QQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{65})));
        Assert.assertEquals((Object)"Qg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{66})));
        Assert.assertEquals((Object)"Qw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{67})));
        Assert.assertEquals((Object)"RA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{68})));
        Assert.assertEquals((Object)"RQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{69})));
        Assert.assertEquals((Object)"Rg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{70})));
        Assert.assertEquals((Object)"Rw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{71})));
        Assert.assertEquals((Object)"SA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{72})));
        Assert.assertEquals((Object)"SQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{73})));
        Assert.assertEquals((Object)"Sg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{74})));
        Assert.assertEquals((Object)"Sw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{75})));
        Assert.assertEquals((Object)"TA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{76})));
        Assert.assertEquals((Object)"TQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{77})));
        Assert.assertEquals((Object)"Tg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{78})));
        Assert.assertEquals((Object)"Tw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{79})));
        Assert.assertEquals((Object)"UA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{80})));
        Assert.assertEquals((Object)"UQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{81})));
        Assert.assertEquals((Object)"Ug==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{82})));
        Assert.assertEquals((Object)"Uw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{83})));
        Assert.assertEquals((Object)"VA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{84})));
        Assert.assertEquals((Object)"VQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{85})));
        Assert.assertEquals((Object)"Vg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{86})));
        Assert.assertEquals((Object)"Vw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{87})));
        Assert.assertEquals((Object)"WA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{88})));
        Assert.assertEquals((Object)"WQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{89})));
        Assert.assertEquals((Object)"Wg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{90})));
        Assert.assertEquals((Object)"Ww==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{91})));
        Assert.assertEquals((Object)"XA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{92})));
        Assert.assertEquals((Object)"XQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{93})));
        Assert.assertEquals((Object)"Xg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{94})));
        Assert.assertEquals((Object)"Xw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{95})));
        Assert.assertEquals((Object)"YA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{96})));
        Assert.assertEquals((Object)"YQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{97})));
        Assert.assertEquals((Object)"Yg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{98})));
        Assert.assertEquals((Object)"Yw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{99})));
        Assert.assertEquals((Object)"ZA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{100})));
        Assert.assertEquals((Object)"ZQ==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{101})));
        Assert.assertEquals((Object)"Zg==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{102})));
        Assert.assertEquals((Object)"Zw==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{103})));
        Assert.assertEquals((Object)"aA==\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{104})));
    }

    @Test
    public void testTriplets() {
        Assert.assertEquals((Object)"AAAA", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 0})));
        Assert.assertEquals((Object)"AAAB", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 1})));
        Assert.assertEquals((Object)"AAAC", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 2})));
        Assert.assertEquals((Object)"AAAD", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 3})));
        Assert.assertEquals((Object)"AAAE", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 4})));
        Assert.assertEquals((Object)"AAAF", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 5})));
        Assert.assertEquals((Object)"AAAG", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 6})));
        Assert.assertEquals((Object)"AAAH", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 7})));
        Assert.assertEquals((Object)"AAAI", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 8})));
        Assert.assertEquals((Object)"AAAJ", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 9})));
        Assert.assertEquals((Object)"AAAK", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 10})));
        Assert.assertEquals((Object)"AAAL", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 11})));
        Assert.assertEquals((Object)"AAAM", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 12})));
        Assert.assertEquals((Object)"AAAN", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 13})));
        Assert.assertEquals((Object)"AAAO", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 14})));
        Assert.assertEquals((Object)"AAAP", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 15})));
        Assert.assertEquals((Object)"AAAQ", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 16})));
        Assert.assertEquals((Object)"AAAR", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 17})));
        Assert.assertEquals((Object)"AAAS", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 18})));
        Assert.assertEquals((Object)"AAAT", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 19})));
        Assert.assertEquals((Object)"AAAU", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 20})));
        Assert.assertEquals((Object)"AAAV", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 21})));
        Assert.assertEquals((Object)"AAAW", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 22})));
        Assert.assertEquals((Object)"AAAX", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 23})));
        Assert.assertEquals((Object)"AAAY", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 24})));
        Assert.assertEquals((Object)"AAAZ", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 25})));
        Assert.assertEquals((Object)"AAAa", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 26})));
        Assert.assertEquals((Object)"AAAb", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 27})));
        Assert.assertEquals((Object)"AAAc", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 28})));
        Assert.assertEquals((Object)"AAAd", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 29})));
        Assert.assertEquals((Object)"AAAe", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 30})));
        Assert.assertEquals((Object)"AAAf", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 31})));
        Assert.assertEquals((Object)"AAAg", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 32})));
        Assert.assertEquals((Object)"AAAh", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 33})));
        Assert.assertEquals((Object)"AAAi", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 34})));
        Assert.assertEquals((Object)"AAAj", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 35})));
        Assert.assertEquals((Object)"AAAk", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 36})));
        Assert.assertEquals((Object)"AAAl", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 37})));
        Assert.assertEquals((Object)"AAAm", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 38})));
        Assert.assertEquals((Object)"AAAn", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 39})));
        Assert.assertEquals((Object)"AAAo", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 40})));
        Assert.assertEquals((Object)"AAAp", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 41})));
        Assert.assertEquals((Object)"AAAq", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 42})));
        Assert.assertEquals((Object)"AAAr", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 43})));
        Assert.assertEquals((Object)"AAAs", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 44})));
        Assert.assertEquals((Object)"AAAt", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 45})));
        Assert.assertEquals((Object)"AAAu", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 46})));
        Assert.assertEquals((Object)"AAAv", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 47})));
        Assert.assertEquals((Object)"AAAw", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 48})));
        Assert.assertEquals((Object)"AAAx", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 49})));
        Assert.assertEquals((Object)"AAAy", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 50})));
        Assert.assertEquals((Object)"AAAz", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 51})));
        Assert.assertEquals((Object)"AAA0", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 52})));
        Assert.assertEquals((Object)"AAA1", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 53})));
        Assert.assertEquals((Object)"AAA2", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 54})));
        Assert.assertEquals((Object)"AAA3", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 55})));
        Assert.assertEquals((Object)"AAA4", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 56})));
        Assert.assertEquals((Object)"AAA5", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 57})));
        Assert.assertEquals((Object)"AAA6", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 58})));
        Assert.assertEquals((Object)"AAA7", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 59})));
        Assert.assertEquals((Object)"AAA8", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 60})));
        Assert.assertEquals((Object)"AAA9", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 61})));
        Assert.assertEquals((Object)"AAA+", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 62})));
        Assert.assertEquals((Object)"AAA/", (Object)new String(Base64.encodeBase64((byte[])new byte[]{0, 0, 63})));
    }

    @Test
    public void testTripletsChunked() {
        Assert.assertEquals((Object)"AAAA\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 0})));
        Assert.assertEquals((Object)"AAAB\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 1})));
        Assert.assertEquals((Object)"AAAC\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 2})));
        Assert.assertEquals((Object)"AAAD\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 3})));
        Assert.assertEquals((Object)"AAAE\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 4})));
        Assert.assertEquals((Object)"AAAF\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 5})));
        Assert.assertEquals((Object)"AAAG\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 6})));
        Assert.assertEquals((Object)"AAAH\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 7})));
        Assert.assertEquals((Object)"AAAI\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 8})));
        Assert.assertEquals((Object)"AAAJ\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 9})));
        Assert.assertEquals((Object)"AAAK\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 10})));
        Assert.assertEquals((Object)"AAAL\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 11})));
        Assert.assertEquals((Object)"AAAM\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 12})));
        Assert.assertEquals((Object)"AAAN\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 13})));
        Assert.assertEquals((Object)"AAAO\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 14})));
        Assert.assertEquals((Object)"AAAP\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 15})));
        Assert.assertEquals((Object)"AAAQ\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 16})));
        Assert.assertEquals((Object)"AAAR\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 17})));
        Assert.assertEquals((Object)"AAAS\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 18})));
        Assert.assertEquals((Object)"AAAT\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 19})));
        Assert.assertEquals((Object)"AAAU\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 20})));
        Assert.assertEquals((Object)"AAAV\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 21})));
        Assert.assertEquals((Object)"AAAW\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 22})));
        Assert.assertEquals((Object)"AAAX\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 23})));
        Assert.assertEquals((Object)"AAAY\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 24})));
        Assert.assertEquals((Object)"AAAZ\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 25})));
        Assert.assertEquals((Object)"AAAa\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 26})));
        Assert.assertEquals((Object)"AAAb\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 27})));
        Assert.assertEquals((Object)"AAAc\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 28})));
        Assert.assertEquals((Object)"AAAd\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 29})));
        Assert.assertEquals((Object)"AAAe\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 30})));
        Assert.assertEquals((Object)"AAAf\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 31})));
        Assert.assertEquals((Object)"AAAg\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 32})));
        Assert.assertEquals((Object)"AAAh\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 33})));
        Assert.assertEquals((Object)"AAAi\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 34})));
        Assert.assertEquals((Object)"AAAj\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 35})));
        Assert.assertEquals((Object)"AAAk\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 36})));
        Assert.assertEquals((Object)"AAAl\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 37})));
        Assert.assertEquals((Object)"AAAm\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 38})));
        Assert.assertEquals((Object)"AAAn\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 39})));
        Assert.assertEquals((Object)"AAAo\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 40})));
        Assert.assertEquals((Object)"AAAp\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 41})));
        Assert.assertEquals((Object)"AAAq\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 42})));
        Assert.assertEquals((Object)"AAAr\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 43})));
        Assert.assertEquals((Object)"AAAs\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 44})));
        Assert.assertEquals((Object)"AAAt\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 45})));
        Assert.assertEquals((Object)"AAAu\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 46})));
        Assert.assertEquals((Object)"AAAv\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 47})));
        Assert.assertEquals((Object)"AAAw\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 48})));
        Assert.assertEquals((Object)"AAAx\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 49})));
        Assert.assertEquals((Object)"AAAy\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 50})));
        Assert.assertEquals((Object)"AAAz\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 51})));
        Assert.assertEquals((Object)"AAA0\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 52})));
        Assert.assertEquals((Object)"AAA1\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 53})));
        Assert.assertEquals((Object)"AAA2\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 54})));
        Assert.assertEquals((Object)"AAA3\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 55})));
        Assert.assertEquals((Object)"AAA4\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 56})));
        Assert.assertEquals((Object)"AAA5\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 57})));
        Assert.assertEquals((Object)"AAA6\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 58})));
        Assert.assertEquals((Object)"AAA7\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 59})));
        Assert.assertEquals((Object)"AAA8\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 60})));
        Assert.assertEquals((Object)"AAA9\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 61})));
        Assert.assertEquals((Object)"AAA+\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 62})));
        Assert.assertEquals((Object)"AAA/\r\n", (Object)new String(Base64.encodeBase64Chunked((byte[])new byte[]{0, 0, 63})));
    }

    @Test
    public void testUrlSafe() {
        Base64 codec = new Base64(true);
        for (int i = 0; i <= 150; ++i) {
            byte[][] randomData = BaseNTestData.randomData((BaseNCodec)codec, i);
            byte[] encoded = randomData[1];
            byte[] decoded = randomData[0];
            byte[] result = Base64.decodeBase64((byte[])encoded);
            Assert.assertTrue((String)("url-safe i=" + i), (boolean)Arrays.equals(decoded, result));
            Assert.assertFalse((String)("url-safe i=" + i + " no '='"), (boolean)BaseNTestData.bytesContain(encoded, (byte)61));
            Assert.assertFalse((String)("url-safe i=" + i + " no '\\'"), (boolean)BaseNTestData.bytesContain(encoded, (byte)92));
            Assert.assertFalse((String)("url-safe i=" + i + " no '+'"), (boolean)BaseNTestData.bytesContain(encoded, (byte)43));
        }
    }

    @Test
    public void testUUID() throws DecoderException {
        byte[][] ids = new byte[][]{Hex.decodeHex((String)"94ed8d0319e4493399560fb67404d370"), Hex.decodeHex((String)"2bf7cc2701fe4397b49ebeed5acc7090"), Hex.decodeHex((String)"64be154b6ffa40258d1a01288e7c31ca"), Hex.decodeHex((String)"ff7f8fc01cdb471a8c8b5a9306183fe8")};
        byte[][] standard = new byte[][]{StringUtils.getBytesUtf8((String)"lO2NAxnkSTOZVg+2dATTcA=="), StringUtils.getBytesUtf8((String)"K/fMJwH+Q5e0nr7tWsxwkA=="), StringUtils.getBytesUtf8((String)"ZL4VS2/6QCWNGgEojnwxyg=="), StringUtils.getBytesUtf8((String)"/3+PwBzbRxqMi1qTBhg/6A==")};
        byte[][] urlSafe1 = new byte[][]{StringUtils.getBytesUtf8((String)"lO2NAxnkSTOZVg-2dATTcA=="), StringUtils.getBytesUtf8((String)"K_fMJwH-Q5e0nr7tWsxwkA=="), StringUtils.getBytesUtf8((String)"ZL4VS2_6QCWNGgEojnwxyg=="), StringUtils.getBytesUtf8((String)"_3-PwBzbRxqMi1qTBhg_6A==")};
        byte[][] urlSafe2 = new byte[][]{StringUtils.getBytesUtf8((String)"lO2NAxnkSTOZVg-2dATTcA="), StringUtils.getBytesUtf8((String)"K_fMJwH-Q5e0nr7tWsxwkA="), StringUtils.getBytesUtf8((String)"ZL4VS2_6QCWNGgEojnwxyg="), StringUtils.getBytesUtf8((String)"_3-PwBzbRxqMi1qTBhg_6A=")};
        byte[][] urlSafe3 = new byte[][]{StringUtils.getBytesUtf8((String)"lO2NAxnkSTOZVg-2dATTcA"), StringUtils.getBytesUtf8((String)"K_fMJwH-Q5e0nr7tWsxwkA"), StringUtils.getBytesUtf8((String)"ZL4VS2_6QCWNGgEojnwxyg"), StringUtils.getBytesUtf8((String)"_3-PwBzbRxqMi1qTBhg_6A")};
        for (int i = 0; i < 4; ++i) {
            byte[] encodedStandard = Base64.encodeBase64((byte[])ids[i]);
            byte[] encodedUrlSafe = Base64.encodeBase64URLSafe((byte[])ids[i]);
            byte[] decodedStandard = Base64.decodeBase64((byte[])standard[i]);
            byte[] decodedUrlSafe1 = Base64.decodeBase64((byte[])urlSafe1[i]);
            byte[] decodedUrlSafe2 = Base64.decodeBase64((byte[])urlSafe2[i]);
            byte[] decodedUrlSafe3 = Base64.decodeBase64((byte[])urlSafe3[i]);
            Assert.assertTrue((String)"standard encode uuid", (boolean)Arrays.equals(encodedStandard, standard[i]));
            Assert.assertTrue((String)"url-safe encode uuid", (boolean)Arrays.equals(encodedUrlSafe, urlSafe3[i]));
            Assert.assertTrue((String)"standard decode uuid", (boolean)Arrays.equals(decodedStandard, ids[i]));
            Assert.assertTrue((String)"url-safe1 decode uuid", (boolean)Arrays.equals(decodedUrlSafe1, ids[i]));
            Assert.assertTrue((String)"url-safe2 decode uuid", (boolean)Arrays.equals(decodedUrlSafe2, ids[i]));
            Assert.assertTrue((String)"url-safe3 decode uuid", (boolean)Arrays.equals(decodedUrlSafe3, ids[i]));
        }
    }

    @Test
    public void testByteToStringVariations() throws DecoderException {
        Base64 base64 = new Base64(0);
        byte[] b1 = StringUtils.getBytesUtf8((String)"Hello World");
        byte[] b2 = new byte[]{};
        byte[] b3 = null;
        byte[] b4 = Hex.decodeHex((String)"2bf7cc2701fe4397b49ebeed5acc7090");
        Assert.assertEquals((String)"byteToString Hello World", (Object)"SGVsbG8gV29ybGQ=", (Object)base64.encodeToString(b1));
        Assert.assertEquals((String)"byteToString static Hello World", (Object)"SGVsbG8gV29ybGQ=", (Object)Base64.encodeBase64String((byte[])b1));
        Assert.assertEquals((String)"byteToString \"\"", (Object)"", (Object)base64.encodeToString(b2));
        Assert.assertEquals((String)"byteToString static \"\"", (Object)"", (Object)Base64.encodeBase64String((byte[])b2));
        Assert.assertEquals((String)"byteToString null", null, (Object)base64.encodeToString(b3));
        Assert.assertEquals((String)"byteToString static null", null, (Object)Base64.encodeBase64String(b3));
        Assert.assertEquals((String)"byteToString UUID", (Object)"K/fMJwH+Q5e0nr7tWsxwkA==", (Object)base64.encodeToString(b4));
        Assert.assertEquals((String)"byteToString static UUID", (Object)"K/fMJwH+Q5e0nr7tWsxwkA==", (Object)Base64.encodeBase64String((byte[])b4));
        Assert.assertEquals((String)"byteToString static-url-safe UUID", (Object)"K_fMJwH-Q5e0nr7tWsxwkA", (Object)Base64.encodeBase64URLSafeString((byte[])b4));
    }

    @Test
    public void testStringToByteVariations() throws DecoderException {
        Base64 base64 = new Base64();
        String s1 = "SGVsbG8gV29ybGQ=\r\n";
        String s2 = "";
        String s3 = null;
        String s4a = "K/fMJwH+Q5e0nr7tWsxwkA==\r\n";
        String s4b = "K_fMJwH-Q5e0nr7tWsxwkA";
        byte[] b4 = Hex.decodeHex((String)"2bf7cc2701fe4397b49ebeed5acc7090");
        Assert.assertEquals((String)"StringToByte Hello World", (Object)"Hello World", (Object)StringUtils.newStringUtf8((byte[])base64.decode("SGVsbG8gV29ybGQ=\r\n")));
        Assert.assertEquals((String)"StringToByte Hello World", (Object)"Hello World", (Object)StringUtils.newStringUtf8((byte[])((byte[])base64.decode((Object)"SGVsbG8gV29ybGQ=\r\n"))));
        Assert.assertEquals((String)"StringToByte static Hello World", (Object)"Hello World", (Object)StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)"SGVsbG8gV29ybGQ=\r\n")));
        Assert.assertEquals((String)"StringToByte \"\"", (Object)"", (Object)StringUtils.newStringUtf8((byte[])base64.decode("")));
        Assert.assertEquals((String)"StringToByte static \"\"", (Object)"", (Object)StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)"")));
        Assert.assertEquals((String)"StringToByte null", null, (Object)StringUtils.newStringUtf8((byte[])base64.decode(s3)));
        Assert.assertEquals((String)"StringToByte static null", null, (Object)StringUtils.newStringUtf8((byte[])Base64.decodeBase64(s3)));
        Assert.assertTrue((String)"StringToByte UUID", (boolean)Arrays.equals(b4, base64.decode("K_fMJwH-Q5e0nr7tWsxwkA")));
        Assert.assertTrue((String)"StringToByte static UUID", (boolean)Arrays.equals(b4, Base64.decodeBase64((String)"K/fMJwH+Q5e0nr7tWsxwkA==\r\n")));
        Assert.assertTrue((String)"StringToByte static-url-safe UUID", (boolean)Arrays.equals(b4, Base64.decodeBase64((String)"K_fMJwH-Q5e0nr7tWsxwkA")));
    }

    private String toString(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buf.append(data[i]);
            if (i == data.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    @Test
    public void testHugeLineSeparator() {
        int BaseNCodec_DEFAULT_BUFFER_SIZE = 8192;
        int Base64_BYTES_PER_ENCODED_BLOCK = 4;
        byte[] baLineSeparator = new byte[32765];
        Base64 b64 = new Base64(4, baLineSeparator);
        String strOriginal = "Hello World";
        String strDecoded = new String(b64.decode(b64.encode(StringUtils.getBytesUtf8((String)"Hello World"))));
        Assert.assertEquals((String)"testDEFAULT_BUFFER_SIZE", (Object)"Hello World", (Object)strDecoded);
    }

    @Test
    public void testBase64ImpossibleSamples() {
        Base64 codec = new Base64(0, null, false, CodecPolicy.STRICT);
        for (String s : BASE64_IMPOSSIBLE_CASES) {
            try {
                codec.decode(s);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testBase64DecodingOfTrailing6Bits() {
        Base64Test.assertBase64DecodingOfTrailingBits(6);
    }

    @Test
    public void testBase64DecodingOfTrailing12Bits() {
        Base64Test.assertBase64DecodingOfTrailingBits(12);
    }

    @Test
    public void testBase64DecodingOfTrailing18Bits() {
        Base64Test.assertBase64DecodingOfTrailingBits(18);
    }

    private static void assertBase64DecodingOfTrailingBits(int nbits) {
        Base64 codec = new Base64(0, null, false, CodecPolicy.STRICT);
        Assert.assertTrue((boolean)codec.isStrictDecoding());
        Assert.assertEquals((Object)CodecPolicy.STRICT, (Object)codec.getCodecPolicy());
        Base64 defaultCodec = new Base64();
        Assert.assertFalse((boolean)defaultCodec.isStrictDecoding());
        Assert.assertEquals((Object)CodecPolicy.LENIENT, (Object)defaultCodec.getCodecPolicy());
        int length = nbits / 6;
        byte[] encoded = new byte[4];
        Arrays.fill(encoded, 0, length, STANDARD_ENCODE_TABLE[0]);
        Arrays.fill(encoded, length, encoded.length, (byte)61);
        int discard = nbits % 8;
        int emptyBitsMask = (1 << discard) - 1;
        boolean invalid = length == 1;
        int last = length - 1;
        for (int i = 0; i < 64; ++i) {
            byte[] decoded;
            encoded[last] = STANDARD_ENCODE_TABLE[i];
            if (invalid || (i & emptyBitsMask) != 0) {
                try {
                    codec.decode(encoded);
                    Assert.fail((String)"Final base-64 digit should not be allowed");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                decoded = defaultCodec.decode(encoded);
                Assert.assertFalse((boolean)Arrays.equals(encoded, defaultCodec.encode(decoded)));
                continue;
            }
            decoded = codec.decode(encoded);
            int bitsEncoded = i >> discard;
            Assert.assertEquals((String)"Invalid decoding of last character", (long)bitsEncoded, (long)decoded[decoded.length - 1]);
            Assert.assertArrayEquals((byte[])encoded, (byte[])codec.encode(decoded));
        }
    }

    @Test
    public void testCodec265() {
        long estimatedMemory;
        int size1GiB = 0x40000000;
        int blocks = (int)Math.ceil(3.579139413333333E8);
        int expectedLength = 4 * blocks;
        long presumableFreeMemory = BaseNCodecTest.getPresumableFreeMemory();
        Assume.assumeTrue((String)"Not enough free memory for the test", (presumableFreeMemory > (estimatedMemory = 0x100000000L + (long)expectedLength + 32768L) ? 1 : 0) != 0);
        byte[] bytes = new byte[0x40000000];
        byte[] encoded = Base64.encodeBase64((byte[])bytes);
        Assert.assertEquals((long)expectedLength, (long)encoded.length);
    }
}

