/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.controlbus.it;

import javax.enterprise.context.ApplicationScoped;

import io.quarkus.runtime.annotations.RegisterForReflection;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RouteController;

@ApplicationScoped
@RegisterForReflection(targets = { RouteController.class })
public class ControlbusLanguageRoute extends RouteBuilder {

    @Override
    public void configure() throws Exception {
        from("direct:lang-control")
                .routeId("lang-control")
                .log("control: ${body}");

        from("direct:header")
                .setHeader("action", constant("stop"))
                .to("controlbus:language:header")
                .toD("controlbus:route?routeId=lang-control&action=${body}");

        from("direct:exchangeProperty")
                .setProperty("action", constant("stop"))
                .to("controlbus:language:exchangeProperty")
                .toD("controlbus:route?routeId=lang-control&action=${body}");
    }
}
